/**
 * <copyright> 
 *
 * Copyright (c) 2002 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 * 
 * Contributors: 
 *   IBM - Initial API and implementation
 *
 * </copyright>
 *
 * plugins/org.eclipse.emf.edit/src/org/eclipse/emf/edit/provider/ITreeItemContentProvider.java, emf.edit, org.eclipse.111, 20031020_1612WL
 * @version 1.5 10/20/03
 */
package org.eclipse.emf.edit.provider;


import java.util.Collection;


/**
 * This is the interface needed to populate subtrees in a TreeViewer.
 */
public interface ITreeItemContentProvider extends IStructuredItemContentProvider
{
  /**
   * This does the same thing as ITreeContentProvider.getChildren.
   */
  public Collection getChildren(Object object);

  /**
   * This does the same thing as ITreeContentProvider.hasChildren.
   */
  public boolean hasChildren(Object object);

  /**
   * This does the same thing as ITreeContentProvider.getParent.
   */
  public Object getParent(Object object);
}
