package org.eclipse.emf.codegen.ecore.templates.model;

import java.util.*;
import org.eclipse.emf.ecore.*;
import org.eclipse.emf.codegen.ecore.genmodel.*;
import org.eclipse.emf.codegen.ecore.genmodel.impl.Literals;

public class PackageClass
{
  protected final String NL = System.getProperties().getProperty("line.separator");
  protected final String TEXT_1 = "";
  protected final String TEXT_2 = "/**" + NL + " * <copyright>" + NL + " * </copyright>" + NL + " *" + NL + " * ";
  protected final String TEXT_3 = "W%" + NL + " * @version ";
  protected final String TEXT_4 = "I% ";
  protected final String TEXT_5 = "H%" + NL + " */" + NL + "package ";
  protected final String TEXT_6 = ";" + NL;
  protected final String TEXT_7 = NL + NL + "/**" + NL + " * <!-- begin-user-doc -->" + NL + " * An implementation of the model <b>Package</b>." + NL + " * <!-- end-user-doc -->" + NL + " * @generated" + NL + " */" + NL + "public class ";
  protected final String TEXT_8 = " extends ";
  protected final String TEXT_9 = " implements ";
  protected final String TEXT_10 = NL + "{";
  protected final String TEXT_11 = NL + "\t/**" + NL + "\t * <!-- begin-user-doc -->" + NL + "\t * <!-- end-user-doc -->" + NL + "\t * @generated" + NL + "\t */" + NL + "\tpublic static final ";
  protected final String TEXT_12 = " copyright = \"";
  protected final String TEXT_13 = "\";";
  protected final String TEXT_14 = NL;
  protected final String TEXT_15 = NL + "\t/**" + NL + "\t * <!-- begin-user-doc -->" + NL + "\t * <!-- end-user-doc -->" + NL + "\t * @generated" + NL + "\t */" + NL + "\tprivate ";
  protected final String TEXT_16 = " ";
  protected final String TEXT_17 = " = null;" + NL;
  protected final String TEXT_18 = NL + "\t/**" + NL + "\t * Creates an instance of the model <b>Package</b>, registered with" + NL + "\t * {@link org.eclipse.emf.ecore.EPackage.Registry EPackage.Registry} by the package" + NL + "\t * package URI value." + NL + "\t * <p>Note: the correct way to create the package is via the static" + NL + "\t * factory method {@link #init init()}, which also performs" + NL + "\t * initialization of the package, or returns the registered package," + NL + "\t * if one already exists." + NL + "\t * <!-- begin-user-doc -->" + NL + "\t * <!-- end-user-doc -->" + NL + "\t * @see org.eclipse.emf.ecore.EPackage.Registry" + NL + "\t * @see ";
  protected final String TEXT_19 = "#eNS_URI" + NL + "\t * @see #init()" + NL + "\t * @generated" + NL + "\t */" + NL + "\tprivate ";
  protected final String TEXT_20 = "()" + NL + "\t{" + NL + "\t\tsuper(eNS_URI, ";
  protected final String TEXT_21 = ".eINSTANCE);" + NL + "\t}" + NL + "" + NL + "\t/**" + NL + "\t * Creates, registers, and initializes the <b>Package</b> for this" + NL + "\t * model, and for any others upon which it depends.  Simple" + NL + "\t * dependencies are satisfied by calling this method on all" + NL + "\t * dependent packages before doing anything else.  This method drives" + NL + "\t * initialization for interdependent packages directly, in parallel" + NL + "\t * with this package, itself." + NL + "\t * <p>Of this package and its interdependencies, all packages which" + NL + "\t * have not yet been registered by their URI values are first created" + NL + "\t * and registered.  The packages are then initialized in two steps:" + NL + "\t * meta-model objects for all of the packages are created before any" + NL + "\t * are initialized, since one package's meta-model objects may refer to" + NL + "\t * those of another." + NL + "\t * <p>Invocation of this method will not affect any packages that have" + NL + "\t * already been initialized." + NL + "\t * <!-- begin-user-doc -->" + NL + "\t * <!-- end-user-doc -->" + NL + "\t * @see #eNS_URI" + NL + "\t * @see #createPackageContents()" + NL + "\t * @see #initializePackageContents()" + NL + "\t * @generated" + NL + "\t */" + NL + "\tpublic static ";
  protected final String TEXT_22 = " init()" + NL + "\t{";
  protected final String TEXT_23 = NL + "\t\t// Initialize simple dependencies";
  protected final String TEXT_24 = NL + "\t\t";
  protected final String TEXT_25 = ".init();";
  protected final String TEXT_26 = NL;
  protected final String TEXT_27 = NL + "\t\t// Obtain or create and register package and interdependencies" + NL + "\t\t";
  protected final String TEXT_28 = " the";
  protected final String TEXT_29 = " = (";
  protected final String TEXT_30 = ")(";
  protected final String TEXT_31 = ".Registry.INSTANCE.get(eNS_URI) instanceof ";
  protected final String TEXT_32 = " ? ";
  protected final String TEXT_33 = ".Registry.INSTANCE.get(eNS_URI) : new ";
  protected final String TEXT_34 = "());";
  protected final String TEXT_35 = NL + "\t\t";
  protected final String TEXT_36 = " ";
  protected final String TEXT_37 = " = (";
  protected final String TEXT_38 = ")(";
  protected final String TEXT_39 = ".Registry.INSTANCE.get(";
  protected final String TEXT_40 = ".eNS_URI) instanceof ";
  protected final String TEXT_41 = " ? ";
  protected final String TEXT_42 = ".Registry.INSTANCE.get(";
  protected final String TEXT_43 = ".eNS_URI) : ";
  protected final String TEXT_44 = ".eINSTANCE);";
  protected final String TEXT_45 = NL + NL + "\t\t// Step 1: create meta-model objects" + NL + "\t\tthe";
  protected final String TEXT_46 = ".createPackageContents();";
  protected final String TEXT_47 = NL + "\t\t";
  protected final String TEXT_48 = ".createPackageContents();";
  protected final String TEXT_49 = NL + NL + "\t\t// Step 2: complete initialization" + NL + "\t\tthe";
  protected final String TEXT_50 = ".initializePackageContents();";
  protected final String TEXT_51 = NL + "\t\t";
  protected final String TEXT_52 = ".initializePackageContents();";
  protected final String TEXT_53 = NL + NL + "\t\treturn the";
  protected final String TEXT_54 = ";" + NL + "\t}" + NL;
  protected final String TEXT_55 = NL + "\t/**" + NL + "\t * <!-- begin-user-doc -->" + NL + "\t * <!-- end-user-doc -->" + NL + "\t * @generated" + NL + "\t */" + NL + "\tpublic ";
  protected final String TEXT_56 = " get";
  protected final String TEXT_57 = "()" + NL + "\t{" + NL + "\t\treturn ";
  protected final String TEXT_58 = ";" + NL + "\t}" + NL;
  protected final String TEXT_59 = NL + "\t/**" + NL + "\t * <!-- begin-user-doc -->" + NL + "\t * <!-- end-user-doc -->" + NL + "\t * @generated" + NL + "\t */" + NL + "\tpublic ";
  protected final String TEXT_60 = " get";
  protected final String TEXT_61 = "()" + NL + "\t{";
  protected final String TEXT_62 = NL + "\t\treturn (";
  protected final String TEXT_63 = ")";
  protected final String TEXT_64 = ".getEReferences().get(";
  protected final String TEXT_65 = ");";
  protected final String TEXT_66 = NL + "\t\treturn (";
  protected final String TEXT_67 = ")";
  protected final String TEXT_68 = ".getEAttributes().get(";
  protected final String TEXT_69 = ");";
  protected final String TEXT_70 = NL + "\t}" + NL;
  protected final String TEXT_71 = NL + "\t/**" + NL + "\t * <!-- begin-user-doc -->" + NL + "\t * <!-- end-user-doc -->" + NL + "\t * @generated" + NL + "\t */" + NL + "\tpublic ";
  protected final String TEXT_72 = " get";
  protected final String TEXT_73 = "()" + NL + "\t{" + NL + "\t\treturn (";
  protected final String TEXT_74 = ")getEFactoryInstance();" + NL + "\t}" + NL + "" + NL + "\t/**" + NL + "\t * <!-- begin-user-doc -->" + NL + "\t * <!-- end-user-doc -->" + NL + "\t * @generated" + NL + "\t */" + NL + "\tprivate boolean isCreated = false;" + NL + "" + NL + "\t/**" + NL + "\t * Creates the meta-model objects for the package.  This method is" + NL + "\t * guarded to have no affect on any invocation but its first." + NL + "\t * <!-- begin-user-doc -->" + NL + "\t * <!-- end-user-doc -->" + NL + "\t * @generated" + NL + "\t */" + NL + "\tpublic void createPackageContents()" + NL + "\t{" + NL + "\t\tif (isCreated) return;" + NL + "\t\tisCreated = true;";
  protected final String TEXT_75 = NL + NL + "\t\t// Create classes and their features";
  protected final String TEXT_76 = NL + "\t\t";
  protected final String TEXT_77 = " = create";
  protected final String TEXT_78 = "(";
  protected final String TEXT_79 = ");";
  protected final String TEXT_80 = NL + "\t\tcreate";
  protected final String TEXT_81 = "(";
  protected final String TEXT_82 = ", ";
  protected final String TEXT_83 = ");";
  protected final String TEXT_84 = NL;
  protected final String TEXT_85 = NL + NL + "\t\t// Create enums";
  protected final String TEXT_86 = NL + "\t\t";
  protected final String TEXT_87 = " = createEEnum(";
  protected final String TEXT_88 = ");";
  protected final String TEXT_89 = NL + NL + "\t\t// Create data types";
  protected final String TEXT_90 = NL + "\t\t";
  protected final String TEXT_91 = " = createEDataType(";
  protected final String TEXT_92 = ");";
  protected final String TEXT_93 = NL + "\t}" + NL + "" + NL + "\t/**" + NL + "\t * <!-- begin-user-doc -->" + NL + "\t * <!-- end-user-doc -->" + NL + "\t * @generated" + NL + "\t */" + NL + "\tprivate boolean isInitialized = false;" + NL + "" + NL + "\t/**" + NL + "\t * Complete the initialization of the package and its meta-model.  This" + NL + "\t * method is guarded to have no affect on any invocation but its first." + NL + "\t * <!-- begin-user-doc -->" + NL + "\t * <!-- end-user-doc -->" + NL + "\t * @generated" + NL + "\t */" + NL + "\tpublic void initializePackageContents()" + NL + "\t{" + NL + "\t\tif (isInitialized) return;" + NL + "\t\tisInitialized = true;" + NL + "" + NL + "\t\t// Initialize package" + NL + "\t\tsetName(eNAME);" + NL + "\t\tsetNsPrefix(eNS_PREFIX);" + NL + "\t\tsetNsURI(eNS_URI);";
  protected final String TEXT_94 = NL + NL + "\t\t// Obtain other dependent packages";
  protected final String TEXT_95 = NL + "\t\t";
  protected final String TEXT_96 = " ";
  protected final String TEXT_97 = " = (";
  protected final String TEXT_98 = ")";
  protected final String TEXT_99 = ".Registry.INSTANCE.getEPackage(";
  protected final String TEXT_100 = ".eNS_URI);";
  protected final String TEXT_101 = NL + "\t\t";
  protected final String TEXT_102 = " ";
  protected final String TEXT_103 = " = (";
  protected final String TEXT_104 = ")";
  protected final String TEXT_105 = ".Registry.INSTANCE.getEPackage(";
  protected final String TEXT_106 = ".eNS_URI);";
  protected final String TEXT_107 = NL + NL + "\t\t// Add subpackages";
  protected final String TEXT_108 = NL + "\t\tgetESubpackages().add(";
  protected final String TEXT_109 = ");";
  protected final String TEXT_110 = NL + NL + "\t\t// Add supertypes to classes";
  protected final String TEXT_111 = NL + "\t\t";
  protected final String TEXT_112 = ".getESuperTypes().add(";
  protected final String TEXT_113 = ".get";
  protected final String TEXT_114 = "());";
  protected final String TEXT_115 = NL + NL + "\t\t// Initialize classes and features; add operations and parameters";
  protected final String TEXT_116 = NL + "\t\tinitEClass(";
  protected final String TEXT_117 = ", ";
  protected final String TEXT_118 = ".class, \"";
  protected final String TEXT_119 = "\", ";
  protected final String TEXT_120 = ", ";
  protected final String TEXT_121 = ");";
  protected final String TEXT_122 = NL + "\t\tinitEReference(get";
  protected final String TEXT_123 = "(), ";
  protected final String TEXT_124 = ".get";
  protected final String TEXT_125 = "(), ";
  protected final String TEXT_126 = ", \"";
  protected final String TEXT_127 = "\", ";
  protected final String TEXT_128 = ", ";
  protected final String TEXT_129 = ", ";
  protected final String TEXT_130 = ", ";
  protected final String TEXT_131 = ", ";
  protected final String TEXT_132 = ", ";
  protected final String TEXT_133 = ", ";
  protected final String TEXT_134 = ", ";
  protected final String TEXT_135 = ", ";
  protected final String TEXT_136 = ");";
  protected final String TEXT_137 = NL + "\t\tinitEAttribute(get";
  protected final String TEXT_138 = "(), ";
  protected final String TEXT_139 = ".get";
  protected final String TEXT_140 = "(), \"";
  protected final String TEXT_141 = "\", ";
  protected final String TEXT_142 = ", ";
  protected final String TEXT_143 = ", ";
  protected final String TEXT_144 = ", ";
  protected final String TEXT_145 = ", ";
  protected final String TEXT_146 = ", ";
  protected final String TEXT_147 = ", ";
  protected final String TEXT_148 = ", ";
  protected final String TEXT_149 = ");";
  protected final String TEXT_150 = NL;
  protected final String TEXT_151 = NL + "\t\t";
  protected final String TEXT_152 = " op;";
  protected final String TEXT_153 = NL + "\t\top = addEOperation(";
  protected final String TEXT_154 = ", ";
  protected final String TEXT_155 = ".get";
  protected final String TEXT_156 = "(), \"";
  protected final String TEXT_157 = "\");";
  protected final String TEXT_158 = NL + "\t\top = addEOperation(";
  protected final String TEXT_159 = ", null, \"";
  protected final String TEXT_160 = "\");";
  protected final String TEXT_161 = NL + "\t\taddEParameter(op, ";
  protected final String TEXT_162 = ".get";
  protected final String TEXT_163 = "(), \"";
  protected final String TEXT_164 = "\");";
  protected final String TEXT_165 = NL;
  protected final String TEXT_166 = NL + NL + "\t\t// Initialize enums and add enum literals";
  protected final String TEXT_167 = NL + "\t\tinitEEnum(";
  protected final String TEXT_168 = ", ";
  protected final String TEXT_169 = ".class, \"";
  protected final String TEXT_170 = "\");";
  protected final String TEXT_171 = NL + "\t\taddEEnumLiteral(";
  protected final String TEXT_172 = ", ";
  protected final String TEXT_173 = ".";
  protected final String TEXT_174 = "_LITERAL);";
  protected final String TEXT_175 = NL;
  protected final String TEXT_176 = NL + NL + "\t\t// Initialize data types";
  protected final String TEXT_177 = NL + "\t\tinitEDataType(";
  protected final String TEXT_178 = ", ";
  protected final String TEXT_179 = ".class, \"";
  protected final String TEXT_180 = "\", ";
  protected final String TEXT_181 = ");";
  protected final String TEXT_182 = NL + NL + "\t\t// Create resource" + NL + "\t\tcreateResource(eNS_URI);";
  protected final String TEXT_183 = NL + NL + "\t\t// Create annotations";
  protected final String TEXT_184 = NL + "\t\t// ";
  protected final String TEXT_185 = NL + "\t\tcreate";
  protected final String TEXT_186 = "Annotations();";
  protected final String TEXT_187 = NL + "\t}";
  protected final String TEXT_188 = NL + NL + "\t/**" + NL + "\t * Initializes the annotations for <b>";
  protected final String TEXT_189 = "</b>." + NL + "\t * <!-- begin-user-doc -->" + NL + "\t * <!-- end-user-doc -->" + NL + "\t * @generated" + NL + "\t */" + NL + "\tprotected void create";
  protected final String TEXT_190 = "Annotations()" + NL + "\t{" + NL + "\t\tString source = \"";
  protected final String TEXT_191 = "\";";
  protected final String TEXT_192 = "\t";
  protected final String TEXT_193 = "\t" + NL + "\t\taddAnnotation" + NL + "\t\t  (";
  protected final String TEXT_194 = ", " + NL + "\t\t   source, " + NL + "\t\t   new String[] " + NL + "\t\t   {";
  protected final String TEXT_195 = NL + "\t\t\t ";
  protected final String TEXT_196 = ", ";
  protected final String TEXT_197 = NL + "\t\t   });";
  protected final String TEXT_198 = NL + "\t}";
  protected final String TEXT_199 = NL + "} //";
  protected final String TEXT_200 = NL;

  public String generate(Object argument)
  {
    StringBuffer stringBuffer = new StringBuffer();
    
/**
 * <copyright>
 *
 * Copyright (c) 2002 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 *
 * Contributors:
 *   IBM - Initial API and implementation
 *
 * </copyright>
 *
 * plugins/org.eclipse.emf.codegen.ecore/templates/model/PackageClass.javajet, emf.codegen.ecore, org.eclipse.102, 20030326_0335VL
 * @version 1.58 3/26/03
 */

    GenPackage genPackage = (GenPackage)argument; GenModel genModel=genPackage.getGenModel();
    stringBuffer.append(TEXT_1);
    stringBuffer.append(TEXT_2);
    stringBuffer.append("%");
    stringBuffer.append(TEXT_3);
    stringBuffer.append("%");
    stringBuffer.append(TEXT_4);
    stringBuffer.append("%");
    stringBuffer.append(TEXT_5);
    stringBuffer.append(genPackage.getClassPackageName());
    stringBuffer.append(TEXT_6);
    genModel.markImportLocation(stringBuffer);
    stringBuffer.append(TEXT_7);
    stringBuffer.append(genPackage.getPackageClassName());
    stringBuffer.append(TEXT_8);
    stringBuffer.append(genModel.getImportedName("org.eclipse.emf.ecore.impl.EPackageImpl"));
    stringBuffer.append(TEXT_9);
    stringBuffer.append(genPackage.getImportedPackageInterfaceName());
    stringBuffer.append(TEXT_10);
    if (genModel.getCopyrightText() != null) {
    stringBuffer.append(TEXT_11);
    stringBuffer.append(genModel.getImportedName("java.lang.String"));
    stringBuffer.append(TEXT_12);
    stringBuffer.append(genModel.getCopyrightText());
    stringBuffer.append(TEXT_13);
    stringBuffer.append(genModel.getNonNLS());
    stringBuffer.append(TEXT_14);
    }
    for (Iterator i=genPackage.getGenClassifiers().iterator(); i.hasNext();) { GenClassifier genClassifier = (GenClassifier)i.next();
    stringBuffer.append(TEXT_15);
    stringBuffer.append(genClassifier.getImportedMetaType());
    stringBuffer.append(TEXT_16);
    stringBuffer.append(genClassifier.getClassifierInstanceName());
    stringBuffer.append(TEXT_17);
    }
    stringBuffer.append(TEXT_18);
    stringBuffer.append(genPackage.getQualifiedPackageInterfaceName());
    stringBuffer.append(TEXT_19);
    stringBuffer.append(genPackage.getPackageClassName());
    stringBuffer.append(TEXT_20);
    stringBuffer.append(genPackage.getImportedFactoryInterfaceName());
    stringBuffer.append(TEXT_21);
    stringBuffer.append(genPackage.getPackageInterfaceName());
    stringBuffer.append(TEXT_22);
    if (!genPackage.getPackageSimpleDependencies().isEmpty()) {
    stringBuffer.append(TEXT_23);
    for (Iterator p=genPackage.getPackageSimpleDependencies().iterator(); p.hasNext();) { GenPackage dep = (GenPackage)p.next();
    stringBuffer.append(TEXT_24);
    stringBuffer.append(dep.getImportedPackageClassName());
    stringBuffer.append(TEXT_25);
    }
    stringBuffer.append(TEXT_26);
    }
    stringBuffer.append(TEXT_27);
    stringBuffer.append(genPackage.getPackageClassName());
    stringBuffer.append(TEXT_28);
    stringBuffer.append(genPackage.getPackageInterfaceName());
    stringBuffer.append(TEXT_29);
    stringBuffer.append(genPackage.getPackageClassName());
    stringBuffer.append(TEXT_30);
    stringBuffer.append(genModel.getImportedName("org.eclipse.emf.ecore.EPackage"));
    stringBuffer.append(TEXT_31);
    stringBuffer.append(genModel.getImportedName("org.eclipse.emf.ecore.EPackage"));
    stringBuffer.append(TEXT_32);
    stringBuffer.append(genModel.getImportedName("org.eclipse.emf.ecore.EPackage"));
    stringBuffer.append(TEXT_33);
    stringBuffer.append(genPackage.getPackageClassName());
    stringBuffer.append(TEXT_34);
    for (Iterator p=genPackage.getPackageInterDependencies().iterator(); p.hasNext();) { GenPackage interdep = (GenPackage)p.next();
    stringBuffer.append(TEXT_35);
    stringBuffer.append(interdep.getImportedPackageClassName());
    stringBuffer.append(TEXT_36);
    stringBuffer.append(genPackage.getPackageInstanceVariable(interdep));
    stringBuffer.append(TEXT_37);
    stringBuffer.append(interdep.getImportedPackageClassName());
    stringBuffer.append(TEXT_38);
    stringBuffer.append(genModel.getImportedName("org.eclipse.emf.ecore.EPackage"));
    stringBuffer.append(TEXT_39);
    stringBuffer.append(interdep.getImportedPackageInterfaceName());
    stringBuffer.append(TEXT_40);
    stringBuffer.append(genModel.getImportedName("org.eclipse.emf.ecore.EPackage"));
    stringBuffer.append(TEXT_41);
    stringBuffer.append(genModel.getImportedName("org.eclipse.emf.ecore.EPackage"));
    stringBuffer.append(TEXT_42);
    stringBuffer.append(interdep.getImportedPackageInterfaceName());
    stringBuffer.append(TEXT_43);
    stringBuffer.append(interdep.getImportedPackageClassName());
    stringBuffer.append(TEXT_44);
    }
    stringBuffer.append(TEXT_45);
    stringBuffer.append(genPackage.getPackageInterfaceName());
    stringBuffer.append(TEXT_46);
    for (Iterator p=genPackage.getPackageInterDependencies().iterator(); p.hasNext();) { GenPackage interdep = (GenPackage)p.next();
    stringBuffer.append(TEXT_47);
    stringBuffer.append(genPackage.getPackageInstanceVariable(interdep));
    stringBuffer.append(TEXT_48);
    }
    stringBuffer.append(TEXT_49);
    stringBuffer.append(genPackage.getPackageInterfaceName());
    stringBuffer.append(TEXT_50);
    for (Iterator p=genPackage.getPackageInterDependencies().iterator(); p.hasNext();) { GenPackage interdep = (GenPackage)p.next();
    stringBuffer.append(TEXT_51);
    stringBuffer.append(genPackage.getPackageInstanceVariable(interdep));
    stringBuffer.append(TEXT_52);
    }
    stringBuffer.append(TEXT_53);
    stringBuffer.append(genPackage.getPackageInterfaceName());
    stringBuffer.append(TEXT_54);
    for (Iterator m=genPackage.getGenClassifiers().iterator(); m.hasNext();) { GenClassifier genClassifier = (GenClassifier)m.next();
    stringBuffer.append(TEXT_55);
    stringBuffer.append(genClassifier.getImportedMetaType());
    stringBuffer.append(TEXT_56);
    stringBuffer.append(genClassifier.getClassifierAccessorName());
    stringBuffer.append(TEXT_57);
    stringBuffer.append(genClassifier.getClassifierInstanceName());
    stringBuffer.append(TEXT_58);
    if (genClassifier instanceof GenClass) { GenClass genClass = (GenClass)genClassifier;
    for (Iterator f=genClass.getGenFeatures().iterator(); f.hasNext();) { GenFeature genFeature = (GenFeature)f.next();
    stringBuffer.append(TEXT_59);
    stringBuffer.append(genFeature.getImportedMetaType());
    stringBuffer.append(TEXT_60);
    stringBuffer.append(genFeature.getFeatureAccessorName());
    stringBuffer.append(TEXT_61);
    if (genFeature.isReferenceType()) {
    stringBuffer.append(TEXT_62);
    stringBuffer.append(genFeature.getImportedMetaType());
    stringBuffer.append(TEXT_63);
    stringBuffer.append(genClass.getClassifierInstanceName());
    stringBuffer.append(TEXT_64);
    stringBuffer.append(genClass.getLocalFeatureIndex(genFeature));
    stringBuffer.append(TEXT_65);
    } else {
    stringBuffer.append(TEXT_66);
    stringBuffer.append(genFeature.getImportedMetaType());
    stringBuffer.append(TEXT_67);
    stringBuffer.append(genClass.getClassifierInstanceName());
    stringBuffer.append(TEXT_68);
    stringBuffer.append(genClass.getLocalFeatureIndex(genFeature));
    stringBuffer.append(TEXT_69);
    }
    stringBuffer.append(TEXT_70);
    }
    }
    }
    stringBuffer.append(TEXT_71);
    stringBuffer.append(genPackage.getImportedFactoryInterfaceName());
    stringBuffer.append(TEXT_72);
    stringBuffer.append(genPackage.getFactoryInterfaceName());
    stringBuffer.append(TEXT_73);
    stringBuffer.append(genPackage.getImportedFactoryInterfaceName());
    stringBuffer.append(TEXT_74);
    if (!genPackage.getGenClasses().isEmpty()) {
    stringBuffer.append(TEXT_75);
    for (Iterator c=genPackage.getGenClasses().iterator(); c.hasNext();) { GenClass genClass = (GenClass)c.next();
    stringBuffer.append(TEXT_76);
    stringBuffer.append(genClass.getClassifierInstanceName());
    stringBuffer.append(TEXT_77);
    stringBuffer.append(genClass.getMetaType());
    stringBuffer.append(TEXT_78);
    stringBuffer.append(genClass.getClassifierID());
    stringBuffer.append(TEXT_79);
    for (Iterator f=genClass.getGenFeatures().iterator(); f.hasNext();) { GenFeature genFeature = (GenFeature)f.next();
    stringBuffer.append(TEXT_80);
    stringBuffer.append(genFeature.getMetaType());
    stringBuffer.append(TEXT_81);
    stringBuffer.append(genClass.getClassifierInstanceName());
    stringBuffer.append(TEXT_82);
    stringBuffer.append(genClass.getFeatureID(genFeature));
    stringBuffer.append(TEXT_83);
    }
    if (c.hasNext()) {
    stringBuffer.append(TEXT_84);
    }
    }
    }
    if (!genPackage.getGenEnums().isEmpty()) {
    stringBuffer.append(TEXT_85);
    for (Iterator e=genPackage.getGenEnums().iterator(); e.hasNext();) { GenEnum genEnum = (GenEnum)e.next();
    stringBuffer.append(TEXT_86);
    stringBuffer.append(genEnum.getClassifierInstanceName());
    stringBuffer.append(TEXT_87);
    stringBuffer.append(genEnum.getClassifierID());
    stringBuffer.append(TEXT_88);
    }
    }
    if (!genPackage.getGenDataTypes().isEmpty()) {
    stringBuffer.append(TEXT_89);
    for (Iterator d=genPackage.getGenDataTypes().iterator(); d.hasNext();) { GenDataType genDataType = (GenDataType)d.next();
    stringBuffer.append(TEXT_90);
    stringBuffer.append(genDataType.getClassifierInstanceName());
    stringBuffer.append(TEXT_91);
    stringBuffer.append(genDataType.getClassifierID());
    stringBuffer.append(TEXT_92);
    }
    }
    stringBuffer.append(TEXT_93);
    if (!genPackage.getPackageInterDependencies().isEmpty() || !genPackage.getPackageSimpleDependencies().isEmpty()) {
    stringBuffer.append(TEXT_94);
    for (Iterator p=genPackage.getPackageInterDependencies().iterator(); p.hasNext();) { GenPackage interdep = (GenPackage) p.next();
    stringBuffer.append(TEXT_95);
    stringBuffer.append(interdep.getImportedPackageClassName());
    stringBuffer.append(TEXT_96);
    stringBuffer.append(genPackage.getPackageInstanceVariable(interdep));
    stringBuffer.append(TEXT_97);
    stringBuffer.append(interdep.getImportedPackageClassName());
    stringBuffer.append(TEXT_98);
    stringBuffer.append(genModel.getImportedName("org.eclipse.emf.ecore.EPackage"));
    stringBuffer.append(TEXT_99);
    stringBuffer.append(interdep.getImportedPackageInterfaceName());
    stringBuffer.append(TEXT_100);
    }
    for (Iterator p=genPackage.getPackageSimpleDependencies().iterator(); p.hasNext();) { GenPackage dep = (GenPackage)p.next();
    stringBuffer.append(TEXT_101);
    stringBuffer.append(dep.getImportedPackageClassName());
    stringBuffer.append(TEXT_102);
    stringBuffer.append(genPackage.getPackageInstanceVariable(dep));
    stringBuffer.append(TEXT_103);
    stringBuffer.append(dep.getImportedPackageClassName());
    stringBuffer.append(TEXT_104);
    stringBuffer.append(genModel.getImportedName("org.eclipse.emf.ecore.EPackage"));
    stringBuffer.append(TEXT_105);
    stringBuffer.append(dep.getImportedPackageInterfaceName());
    stringBuffer.append(TEXT_106);
    }
    }
    if (!genPackage.getSubGenPackages().isEmpty()) {
    stringBuffer.append(TEXT_107);
    for (Iterator p=genPackage.getSubGenPackages().iterator(); p.hasNext();) { GenPackage sub = (GenPackage)p.next();
    stringBuffer.append(TEXT_108);
    stringBuffer.append(genPackage.getPackageInstanceVariable(sub));
    stringBuffer.append(TEXT_109);
    }
    }
    if (!genPackage.getGenClasses().isEmpty()) { boolean firstOperation = true; 
    stringBuffer.append(TEXT_110);
    for (Iterator c=genPackage.getGenClasses().iterator(); c.hasNext();) { GenClass genClass = (GenClass)c.next();
    for (Iterator b=genClass.getBaseGenClasses().iterator(); b.hasNext();) { GenClass baseGenClass = (GenClass)b.next();
    stringBuffer.append(TEXT_111);
    stringBuffer.append(genClass.getClassifierInstanceName());
    stringBuffer.append(TEXT_112);
    stringBuffer.append(genPackage.getPackageInstanceVariable(baseGenClass.getGenPackage()));
    stringBuffer.append(TEXT_113);
    stringBuffer.append(baseGenClass.getClassifierAccessorName());
    stringBuffer.append(TEXT_114);
    }
    }
    stringBuffer.append(TEXT_115);
    for (Iterator c=genPackage.getGenClasses().iterator(); c.hasNext();) { GenClass genClass = (GenClass)c.next();
    stringBuffer.append(TEXT_116);
    stringBuffer.append(genClass.getClassifierInstanceName());
    stringBuffer.append(TEXT_117);
    stringBuffer.append(genClass.getImportedInterfaceName());
    stringBuffer.append(TEXT_118);
    stringBuffer.append(genClass.getName());
    stringBuffer.append(TEXT_119);
    stringBuffer.append(genClass.getAbstractFlag());
    stringBuffer.append(TEXT_120);
    stringBuffer.append(genClass.getInterfaceFlag());
    stringBuffer.append(TEXT_121);
    stringBuffer.append(genModel.getNonNLS());
    for (Iterator f=genClass.getGenFeatures().iterator(); f.hasNext();) { GenFeature genFeature = (GenFeature)f.next();
    if (genFeature.isReferenceType()) { GenFeature reverseGenFeature = genFeature.getReverse();
    String reverse = reverseGenFeature == null ? "null" : genPackage.getPackageInstanceVariable(reverseGenFeature.getGenPackage()) + ".get" + reverseGenFeature.getFeatureAccessorName() + "()";
    stringBuffer.append(TEXT_122);
    stringBuffer.append(genFeature.getFeatureAccessorName());
    stringBuffer.append(TEXT_123);
    stringBuffer.append(genPackage.getPackageInstanceVariable(genFeature.getTypeGenPackage()));
    stringBuffer.append(TEXT_124);
    stringBuffer.append(genFeature.getTypeClassifier());
    stringBuffer.append(TEXT_125);
    stringBuffer.append(reverse);
    stringBuffer.append(TEXT_126);
    stringBuffer.append(genFeature.getName());
    stringBuffer.append(TEXT_127);
    stringBuffer.append(genFeature.getDefaultValue());
    stringBuffer.append(TEXT_128);
    stringBuffer.append(genFeature.getLowerBound());
    stringBuffer.append(TEXT_129);
    stringBuffer.append(genFeature.getUpperBound());
    stringBuffer.append(TEXT_130);
    stringBuffer.append(genFeature.getTransientFlag());
    stringBuffer.append(TEXT_131);
    stringBuffer.append(genFeature.getVolatileFlag());
    stringBuffer.append(TEXT_132);
    stringBuffer.append(genFeature.getChangeableFlag());
    stringBuffer.append(TEXT_133);
    stringBuffer.append(genFeature.getContainmentFlag());
    stringBuffer.append(TEXT_134);
    stringBuffer.append(genFeature.getResolveProxiesFlag());
    stringBuffer.append(TEXT_135);
    stringBuffer.append(genFeature.getUnsettableFlag());
    stringBuffer.append(TEXT_136);
    stringBuffer.append(genModel.getNonNLS());
    stringBuffer.append(genModel.getNonNLS(genFeature.getDefaultValue(), 2));
    } else {
    stringBuffer.append(TEXT_137);
    stringBuffer.append(genFeature.getFeatureAccessorName());
    stringBuffer.append(TEXT_138);
    stringBuffer.append(genPackage.getPackageInstanceVariable(genFeature.getTypeGenPackage()));
    stringBuffer.append(TEXT_139);
    stringBuffer.append(genFeature.getTypeClassifier());
    stringBuffer.append(TEXT_140);
    stringBuffer.append(genFeature.getName());
    stringBuffer.append(TEXT_141);
    stringBuffer.append(genFeature.getDefaultValue());
    stringBuffer.append(TEXT_142);
    stringBuffer.append(genFeature.getLowerBound());
    stringBuffer.append(TEXT_143);
    stringBuffer.append(genFeature.getUpperBound());
    stringBuffer.append(TEXT_144);
    stringBuffer.append(genFeature.getTransientFlag());
    stringBuffer.append(TEXT_145);
    stringBuffer.append(genFeature.getVolatileFlag());
    stringBuffer.append(TEXT_146);
    stringBuffer.append(genFeature.getChangeableFlag());
    stringBuffer.append(TEXT_147);
    stringBuffer.append(genFeature.getUnsettableFlag());
    stringBuffer.append(TEXT_148);
    stringBuffer.append(genFeature.getIDFlag());
    stringBuffer.append(TEXT_149);
    stringBuffer.append(genModel.getNonNLS());
    stringBuffer.append(genModel.getNonNLS(genFeature.getDefaultValue(), 2));
    }
    }
    for (Iterator o=genClass.getGenOperations().iterator(); o.hasNext();) { GenOperation genOperation = (GenOperation)o.next();
    stringBuffer.append(TEXT_150);
    if (firstOperation) { firstOperation = false;
    stringBuffer.append(TEXT_151);
    stringBuffer.append(genModel.getImportedName("org.eclipse.emf.ecore.EOperation"));
    stringBuffer.append(TEXT_152);
    }
    if (!genOperation.isVoid()) {
    stringBuffer.append(TEXT_153);
    stringBuffer.append(genClass.getClassifierInstanceName());
    stringBuffer.append(TEXT_154);
    stringBuffer.append(genPackage.getPackageInstanceVariable(genOperation.getReturnTypeGenPackage()));
    stringBuffer.append(TEXT_155);
    stringBuffer.append(genOperation.getReturnTypeClassifier());
    stringBuffer.append(TEXT_156);
    stringBuffer.append(genOperation.getName());
    stringBuffer.append(TEXT_157);
    stringBuffer.append(genModel.getNonNLS());
    } else {
    stringBuffer.append(TEXT_158);
    stringBuffer.append(genClass.getClassifierInstanceName());
    stringBuffer.append(TEXT_159);
    stringBuffer.append(genOperation.getName());
    stringBuffer.append(TEXT_160);
    stringBuffer.append(genModel.getNonNLS());
    }
    for (Iterator p=genOperation.getGenParameters().iterator(); p.hasNext();) { GenParameter genParameter = (GenParameter)p.next();
    stringBuffer.append(TEXT_161);
    stringBuffer.append(genPackage.getPackageInstanceVariable(genParameter.getTypeGenPackage()));
    stringBuffer.append(TEXT_162);
    stringBuffer.append(genParameter.getTypeClassifier());
    stringBuffer.append(TEXT_163);
    stringBuffer.append(genParameter.getName());
    stringBuffer.append(TEXT_164);
    stringBuffer.append(genModel.getNonNLS());
    }
    }
    if (c.hasNext()) {
    stringBuffer.append(TEXT_165);
    }
    }
    }
    if (!genPackage.getGenEnums().isEmpty()) {
    stringBuffer.append(TEXT_166);
    for (Iterator e=genPackage.getGenEnums().iterator(); e.hasNext();) { GenEnum genEnum = (GenEnum)e.next();
    stringBuffer.append(TEXT_167);
    stringBuffer.append(genEnum.getClassifierInstanceName());
    stringBuffer.append(TEXT_168);
    stringBuffer.append(genEnum.getImportedName());
    stringBuffer.append(TEXT_169);
    stringBuffer.append(genEnum.getName());
    stringBuffer.append(TEXT_170);
    stringBuffer.append(genModel.getNonNLS());
    for (Iterator l=genEnum.getGenEnumLiterals().iterator(); l.hasNext();) { GenEnumLiteral genEnumLiteral = (GenEnumLiteral)l.next();
    stringBuffer.append(TEXT_171);
    stringBuffer.append(genEnum.getClassifierInstanceName());
    stringBuffer.append(TEXT_172);
    stringBuffer.append(genEnum.getImportedName().equals(genEnum.getClassifierID()) ? genEnum.getQualifiedName() : genEnum.getImportedName());
    stringBuffer.append(TEXT_173);
    stringBuffer.append(genEnumLiteral.getEnumLiteralID());
    stringBuffer.append(TEXT_174);
    }
    if (e.hasNext()) {
    stringBuffer.append(TEXT_175);
    }
    }
    }
    if (!genPackage.getGenDataTypes().isEmpty()) {
    stringBuffer.append(TEXT_176);
    for (Iterator d=genPackage.getGenDataTypes().iterator(); d.hasNext();) { GenDataType genDataType = (GenDataType)d.next();
    stringBuffer.append(TEXT_177);
    stringBuffer.append(genDataType.getClassifierInstanceName());
    stringBuffer.append(TEXT_178);
    stringBuffer.append(genDataType.getImportedInstanceClassName());
    stringBuffer.append(TEXT_179);
    stringBuffer.append(genDataType.getName());
    stringBuffer.append(TEXT_180);
    stringBuffer.append(genDataType.getSerializableFlag());
    stringBuffer.append(TEXT_181);
    stringBuffer.append(genModel.getNonNLS());
    }
    }
    if (genPackage.getSuperGenPackage() == null) {
    stringBuffer.append(TEXT_182);
    }
    if (!genPackage.getAnnotationSources().isEmpty()) {
    stringBuffer.append(TEXT_183);
    for (Iterator i = genPackage.getAnnotationSources().iterator(); i.hasNext();) { String annotationSource = (String)i.next();
    stringBuffer.append(TEXT_184);
    stringBuffer.append(annotationSource);
    stringBuffer.append(TEXT_185);
    stringBuffer.append(genPackage.getAnnotationSourceIdentifier(annotationSource));
    stringBuffer.append(TEXT_186);
    }
    }
    stringBuffer.append(TEXT_187);
    for (Iterator i = genPackage.getAnnotationSources().iterator(); i.hasNext();) { String annotationSource = (String)i.next();
    stringBuffer.append(TEXT_188);
    stringBuffer.append(annotationSource);
    stringBuffer.append(TEXT_189);
    stringBuffer.append(genPackage.getAnnotationSourceIdentifier(annotationSource));
    stringBuffer.append(TEXT_190);
    stringBuffer.append(annotationSource);
    stringBuffer.append(TEXT_191);
    stringBuffer.append(genModel.getNonNLS());
    for (Iterator j = genPackage.getAllAnnotations().iterator(); j.hasNext();) { EAnnotation eAnnotation = (EAnnotation)j.next();
    stringBuffer.append(TEXT_192);
    if (annotationSource.equals(eAnnotation.getSource())) {
    stringBuffer.append(TEXT_193);
    stringBuffer.append(genPackage.getAnnotatedModelElementAccessor(eAnnotation));
    stringBuffer.append(TEXT_194);
    for (Iterator k = eAnnotation.getDetails().iterator(); k.hasNext();) { Map.Entry detail = (Map.Entry)k.next(); String key = Literals.toStringLiteral((String)detail.getKey()); String value = Literals.toStringLiteral((String)detail.getValue());
    stringBuffer.append(TEXT_195);
    stringBuffer.append(key);
    stringBuffer.append(TEXT_196);
    stringBuffer.append(value);
    stringBuffer.append(k.hasNext() ? "," : "");
    stringBuffer.append(genModel.getNonNLS(key + value));
    }
    stringBuffer.append(TEXT_197);
    }
    }
    stringBuffer.append(TEXT_198);
    }
    stringBuffer.append(TEXT_199);
    stringBuffer.append(genPackage.getPackageClassName());
    genModel.emitSortedImports();
    stringBuffer.append(TEXT_200);
    return stringBuffer.toString();
  }
}
