/**
 * <copyright>
 *
 * Copyright (c) 2002 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 * 
 * Contributors: 
 *   IBM - Initial API and implementation
 *
 * </copyright>
 *
 * plugins/org.eclipse.emf.ecore/src/org/eclipse/emf/ecore/impl/EObjectImpl.java, emf.ecore, org.eclipse.102, 20030326_0335VL
 * @version 1.86 3/26/03
 */
package org.eclipse.emf.ecore.impl;


import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.NotificationChain;
import org.eclipse.emf.common.notify.NotifyingList;

import org.eclipse.emf.common.notify.impl.NotificationChainImpl;
import org.eclipse.emf.common.notify.impl.NotifierImpl;

import org.eclipse.emf.common.util.AbstractTreeIterator;
import org.eclipse.emf.common.util.BasicEList;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.common.util.WrappedException;

import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.EcorePackage;
import org.eclipse.emf.ecore.InternalEObject;

import org.eclipse.emf.ecore.impl.ENotificationImpl;

import org.eclipse.emf.ecore.resource.Resource;

import org.eclipse.emf.ecore.util.EContentsEList;
import org.eclipse.emf.ecore.util.ECrossReferenceEList;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.ecore.util.InternalEList;


/**
 * <!-- begin-user-doc -->
 * An implementation of the model object '<em><b>EObject</b></em>'.
 * @extends InternalEObject
 * <!-- end-user-doc -->
 * <p>
 * </p>
 *
 * @generated
 */
public class EObjectImpl extends NotifierImpl implements EObject, InternalEObject
{
  /**
   * This is unused, but we can reserve bits with eFlags.
   */
  public static final int ELAST_EOBJECT_FLAG = ELAST_NOTIFIER_FLAG;

  /**
   * An internal class for holding less frequently members variables.
   */
  protected static class EPropertiesHolder
  {
    public EClass eClass;
    public URI eProxyURI;
    public Resource.Internal eResource;
    public EList eContents;
    public EList eCrossReferences;
    public EStructuralFeature.Setting[] eSettings;
  }

  protected InternalEObject eContainer;
  protected int eContainerFeatureID;
  protected EPropertiesHolder eProperties;
  
  /**
   * <!-- begin-user-doc -->
   * Creates an EObject.
   * <!-- end-user-doc -->
   * @generated modifiable
   */
  protected EObjectImpl() 
  {
    super();
  }

  protected EPropertiesHolder eProperties()
  {
    if (eProperties == null)
    {
      eProperties = new EPropertiesHolder();
    }
    return eProperties;
  }

  protected EStructuralFeature.Setting[] eSettings()
  {
    if (eProperties().eSettings == null)
    {
      EClass eClass = eClass();
      int size =  eClass().getEAllStructuralFeatures().size() - eStaticClass().getEAllStructuralFeatures().size();
      if (size > 0)
      {
        eProperties.eSettings = new EStructuralFeature.Setting[size];
      }
    }
    return eProperties.eSettings;
  }

  protected int eSettingIndex(EStructuralFeature eStructuralFeature)
  {
    return eClass().getEAllStructuralFeatures().indexOf(eStructuralFeature) - eStaticClass().getEAllStructuralFeatures().size();
  }

  public String eURIFragmentSegment(EStructuralFeature eStructuralFeature, EObject eObject)
  {
    if (eStructuralFeature == null)
    {
      for (EContentsEList.FeatureIterator crossReferences = 
             (EContentsEList.FeatureIterator)((InternalEList)eCrossReferences()).basicIterator(); 
           crossReferences.hasNext(); )
      {
        EObject crossReference = (EObject)crossReferences.next();
        if (crossReference == eObject)
        {
          eStructuralFeature = crossReferences.feature();
        }
      }
    }

    if (eStructuralFeature.isMany())
    {
      EList eList = (EList)eGet(eStructuralFeature, false);
      int index = eList.indexOf(eObject);
      return '@' + eStructuralFeature.getName() + '.' + index;
    }
    else
    {
      return '@' + eStructuralFeature.getName();
    }
  }

  public EObject eObjectForURIFragmentSegment(String uriFragmentSegment)
  {
    int dotIndex = uriFragmentSegment.indexOf(".");
    if (dotIndex == -1)
    {
      EStructuralFeature eStructuralFeature = eClass().getEStructuralFeature(uriFragmentSegment.substring(1));
      return (EObject)eGet(eStructuralFeature, false);
    }
    else
    {
      EStructuralFeature eStructuralFeature = eClass().getEStructuralFeature(uriFragmentSegment.substring(1, dotIndex));
      EList eList = (EList)eGet(eStructuralFeature, false);
      int position = 0;
      try
      {
        position = Integer.parseInt(uriFragmentSegment.substring(dotIndex + 1));
      }
      catch (NumberFormatException exception)
      {
        throw new WrappedException(exception);
      }
      return position < eList.size() ?
        (EObject)eList.get(position) :
        null;
    }
  }

  public boolean eContains(EObject eObject)
  {
    return EcoreUtil.isAncestor(this, eObject);
  }

  public EObject eContainer()
  {
    return eContainer;
  }

  public int eContainerFeatureID()
  {
    return eContainerFeatureID;
  }

  public EList eContents()
  {
    if (eProperties().eContents == null)
    {
      eProperties.eContents = 
        new EContentsEList
          (this, 
           (EStructuralFeature [])((BasicEList)eClass().getEAllContainments()).data());
    }

    return eProperties.eContents;
  }

  public EList eCrossReferences()
  {
    if (eProperties().eCrossReferences == null)
    {
      eProperties.eCrossReferences = new ECrossReferenceEList(this);
    }

    return eProperties.eCrossReferences;
  }

  public TreeIterator eAllContents()
  {
    return 
      new AbstractTreeIterator(this, false)
      {
        public Iterator getChildren(Object object)
        {
          return ((EObject)object).eContents().iterator();
        }
      };
  }

  /**
   * @generated modifiable
   */
  public EStructuralFeature eContainmentFeature()
  {
    return 
      eContainer == null ?
        null :
        eContainerFeatureID <= EOPPOSITE_FEATURE_BASE ? 
          (EStructuralFeature)eContainer.eClass().getEAllStructuralFeatures().get(EOPPOSITE_FEATURE_BASE - eContainerFeatureID) :
          ((EReference)eClass().getEAllStructuralFeatures().get(eContainerFeatureID)).getEOpposite();
  }

  protected Resource.Internal eDirectResource()
  {
    return eProperties == null ? null : eProperties.eResource;
  }

  /**
   * @generated modifiable
   */
  public Resource eResource()
  {
    return eInternalResource();
  }

  public Resource.Internal eInternalResource()
  {
    Resource.Internal result = eDirectResource();
    if (result == null && eContainer != null)
    {
      result = eContainer.eInternalResource();
    }
    return result;
  }

  public NotificationChain eSetResource(Resource.Internal resource, NotificationChain notifications)
  {
    Resource oldResource = eDirectResource();
    if (oldResource != null)
    {
      notifications = ((InternalEList)oldResource.getContents()).basicRemove(this, notifications);
    }
    else if (eContainer != null)
    {
      notifications = eBasicRemoveFromContainer(notifications);
      notifications = eBasicSetContainer(null, -1, notifications);
    }

    eProperties().eResource = resource;

    return notifications;
  }

  public Object eGet(EStructuralFeature eFeature)
  {
    return eGet(eFeature, true);
  }

  public Object eGet(EStructuralFeature eFeature, boolean resolve)
  {
    return eDynamicGet(eFeature, resolve);
  }

  public Object eDynamicGet(EStructuralFeature eFeature, boolean resolve)
  {
    int index = eSettingIndex(eFeature);
    if (index <= -1)
    {
      throw new IllegalArgumentException("The feature '" + eFeature.getName() + "' is not a valid feature");
    }

    EStructuralFeature.Setting[] settings = eSettings();
    EStructuralFeature.Setting setting = settings[index];
    if (setting == null)
    {
      if (eFeature.isMany())
      {
        settings[index] = (setting = ((EStructuralFeatureImpl)eFeature).createDynamicSetting(this));
        return setting;
      }
      else
      {
        return eFeature.getDefaultValue();
      }
    }
    else
    {
      Object result = setting.get(resolve);
      return result;
    }
  }

  public void eSet(EStructuralFeature eFeature, Object newValue) 
  {
    eDynamicSet(eFeature, newValue);
  }

  public void eDynamicSet(EStructuralFeature eFeature, Object newValue) 
  {
    int index = eSettingIndex(eFeature);
    if (index <= -1 || !eFeature.isChangeable())
    {
      throw new IllegalArgumentException("The feature '" + eFeature.getName() + "' is not a valid changeable feature");
    }
    EStructuralFeature.Setting[] settings = eSettings();
    EStructuralFeature.Setting setting = settings[index];
    if (setting == null)
    {
      settings[index] = (setting = ((EStructuralFeatureImpl)eFeature).createDynamicSetting(this));
    }
    setting.set(newValue);
  }

  public void eUnset(EStructuralFeature eFeature) 
  {
    eDynamicUnset(eFeature);
  }

  public void eDynamicUnset(EStructuralFeature eFeature) 
  {
    int index = eSettingIndex(eFeature);
    if (index <= -1 || !eFeature.isChangeable())
    {
      throw new IllegalArgumentException("The feature '" + eFeature.getName() + "' is not a valid changeable feature");
    }
    EStructuralFeature.Setting[] settings = eSettings();
    EStructuralFeature.Setting setting = settings[index];
    if (setting == null)
    {
      settings[index] = (setting = ((EStructuralFeatureImpl)eFeature).createDynamicSetting(this));
    }
    setting.unset();
  }

  public boolean eIsSet(EStructuralFeature eFeature) 
  {
    return eDynamicIsSet(eFeature);
  }

  public boolean eDynamicIsSet(EStructuralFeature eFeature) 
  {
    int index = eSettingIndex(eFeature);
    if (index <= -1)
    {
      throw new IllegalArgumentException("The feature '" + eFeature.getName() + "' is not a valid feature");
    }

    if (eProperties != null)
    {
      EStructuralFeature.Setting[] settings = eProperties.eSettings;
      if (settings != null)
      {
        EStructuralFeature.Setting setting = settings[index];
        if (setting != null)
        {
          boolean result = setting.isSet();
          return result;
        }
      }
    }
    return false;
  }

  public NotificationChain eBasicSetContainer(InternalEObject newContainer, int newContainerFeatureID, NotificationChain msgs)
  {
    Resource.Internal oldResource = this.eDirectResource();
    if (oldResource != null)
    {
      msgs = ((InternalEList)oldResource.getContents()).basicRemove(this, msgs);
      oldResource = eProperties.eResource = null;
    }
    else
    {
      oldResource = this.eInternalResource();
    }

    Resource.Internal newResource = newContainer == null ? null : newContainer.eInternalResource();
    if (oldResource != newResource) 
    {
      if (oldResource != null) oldResource.detached(this);
      if (newResource != null) newResource.attached(this);
    }

    EObject oldContainer = eContainer;
    int oldContainerFeatureID = eContainerFeatureID;
    eContainer = newContainer;
    eContainerFeatureID = newContainerFeatureID;
    if (eNotificationRequired())
    {
      if (msgs == null) msgs = new NotificationChainImpl(4);
      if (oldContainer != null && oldContainerFeatureID >=0 && oldContainerFeatureID != newContainerFeatureID)
      {
        msgs.add
          (new ENotificationImpl
            (this,
             Notification.SET,
             oldContainerFeatureID, 
             oldContainer,
             null));
      }
      if (newContainerFeatureID >= 0)
      {
        msgs.add
          (new ENotificationImpl
            (this,
             Notification.SET,
             newContainerFeatureID, 
             oldContainerFeatureID == newContainerFeatureID ? oldContainer : null,
             newContainer));
      }
    }
    return msgs;
  }

  public NotificationChain eBasicRemoveFromContainer(NotificationChain msgs)
  {
    if (eContainerFeatureID >= 0)
    {
      return eDynamicBasicRemoveFromContainer(msgs);
    }
    else 
    {
      return eContainer.eInverseRemove(this, EOPPOSITE_FEATURE_BASE - eContainerFeatureID, null, msgs);
    }
  }

  public NotificationChain eDynamicBasicRemoveFromContainer(NotificationChain msgs)
  {
    EReference inverseFeature = ((EReference)eClass().getEAllStructuralFeatures().get(eContainerFeatureID)).getEOpposite();
    return eContainer.eInverseRemove(this, inverseFeature.getFeatureID(), inverseFeature.getContainerClass(), msgs);
  }

  public NotificationChain eInverseAdd(InternalEObject otherEnd, int featureID, Class baseClass, NotificationChain msgs)
  {
    if (featureID >= 0)
    {
      return eDynamicInverseAdd(otherEnd, featureID, baseClass, msgs);
    }
    else
    {
      if (eContainer != null)
      {
        msgs = eBasicRemoveFromContainer(msgs);
      }
      return eBasicSetContainer(otherEnd, featureID, msgs);
    }
  }

  public NotificationChain eDynamicInverseAdd(InternalEObject otherEnd, int featureID, Class baseClass, NotificationChain msgs)
  {
    EStructuralFeature feature = (EStructuralFeature)eClass().getEAllStructuralFeatures().get(featureID);
    return ((EStructuralFeature.Setting.Internal)eSetting(feature)).basicAdd(otherEnd, msgs);
  }


  public NotificationChain eInverseRemove(InternalEObject otherEnd, int featureID, Class baseClass, NotificationChain msgs)
  {
    if (featureID >= 0)
    {
      return eDynamicInverseRemove(otherEnd, featureID, baseClass, msgs);
    }
    else
    {
      return eBasicSetContainer(null, featureID, msgs);
    }
  }

  public NotificationChain eDynamicInverseRemove(InternalEObject otherEnd, int featureID, Class baseClass, NotificationChain msgs)
  {
    EStructuralFeature feature = (EStructuralFeature)eClass().getEAllStructuralFeatures().get(featureID);
    return ((EStructuralFeature.Setting.Internal)eSetting(feature)).basicRemove(otherEnd, msgs);
  }

  public URI eProxyURI()
  {
    return eProperties == null ? null : eProperties.eProxyURI;
  }

  public void eSetProxyURI(URI uri)
  {
    eProperties().eProxyURI = uri;
  }

  public boolean eIsProxy()
  {
    return eProperties != null && eProperties.eProxyURI != null;
  }

  public int eBaseStructuralFeatureID(int derivedFeatureID, Class baseClass)
  {
    return derivedFeatureID;
  }

  public int eDerivedStructuralFeatureID(int baseFeatureID, Class baseClass)
  {
    return baseFeatureID;
  }

  public EClass eClass()
  {
    if (eProperties != null)
    {
      EClass result = eProperties.eClass;
      if (result != null)
      {
        return result;
      }
    }
    return eStaticClass();
  }

  // Subclasses MUST override this function
  protected EClass eStaticClass()
  {
    return EcorePackage.eINSTANCE.getEObject();
  }

  public void eSetClass(EClass eClass)
  {
    eProperties().eClass = eClass;
  }

  public EStructuralFeature.Setting eSetting(final EStructuralFeature eFeature)
  {
    int index = eClass().getEAllStructuralFeatures().indexOf(eFeature);
    int dynamicIndex = eStaticClass().getEAllStructuralFeatures().size();
    if (index >= dynamicIndex)
    {
      EStructuralFeature.Setting[] settings = eSettings();
      index -= dynamicIndex;
      EStructuralFeature.Setting setting = settings[index];
      if (setting == null)
      {
        settings[index] = (setting = ((EStructuralFeatureImpl)eFeature).createDynamicSetting(this));
      }
      return setting;
    }
    else if (index <= -1)
    {
      throw new IllegalArgumentException("The feature '" + eFeature.getName() + "' is not a valid feature");
    }
    else if (eFeature.isMany())
    {
      return (EStructuralFeature.Setting)eGet(eFeature, false);
    }
    else
    {
      EStructuralFeature.Setting setting =
        new EStructuralFeature.Setting.Internal()
        {
          public EObject getEObject()
          {
            return EObjectImpl.this;
          }

          public EStructuralFeature getEStructuralFeature()
          {
            return eFeature;
          }

          public Object get(boolean resolve)
          {
            return EObjectImpl.this.eGet(eFeature, resolve);
          }

          public void set(Object newValue)
          {
            EObjectImpl.this.eSet(eFeature, newValue);
          }

          public boolean isSet()
          {
            return EObjectImpl.this.eIsSet(eFeature);
          }

          public void unset()
          {
            EObjectImpl.this.eUnset(eFeature);
          }

          public NotificationChain basicAdd(Object object, NotificationChain notifications)
          {
            throw new UnsupportedOperationException();
          }

          public NotificationChain basicRemove(Object object, NotificationChain notifications)
          {
            throw new UnsupportedOperationException();
          }
        };

      return setting;
    }
  }

  public String toString()
  {
    // Should use the following code to improve debuggability. Will need to
    // update testcase baselogs before this change can be made.

    StringBuffer result = new StringBuffer(getClass().getName());
    result.append('@');
    result.append(Integer.toHexString(hashCode()));

    if (eIsProxy())
    {
      result.append(" (eProxyURI: ");
      result.append(eProxyURI());
      if (eProperties != null && eProperties.eClass != null)
      {
        result.append(" eClass: ");
        result.append(eProperties.eClass);
      }
      result.append(')');
    }
    else if (eProperties != null && eProperties.eClass != null)
    {
      result.append(" (eClass: ");
      result.append(eProperties.eClass);
      result.append(')');
    }

    return result.toString();
  }
}
