/**
 * <copyright>
 *
 * Copyright (c) 2002 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 *
 * Contributors:
 *   IBM - Initial API and implementation
 *
 * </copyright>
 *
 * plugins/org.eclipse.emf.ecore/src/org/eclipse/emf/ecore/plugin/URIMappingRegistryReader.java, emf.ecore, org.eclipse.102, 20030326_0335VL
 * @version 1.4 3/26/03
 */
package org.eclipse.emf.ecore.plugin;


import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.emf.ecore.resource.URIConverter;
import java.net.URL;

import org.eclipse.emf.common.util.URI;


/**
 * A plugin extension reader that populates the
 * {@link org.eclipse.emf.ecore.resource.URIConverter#URI_MAP global} mapping registry.
 * Clients are not expected to use this class directly.
 */
class URIMappingRegistryReader extends RegistryReader 
{
  static final String TAG_MAPPING  = "mapping";
  static final String ATT_SOURCE   = "source";
  static final String ATT_TARGET   = "target";
   
  public URIMappingRegistryReader() 
  {
    super
      (Platform.getPluginRegistry(),
       EcorePlugin.getPlugin().getDescriptor().getUniqueIdentifier(),
       EcorePlugin.URI_MAPPING_PPID);
  }

  protected boolean readElement(IConfigurationElement element) 
  {
    if (element.getName().equals(TAG_MAPPING))
    {
      String sourceURIValue = element.getAttribute(ATT_SOURCE);
      if (sourceURIValue == null)
      {
        logMissingAttribute(element, ATT_SOURCE);
      }
      else
      {
        String targetURIValue = element.getAttribute(ATT_TARGET);
        if (targetURIValue == null)
        {
          logMissingAttribute(element, ATT_TARGET);
        }
        else
        {
          URI sourceURI = URI.createDeviceURI(sourceURIValue);
          URI targetURI = URI.createDeviceURI(targetURIValue);
          if (targetURI.isRelative() && targetURI.hasRelativePath())
          {
            targetURI = 
              targetURI.resolve
                (URI.createDeviceURI
                  (element.getDeclaringExtension().getDeclaringPluginDescriptor().getInstallURL().toString()));
          }
          URIConverter.URI_MAP.put(sourceURI, targetURI);
          return true;
        }
      }
    }
    return false;
  }
}
