/**
 * <copyright>
 *
 * Copyright (c) 2002 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 *
 * Contributors:
 *   IBM - Initial API and implementation
 *
 * </copyright>
 *
 * plugins/org.eclipse.emf.ecore/src/org/eclipse/emf/ecore/util/InternalEList.java, emf.ecore, org.eclipse.102, 20030326_0335VL
 * @version 1.15 3/26/03
 */
package org.eclipse.emf.ecore.util;


import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;

import org.eclipse.emf.common.notify.NotificationChain;

import org.eclipse.emf.common.util.EList;


public interface InternalEList extends EList
{
  /**
   * Returns an unmodifiable list that yields unresolved values.
   */
  List basicList();

  /**
   * Returns an iterator that yields unresolved values.
   */
  Iterator basicIterator();

  /**
   * Returns a list iterator that yields unresolved values.
   */
  ListIterator basicListIterator();

  /**
   * Returns a list iterator that yields unresolved values.
   */
  ListIterator basicListIterator(int index);

  /**
   * Remove the object with without updating the inverse.
   */
  NotificationChain basicRemove(Object object, NotificationChain notifications);

  /**
   * Add the object without updating the inverse.
   */
  NotificationChain basicAdd(Object object, NotificationChain notifications);

  /**
   * Add the object without verifying uniqueness.
   */
  void addUnique(Object object);

  /**
   * Add the object without verifying uniqueness.
   */
  void addUnique(int index, Object object);
}
