/**
 * <copyright>
 *
 * Copyright (c) 2002 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 * 
 * Contributors: 
 *   IBM - Initial API and implementation
 *
 * </copyright>
 *
 * plugins/org.eclipse.emf.ecore.editor/src/org/eclipse/emf/ecore/action/OpenEditorAction.java, emf.ecore.editor, org.eclipse.102, 20030326_0335VL
 * @version 1.2 3/26/03
 */
package org.eclipse.emf.ecore.action;


import org.eclipse.core.resources.IFile;

import org.eclipse.emf.common.util.URI;

import org.eclipse.emf.ecore.resource.Resource;

import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;

import org.eclipse.jface.dialogs.MessageDialog;

import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;

import org.eclipse.jface.wizard.WizardDialog;

import org.eclipse.swt.widgets.Shell;

import org.eclipse.ui.IActionDelegate;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;

import org.eclipse.ui.actions.ActionDelegate;


/**
 * Generate Java beans from the XML Schema
 */
public class OpenEditorAction extends ActionDelegate
       implements IActionDelegate
{
  protected IFile file;

  public OpenEditorAction()
  {
  }

  public void run(IAction action)
  {
    IWorkbenchWindow workbenchWindow = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
    IWorkbenchPage page = workbenchWindow.getActivePage();

    // Open an editor on the new file.
    //
    try
    {
      page.openEditor
        (file, 
          action.getId().indexOf("XML") == -1 ? 
            "org.eclipse.emf.ecore.presentation.ReflectiveEditorID" :
            "org.eclipse.emf.ecore.presentation.XMLReflectiveEditorID");
    }
    catch (PartInitException exception)
    {
      MessageDialog.openError(workbenchWindow.getShell(), "Open Editor", exception.getMessage());
    }
  }

  public void selectionChanged(IAction action, ISelection selection) 
  {
    if (selection instanceof IStructuredSelection)
    {
      Object object = ((IStructuredSelection)selection).getFirstElement();
      if (object instanceof IFile)
      {
        file = (IFile)object;

        action.setEnabled
          (action.getId().indexOf("XML") != -1 ||
             Resource.Factory.Registry.INSTANCE.getExtensionToFactoryMap().containsKey
               (file.getFullPath().getFileExtension()));
        return;
      }
    }
    file = null;
    action.setEnabled(false);
  }
}
