/**
 * <copyright> 
 *
 * Copyright (c) 2002 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 * 
 * Contributors: 
 *   IBM - Initial API and implementation
 *
 * </copyright>
 *
 * plugins/org.eclipse.emf.common.ui/src/org/eclipse/emf/common/ui/celleditor/ExtendedDialogCellEditor.java, emf.common.ui, org.eclipse.102, 20030326_0335VL
 * @version 1.1 3/26/03
 */
package org.eclipse.emf.common.ui.celleditor;


import java.util.Iterator;
import java.util.List;

import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.DialogCellEditor;
import org.eclipse.jface.viewers.ICellEditorValidator;
import org.eclipse.jface.viewers.ILabelProvider;

import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;


/**
 * This uses a label provider to display a dialog cell editor.
 */
public abstract class ExtendedDialogCellEditor extends DialogCellEditor
{
  protected ILabelProvider labelProvider;

  public ExtendedDialogCellEditor(Composite composite, ILabelProvider labelProvider)
  {
    super(composite);
    this.labelProvider = labelProvider;
  }

  protected void updateContents(Object object)
  {
    if (getDefaultLabel() != null && labelProvider != null)
    {
      getDefaultLabel().setText(labelProvider.getText(object));
    }
  }
}
