/**
 * <copyright>
 *
 * Copyright (c) 2002 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 * 
 * Contributors: 
 *   IBM - Initial API and implementation
 *
 * </copyright>
 *
 * plugins/org.eclipse.emf.ecore.xmi/src/org/eclipse/emf/ecore/xmi/ClassNotFoundException.java, emf.ecore.xmi, org.eclipse.102, 20030326_0335VL
 * @version 1.4 3/26/03
 */
package org.eclipse.emf.ecore.xmi;

import org.eclipse.emf.ecore.EFactory;

public class ClassNotFoundException extends XMIException {
    protected String className;
    protected EFactory factory;

	/**
	 * Constructor for ClassNotFoundException.
	 * @param name
	 * @param factory
	 * @param location
	 * @param line
	 * @param column
	 */
	public ClassNotFoundException(
		String name,
		EFactory factory,
		String location,
		int line,
		int column) {
		super("Class '" + name + "' not found.", location, line, column);
		className = name;
		this.factory = factory;
	}
	
	public String getName() {
		return className;
	}	
	
	public EFactory getFactory() {
		return factory;
	}	
}
