/**
 * <copyright>
 *
 * Copyright (c) 2002 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 *
 * Contributors:
 *   IBM - Initial API and implementation
 *
 * </copyright>
 *
 * plugins/org.eclipse.emf.ecore.xmi/src/org/eclipse/emf/ecore/xmi/impl/EcoreResourceFactoryImpl.java, emf.ecore.xmi, org.eclipse.102, 20030326_0335VL
 * @version 1.5 3/26/03
 */
package org.eclipse.emf.ecore.xmi.impl;


import org.eclipse.emf.common.util.URI;

import org.eclipse.emf.ecore.resource.Resource;

import org.eclipse.emf.ecore.resource.impl.ResourceFactoryImpl;

import org.eclipse.emf.ecore.xmi.XMIResource;


public class EcoreResourceFactoryImpl extends ResourceFactoryImpl
{
  /**
   * Constructor for EcoreResourceFactoryImpl.
   */
  public EcoreResourceFactoryImpl()
  {
    super();
  }

  public Resource createResource(URI uri)
  {
    XMLResourceImpl result = new XMIResourceImpl(uri);
    result.getDefaultSaveOptions().put(XMIResource.OPTION_USE_ENCODED_ATTRIBUTE_STYLE, Boolean.TRUE);
    result.getDefaultSaveOptions().put(XMIResource.OPTION_LINE_WIDTH, new Integer(80));
    return result;
  }
}
