/**
 * <copyright>
 *
 * Copyright (c) 2002 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 *
 * Contributors:
 *   IBM - Initial API and implementation
 *
 * </copyright>
 *
 * plugins/org.eclipse.emf.ecore.xmi/src/org/eclipse/emf/ecore/xmi/impl/XMILoadImpl.java, emf.ecore.xmi, org.eclipse.102, 20030326_0335VL
 * @version 1.1 3/26/03
 */
package org.eclipse.emf.ecore.xmi.impl;

import org.eclipse.emf.ecore.xmi.XMLHelper;
import org.xml.sax.helpers.DefaultHandler;

/**
 * This class creates an XMIHandler rather than an
 * XMLHandler so an XMI file can be loaded.
 */
public class XMILoadImpl extends XMLLoadImpl {

  /**
   * Constructor for XMILoad.
   */
  public XMILoadImpl(XMLHelper helper) {
    super(helper);
  }

  protected DefaultHandler makeDefaultHandler()
  {
    return new SAXWrapper(new SAXXMIHandler(resource, helper, options));
  }

}
