/**
 * <copyright> 
 *
 * Copyright (c) 2002 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 * 
 * Contributors: 
 *   IBM - Initial API and implementation
 *
 * </copyright>
 *
 * plugins/org.eclipse.emf.edit.ui/src/org/eclipse/emf/edit/ui/action/CopyAction.java, emf.edit.ui, org.eclipse.102, 20030326_0335VL
 * @version 1.3 3/26/03
 */
package org.eclipse.emf.edit.ui.action;


import org.eclipse.emf.common.command.Command;

import org.eclipse.emf.edit.command.CopyToClipboardCommand;

import org.eclipse.emf.edit.ui.EMFEditUIPlugin;

import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.edit.domain.IEditingDomainProvider;

import java.util.Collection;

import org.eclipse.ui.IEditorPart;


/**
 * A copy action is implemented by creating a {@link CopyToClipboardCommand}.
 */
public class CopyAction extends CommandActionHandler
{
  public CopyAction(EditingDomain domain)
  {
    super(domain, EMFEditUIPlugin.INSTANCE.getString("_UI_Copy_menu_item"));
  }

  public CopyAction()
  {
    super(null, EMFEditUIPlugin.INSTANCE.getString("_UI_Copy_menu_item"));
  }

  public Command createCommand(Collection selection)
  {
    return CopyToClipboardCommand.create(domain, selection);
  }

  public void setActiveEditor(IEditorPart editorPart)
  {
    if (editorPart instanceof IEditingDomainProvider)
    {
      domain = ((IEditingDomainProvider)editorPart).getEditingDomain();
    }
  }
}
