/**
 * <copyright>
 *
 * Copyright (c) 2002 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 *
 * Contributors:
 *   IBM - Initial API and implementation
 *
 * </copyright>
 *
 * plugins/org.eclipse.emf.ecore.edit/src/org/eclipse/emf/ecore/provider/EStructuralFeatureItemProvider.java, emf.ecore.edit, org.eclipse.102, 20030326_0335VL
 * @version 1.4 3/26/03
 */
package org.eclipse.emf.ecore.provider;


import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;

import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.Notifier;

import org.eclipse.emf.common.util.ResourceLocator;

import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.EcorePackage;

import org.eclipse.emf.edit.command.AddCommand;
import org.eclipse.emf.edit.command.RemoveCommand;

import org.eclipse.emf.edit.domain.AdapterFactoryEditingDomain;
import org.eclipse.emf.edit.domain.EditingDomain;

import org.eclipse.emf.edit.provider.ComposeableAdapterFactory;
import org.eclipse.emf.edit.provider.ComposedImage;
import org.eclipse.emf.edit.provider.IEditingDomainItemProvider;
import org.eclipse.emf.edit.provider.IItemLabelProvider;
import org.eclipse.emf.edit.provider.IItemPropertySource;
import org.eclipse.emf.edit.provider.IStructuredItemContentProvider;
import org.eclipse.emf.edit.provider.ITreeItemContentProvider;
import org.eclipse.emf.edit.provider.ItemPropertyDescriptor;
import org.eclipse.emf.edit.provider.ItemProviderAdapter;


/**
 * This is the item provider adpater for a {@link org.eclipse.emf.ecore.EStructuralFeature} object.
 * <!-- begin-user-doc -->
 * <!-- end-user-doc -->
 * @generated
 */
public class EStructuralFeatureItemProvider
  extends ETypedElementItemProvider
  implements
    IEditingDomainItemProvider, IStructuredItemContentProvider, ITreeItemContentProvider, IItemLabelProvider, IItemPropertySource
{
  /**
   * This constructs an instance from a factory and a notifier.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   */
  public EStructuralFeatureItemProvider(AdapterFactory adapterFactory)
  {
    super(adapterFactory);
  }

  /**
   * This returns the property descriptors for the adapted class.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   */
  public List getPropertyDescriptors(Object object)
  {
    if (itemPropertyDescriptors == null)
    {
      super.getPropertyDescriptors(object);

      addChangeablePropertyDescriptor(object);
      addVolatilePropertyDescriptor(object);
      addTransientPropertyDescriptor(object);
      addUniquePropertyDescriptor(object);
      addDefaultValueLiteralPropertyDescriptor(object);
      addDefaultValuePropertyDescriptor(object);
      addLowerBoundPropertyDescriptor(object);
      addUpperBoundPropertyDescriptor(object);
      addManyPropertyDescriptor(object);
      addRequiredPropertyDescriptor(object);
      addUnsettablePropertyDescriptor(object);
      addEContainingClassPropertyDescriptor(object);
    }
    return itemPropertyDescriptors;
  }

  /**
   * This adds a property descriptor for the Changeable feature.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   */
  protected void addChangeablePropertyDescriptor(Object object)
  {
    itemPropertyDescriptors.add
      (new ItemPropertyDescriptor
        (((ComposeableAdapterFactory)adapterFactory).getRootAdapterFactory(),
         getString("_UI_EStructuralFeature_changeable_feature"),
         getString("_UI_PropertyDescriptor_description", "_UI_EStructuralFeature_changeable_feature", "_UI_EStructuralFeature_type"),
         EcorePackage.eINSTANCE.getEStructuralFeature_Changeable(),
         true,
         ItemPropertyDescriptor.BOOLEAN_VALUE_IMAGE));
  }

  /**
   * This adds a property descriptor for the Volatile feature.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   */
  protected void addVolatilePropertyDescriptor(Object object)
  {
    itemPropertyDescriptors.add
      (new ItemPropertyDescriptor
        (((ComposeableAdapterFactory)adapterFactory).getRootAdapterFactory(),
         getString("_UI_EStructuralFeature_volatile_feature"),
         getString("_UI_PropertyDescriptor_description", "_UI_EStructuralFeature_volatile_feature", "_UI_EStructuralFeature_type"),
         EcorePackage.eINSTANCE.getEStructuralFeature_Volatile(),
         true,
         ItemPropertyDescriptor.BOOLEAN_VALUE_IMAGE));
  }

  /**
   * This adds a property descriptor for the Transient feature.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   */
  protected void addTransientPropertyDescriptor(Object object)
  {
    itemPropertyDescriptors.add
      (new ItemPropertyDescriptor
        (((ComposeableAdapterFactory)adapterFactory).getRootAdapterFactory(),
         getString("_UI_EStructuralFeature_transient_feature"),
         getString("_UI_PropertyDescriptor_description", "_UI_EStructuralFeature_transient_feature", "_UI_EStructuralFeature_type"),
         EcorePackage.eINSTANCE.getEStructuralFeature_Transient(),
         true,
         ItemPropertyDescriptor.BOOLEAN_VALUE_IMAGE));
  }

  /**
   * This adds a property descriptor for the Unique feature.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   */
  protected void addUniquePropertyDescriptor(Object object)
  {
    itemPropertyDescriptors.add
      (new ItemPropertyDescriptor
        (((ComposeableAdapterFactory)adapterFactory).getRootAdapterFactory(),
         getString("_UI_EStructuralFeature_unique_feature"),
         getString("_UI_PropertyDescriptor_description", "_UI_EStructuralFeature_unique_feature", "_UI_EStructuralFeature_type"),
         EcorePackage.eINSTANCE.getEStructuralFeature_Unique(),
         true,
         ItemPropertyDescriptor.BOOLEAN_VALUE_IMAGE));
  }

  /**
   * This adds a property descriptor for the Default Value Literal feature.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   */
  protected void addDefaultValueLiteralPropertyDescriptor(Object object)
  {
    itemPropertyDescriptors.add
      (new ItemPropertyDescriptor
        (((ComposeableAdapterFactory)adapterFactory).getRootAdapterFactory(),
         getString("_UI_EStructuralFeature_defaultValueLiteral_feature"),
         getString("_UI_PropertyDescriptor_description", "_UI_EStructuralFeature_defaultValueLiteral_feature", "_UI_EStructuralFeature_type"),
         EcorePackage.eINSTANCE.getEStructuralFeature_DefaultValueLiteral(),
         true,
         ItemPropertyDescriptor.GENERIC_VALUE_IMAGE));
  }

  /**
   * This adds a property descriptor for the Default Value feature.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   */
  protected void addDefaultValuePropertyDescriptor(Object object)
  {
    itemPropertyDescriptors.add
      (new ItemPropertyDescriptor
        (((ComposeableAdapterFactory)adapterFactory).getRootAdapterFactory(),
         getString("_UI_EStructuralFeature_defaultValue_feature"),
         getString("_UI_PropertyDescriptor_description", "_UI_EStructuralFeature_defaultValue_feature", "_UI_EStructuralFeature_type"),
         EcorePackage.eINSTANCE.getEStructuralFeature_DefaultValue(),
         true,
         ItemPropertyDescriptor.GENERIC_VALUE_IMAGE));
  }

  /**
   * This adds a property descriptor for the Lower Bound feature.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   */
  protected void addLowerBoundPropertyDescriptor(Object object)
  {
    itemPropertyDescriptors.add
      (new ItemPropertyDescriptor
        (((ComposeableAdapterFactory)adapterFactory).getRootAdapterFactory(),
         getString("_UI_EStructuralFeature_lowerBound_feature"),
         getString("_UI_PropertyDescriptor_description", "_UI_EStructuralFeature_lowerBound_feature", "_UI_EStructuralFeature_type"),
         EcorePackage.eINSTANCE.getEStructuralFeature_LowerBound(),
         true,
         ItemPropertyDescriptor.INTEGRAL_VALUE_IMAGE));
  }

  /**
   * This adds a property descriptor for the Upper Bound feature.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   */
  protected void addUpperBoundPropertyDescriptor(Object object)
  {
    itemPropertyDescriptors.add
      (new ItemPropertyDescriptor
        (((ComposeableAdapterFactory)adapterFactory).getRootAdapterFactory(),
         getString("_UI_EStructuralFeature_upperBound_feature"),
         getString("_UI_PropertyDescriptor_description", "_UI_EStructuralFeature_upperBound_feature", "_UI_EStructuralFeature_type"),
         EcorePackage.eINSTANCE.getEStructuralFeature_UpperBound(),
         true,
         ItemPropertyDescriptor.INTEGRAL_VALUE_IMAGE));
  }

  /**
   * This adds a property descriptor for the Many feature.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   */
  protected void addManyPropertyDescriptor(Object object)
  {
    itemPropertyDescriptors.add
      (new ItemPropertyDescriptor
        (((ComposeableAdapterFactory)adapterFactory).getRootAdapterFactory(),
         getString("_UI_EStructuralFeature_many_feature"),
         getString("_UI_PropertyDescriptor_description", "_UI_EStructuralFeature_many_feature", "_UI_EStructuralFeature_type"),
         EcorePackage.eINSTANCE.getEStructuralFeature_Many(),
         false,
         ItemPropertyDescriptor.BOOLEAN_VALUE_IMAGE));
  }

  /**
   * This adds a property descriptor for the Required feature.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   */
  protected void addRequiredPropertyDescriptor(Object object)
  {
    itemPropertyDescriptors.add
      (new ItemPropertyDescriptor
        (((ComposeableAdapterFactory)adapterFactory).getRootAdapterFactory(),
         getString("_UI_EStructuralFeature_required_feature"),
         getString("_UI_PropertyDescriptor_description", "_UI_EStructuralFeature_required_feature", "_UI_EStructuralFeature_type"),
         EcorePackage.eINSTANCE.getEStructuralFeature_Required(),
         false,
         ItemPropertyDescriptor.BOOLEAN_VALUE_IMAGE));
  }

  /**
   * This adds a property descriptor for the Unsettable feature.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   */
  protected void addUnsettablePropertyDescriptor(Object object)
  {
    itemPropertyDescriptors.add
      (new ItemPropertyDescriptor
        (((ComposeableAdapterFactory)adapterFactory).getRootAdapterFactory(),
         getString("_UI_EStructuralFeature_unsettable_feature"),
         getString("_UI_PropertyDescriptor_description", "_UI_EStructuralFeature_unsettable_feature", "_UI_EStructuralFeature_type"),
         EcorePackage.eINSTANCE.getEStructuralFeature_Unsettable(),
         true,
         ItemPropertyDescriptor.BOOLEAN_VALUE_IMAGE));
  }

  /**
   * This adds a property descriptor for the EContaining Class feature.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   */
  protected void addEContainingClassPropertyDescriptor(Object object)
  {
    itemPropertyDescriptors.add
      (new ItemPropertyDescriptor
        (((ComposeableAdapterFactory)adapterFactory).getRootAdapterFactory(),
         getString("_UI_EStructuralFeature_eContainingClass_feature"),
         getString("_UI_PropertyDescriptor_description", "_UI_EStructuralFeature_eContainingClass_feature", "_UI_EStructuralFeature_type"),
         EcorePackage.eINSTANCE.getEStructuralFeature_EContainingClass(),
         false));
  }


  /**
   * This returns the label text for the adapted class.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   */
  public String getText(Object object)
  {
    String label = ((EStructuralFeature)object).getName();
    return label == null || label.length() == 0 ?
      getString("_UI_EStructuralFeature_type") :
      getString("_UI_EStructuralFeature_type") + " " + label;
  }

  public Object getComposedImage(Object object, Object imageToCompose)
  {
    EStructuralFeature eStructuralFeature = (EStructuralFeature)object;
    Collection images = new ArrayList();
    images.add(imageToCompose);
    String imageName = "full/obj16/EOccurrence";
    int minOccurs = eStructuralFeature.getLowerBound();
    int maxOccurs = eStructuralFeature.getUpperBound();
    if (minOccurs >= 0 && (minOccurs <= maxOccurs || maxOccurs == -1))
    {
      switch (minOccurs)
      {
        case 0:
        {
          imageName += "Zero";
          break;
        }
        case 1:
        {
          imageName += "One";
          break;
        }
        default:
        {
          imageName += "N";
          break;
        }
      }

      if (minOccurs != maxOccurs)
      {
        switch (maxOccurs)
        {
          case -1:
          {
            imageName += "ToUnbounded";
            break;
          }
          case 0:
          {
            break;
          }
          case 1:
          {
            imageName += "ToOne";
            break;
          }
          default:
          {
            imageName += minOccurs <= 1 ? "ToN" : "ToM";
            break;
          }
        }
      }
    }
    else
    {
      imageName += "NToM";
    }

    if (!imageName.equals("full/obj16/EOccurrenceZeroToOne"))
    {
      images.add(EcoreEditPlugin.INSTANCE.getImage(imageName));
    }

    return 
      new ComposedImage(images)
      {
        public List getDrawPoints(Size size)
        {
          List result = super.getDrawPoints(size);
          if (result.size() > 1)
          {
            ((Point)result.get(0)).y = -2;
          }
          return result;
        }
      };
  }


  /**
   * This handles notification by calling {@link #fireNotifyChanged fireNotifyChanged}.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   */
  public void notifyChanged(Notification notification)
  {
    switch (notification.getFeatureID(EStructuralFeature.class))
    {
      case EcorePackage.ESTRUCTURAL_FEATURE__CHANGEABLE:
      case EcorePackage.ESTRUCTURAL_FEATURE__VOLATILE:
      case EcorePackage.ESTRUCTURAL_FEATURE__TRANSIENT:
      case EcorePackage.ESTRUCTURAL_FEATURE__UNIQUE:
      case EcorePackage.ESTRUCTURAL_FEATURE__DEFAULT_VALUE_LITERAL:
      case EcorePackage.ESTRUCTURAL_FEATURE__DEFAULT_VALUE:
      case EcorePackage.ESTRUCTURAL_FEATURE__LOWER_BOUND:
      case EcorePackage.ESTRUCTURAL_FEATURE__UPPER_BOUND:
      case EcorePackage.ESTRUCTURAL_FEATURE__MANY:
      case EcorePackage.ESTRUCTURAL_FEATURE__REQUIRED:
      case EcorePackage.ESTRUCTURAL_FEATURE__UNSETTABLE:
      case EcorePackage.ESTRUCTURAL_FEATURE__ECONTAINING_CLASS:
      {
        fireNotifyChanged(notification);
        return;
      }
    }
    super.notifyChanged(notification);
  }

  /**
   * This adds to the collection of {@link org.eclipse.emf.edit.command.CommandParameter}s
   * describing all of the children that can be created under this object.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   */
  protected void collectNewChildDescriptors(Collection newChildDescriptors, Object object)
  {
    super.collectNewChildDescriptors(newChildDescriptors, object);
  }

  /**
   * Return the resource locator for this item provider's resources.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   */
  public ResourceLocator getResourceLocator()
  {
    return EcoreEditPlugin.INSTANCE;
  }
}
