/**
 * <copyright>
 *
 * Copyright (c) 2002 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 * 
 * Contributors: 
 *   IBM - Initial API and implementation
 *
 * </copyright>
 *
 * plugins/org.eclipse.emf.codegen/src/org/eclipse/emf/codegen/jet/JETSkeleton.java, emf.codegen, org.eclipse.dev, 20030620_1105VL
 * @version 1.4 6/20/03
 */
package org.eclipse.emf.codegen.jet;


import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.StringTokenizer;

import org.eclipse.jdt.core.jdom.DOMFactory;
import org.eclipse.jdt.core.jdom.IDOMCompilationUnit;
import org.eclipse.jdt.core.jdom.IDOMMethod;
import org.eclipse.jdt.core.jdom.IDOMNode;
import org.eclipse.jdt.core.jdom.IDOMPackage;


/**
 */
public class JETSkeleton 
{
  protected final String SKELETON_COMPILATION_UNIT = 
    "public class CLASS\n{\n  public String generate(Object argument)\n  {\n    return \"\";\n  }\n}\n";

  protected final String NL_DECLARATION = "  protected final String NL = ";
  protected final String NL_DECLARATION_TAIL = ";\n";
  protected final String STRING_BUFFER_DECLARATION = "    StringBuffer stringBuffer = new StringBuffer();\n";
  protected final String STRING_BUFFER_RETURN = "    return stringBuffer.toString();\n";

  protected DOMFactory jdomFactory = new DOMFactory();
  protected IDOMCompilationUnit compilationUnit;
  protected String nlString = "System.getProperties().getProperty(\"line.separator\")";

  /**
   */
  public JETSkeleton() 
  {
    compilationUnit = jdomFactory.createCompilationUnit(SKELETON_COMPILATION_UNIT, "CLASS");
  }

  public IDOMCompilationUnit getCompilationUnit()
  {
    return compilationUnit;
  }

  public void setCompilationUnitContents(String contents)
  {
    compilationUnit = jdomFactory.createCompilationUnit(contents, "CLASS");
  }

  public String getNLString()
  {
    return nlString;
  }

  public void setNLString(String nlString)
  {
    this.nlString = nlString;
  }

  public String getPackageName() 
  {
    for (IDOMNode node = compilationUnit.getFirstChild(); node != null; node = node.getNextNode())
    {
      if (node.getNodeType() == IDOMNode.PACKAGE)
      {
        return node.getName();
      }
    }

    return "";
  }

  public void setPackageName(String packageName) 
  {
    for (IDOMNode node = compilationUnit.getFirstChild(); node != null; node = node.getNextNode())
    {
      if (node.getNodeType() == IDOMNode.PACKAGE)
      {
        node.setName(packageName);
        return;
      }
    }

    compilationUnit.getFirstChild().insertSibling(jdomFactory.createPackage("package " + packageName + ";\n\n"));
  }

  public void setConstants(List constants)
  {
    for (IDOMNode node = compilationUnit.getFirstChild(); node != null; node = node.getNextNode())
    {
      if (node.getNodeType() == IDOMNode.TYPE)
      {
        IDOMNode insertionNode = node.getFirstChild();
        insertionNode.insertSibling(jdomFactory.createField(NL_DECLARATION + getNLString() + NL_DECLARATION_TAIL));
        for (Iterator i = constants.iterator(); i.hasNext(); )
        {
          String constant = "  " + (String)i.next() + "\n";
          if (!i.hasNext())
          {
            constant += "\n";
          }
          insertionNode.insertSibling(jdomFactory.createField(constant));
        }
        break;
      }
    }
  }
  public void setBody(List lines)
  {
    IDOMMethod method = getLastMethod();
    if (method != null)
    {
      StringBuffer body = new StringBuffer();
      body.append("\n  {\n");
      body.append(STRING_BUFFER_DECLARATION);
      for (Iterator i = lines.iterator(); i.hasNext(); )
      {
        String line = (String)i.next();
        body.append("    ");
        body.append(line);
        body.append("\n");
      }
      body.append(STRING_BUFFER_RETURN);
      body.append("  }\n");

      method.setBody(body.toString());
    }
  }

  public String getMethodName() 
  {
    IDOMMethod method = getLastMethod();
    if (method != null)
    {
      return method.getName();
    }
    else
    {
      return "";
    }
  }

  public void addImports(String importList)
  {
    for (IDOMNode node = compilationUnit.getFirstChild(); node != null; node = node.getNextNode())
    {
      if (node.getNodeType() == IDOMNode.TYPE)
      {
        for (StringTokenizer stringTokenizer = new StringTokenizer(importList, " \t"); stringTokenizer.hasMoreTokens(); )
        {
          String token = stringTokenizer.nextToken();
          String newImport = "import " + token + ";\n";
          if (!stringTokenizer.hasMoreTokens())
          {
            newImport += "\n";
          }
          node.insertSibling(jdomFactory.createImport(newImport));
        }
        return;
      }
    }
  }

  public String getClassName() 
  {
    for (IDOMNode node = compilationUnit.getFirstChild(); node != null; node = node.getNextNode())
    {
      if (node.getNodeType() == IDOMNode.TYPE)
      {
        return node.getName();
      }
    }

    return null;
  }

  public void setClassName(String className) 
  {
    for (IDOMNode node = compilationUnit.getFirstChild(); node != null; node = node.getNextNode())
    {
      if (node.getNodeType() == IDOMNode.TYPE)
      {
        node.setName(className);
      }
    }
  }

  protected IDOMMethod getLastMethod()
  {
    IDOMMethod method = null;
    for (IDOMNode node = compilationUnit.getFirstChild(); node != null; node = node.getNextNode())
    {
      if (node.getNodeType() == IDOMNode.TYPE)
      {
        for (IDOMNode child = node.getFirstChild(); child != null; child = child.getNextNode())
        {
          if (child.getNodeType() == IDOMNode.METHOD)
          {
            method = (IDOMMethod)child;
          }
        }
      }
    }
    return method;
  }
}
