/**
 * <copyright>
 *
 * Copyright (c) 2002 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 *
 * Contributors:
 *   IBM - Initial API and implementation
 *
 * </copyright>
 *
 * plugins/org.eclipse.emf.mapping.ui/src/org/eclipse/emf/mapping/action/AddRootTopAction.java, emf.mapping.ui, org.eclipse.dev, 20030620_1105VL
 * @version 1.1 6/20/03
 */
package org.eclipse.emf.mapping.action;


import java.util.Collection;

import org.eclipse.emf.common.command.Command;

import org.eclipse.emf.edit.command.AddCommand;

import org.eclipse.emf.edit.ui.action.CommandAction;

import org.eclipse.emf.mapping.MappingPackage;
import org.eclipse.emf.mapping.MappingRoot;

import org.eclipse.emf.mapping.domain.MappingDomain;

import org.eclipse.jface.action.IAction;

import org.eclipse.jface.viewers.ISelection;

import org.eclipse.ui.IEditorPart;


/**
 * This adds new root inputs to the mapping domain's root mapping.
 */
public class AddRootTopAction extends CommandAction 
{
  /**
   * This method should be overriden with a domain-specific implementation 
   * that returns the inputs to be added, e.g., by querying the user with a dialog.
   */
  protected Collection getTopsToAdd()
  {
    return null;
  }

  /**
   * This action ignores the selection.
   */
  public void selectionChanged(IAction action, ISelection selection) 
  {
  }

  public void run(IAction action)
  {
    Collection additions = getTopsToAdd();
    MappingRoot mappingRoot = ((MappingDomain)editingDomain).getMappingRoot();
    command = AddCommand.create
      (editingDomain, 
       mappingRoot, 
       mappingRoot.isTopToBottom() ?
         //mappingRoot.ePackageMapping().getMapping_Inputs() :
         //mappingRoot.ePackageMapping().getMapping_Outputs(),
         MappingPackage.eINSTANCE.getMapping_Inputs() :
         MappingPackage.eINSTANCE.getMapping_Outputs(),
       additions);

    super.run(action);
  }

  public void setActiveEditor(IAction action, IEditorPart editorPart)
  {
    super.setActiveEditor(action, editorPart);
    action.setEnabled(true);
  }
}
