/**
 * <copyright>
 *
 * Copyright (c) 2002 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 * 
 * Contributors: 
 *   IBM - Initial API and implementation
 *
 * </copyright>
 *
 * plugins/org.eclipse.emf.ecore/src/org/eclipse/emf/ecore/impl/EcoreFactoryImpl.java, emf.ecore, org.eclipse.dev, 20030620_1105VL
 * @version 1.36 6/20/03
 */
package org.eclipse.emf.ecore.impl;


import java.util.Collection;

import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.notify.Notifier;

import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.Enumerator;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.common.util.WrappedException;

import org.eclipse.emf.ecore.*;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EObject;
import java.util.Map;

import org.eclipse.emf.ecore.EcorePackage;

import org.eclipse.emf.ecore.resource.Resource;


/**
 * <!-- begin-user-doc -->
 * An implementation of the model <b>Factory</b>.
 * <!-- end-user-doc -->
 * @generated
 */
public class EcoreFactoryImpl extends EFactoryImpl implements EcoreFactory
{
  /**
   * Creates and instance of the factory.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   */
  public EcoreFactoryImpl()
  {
    super();
  }

  /**
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   */
  public EObject create(EClass eClass)
  {
    switch (eClass.getClassifierID())
    {
      case EcorePackage.EATTRIBUTE: return createEAttribute();
      case EcorePackage.EANNOTATION: return createEAnnotation();
      case EcorePackage.ECLASS: return createEClass();
      case EcorePackage.EDATA_TYPE: return createEDataType();
      case EcorePackage.EENUM: return createEEnum();
      case EcorePackage.EENUM_LITERAL: return createEEnumLiteral();
      case EcorePackage.EFACTORY: return createEFactory();
      case EcorePackage.EOBJECT: return createEObject();
      case EcorePackage.EOPERATION: return createEOperation();
      case EcorePackage.EPACKAGE: return createEPackage();
      case EcorePackage.EPARAMETER: return createEParameter();
      case EcorePackage.EREFERENCE: return createEReference();
      case EcorePackage.ESTRING_TO_STRING_MAP_ENTRY: return (EObject)createEStringToStringMapEntry();
      default:
        throw new IllegalArgumentException("The class '" + eClass.getName() + "' is not a valid classifier");
    }
  }

  /**
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   */
  public Object createFromString(EDataType eDataType, String initialValue)
  {
    switch (eDataType.getClassifierID())
    {
      case EcorePackage.EBOOLEAN:
        return createEBooleanFromString(eDataType, initialValue);
      case EcorePackage.EBOOLEAN_OBJECT:
        return createEBooleanObjectFromString(eDataType, initialValue);
      case EcorePackage.ECHAR:
        return createECharFromString(eDataType, initialValue);
      case EcorePackage.ECHARACTER_OBJECT:
        return createECharacterObjectFromString(eDataType, initialValue);
      case EcorePackage.EBYTE:
        return createEByteFromString(eDataType, initialValue);
      case EcorePackage.EBYTE_OBJECT:
        return createEByteObjectFromString(eDataType, initialValue);
      case EcorePackage.EDOUBLE:
        return createEDoubleFromString(eDataType, initialValue);
      case EcorePackage.EDOUBLE_OBJECT:
        return createEDoubleObjectFromString(eDataType, initialValue);
      case EcorePackage.EFLOAT:
        return createEFloatFromString(eDataType, initialValue);
      case EcorePackage.EFLOAT_OBJECT:
        return createEFloatObjectFromString(eDataType, initialValue);
      case EcorePackage.EINT:
        return createEIntFromString(eDataType, initialValue);
      case EcorePackage.EINTEGER_OBJECT:
        return createEIntegerObjectFromString(eDataType, initialValue);
      case EcorePackage.EJAVA_CLASS:
        return createEJavaClassFromString(eDataType, initialValue);
      case EcorePackage.ELONG:
        return createELongFromString(eDataType, initialValue);
      case EcorePackage.ELONG_OBJECT:
        return createELongObjectFromString(eDataType, initialValue);
      case EcorePackage.ESHORT:
        return createEShortFromString(eDataType, initialValue);
      case EcorePackage.ESHORT_OBJECT:
        return createEShortObjectFromString(eDataType, initialValue);
      case EcorePackage.ESTRING:
        return createEStringFromString(eDataType, initialValue);
      default:
        throw new IllegalArgumentException("The datatype '" + eDataType.getName() + "' is not a valid classifier");
    }
  }

  /**
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   */
  public String convertToString(EDataType eDataType, Object instanceValue)
  {
    switch (eDataType.getClassifierID())
    {
      case EcorePackage.EBOOLEAN:
        return convertEBooleanToString(eDataType, instanceValue);
      case EcorePackage.EBOOLEAN_OBJECT:
        return convertEBooleanObjectToString(eDataType, instanceValue);
      case EcorePackage.ECHAR:
        return convertECharToString(eDataType, instanceValue);
      case EcorePackage.ECHARACTER_OBJECT:
        return convertECharacterObjectToString(eDataType, instanceValue);
      case EcorePackage.EBYTE:
        return convertEByteToString(eDataType, instanceValue);
      case EcorePackage.EBYTE_OBJECT:
        return convertEByteObjectToString(eDataType, instanceValue);
      case EcorePackage.EDOUBLE:
        return convertEDoubleToString(eDataType, instanceValue);
      case EcorePackage.EDOUBLE_OBJECT:
        return convertEDoubleObjectToString(eDataType, instanceValue);
      case EcorePackage.EFLOAT:
        return convertEFloatToString(eDataType, instanceValue);
      case EcorePackage.EFLOAT_OBJECT:
        return convertEFloatObjectToString(eDataType, instanceValue);
      case EcorePackage.EINT:
        return convertEIntToString(eDataType, instanceValue);
      case EcorePackage.EINTEGER_OBJECT:
        return convertEIntegerObjectToString(eDataType, instanceValue);
      case EcorePackage.EJAVA_CLASS:
        return convertEJavaClassToString(eDataType, instanceValue);
      case EcorePackage.ELONG:
        return convertELongToString(eDataType, instanceValue);
      case EcorePackage.ELONG_OBJECT:
        return convertELongObjectToString(eDataType, instanceValue);
      case EcorePackage.ESHORT:
        return convertEShortToString(eDataType, instanceValue);
      case EcorePackage.ESHORT_OBJECT:
        return convertEShortObjectToString(eDataType, instanceValue);
      case EcorePackage.ESTRING:
        return convertEStringToString(eDataType, instanceValue);
      default:
        throw new IllegalArgumentException("The datatype '" + eDataType.getName() + "' is not a valid classifier");
    }
  }

  /**
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   */
  public EObject createEObject()
  {
    EObjectImpl eObject = new EObjectImpl();
    return eObject;
  }

  /**
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   */
  public EAttribute createEAttribute()
  {
    EAttributeImpl eAttribute = new EAttributeImpl();
    return eAttribute;
  }

  /**
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   */
  public EAnnotation createEAnnotation()
  {
    EAnnotationImpl eAnnotation = new EAnnotationImpl();
    return eAnnotation;
  }

  /**
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   */
  public EClass createEClass()
  {
    EClassImpl eClass = new EClassImpl();
    return eClass;
  }

  /**
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   */
  public EDataType createEDataType()
  {
    EDataTypeImpl eDataType = new EDataTypeImpl();
    return eDataType;
  }

  /**
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   */
  public EParameter createEParameter()
  {
    EParameterImpl eParameter = new EParameterImpl();
    return eParameter;
  }

  /**
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   */
  public EOperation createEOperation()
  {
    EOperationImpl eOperation = new EOperationImpl();
    return eOperation;
  }

  /**
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   */
  public EPackage createEPackage()
  {
    EPackageImpl ePackage = new EPackageImpl();
    return ePackage;
  }

  /**
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   */
  public EFactory createEFactory()
  {
    EFactoryImpl eFactory = new EFactoryImpl();
    return eFactory;
  }

  /**
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   */
  public EEnumLiteral createEEnumLiteral()
  {
    EEnumLiteralImpl eEnumLiteral = new EEnumLiteralImpl();
    return eEnumLiteral;
  }

  /**
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   */
  public EEnum createEEnum()
  {
    EEnumImpl eEnum = new EEnumImpl();
    return eEnum;
  }

  /**
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated modifiable
   */
  public Boolean createEBooleanObjectFromString(EDataType metaObject, String initialValue) 
  {
    return Boolean.valueOf(initialValue);
  }

  /**
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated modifiable
   */
  public String convertEBooleanObjectToString(EDataType metaObject, Object instanceValue) 
  {
    return instanceValue == null ? null : instanceValue.toString();
  }

  /**
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated modifiable
   */
  public Character createECharacterObjectFromString(EDataType metaObject, String initialValue) 
  {
    char charValue = 0;
    try
    {
      Integer value = new Integer(initialValue);
      charValue = (char) value.intValue();
    }
    catch (NumberFormatException e)
    {
      char[] carray = initialValue.toCharArray();
      charValue = carray[0];
    }
    return new Character(charValue);
  }

  /**
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated modifiable
   */
  public String convertECharacterObjectToString(EDataType metaObject, Object instanceValue) 
  {
    if (instanceValue instanceof Character)
    {
      int charInt = ((Character) instanceValue).charValue();
      Integer value = new Integer(charInt);
      return value.toString();
    }

    return instanceValue == null ? null : instanceValue.toString();
  }

  /**
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated modifiable
   */
  public Double createEDoubleObjectFromString(EDataType metaObject, String initialValue) 
  {
    return Double.valueOf(initialValue);
  }

  /**
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated modifiable
   */
  public String convertEDoubleObjectToString(EDataType metaObject, Object instanceValue) 
  {
    return instanceValue == null ? null : instanceValue.toString();
  }

  /**
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated modifiable
   */
  public Float createEFloatObjectFromString(EDataType metaObject, String initialValue) 
  {
    return Float.valueOf(initialValue);
  }

  /**
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated modifiable
   */
  public String convertEFloatObjectToString(EDataType metaObject, Object instanceValue) 
  {
    return instanceValue == null ? null : instanceValue.toString();
  }

  /**
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated modifiable
   */
  public Integer createEIntegerObjectFromString(EDataType metaObject, String initialValue) 
  {
    return Integer.valueOf(initialValue);
  }

  /**
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated modifiable
   */
  public String convertEIntegerObjectToString(EDataType metaObject, Object instanceValue) 
  {
    return instanceValue == null ? null : instanceValue.toString();
  }

  /**
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   */
  public EReference createEReference()
  {
    EReferenceImpl eReference = new EReferenceImpl();
    return eReference;
  }

  /**
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   */
  public Map.Entry createEStringToStringMapEntry()
  {
    EStringToStringMapEntryImpl eStringToStringMapEntry = new EStringToStringMapEntryImpl();
    return eStringToStringMapEntry;
  }

  /**
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   */
  public EcorePackage getEcorePackage()
  {
    return (EcorePackage)getEPackage();
  }

  /**
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   */
  public static EcorePackage getPackage()
  {
    return EcorePackage.eINSTANCE;
  }

  /**
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated modifiable
   */
  public String createEStringFromString(EDataType metaObject, String initialValue) 
  {
    return initialValue;
  }

  /**
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated modifiable
   */
  public String convertEStringToString(EDataType metaObject, Object instanceValue) 
  {
    return (String)instanceValue;
  }

  /**
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated modifiable
   */
  public Integer createEIntFromString(EDataType metaObject, String initialValue) 
  {
    return Integer.valueOf(initialValue);
  }

  /**
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated modifiable
   */
  public String convertEIntToString(EDataType metaObject, Object instanceValue) 
  {
    return instanceValue == null ? null : instanceValue.toString();
  }

  /**
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated modifiable
   */
  public Boolean createEBooleanFromString(EDataType metaObject, String initialValue) 
  {
    return Boolean.valueOf(initialValue);
  }

  /**
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated modifiable
   */
  public String convertEBooleanToString(EDataType metaObject, Object instanceValue) 
  {
    return instanceValue == null ? null : instanceValue.toString();
  }

  /**
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated modifiable
   */
  public Byte createEByteObjectFromString(EDataType metaObject, String initialValue) 
  {
    return Byte.valueOf(initialValue);
  }

  /**
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated modifiable
   */
  public String convertEByteObjectToString(EDataType metaObject, Object instanceValue) 
  {
    return instanceValue == null ? null : instanceValue.toString();
  }

  /**
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated modifiable
   */
  public Float createEFloatFromString(EDataType metaObject, String initialValue) 
  {
    return Float.valueOf(initialValue);
  }

  /**
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated modifiable
   */
  public String convertEFloatToString(EDataType metaObject, Object instanceValue) 
  {
    return instanceValue == null ? null : instanceValue.toString();
  }

  /**
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated modifiable
   */
  public Character createECharFromString(EDataType metaObject, String initialValue) 
  {
    char charValue = 0;
    try
    {
      Integer value = new Integer(initialValue);
      charValue = (char) value.intValue();
    }
    catch (NumberFormatException e)
    {
      char[] carray = initialValue.toCharArray();
      charValue = carray[0];
    }
    return new Character(charValue);
  }

  /**
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated modifiable
   */
  public String convertECharToString(EDataType metaObject, Object instanceValue) 
  {
    if (instanceValue instanceof Character)
    {
      int charInt = ((Character) instanceValue).charValue();
      Integer value = new Integer(charInt);
      return value.toString();
    }

    return instanceValue == null ? null : instanceValue.toString();
  }

  /**
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated modifiable
   */
  public Long createELongFromString(EDataType metaObject, String initialValue) 
  {
    return Long.valueOf(initialValue);
  }

  /**
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated modifiable
   */
  public String convertELongToString(EDataType metaObject, Object instanceValue) 
  {
    return instanceValue == null ? null : instanceValue.toString();
  }

  /**
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated modifiable
   */
  public Double createEDoubleFromString(EDataType metaObject, String initialValue) 
  {
    return Double.valueOf(initialValue);
  }

  /**
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated modifiable
   */
  public String convertEDoubleToString(EDataType metaObject, Object instanceValue) 
  {
    return instanceValue == null ? null : instanceValue.toString();
  }

  /**
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated modifiable
   */
  public Byte createEByteFromString(EDataType metaObject, String initialValue) 
  {
    return Byte.valueOf(initialValue);
  }

  /**
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated modifiable
   */
  public String convertEByteToString(EDataType metaObject, Object instanceValue) 
  {
    return instanceValue == null ? null : instanceValue.toString();
  }


  /**
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated modifiable
   */
  public Short createEShortFromString(EDataType metaObject, String initialValue) 
  {
    return Short.valueOf(initialValue);
  }

  /**
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated modifiable
   */
  public String convertEShortToString(EDataType metaObject, Object instanceValue) 
  {
    return instanceValue == null ? null : instanceValue.toString();
  }

  /**
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated modifiable
   */
  public Class createEJavaClassFromString(EDataType metaObject, String initialValue) 
  {
    try
    {
      return Class.forName(initialValue);
    }
    catch (ClassNotFoundException e)
    {
      throw new WrappedException(e);
    }
  }

  /**
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated modifiable
   */
  public String convertEJavaClassToString(EDataType metaObject, Object instanceValue)
  {
    return instanceValue == null ? "" : ((Class)instanceValue).getName();
  }

  /**
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated modifiable
   */
  public Long createELongObjectFromString(EDataType metaObject, String initialValue) 
  {
    return Long.valueOf(initialValue);
  }

  /**
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated modifiable
   */
  public String convertELongObjectToString(EDataType metaObject, Object instanceValue) 
  {
    return instanceValue == null ? null : instanceValue.toString();
  }

  /**
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated modifiable
   */
  public Short createEShortObjectFromString(EDataType metaObject, String initialValue) 
  {
    return Short.valueOf(initialValue);
  }

  /**
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated modifiable
   */
  public String convertEShortObjectToString(EDataType metaObject, Object instanceValue) 
  {
    return instanceValue == null ? null : instanceValue.toString();
  }

} //EcoreFactoryImpl
