/**
 * <copyright>
 *
 * Copyright (c) 2002 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 *
 * Contributors:
 *   IBM - Initial API and implementation
 *
 * </copyright>
 *
 * plugins/org.eclipse.emf.ecore/src/org/eclipse/emf/ecore/util/EContentsEList.java, emf.ecore, org.eclipse.dev, 20030620_1105VL
 * @version 1.12 6/20/03
 */
package org.eclipse.emf.ecore.util;


import java.util.AbstractSequentialList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.NoSuchElementException;

import org.eclipse.emf.common.notify.NotificationChain;

import org.eclipse.emf.common.util.BasicEList;
import org.eclipse.emf.common.util.ECollections;
import org.eclipse.emf.common.util.EList;

import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.InternalEObject;


public class EContentsEList extends AbstractSequentialList implements EList, InternalEList
{
  protected final EObject eObject; 
  protected final EStructuralFeature [] eStructuralFeatures;

  public EContentsEList(EObject eObject)
  {
    this.eObject = eObject;
    this.eStructuralFeatures = (EStructuralFeature [])((BasicEList)eObject.eClass().getEAllContainments()).data();
  }

  public EContentsEList(EObject eObject, List eStructuralFeatures)
  {
    this.eObject = eObject;
    this.eStructuralFeatures = new EStructuralFeature [eStructuralFeatures.size()];
    eStructuralFeatures.toArray(this.eStructuralFeatures);
  }

  public EContentsEList(EObject eObject, EStructuralFeature [] eStructuralFeatures)
  {
    this.eObject = eObject;
    this.eStructuralFeatures = eStructuralFeatures;
  }

  protected ListIterator newListIterator()
  {
    return
     resolve() ?
       new ResolvingFeatureIteratorImpl(eObject, eStructuralFeatures) :
       new FeatureIteratorImpl(eObject, eStructuralFeatures);
  }

  protected Iterator newIterator()
  {
    return newListIterator();
  }

  protected boolean useIsSet()
  {
    return true;
  }

  protected boolean resolve()
  {
    return true;
  }

  protected boolean isIncluded(EStructuralFeature eStructuralFeature)
  {
    return true;
  }

  public ListIterator listIterator(int index)
  {
    if (eStructuralFeatures == null)
    {
      if (index != 0)
      {
        throw new IndexOutOfBoundsException("index=" + index + ", size=0");
      }

      return FeatureIteratorImpl.EMPTY_ITERATOR;
    }

    ListIterator result = newListIterator();
    for (int i = 0; i < index; ++i)
    {
      result.next();
    }
    return result;
  }

  public Iterator iterator()
  {
    if (eStructuralFeatures == null)
    {
      return FeatureIteratorImpl.EMPTY_ITERATOR;
    }

    Iterator result = newIterator();
    return result;
  }

  public int size()
  {
    int result = 0;
    if (eStructuralFeatures != null)
    {
      for (int i = 0; i < eStructuralFeatures.length; ++i)
      {
        EStructuralFeature feature = eStructuralFeatures[i];
        if (isIncluded(feature) && (!useIsSet() || eObject.eIsSet(feature)))
        {
          Object value = eObject.eGet(feature, false);
          if (feature.isMany())
          {
            result += ((Collection)value).size();
          } 
          else if (value != null)
          {
            ++result;
          }
        }
      }
    }
    return result;
  }

  public boolean isEmpty()
  {
    if (eStructuralFeatures != null)
    {
      for (int i = 0; i < eStructuralFeatures.length; ++i)
      {
        EStructuralFeature feature = eStructuralFeatures[i];
        if (isIncluded(feature) && (!useIsSet() || eObject.eIsSet(feature)))
        {
          Object value = eObject.eGet(feature, false);
          if (feature.isMany())
          {
            if (!((Collection)value).isEmpty())
            {
              return false;
            }
          } 
          else if (value != null)
          {
            return false;
          }
        }
      }
    }
    return true;
  }

  public void move(int newPosition, Object o)
  {
    throw new UnsupportedOperationException();
  }

  public Object move(int newPosition, int oldPosition)
  {
    throw new UnsupportedOperationException();
  }

  public List basicList()
  {
    return
      new EContentsEList(eObject, eStructuralFeatures)
      {
        protected boolean resolve()
        {
          return false;
        }
      };
  }

  public Iterator basicIterator()
  {
    if (eStructuralFeatures == null)
    {
      return FeatureIteratorImpl.EMPTY_ITERATOR;
    }

    return new FeatureIteratorImpl(eObject, eStructuralFeatures);
  }

  public ListIterator basicListIterator()
  {
    if (eStructuralFeatures == null)
    {
      return FeatureIteratorImpl.EMPTY_ITERATOR;
    }

    return new FeatureIteratorImpl(eObject, eStructuralFeatures);
  }

  public ListIterator basicListIterator(int index)
  {
    if (eStructuralFeatures == null)
    {
      if (index < 0 || index > 1)
      {
        throw new IndexOutOfBoundsException("index=" + index + ", size=0");
      }

      return FeatureIteratorImpl.EMPTY_ITERATOR;
    }

    ListIterator result = new FeatureIteratorImpl(eObject, eStructuralFeatures);
    for (int i = 0; i < index; ++i)
    {
      result.next();
    }
    return result;
  }

  public NotificationChain basicRemove(Object object, NotificationChain notifications)
  {
    throw new UnsupportedOperationException();
  }

  public NotificationChain basicAdd(Object object, NotificationChain notifications)
  {
    throw new UnsupportedOperationException();
  }

  public void addUnique(Object object)
  {
    throw new UnsupportedOperationException();
  }

  public void addUnique(int index, Object object)
  {
    throw new UnsupportedOperationException();
  }

  public Object setUnique(int index, Object object)
  {
    throw new UnsupportedOperationException();
  }

  public interface FeatureIterator extends Iterator
  {
    EStructuralFeature feature();
  }

  public interface FeatureListIterator extends FeatureIterator, ListIterator
  {
  }

  public static class FeatureIteratorImpl implements FeatureListIterator
  {
    protected final EObject eObject; 
    protected final EStructuralFeature [] eStructuralFeatures;
    protected int featureCursor;
    protected int cursor;
    protected int prepared;
    protected Object preparedResult;
    protected EStructuralFeature preparedFeature;
    protected EStructuralFeature feature;
    protected ListIterator values;

    public FeatureIteratorImpl(EObject eObject, List eStructuralFeatures)
    {
      this.eObject = eObject;
      this.eStructuralFeatures = new EStructuralFeature [eStructuralFeatures.size()];
      eStructuralFeatures.toArray(this.eStructuralFeatures);
    }

    public FeatureIteratorImpl(EObject eObject, EStructuralFeature [] eStructuralFeatures)
    {
      this.eObject = eObject;
      this.eStructuralFeatures = eStructuralFeatures;
    }

    protected boolean resolve()
    {
      return false;
    }

    protected boolean useIsSet()
    {
      return true;
    }

    protected boolean isIncluded(EStructuralFeature eStructuralFeature)
    {
      return true;
    }

    public EStructuralFeature feature()
    {
      return feature;
    }

    public boolean hasNext()
    {
      switch (prepared)
      {
        case 3:
        case 2:
        {
          return true;
        }
        case 1:
        {
          return false;
        }
        case -3:
        {
          // Undo the preparation for previous and continue.
          values.next();
        }
        default:
        {
          if (values == null || !values.hasNext())
          {
            while (featureCursor < eStructuralFeatures.length)
            {
              EStructuralFeature feature = (EStructuralFeature)eStructuralFeatures[featureCursor++];
              if (isIncluded(feature) && (!useIsSet() || eObject.eIsSet(feature)))
              {
                Object value = eObject.eGet(feature, resolve());
                if (feature.isMany())
                {
                  values = resolve() ? ((List)value).listIterator() : ((InternalEList)value).basicListIterator();
                  if (values.hasNext())
                  {
                    preparedResult = values.next();
                    preparedFeature = feature;
                    prepared = 3;
                    return true;
                  }
                }
                else if (value != null)
                {
                  values = null;
                  preparedResult = value;
                  preparedFeature = feature;
                  prepared = 2;
                  return true;
                }
              }
            }
            values = null;
            prepared = 1;
            return false;
          }
          else
          {
            preparedResult = values.next();
            prepared = 3;
            return true;
          }
        }
      }
    }

    public Object next()
    {
      if (hasNext())
      {
        ++cursor;
        prepared = 0;
        feature = preparedFeature;
        return preparedResult;
      }
      else
      {
        throw new NoSuchElementException();
      }
    }

    public int nextIndex()
    {
      return cursor;
    }

    public boolean hasPrevious()
    {
      switch (prepared)
      {
        case -3:
        case -2:
        {
          return true;
        }
        case -1:
        {
          return false;
        }
        case 3:
        {
          // Undo the preparation for next and continue.
          values.previous();
        }
        default:
        {
          if (values == null || !values.hasPrevious())
          {
            while (featureCursor > 0)
            {
              EStructuralFeature feature = (EStructuralFeature)eStructuralFeatures[--featureCursor];
              if (isIncluded(feature) && (!useIsSet() || eObject.eIsSet(feature)))
              {
                Object value = eObject.eGet(feature, resolve());
                if (feature.isMany())
                {
                  List list = (List)value;
                  values = resolve() ? list.listIterator(list.size()) : ((InternalEList)list).basicListIterator(list.size());
                  if (values.hasPrevious())
                  {
                    preparedResult = values.previous();
                    preparedFeature = feature;
                    prepared = -3;
                    return true;
                  }
                }
                else if (value != null)
                {
                  values = null;
                  preparedResult = value;
                  preparedFeature = feature;
                  prepared = -2;
                  return true;
                }
              }
            }
            values = null;
            prepared = -1;
            return false;
          }
          else
          {
            preparedResult = values.previous();
            prepared = -3;
            return true;
          }
        }
      }
    }

    public Object previous()
    {
      if (hasPrevious())
      {
        --cursor;
        prepared = 0;
        feature = preparedFeature;
        return preparedResult;
      }
      else
      {
        throw new NoSuchElementException();
      }
    }

    public int previousIndex()
    {
      return cursor - 1;
    }

    public void add(Object o)
    {
      throw new UnsupportedOperationException();
    }

    public void remove()
    {
      throw new UnsupportedOperationException();
    }

    public void set(Object o)
    {
      throw new UnsupportedOperationException();
    }

    public static final ListIterator EMPTY_ITERATOR = 
      new FeatureIteratorImpl(null, (EStructuralFeature [] )null)
      {
        public boolean hasNext()
        {
          return false;
        }

        public boolean hasPrevious()
        {
          return false;
        }
      };
  }

  public static class ResolvingFeatureIteratorImpl extends FeatureIteratorImpl
  {
    public ResolvingFeatureIteratorImpl(EObject eObject, List eStructuralFeatures)
    {
      super(eObject, eStructuralFeatures);
    }

    public ResolvingFeatureIteratorImpl(EObject eObject, EStructuralFeature [] eStructuralFeatures)
    {
      super(eObject, eStructuralFeatures);
    }

    protected boolean resolve()
    {
      return true;
    }
  }
}
