/**
 * <copyright> 
 *
 * Copyright (c) 2002 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 * 
 * Contributors: 
 *   IBM - Initial API and implementation
 *
 * </copyright>
 *
 * plugins/org.eclipse.emf.codegen.ecore.ui/src/org/eclipse/emf/codegen/ecore/genmodel/provider/GenModelItemProvider.java, emf.codegen.ecore.ui, org.eclipse.dev, 20030620_1105VL
 * @version 1.24 6/20/03
 */
package org.eclipse.emf.codegen.ecore.genmodel.provider;


import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.notify.Notification;

import org.eclipse.emf.common.util.ResourceLocator;

import org.eclipse.emf.edit.command.AddCommand;
import org.eclipse.emf.edit.command.RemoveCommand;

import org.eclipse.emf.edit.domain.AdapterFactoryEditingDomain;
import org.eclipse.emf.edit.domain.EditingDomain;

import org.eclipse.emf.edit.provider.ComposeableAdapterFactory;
import org.eclipse.emf.edit.provider.IEditingDomainItemProvider;
import org.eclipse.emf.edit.provider.IItemLabelProvider;
import org.eclipse.emf.edit.provider.IItemPropertySource;
import org.eclipse.emf.edit.provider.IStructuredItemContentProvider;
import org.eclipse.emf.edit.provider.ITreeItemContentProvider;
import org.eclipse.emf.edit.provider.ItemPropertyDescriptor;

import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;

import org.eclipse.emf.edit.provider.ItemProviderAdapter;

import org.eclipse.emf.codegen.ecore.genmodel.GenModel;
import org.eclipse.emf.codegen.ecore.genmodel.GenModelPackage;


/**
 * This is the item provider adpater for a {@link org.eclipse.emf.codegen.ecore.genmodel.GenModel} object.
 * <!-- begin-user-doc -->
 * <!-- end-user-doc -->
 * @generated
 */
public class GenModelItemProvider
  extends GenBaseItemProvider
  implements 
    IEditingDomainItemProvider, IStructuredItemContentProvider, ITreeItemContentProvider, IItemLabelProvider, IItemPropertySource
{
  /**
   * This constructs an instance from a factory and a notifier.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   */
  public GenModelItemProvider(AdapterFactory adapterFactory)
  {
    super(adapterFactory);
  }

  /**
   * This returns the property descriptors for the adapted class.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   */
  public List getPropertyDescriptors(Object object)
  {
    if (itemPropertyDescriptors == null)
    {
      super.getPropertyDescriptors(object);

      addCopyrightTextPropertyDescriptor(object);
      addModelDirectoryPropertyDescriptor(object);
      addCreationCommandsPropertyDescriptor(object);
      addEditDirectoryPropertyDescriptor(object);
      addEditorDirectoryPropertyDescriptor(object);
      addModelPluginIDPropertyDescriptor(object);
      addTemplateDirectoryPropertyDescriptor(object);
      addRuntimeJarPropertyDescriptor(object);
      addDynamicTemplatesPropertyDescriptor(object);
      addRedirectionPropertyDescriptor(object);
      addForceOverwritePropertyDescriptor(object);
      addModelNamePropertyDescriptor(object);
      addModelPluginClassPropertyDescriptor(object);
      addEditPluginClassPropertyDescriptor(object);
      addEditorPluginClassPropertyDescriptor(object);
      addUpdateClasspathPropertyDescriptor(object);
      addGenerateSchemaPropertyDescriptor(object);
      addNonNLSMarkersPropertyDescriptor(object);
    }
    return itemPropertyDescriptors;
  }

  /**
   * This adds a property descriptor for the Copyright Text feature.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated NOT
   */
  protected void addCopyrightTextPropertyDescriptor(Object object)
  {
    itemPropertyDescriptors.add
      (new GenItemPropertyDescriptor
        (((ComposeableAdapterFactory)adapterFactory).getRootAdapterFactory(),
         getString("_UI_GenModel_copyrightText_feature"),
         getString("_UI_GenModel_copyrightText_description"),
         GenModelPackage.eINSTANCE.getGenModel_CopyrightText(),
         true,
         ItemPropertyDescriptor.GENERIC_VALUE_IMAGE,
         getString("_UI_AllPropertyCategory")));
  }

  /**
   * This adds a property descriptor for the Model Directory feature.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated NOT
   */
  protected void addModelDirectoryPropertyDescriptor(Object object)
  {
    itemPropertyDescriptors.add
      (new GenItemPropertyDescriptor
        (((ComposeableAdapterFactory)adapterFactory).getRootAdapterFactory(),
         getString("_UI_GenModel_modelDirectory_feature"),
         getString("_UI_GenModel_modelDirectory_description"),
         GenModelPackage.eINSTANCE.getGenModel_ModelDirectory(),
         true,
         ItemPropertyDescriptor.GENERIC_VALUE_IMAGE,
         getString("_UI_ModelPropertyCategory")));
  }

  /**
   * This adds a property descriptor for the Creation Commands feature.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated NOT
   */
  protected void addCreationCommandsPropertyDescriptor(Object object)
  {
    itemPropertyDescriptors.add
      (new GenItemPropertyDescriptor
        (((ComposeableAdapterFactory)adapterFactory).getRootAdapterFactory(),
         getString("_UI_GenModel_creationCommands_feature"),
         getString("_UI_GenModel_creationCommands_description"),
         GenModelPackage.eINSTANCE.getGenModel_CreationCommands(),
         true,
         ItemPropertyDescriptor.BOOLEAN_VALUE_IMAGE,
         getString("_UI_EditPropertyCategory")));
  }

  /**
   * This adds a property descriptor for the Edit Directory feature.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated NOT
   */
  protected void addEditDirectoryPropertyDescriptor(Object object)
  {
    itemPropertyDescriptors.add
      (new GenItemPropertyDescriptor
        (((ComposeableAdapterFactory)adapterFactory).getRootAdapterFactory(),
         getString("_UI_GenModel_editDirectory_feature"),
         getString("_UI_GenModel_editDirectory_description"),
         GenModelPackage.eINSTANCE.getGenModel_EditDirectory(),
         true,
         ItemPropertyDescriptor.GENERIC_VALUE_IMAGE,
         getString("_UI_EditPropertyCategory")));
  }

  /**
   * This adds a property descriptor for the Editor Directory feature.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated NOT
   */
  protected void addEditorDirectoryPropertyDescriptor(Object object)
  {
    itemPropertyDescriptors.add
      (new GenItemPropertyDescriptor
        (((ComposeableAdapterFactory)adapterFactory).getRootAdapterFactory(),
         getString("_UI_GenModel_editorDirectory_feature"),
         getString("_UI_GenModel_editorDirectory_description"),
         GenModelPackage.eINSTANCE.getGenModel_EditorDirectory(),
         true,
         ItemPropertyDescriptor.GENERIC_VALUE_IMAGE,
         getString("_UI_EditorPropertyCategory")));
  }

  /**
   * This adds a property descriptor for the Model Plugin ID feature.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated NOT
   */
  protected void addModelPluginIDPropertyDescriptor(Object object)
  {
    itemPropertyDescriptors.add
      (new GenItemPropertyDescriptor
        (((ComposeableAdapterFactory)adapterFactory).getRootAdapterFactory(),
         getString("_UI_GenModel_modelPluginID_feature"),
         getString("_UI_GenModel_modelPluginID_description"),
         GenModelPackage.eINSTANCE.getGenModel_ModelPluginID(),
         true,
         ItemPropertyDescriptor.GENERIC_VALUE_IMAGE,
         getString("_UI_AllPropertyCategory")));
  }

  /**
   * This adds a property descriptor for the Template Directory feature.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated NOT
   */
  protected void addTemplateDirectoryPropertyDescriptor(Object object)
  {
    itemPropertyDescriptors.add
      (new GenItemPropertyDescriptor
        (((ComposeableAdapterFactory)adapterFactory).getRootAdapterFactory(),
         getString("_UI_GenModel_templateDirectory_feature"),
         getString("_UI_GenModel_templateDirectory_description"),
         GenModelPackage.eINSTANCE.getGenModel_TemplateDirectory(),
         true,
         ItemPropertyDescriptor.GENERIC_VALUE_IMAGE,
         getString("_UI_JETPropertyCategory")));
  }

  /**
   * This adds a property descriptor for the Runtime Jar feature.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated NOT
   */
  protected void addRuntimeJarPropertyDescriptor(Object object)
  {
    itemPropertyDescriptors.add
      (new GenItemPropertyDescriptor
        (((ComposeableAdapterFactory)adapterFactory).getRootAdapterFactory(),
         getString("_UI_GenModel_runtimeJar_feature"),
         getString("_UI_GenModel_runtimeJar_description"),
         GenModelPackage.eINSTANCE.getGenModel_RuntimeJar(),
         true,
         ItemPropertyDescriptor.BOOLEAN_VALUE_IMAGE,
         getString("_UI_JETPropertyCategory")));
  }

  /**
   * This adds a property descriptor for the Dynamic Templates feature.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated NOT
   */
  protected void addDynamicTemplatesPropertyDescriptor(Object object)
  {
    itemPropertyDescriptors.add
      (new GenItemPropertyDescriptor
        (((ComposeableAdapterFactory)adapterFactory).getRootAdapterFactory(),
         getString("_UI_GenModel_dynamicTemplates_feature"),
         getString("_UI_GenModel_dynamicTemplates_description"),
         GenModelPackage.eINSTANCE.getGenModel_DynamicTemplates(),
         true,
         ItemPropertyDescriptor.BOOLEAN_VALUE_IMAGE,
         getString("_UI_JETPropertyCategory")));
  }

  /**
   * This adds a property descriptor for the Redirection feature.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated NOT
   */
  protected void addRedirectionPropertyDescriptor(Object object)
  {
    itemPropertyDescriptors.add
      (new GenItemPropertyDescriptor
        (((ComposeableAdapterFactory)adapterFactory).getRootAdapterFactory(),
         getString("_UI_GenModel_redirection_feature"),
         getString("_UI_GenModel_redirection_description"),
         GenModelPackage.eINSTANCE.getGenModel_Redirection(),
         true,
         ItemPropertyDescriptor.GENERIC_VALUE_IMAGE,
         getString("_UI_JETPropertyCategory")));
  }

  /**
   * This adds a property descriptor for the Force Overwrite feature.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated NOT
   */
  protected void addForceOverwritePropertyDescriptor(Object object)
  {
    itemPropertyDescriptors.add
      (new GenItemPropertyDescriptor
        (((ComposeableAdapterFactory)adapterFactory).getRootAdapterFactory(),
         getString("_UI_GenModel_forceOverwrite_feature"),
         getString("_UI_GenModel_forceOverwrite_description"),
         GenModelPackage.eINSTANCE.getGenModel_ForceOverwrite(),
         true,
         ItemPropertyDescriptor.BOOLEAN_VALUE_IMAGE,
         getString("_UI_JETPropertyCategory")));
  }

  /**
   * This adds a property descriptor for the Model Name feature.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated NOT
   */
  protected void addModelNamePropertyDescriptor(Object object)
  {
    itemPropertyDescriptors.add
      (new GenItemPropertyDescriptor
        (((ComposeableAdapterFactory)adapterFactory).getRootAdapterFactory(),
         getString("_UI_GenModel_modelName_feature"),
         getString("_UI_GenModel_modelName_description"),
         GenModelPackage.eINSTANCE.getGenModel_ModelName(),
         true,
         ItemPropertyDescriptor.GENERIC_VALUE_IMAGE,
         getString("_UI_AllPropertyCategory")));
  }

  /**
   * This adds a property descriptor for the Model Plugin Class feature.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated NOT
   */
  protected void addModelPluginClassPropertyDescriptor(Object object)
  {
    itemPropertyDescriptors.add
      (new GenItemPropertyDescriptor
        (((ComposeableAdapterFactory)adapterFactory).getRootAdapterFactory(),
         getString("_UI_GenModel_modelPluginClass_feature"),
         getString("_UI_GenModel_modelPluginClass_description"),
         GenModelPackage.eINSTANCE.getGenModel_ModelPluginClass(),
         true,
         ItemPropertyDescriptor.GENERIC_VALUE_IMAGE,
         getString("_UI_ModelPropertyCategory")));
  }

  /**
   * This adds a property descriptor for the Edit Plugin Class feature.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated NOT
   */
  protected void addEditPluginClassPropertyDescriptor(Object object)
  {
    itemPropertyDescriptors.add
      (new GenItemPropertyDescriptor
        (((ComposeableAdapterFactory)adapterFactory).getRootAdapterFactory(),
         getString("_UI_GenModel_editPluginClass_feature"),
         getString("_UI_GenModel_editPluginClass_description"),
         GenModelPackage.eINSTANCE.getGenModel_EditPluginClass(),
         true,
         ItemPropertyDescriptor.GENERIC_VALUE_IMAGE,
         getString("_UI_EditPropertyCategory")));
  }

  /**
   * This adds a property descriptor for the Editor Plugin Class feature.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated NOT
   */
  protected void addEditorPluginClassPropertyDescriptor(Object object)
  {
    itemPropertyDescriptors.add
      (new GenItemPropertyDescriptor
        (((ComposeableAdapterFactory)adapterFactory).getRootAdapterFactory(),
         getString("_UI_GenModel_editorPluginClass_feature"),
         getString("_UI_GenModel_editorPluginClass_description"),
         GenModelPackage.eINSTANCE.getGenModel_EditorPluginClass(),
         true,
         ItemPropertyDescriptor.GENERIC_VALUE_IMAGE,
         getString("_UI_EditorPropertyCategory")));
  }

  /**
   * This adds a property descriptor for the Update Classpath feature.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated NOT
   */
  protected void addUpdateClasspathPropertyDescriptor(Object object)
  {
    itemPropertyDescriptors.add
      (new GenItemPropertyDescriptor
        (((ComposeableAdapterFactory)adapterFactory).getRootAdapterFactory(),
         getString("_UI_GenModel_updateClasspath_feature"),
         getString("_UI_GenModel_updateClasspath_description"),
         GenModelPackage.eINSTANCE.getGenModel_UpdateClasspath(),
         true,
         ItemPropertyDescriptor.BOOLEAN_VALUE_IMAGE,
         getString("_UI_JETPropertyCategory")));
  }

  /**
   * This adds a property descriptor for the Generate Schema feature.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated NOT
   */
  protected void addGenerateSchemaPropertyDescriptor(Object object)
  {
    itemPropertyDescriptors.add
      (new GenItemPropertyDescriptor
        (((ComposeableAdapterFactory)adapterFactory).getRootAdapterFactory(),
         getString("_UI_GenModel_generateSchema_feature"),
         getString("_UI_GenModel_generateSchema_description"),
         GenModelPackage.eINSTANCE.getGenModel_GenerateSchema(),
         true,
         ItemPropertyDescriptor.BOOLEAN_VALUE_IMAGE,
         getString("_UI_ModelPropertyCategory")));
  }

  /**
   * This adds a property descriptor for the Non NLS Markers feature.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated NOT
   */
  protected void addNonNLSMarkersPropertyDescriptor(Object object)
  {
    itemPropertyDescriptors.add
      (new GenItemPropertyDescriptor
        (((ComposeableAdapterFactory)adapterFactory).getRootAdapterFactory(),
         getString("_UI_GenModel_nonNLSMarkers_feature"),
         getString("_UI_GenModel_nonNLSMarkers_description"),
         GenModelPackage.eINSTANCE.getGenModel_NonNLSMarkers(),
         true,
         ItemPropertyDescriptor.BOOLEAN_VALUE_IMAGE,
         getString("_UI_AllPropertyCategory")));
  }

  /**
   * This specifies how to implement {@link #getChildren} and {@link AddCommand} and {@link RemoveCommand} support in {@link #createCommand}.
   */
  public Collection getChildrenReferences(Object object)
  {
    if (childrenReferences == null)
    {
      super.getChildrenReferences(object);
      childrenReferences.add(GenModelPackage.eINSTANCE.getGenModel_GenPackages());
      childrenReferences.add(GenModelPackage.eINSTANCE.getGenModel_UsedGenPackages());
    }
    return childrenReferences;
  }


  /**
   */
  public Object getImage(Object object)
  {
    return new UnderlayedImage(getResourceLocator().getImage("full/obj16/GenModel"));
  }

  /**
   * This returns the label text for the adapted class.
   */
  public String getText(Object object)
  {
    GenModel genModel = (GenModel)object;
    return genModel.getModelName();
  }

  /**
   * This handles notification by calling {@link #fireNotifyChanged fireNotifyChanged}.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   */
  public void notifyChanged(Notification notification)
  {
    switch (notification.getFeatureID(GenModel.class))
    {
      case GenModelPackage.GEN_MODEL__COPYRIGHT_TEXT:
      case GenModelPackage.GEN_MODEL__MODEL_DIRECTORY:
      case GenModelPackage.GEN_MODEL__CREATION_COMMANDS:
      case GenModelPackage.GEN_MODEL__EDIT_DIRECTORY:
      case GenModelPackage.GEN_MODEL__EDITOR_DIRECTORY:
      case GenModelPackage.GEN_MODEL__MODEL_PLUGIN_ID:
      case GenModelPackage.GEN_MODEL__TEMPLATE_DIRECTORY:
      case GenModelPackage.GEN_MODEL__RUNTIME_JAR:
      case GenModelPackage.GEN_MODEL__FOREIGN_MODEL:
      case GenModelPackage.GEN_MODEL__DYNAMIC_TEMPLATES:
      case GenModelPackage.GEN_MODEL__REDIRECTION:
      case GenModelPackage.GEN_MODEL__FORCE_OVERWRITE:
      case GenModelPackage.GEN_MODEL__NON_EXTERNALIZED_STRING_TAG:
      case GenModelPackage.GEN_MODEL__TEST_DIRECTORY:
      case GenModelPackage.GEN_MODEL__MODEL_NAME:
      case GenModelPackage.GEN_MODEL__MODEL_PLUGIN_CLASS:
      case GenModelPackage.GEN_MODEL__EDIT_PLUGIN_CLASS:
      case GenModelPackage.GEN_MODEL__EDITOR_PLUGIN_CLASS:
      case GenModelPackage.GEN_MODEL__UPDATE_CLASSPATH:
      case GenModelPackage.GEN_MODEL__GENERATE_SCHEMA:
      case GenModelPackage.GEN_MODEL__NON_NLS_MARKERS:
      case GenModelPackage.GEN_MODEL__GEN_PACKAGES:
      {
        fireNotifyChanged(notification);
        return;
      }
    }
    super.notifyChanged(notification);
  }

  /**
   * Return the resource locator for this item provider's resources.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   */
  public ResourceLocator getResourceLocator()
  {
    return GenModelEditPlugin.INSTANCE;
  }
}

