/**
 * <copyright>
 *
 * Copyright (c) 2002 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 * 
 * Contributors: 
 *   IBM - Initial API and implementation
 *
 * </copyright>
 *
 * plugins/org.eclipse.emf.ecore.xmi/src/org/eclipse/emf/ecore/xmi/PackageNotFoundException.java, emf.ecore.xmi, org.eclipse.111, 20031020_1612WL
 * @version 1.2 10/20/03
 */
package org.eclipse.emf.ecore.xmi;

public class PackageNotFoundException extends XMIException {
    protected String uri;

	/**
	 * Constructor for PackageNotFoundException.
	 * @param uri
	 * @param location
	 * @param line
	 * @param column
	 */
	public PackageNotFoundException(
		String uri,
		String location,
		int line,
		int column) {
		super("Package with uri '" + uri + "' not found.", location, line, column);
		this.uri = uri;
	}
	
	public String uri() {
		return uri;
	}	
}
