/**
 * <copyright> 
 *
 * Copyright (c) 2002 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 * 
 * Contributors: 
 *   IBM - Initial API and implementation
 *
 * </copyright>
 *
 * plugins/org.eclipse.emf.codegen.ecore.ui/src/org/eclipse/emf/codegen/ecore/genmodel/provider/GenClassItemProvider.java, emf.codegen.ecore.ui, org.eclipse.111, 20031020_1612WL
 * @version 1.21 10/20/03
 */
package org.eclipse.emf.codegen.ecore.genmodel.provider;


import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.notify.Notification;

import org.eclipse.emf.common.util.ResourceLocator;

import org.eclipse.emf.edit.command.AddCommand;
import org.eclipse.emf.edit.command.RemoveCommand;

import org.eclipse.emf.edit.domain.AdapterFactoryEditingDomain;
import org.eclipse.emf.edit.domain.EditingDomain;

import org.eclipse.emf.edit.provider.ComposeableAdapterFactory;
import org.eclipse.emf.edit.provider.IEditingDomainItemProvider;
import org.eclipse.emf.edit.provider.IItemLabelProvider;
import org.eclipse.emf.edit.provider.IItemPropertySource;
import org.eclipse.emf.edit.provider.IStructuredItemContentProvider;
import org.eclipse.emf.edit.provider.ITreeItemContentProvider;
import org.eclipse.emf.edit.provider.ItemPropertyDescriptor;

import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EReference;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;

import org.eclipse.emf.edit.provider.ItemProviderAdapter;

import org.eclipse.emf.codegen.ecore.genmodel.GenClass;
import org.eclipse.emf.codegen.ecore.genmodel.GenModelPackage;

import org.eclipse.emf.codegen.ecore.genmodel.GenProviderKind;

/**
 * This is the item provider adpater for a {@link org.eclipse.emf.codegen.ecore.genmodel.GenClass} object.
 * <!-- begin-user-doc -->
 * <!-- end-user-doc -->
 * @generated
 */
public class GenClassItemProvider
  extends GenBaseItemProvider
  implements 
    IEditingDomainItemProvider, IStructuredItemContentProvider, ITreeItemContentProvider, IItemLabelProvider, IItemPropertySource
{
  /**
   * This constructs an instance from a factory and a notifier.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   */
  public GenClassItemProvider(AdapterFactory adapterFactory)
  {
    super(adapterFactory);
  }

  /**
   * This returns the property descriptors for the adapted class.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   */
  public List getPropertyDescriptors(Object object)
  {
    if (itemPropertyDescriptors == null)
    {
      super.getPropertyDescriptors(object);

      addProviderPropertyDescriptor(object);
      addImagePropertyDescriptor(object);
      addEcoreClassPropertyDescriptor(object);
      addLabelFeaturePropertyDescriptor(object);
    }
    return itemPropertyDescriptors;
  }

  /**
   * This adds a property descriptor for the Provider feature.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated NOT
   */
  protected void addProviderPropertyDescriptor(Object object)
  {
    itemPropertyDescriptors.add
      (new GenItemPropertyDescriptor
        (((ComposeableAdapterFactory)adapterFactory).getRootAdapterFactory(),
         getString("_UI_GenClass_provider_feature"),
         getString("_UI_GenClass_provider_description"),
         GenModelPackage.eINSTANCE.getGenClass_Provider(),
         true,
         ItemPropertyDescriptor.GENERIC_VALUE_IMAGE,
         getString("_UI_EditPropertyCategory")));
  }

  /**
   * This adds a property descriptor for the Image feature.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated NOT
   */
  protected void addImagePropertyDescriptor(Object object)
  {
    itemPropertyDescriptors.add
      (new GenItemPropertyDescriptor
        (((ComposeableAdapterFactory)adapterFactory).getRootAdapterFactory(),
         getString("_UI_GenClass_image_feature"),
         getString("_UI_GenClass_image_description"),
         GenModelPackage.eINSTANCE.getGenClass_Image(),
         true,
         ItemPropertyDescriptor.BOOLEAN_VALUE_IMAGE,
         getString("_UI_EditPropertyCategory")));
  }

  /**
   * This adds a property descriptor for the Ecore Class feature.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated NOT
   */
  protected void addEcoreClassPropertyDescriptor(Object object)
  {
    itemPropertyDescriptors.add
      (new GenItemPropertyDescriptor
        (((ComposeableAdapterFactory)adapterFactory).getRootAdapterFactory(),
         getString("_UI_GenClass_ecoreClass_feature"),
         getString("_UI_GenClass_ecoreClass_description"),
         GenModelPackage.eINSTANCE.getGenClass_EcoreClass(),
         false,
         getString("_UI_EcorePropertyCategory")));
  }

  /**
   * This adds a property descriptor for the Label Feature feature.
   */
  protected void addLabelFeaturePropertyDescriptor(Object object)
  {
    itemPropertyDescriptors.add
      (new GenItemPropertyDescriptor
        (((ComposeableAdapterFactory)adapterFactory).getRootAdapterFactory(),
         getString("_UI_GenClass_labelFeature_feature"),
         getString("_UI_GenClass_labelFeature_description"),
         GenModelPackage.eINSTANCE.getGenClass_LabelFeature(),
         true,
         getString("_UI_EditPropertyCategory"))
       {
         protected Collection getComboBoxObjects(Object object)
         {
           GenClass genClass = (GenClass)object;
           return genClass.getLabelFeatureCandidates();
         }
       });
  }

  /**
   * This specifies how to implement {@link #getChildren} 
   * and {@link org.eclipse.emf.edit.command.AddCommand} and {@link org.eclipse.emf.edit.command.RemoveCommand} 
   * support in {@link #createCommand}.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   */
  public Collection getChildrenReferences(Object object)
  {
    if (childrenReferences == null)
    {
      super.getChildrenReferences(object);
      childrenReferences.add(GenModelPackage.eINSTANCE.getGenClass_GenFeatures());
      childrenReferences.add(GenModelPackage.eINSTANCE.getGenClass_GenOperations());
    }
    return childrenReferences;
  }

  /**
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   */
  protected EReference getChildReference(Object object, Object child)
  {
    // Check the type of the specified child object and return the proper feature to use for
    // adding (see {@link AddCommand}) it as a child.

    return super.getChildReference(object, child);
  }


  /**
   */
  public Object getImage(Object object)
  {
    return new UnderlayedImage(getResourceLocator().getImage("full/obj16/EClass"));
  }

  /**
   * This returns the label text for the adapted class.
   */
  public String getText(Object object)
  {
    GenClass genClass = (GenClass)object;
    EClass eClass = (EClass)genClass.getEcoreClass();
    StringBuffer result = new StringBuffer();
    if (eClass.getName() != null)
    {
      result.append(eClass.getName());
    }
    if (!eClass.getESuperTypes().isEmpty())
    {
      result.append(" -> ");
      for (Iterator i = eClass.getESuperTypes().iterator(); i.hasNext(); )
      {
        EClass eSuperType = (EClass)i.next();
        result.append(eSuperType.getName());
        if (i.hasNext())
        {
          result.append(", ");
        }
      }
    }
    if (eClass.getInstanceClassName() != null)
    {
      result.append(" <");
      result.append(eClass.getInstanceClassName());
      result.append(">");
    }

    return result.toString();
  }

  /**
   * This handles notification by calling {@link #fireNotifyChanged fireNotifyChanged}.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   */
  public void notifyChanged(Notification notification)
  {
    switch (notification.getFeatureID(GenClass.class))
    {
      case GenModelPackage.GEN_CLASS__GEN_PACKAGE:
      case GenModelPackage.GEN_CLASS__PROVIDER:
      case GenModelPackage.GEN_CLASS__IMAGE:
      case GenModelPackage.GEN_CLASS__ECORE_CLASS:
      case GenModelPackage.GEN_CLASS__GEN_FEATURES:
      case GenModelPackage.GEN_CLASS__GEN_OPERATIONS:
      case GenModelPackage.GEN_CLASS__LABEL_FEATURE:
      {
        fireNotifyChanged(notification);
        return;
      }
    }
    super.notifyChanged(notification);
  }

  /**
   * Return the resource locator for this item provider's resources.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   */
  public ResourceLocator getResourceLocator()
  {
    return GenModelEditPlugin.INSTANCE;
  }
}
