/**
 * <copyright>
 *
 * Copyright (c) 2002 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 * 
 * Contributors: 
 *   IBM - Initial API and implementation
 *
 * </copyright>
 *
 * plugins/org.eclipse.emf.ecore/src/org/eclipse/emf/ecore/impl/EObjectImpl.java, emf.ecore, org.eclipse.111, 20031020_1612WL
 * @version 1.94 10/20/03
 */
package org.eclipse.emf.ecore.impl;


import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.NotificationChain;
import org.eclipse.emf.common.notify.NotifyingList;

import org.eclipse.emf.common.notify.impl.NotificationChainImpl;
import org.eclipse.emf.common.notify.impl.NotifierImpl;

import org.eclipse.emf.common.util.AbstractTreeIterator;
import org.eclipse.emf.common.util.BasicEList;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.common.util.WrappedException;

import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.EcorePackage;
import org.eclipse.emf.ecore.InternalEObject;

import org.eclipse.emf.ecore.impl.ENotificationImpl;

import org.eclipse.emf.ecore.resource.Resource;

import org.eclipse.emf.ecore.util.EContentsEList;
import org.eclipse.emf.ecore.util.ECrossReferenceEList;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.ecore.util.InternalEList;


/**
 * <!-- begin-user-doc -->
 * An implementation of the model object '<em><b>EObject</b></em>'.
 * @extends InternalEObject
 * <!-- end-user-doc -->
 * <p>
 * </p>
 *
 * @generated
 */
public class EObjectImpl extends NotifierImpl implements EObject, InternalEObject
{
  /**
   * This is unused, but we can reserve bits with eFlags.
   */
  public static final int ELAST_EOBJECT_FLAG = ELAST_NOTIFIER_FLAG;

  /**
   * An internal interface for holding less frequently members variables.
   */
  protected interface EPropertiesHolder extends EStructuralFeature.Internal.DynamicValueHolder
  {
    EClass getEClass();
    void setEClass(EClass eClass);

    URI getEProxyURI();
    void setEProxyURI(URI eProxyURI);

    Resource.Internal getEResource();
    void setEResource(Resource.Internal eResource);

    EList getEContents();
    void setEContents(EList eContents);

    EList getECrossReferences();
    void setECrossReferences(EList eCrossReferences);

    boolean hasSettings();
    void allocateSettings(int maximumDynamicFeatureID);
  }

  /**
   * An internal class for holding less frequently members variables.
   */
  protected static class EPropertiesHolderImpl implements EPropertiesHolder
  {
    protected EClass eClass;
    protected URI eProxyURI;
    protected Resource.Internal eResource;
    protected EList eContents;
    protected EList eCrossReferences;
    protected Object [] eSettings;

    public EClass getEClass()
    {
      return eClass;
    }

    public void setEClass(EClass eClass)
    {
      this.eClass = eClass;
    }

    public URI getEProxyURI()
    {
      return eProxyURI;
    }

    public void setEProxyURI(URI eProxyURI)
    {
      this.eProxyURI = eProxyURI;
    }

    public Resource.Internal getEResource()
    {
      return eResource;
    }

    public void setEResource(Resource.Internal eResource)
    {
      this.eResource = eResource;
    }

    public EList getEContents()
    {
      return eContents;
    }

    public void setEContents(EList eContents)
    {
      this.eContents = eContents;
    }

    public EList getECrossReferences()
    {
      return eCrossReferences;
    }

    public void setECrossReferences(EList eCrossReferences)
    {
      this.eCrossReferences = eCrossReferences;
    }

    public boolean hasSettings()
    {
      return eSettings != null;
    }

    public void allocateSettings(int maximumDynamicFeatureID)
    {
      eSettings = new Object [maximumDynamicFeatureID];
    }

    public Object dynamicGet(int dynamicFeatureID)
    {
      return eSettings[dynamicFeatureID];
    }

    public void dynamicSet(int dynamicFeatureID, Object value)
    {
      eSettings[dynamicFeatureID] = value;
    }

    public void dynamicUnset(int dynamicFeatureID)
    {
      eSettings[dynamicFeatureID] = null;
    }
  }

  protected InternalEObject eContainer;
  protected int eContainerFeatureID;
  protected EPropertiesHolder eProperties;
  
  /**
   * <!-- begin-user-doc -->
   * Creates an EObject.
   * <!-- end-user-doc -->
   * @generated modifiable
   */
  protected EObjectImpl() 
  {
    super();
  }

  protected int eStaticFeatureCount()
  {
    return eStaticClass().getEAllStructuralFeatures().size();
  }

  protected EPropertiesHolder eProperties()
  {
    if (eProperties == null)
    {
      eProperties = new EPropertiesHolderImpl();
    }
    return eProperties;
  }

  protected boolean eHasSettings()
  {
    return eProperties != null && eProperties.hasSettings();
  }

  protected EStructuralFeature.Internal.DynamicValueHolder eSettings()
  {
    if (!eHasSettings())
    {
      int size =  eClass().getEAllStructuralFeatures().size() - eStaticFeatureCount();
      if (size > 0)
      {
        eProperties().allocateSettings(size);
      }
    }

    return eProperties;
  }

  protected int eDynamicFeatureID(EStructuralFeature eStructuralFeature)
  {
    return eClass().getEAllStructuralFeatures().indexOf(eStructuralFeature) - eStaticFeatureCount();
  }

  public String eURIFragmentSegment(EStructuralFeature eStructuralFeature, EObject eObject)
  {
    if (eStructuralFeature == null)
    {
      for (EContentsEList.FeatureIterator crossReferences = 
             (EContentsEList.FeatureIterator)((InternalEList)eCrossReferences()).basicIterator(); 
           crossReferences.hasNext(); )
      {
        EObject crossReference = (EObject)crossReferences.next();
        if (crossReference == eObject)
        {
          eStructuralFeature = crossReferences.feature();
        }
      }
    }

    if (eStructuralFeature.isMany())
    {
      EList eList = (EList)eGet(eStructuralFeature, false);
      int index = eList.indexOf(eObject);
      return '@' + eStructuralFeature.getName() + '.' + index;
    }
    else
    {
      return '@' + eStructuralFeature.getName();
    }
  }

  public EObject eObjectForURIFragmentSegment(String uriFragmentSegment)
  {
    int dotIndex = uriFragmentSegment.indexOf(".");
    if (dotIndex == -1)
    {
      EStructuralFeature eStructuralFeature = eClass().getEStructuralFeature(uriFragmentSegment.substring(1));
      return (EObject)eGet(eStructuralFeature, false);
    }
    else
    {
      EStructuralFeature eStructuralFeature = eClass().getEStructuralFeature(uriFragmentSegment.substring(1, dotIndex));
      EList eList = (EList)eGet(eStructuralFeature, false);
      int position = 0;
      try
      {
        position = Integer.parseInt(uriFragmentSegment.substring(dotIndex + 1));
      }
      catch (NumberFormatException exception)
      {
        throw new WrappedException(exception);
      }
      return position < eList.size() ?
        (EObject)eList.get(position) :
        null;
    }
  }

  public boolean eContains(EObject eObject)
  {
    return EcoreUtil.isAncestor(this, eObject);
  }

  public EObject eContainer()
  {
    return eInternalContainer();
  }

  protected InternalEObject eInternalContainer()
  {
    return eContainer;
  }

  public int eContainerFeatureID()
  {
    return eContainerFeatureID;
  }

  public EList eContents()
  {
    EList result = eProperties().getEContents();
    if (result == null)
    {
      eProperties.setEContents
       (result = 
          new EContentsEList
          (this, 
           (EStructuralFeature [])((BasicEList)eClass().getEAllContainments()).data()));
    }

    return result;
  }

  public EList eCrossReferences()
  {
    EList result = eProperties().getECrossReferences();
    if (result == null)
    {
      eProperties.setECrossReferences(result = new ECrossReferenceEList(this));
    }

    return result;
  }

  public TreeIterator eAllContents()
  {
    return 
      new AbstractTreeIterator(this, false)
      {
        public Iterator getChildren(Object object)
        {
          return ((EObject)object).eContents().iterator();
        }
      };
  }

  /**
   * @generated modifiable
   */
  public EReference eContainmentFeature()
  {
    EObject eContainer = eContainer();
    if (eContainer == null)
    {
      return null;
    }
    else
    {
      int eContainerFeatureID = eContainerFeatureID();
      return 
        eContainerFeatureID <= EOPPOSITE_FEATURE_BASE ? 
          (EReference)eContainer.eClass().getEAllStructuralFeatures().get(EOPPOSITE_FEATURE_BASE - eContainerFeatureID) :
          ((EReference)eClass().getEAllStructuralFeatures().get(eContainerFeatureID)).getEOpposite();
    }
  }

  protected Resource.Internal eDirectResource()
  {
    return eProperties == null ? null : eProperties.getEResource();
  }

  /**
   * @generated modifiable
   */
  public Resource eResource()
  {
    return eInternalResource();
  }

  public Resource.Internal eInternalResource()
  {
    Resource.Internal result = eDirectResource();
    if (result == null) 
    {
      InternalEObject eContainer = eInternalContainer();
      if (eContainer != null)
      {
        result = eContainer.eInternalResource();
      }
    }
    return result;
  }

  public NotificationChain eSetResource(Resource.Internal resource, NotificationChain notifications)
  {
    Resource oldResource = eDirectResource();
    if (oldResource != null)
    {
      notifications = ((InternalEList)oldResource.getContents()).basicRemove(this, notifications);
    }
    else if (eContainer() != null)
    {
      notifications = eBasicRemoveFromContainer(notifications);
      notifications = eBasicSetContainer(null, -1, notifications);
    }

    eProperties().setEResource(resource);

    return notifications;
  }

  public Object eGet(EStructuralFeature eFeature)
  {
    return eGet(eFeature, true);
  }

  public Object eGet(EStructuralFeature eFeature, boolean resolve)
  {
    return eDynamicGet(eFeature, resolve);
  }

  public Object eDynamicGet(EStructuralFeature eFeature, boolean resolve)
  {
    int dynamicFeatureID = eDynamicFeatureID(eFeature);
    if (dynamicFeatureID <= -1)
    {
      throw new IllegalArgumentException("The feature '" + eFeature.getName() + "' is not a valid feature");
    }
    return eSettingDelegate(eFeature).dynamicGet(this, eSettings(), dynamicFeatureID, resolve);
  }

  public void eSet(EStructuralFeature eFeature, Object newValue) 
  {
    eDynamicSet(eFeature, newValue);
  }

  public void eDynamicSet(EStructuralFeature eFeature, Object newValue) 
  {
    int dynamicFeatureID = eDynamicFeatureID(eFeature);
    if (dynamicFeatureID <= -1 || !eFeature.isChangeable())
    {
      throw new IllegalArgumentException("The feature '" + eFeature.getName() + "' is not a valid changeable feature");
    }

    eSettingDelegate(eFeature).dynamicSet(this, eSettings(), dynamicFeatureID, newValue);
  }

  public void eUnset(EStructuralFeature eFeature) 
  {
    eDynamicUnset(eFeature);
  }

  public void eDynamicUnset(EStructuralFeature eFeature) 
  {
    int dynamicFeatureID = eDynamicFeatureID(eFeature);
    if (dynamicFeatureID <= -1 || !eFeature.isChangeable())
    {
      throw new IllegalArgumentException("The feature '" + eFeature.getName() + "' is not a valid changeable feature");
    }

    eSettingDelegate(eFeature).dynamicUnset(this, eSettings(), dynamicFeatureID);
  }

  public boolean eIsSet(EStructuralFeature eFeature) 
  {
    return eDynamicIsSet(eFeature);
  }

  public boolean eDynamicIsSet(EStructuralFeature eFeature) 
  {
    int dynamicFeatureID = eDynamicFeatureID(eFeature);
    if (dynamicFeatureID <= -1)
    {
      throw new IllegalArgumentException("The feature '" + eFeature.getName() + "' is not a valid feature");
    }

    if (eHasSettings())
    {
      return eSettingDelegate(eFeature).dynamicIsSet(this, eSettings(), dynamicFeatureID);
    }

    return false;
  }

  public NotificationChain eBasicSetContainer(InternalEObject newContainer, int newContainerFeatureID, NotificationChain msgs)
  {
    Resource.Internal oldResource = this.eDirectResource();
    if (oldResource != null)
    {
      msgs = ((InternalEList)oldResource.getContents()).basicRemove(this, msgs);
      eProperties.setEResource(oldResource = null);
    }
    else
    {
      oldResource = this.eInternalResource();
    }

    Resource.Internal newResource = newContainer == null ? null : newContainer.eInternalResource();
    if (oldResource != newResource && oldResource != null) 
    {
      oldResource.detached(this);
    }

    EObject oldContainer = eContainer();
    int oldContainerFeatureID = eContainerFeatureID();
    eBasicSetContainer(newContainer, newContainerFeatureID);

    if (oldResource != newResource && newResource != null) 
    {
      newResource.attached(this);
    }

    if (eNotificationRequired())
    {
      if (msgs == null) msgs = new NotificationChainImpl(4);
      if (oldContainer != null && oldContainerFeatureID >=0 && oldContainerFeatureID != newContainerFeatureID)
      {
        msgs.add
          (new ENotificationImpl
            (this,
             Notification.SET,
             oldContainerFeatureID, 
             oldContainer,
             null));
      }
      if (newContainerFeatureID >= 0)
      {
        msgs.add
          (new ENotificationImpl
            (this,
             Notification.SET,
             newContainerFeatureID, 
             oldContainerFeatureID == newContainerFeatureID ? oldContainer : null,
             newContainer));
      }
    }
    return msgs;
  }

  protected void eBasicSetContainer(InternalEObject newContainer, int newContainerFeatureID)
  {
    eContainer = newContainer;
    eContainerFeatureID = newContainerFeatureID;
  }

  public NotificationChain eBasicRemoveFromContainer(NotificationChain msgs)
  {
    int eContainerFeatureID = eContainerFeatureID();
    if (eContainerFeatureID >= 0)
    {
      return eDynamicBasicRemoveFromContainer(msgs);
    }
    else 
    {
      return eInternalContainer().eInverseRemove(this, EOPPOSITE_FEATURE_BASE - eContainerFeatureID, null, msgs);
    }
  }

  public NotificationChain eDynamicBasicRemoveFromContainer(NotificationChain msgs)
  {
    EReference inverseFeature = ((EReference)eClass().getEAllStructuralFeatures().get(eContainerFeatureID())).getEOpposite();
    return eInternalContainer().eInverseRemove(this, inverseFeature.getFeatureID(), inverseFeature.getContainerClass(), msgs);
  }

  public NotificationChain eInverseAdd(InternalEObject otherEnd, int featureID, Class baseClass, NotificationChain msgs)
  {
    if (featureID >= 0)
    {
      return eDynamicInverseAdd(otherEnd, featureID, baseClass, msgs);
    }
    else
    {
      if (eContainer() != null)
      {
        msgs = eBasicRemoveFromContainer(msgs);
      }
      return eBasicSetContainer(otherEnd, featureID, msgs);
    }
  }

  public NotificationChain eDynamicInverseAdd(InternalEObject otherEnd, int featureID, Class inverseClass, NotificationChain msgs)
  {
    EStructuralFeature.Internal feature = (EStructuralFeature.Internal)eClass().getEAllStructuralFeatures().get(featureID);
    return 
      feature.getSettingDelegate().dynamicInverseAdd
        (this, eSettings(), featureID - eStaticFeatureCount(), otherEnd, msgs);
  }


  public NotificationChain eInverseRemove(InternalEObject otherEnd, int featureID, Class baseClass, NotificationChain msgs)
  {
    if (featureID >= 0)
    {
      return eDynamicInverseRemove(otherEnd, featureID, baseClass, msgs);
    }
    else
    {
      return eBasicSetContainer(null, featureID, msgs);
    }
  }

  public NotificationChain eDynamicInverseRemove(InternalEObject otherEnd, int featureID, Class inverseClass, NotificationChain msgs)
  {
    EStructuralFeature.Internal feature = (EStructuralFeature.Internal)eClass().getEAllStructuralFeatures().get(featureID);
    return feature.getSettingDelegate().dynamicInverseRemove
      (this, eSettings(), featureID - eStaticFeatureCount(), otherEnd, msgs);
  }

  public URI eProxyURI()
  {
    return eProperties == null ? null : eProperties.getEProxyURI();
  }

  public void eSetProxyURI(URI uri)
  {
    eProperties().setEProxyURI(uri);
  }

  public boolean eIsProxy()
  {
    return eProperties != null && eProperties.getEProxyURI() != null;
  }

  public int eBaseStructuralFeatureID(int derivedFeatureID, Class baseClass)
  {
    return derivedFeatureID;
  }

  public int eDerivedStructuralFeatureID(int baseFeatureID, Class baseClass)
  {
    return baseFeatureID;
  }

  public int eDerivedStructuralFeatureID(EStructuralFeature eStructuralFeature)
  {
    return eClass().getEAllStructuralFeatures().indexOf(eStructuralFeature);
  }

  public EClass eClass()
  {
    if (eProperties != null)
    {
      EClass result = eProperties.getEClass();
      if (result != null)
      {
        return result;
      }
    }
    return eStaticClass();
  }

  // Subclasses MUST override this function
  protected EClass eStaticClass()
  {
    return EcorePackage.eINSTANCE.getEObject();
  }

  public void eSetClass(EClass eClass)
  {
    eProperties().setEClass(eClass);
  }

  protected EStructuralFeature.Internal.SettingDelegate eSettingDelegate(EStructuralFeature eFeature)
  {
    return ((EStructuralFeature.Internal)eFeature).getSettingDelegate();
  }

  public EStructuralFeature.Setting eSetting(final EStructuralFeature eFeature)
  {
    int index = eClass().getEAllStructuralFeatures().indexOf(eFeature);
    int dynamicIndex = eStaticFeatureCount();
    if (index >= dynamicIndex)
    {
      return eSettingDelegate(eFeature).dynamicSetting(this, eSettings(), index - dynamicIndex);
    }
    else if (index <= -1)
    {
      throw new IllegalArgumentException("The feature '" + eFeature.getName() + "' is not a valid feature");
    }
    else if (eFeature.isMany())
    {
      return (EStructuralFeature.Setting)eGet(eFeature, false);
    }
    else
    {
      EStructuralFeature.Setting setting =
        new EStructuralFeature.Setting()
        {
          public EObject getEObject()
          {
            return EObjectImpl.this;
          }

          public EStructuralFeature getEStructuralFeature()
          {
            return eFeature;
          }

          public Object get(boolean resolve)
          {
            return EObjectImpl.this.eGet(eFeature, resolve);
          }

          public void set(Object newValue)
          {
            EObjectImpl.this.eSet(eFeature, newValue);
          }

          public boolean isSet()
          {
            return EObjectImpl.this.eIsSet(eFeature);
          }

          public void unset()
          {
            EObjectImpl.this.eUnset(eFeature);
          }
        };
      return setting;
    }
  }

  public String toString()
  {
    // Should use the following code to improve debuggability. Will need to
    // update testcase baselogs before this change can be made.

    StringBuffer result = new StringBuffer(getClass().getName());
    result.append('@');
    result.append(Integer.toHexString(hashCode()));

    if (eIsProxy())
    {
      result.append(" (eProxyURI: ");
      result.append(eProxyURI());
      if (eProperties != null && eProperties.getEClass() != null)
      {
        result.append(" eClass: ");
        result.append(eProperties.getEClass());
      }
      result.append(')');
    }
    else if (eProperties != null && eProperties.getEClass() != null)
    {
      result.append(" (eClass: ");
      result.append(eProperties.getEClass());
      result.append(')');
    }

    return result.toString();
  }
}
