/**
 * <copyright>
 *
 * Copyright (c) 2002 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 *
 * Contributors:
 *   IBM - Initial API and implementation
 *
 * </copyright>
 *
 * plugins/org.eclipse.emf.ecore/src/org/eclipse/emf/ecore/util/ECrossReferenceEList.java, emf.ecore, org.eclipse.111, 20031020_1612WL
 * @version 1.7 10/20/03
 */
package org.eclipse.emf.ecore.util;


import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;

import org.eclipse.emf.common.util.BasicEList;

import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;


/**
 * A virtual list of all the cross references of an EObject.
 */
public class ECrossReferenceEList extends EContentsEList
{
  public ECrossReferenceEList(EObject eObject)
  {
    super(eObject, (EStructuralFeature [])((BasicEList)eObject.eClass().getEAllReferences()).data());
  }

  protected ECrossReferenceEList(EObject eObject, EStructuralFeature [] eStructuralFeatures)
  {
    super(eObject, eStructuralFeatures);
  }

  public static class FeatureIteratorImpl extends EContentsEList.FeatureIteratorImpl
  {
    public FeatureIteratorImpl(EObject eObject)
    {
      super(eObject, (EStructuralFeature [])((BasicEList)eObject.eClass().getEAllReferences()).data());
    }

    public FeatureIteratorImpl(EObject eObject, EStructuralFeature [] eStructuralFeatures)
    {
      super(eObject, eStructuralFeatures);
    }

    protected boolean isIncluded(EStructuralFeature eStructuralFeature)
    {
      EReference eReference = (EReference)eStructuralFeature;
      return !eReference.isContainment() && !eReference.isContainer();
    }
  }

  public static class ResolvingFeatureIteratorImpl extends FeatureIteratorImpl
  {
    public ResolvingFeatureIteratorImpl(EObject eObject)
    {
      super(eObject);
    }

    public ResolvingFeatureIteratorImpl(EObject eObject, EStructuralFeature [] eStructuralFeatures)
    {
      super(eObject, eStructuralFeatures);
    }

    protected boolean resolve()
    {
      return true;
    }
  }

  protected boolean isIncluded(EStructuralFeature eStructuralFeature)
  {
    EReference eReference = (EReference)eStructuralFeature;
    return !eReference.isContainment() && !eReference.isContainer();
  }

  protected ListIterator newListIterator()
  {
    return
      this.resolve() ?
        new ResolvingFeatureIteratorImpl(eObject, eStructuralFeatures) :
        new FeatureIteratorImpl(eObject, eStructuralFeatures);
  }

  public List basicList()
  {
    return
      new ECrossReferenceEList(eObject, eStructuralFeatures)
      {
        protected boolean resolve()
        {
          return false;
        }
      };
  }

  public Iterator basicIterator()
  {
    if (eStructuralFeatures == null)
    {
      return FeatureIteratorImpl.EMPTY_ITERATOR;
    }

    return new FeatureIteratorImpl(eObject, eStructuralFeatures);
  }

  public ListIterator basicListIterator()
  {
    if (eStructuralFeatures == null)
    {
      return FeatureIteratorImpl.EMPTY_ITERATOR;
    }

    return new FeatureIteratorImpl(eObject, eStructuralFeatures);
  }

  public ListIterator basicListIterator(int index)
  {
    if (eStructuralFeatures == null)
    {
      if (index < 0 || index > 1)
      {
        throw new IndexOutOfBoundsException("index=" + index + ", size=0");
      }

      return FeatureIteratorImpl.EMPTY_ITERATOR;
    }

    ListIterator result = new FeatureIteratorImpl(eObject, eStructuralFeatures);
    for (int i = 0; i < index; ++i)
    {
      result.next();
    }
    return result;
  }
}
