/**
 * <copyright> 
 *
 * Copyright (c) 2002 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 * 
 * Contributors: 
 *   IBM - Initial API and implementation
 *
 * </copyright>
 *
 * plugins/org.eclipse.emf.edit.ui/src/org/eclipse/emf/edit/ui/action/CutAction.java, emf.edit.ui, org.eclipse.111, 20031020_1612WL
 * @version 1.3 10/20/03
 */
package org.eclipse.emf.edit.ui.action;


import org.eclipse.emf.common.command.Command;

import org.eclipse.emf.edit.command.CutToClipboardCommand;

import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.edit.domain.IEditingDomainProvider;

import org.eclipse.emf.edit.ui.EMFEditUIPlugin;

import java.util.Collection;

import org.eclipse.ui.IEditorPart;


/**
 * A cut action is implemented by creating a {@link CutToClipboardCommand}.
 */
public class CutAction extends CommandActionHandler
{
  public CutAction(EditingDomain domain)
  {
    super(domain, EMFEditUIPlugin.INSTANCE.getString("_UI_Cut_menu_item"));
  }

  public CutAction()
  {
    super(null, EMFEditUIPlugin.INSTANCE.getString("_UI_Cut_menu_item"));
  }

  public Command createCommand(Collection selection)
  {
    return CutToClipboardCommand.create(domain, selection);
  }

  public void setActiveEditor(IEditorPart editorPart)
  {
    if (editorPart instanceof IEditingDomainProvider)
    {
      domain = ((IEditingDomainProvider)editorPart).getEditingDomain();
    }
  }
}
