/**
 * <copyright> 
 *
 * Copyright (c) 2002 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 * 
 * Contributors: 
 *   IBM - Initial API and implementation
 *
 * </copyright>
 *
 * plugins/org.eclipse.emf.edit.ui/src/org/eclipse/emf/edit/ui/action/PasteAction.java, emf.edit.ui, org.eclipse.111, 20031020_1612WL
 * @version 1.3 10/20/03
 */
package org.eclipse.emf.edit.ui.action;


import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.command.UnexecutableCommand;

import org.eclipse.emf.edit.command.PasteFromClipboardCommand;

import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.edit.domain.IEditingDomainProvider;

import org.eclipse.emf.edit.ui.EMFEditUIPlugin;

import java.util.Collection;

import org.eclipse.ui.IEditorPart;


/**
 * A paste action is implemented by creating a {@link PasteFromClipboardCommand}.
 */
public class PasteAction extends CommandActionHandler
{
  public PasteAction(EditingDomain domain)
  {
    super(domain, EMFEditUIPlugin.INSTANCE.getString("_UI_Paste_menu_item"));
  }

  public PasteAction()
  {
    super(null, EMFEditUIPlugin.INSTANCE.getString("_UI_Paste_menu_item"));
  }

  public Command createCommand(Collection selection)
  {
    if (selection.size() == 1)
    {
      return PasteFromClipboardCommand.create(domain, selection.iterator().next(), null);
    }
    else
    {
      return UnexecutableCommand.INSTANCE;
    }
  }

  public void setActiveEditor(IEditorPart editorPart)
  {
    if (editorPart instanceof IEditingDomainProvider)
    {
      domain = ((IEditingDomainProvider)editorPart).getEditingDomain();
    }
  }
}
