/**
 * <copyright>
 *
 * Copyright (c) 2002 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 *
 * Contributors:
 *   IBM - Initial API and implementation
 *
 * </copyright>
 *
 * plugins/org.eclipse.emf.mapping/src/org/eclipse/emf/mapping/command/TypeMatchMappingCommand.java, emf.mapping, org.eclipse.111, 20031120_1149WL
 * @version 1.1 11/20/03
 */
package org.eclipse.emf.mapping.command;


import java.util.Collection;

import org.eclipse.emf.common.command.Command;

import org.eclipse.emf.edit.command.CommandParameter;

import org.eclipse.emf.mapping.Mapping;

import org.eclipse.emf.mapping.domain.MappingDomain;


public class TypeMatchMappingCommand extends MatchMappingCommand
{
  /**
   * This creates a command that creates a new child mappings for the given mapping 
   * by attempting to match by type input children with output children.
   */
  public static Command create(MappingDomain domain, Mapping mapping)
  {
    return domain.createCommand(TypeMatchMappingCommand.class, new CommandParameter(mapping));
  }

  public TypeMatchMappingCommand(MappingDomain domain, Mapping mapping)
  {
    super(domain, mapping);
  }

  protected boolean match(Object inputObject, Object outputObject, Collection mappedObjects)
  {
    if (mappedInputs.contains(inputObject) || !domain.getMappingRoot().getMappings(inputObject).isEmpty())
    {
      return false; // Type matching never matches inputs that are already mapped
    }

    Object inputType = domain.getTypeClassifier(inputObject);
    if (inputType != null)
    {
      Object outputType = domain.getTypeClassifier(outputObject);
      Object convertedInputType = domain.getOutputTypeClassifier(inputType);

      if (outputType != null && outputType == convertedInputType)
      {
        mappedObjects.add(inputObject);
        return true;
      }
    }

    return false;
  }

}
