/**
 * <copyright> 
 *
 * Copyright (c) 2002 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 * 
 * Contributors: 
 *   IBM - Initial API and implementation
 *
 * </copyright>
 *
 * plugins/org.eclipse.emf.edit/src/org/eclipse/emf/edit/provider/ComposeableAdapterFactory.java, emf.edit, org.eclipse.111, 20031120_1149WL
 * @version 1.4 11/20/03
 */
package org.eclipse.emf.edit.provider;


import org.eclipse.emf.common.notify.AdapterFactory;


/**
 * This provides support that allows a factory to be composed into a {@link ComposedAdapterFactory} 
 * that serves the union of the model objects from different packages.
 */
public interface ComposeableAdapterFactory extends AdapterFactory
{
  /**
   * This convenience method returns the first adapter factory that doesn't have a parent, i.e., the root.
   */
  public ComposeableAdapterFactory getRootAdapterFactory();

  /**
   * This sets the direct parent adapter factory into which this factory is composed.
   */
  public void setParentAdapterFactory(ComposedAdapterFactory parentAdapterFactory);
}
