/**
 * <copyright> 
 *
 * Copyright (c) 2002 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 * 
 * Contributors: 
 *   IBM - Initial API and implementation
 *
 * </copyright>
 *
 * plugins/org.eclipse.emf.edit/src/org/eclipse/emf/edit/provider/IItemPropertySource.java, emf.edit, org.eclipse.111, 20031120_1149WL
 * @version 1.4 11/20/03
 */
package org.eclipse.emf.edit.provider;


import java.util.List;


/**
 * This is the interface is needed to populate property sheet items; 
 * it is the same as IPropertySource 
 * except that the object is passed as the first parameter for each method.
 */
public interface IItemPropertySource
{
  /**
   * This does the same thing as 
   * IPropertySource.getPropertyDescriptors.
   */
  List getPropertyDescriptors(Object object);

  /**
   * This returns the property descriptor with the given ID.
   */
  IItemPropertyDescriptor getPropertyDescriptor(Object object, Object propertyID);

  /**
   * This returns the value to be edited.
   */
  Object getEditableValue(Object object);
}
