/**
 * <copyright> 
 *
 * Copyright (c) 2002 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 * 
 * Contributors: 
 *   IBM - Initial API and implementation
 *
 * </copyright>
 *
 * plugins/org.eclipse.emf.codegen.ecore/src/org/eclipse/emf/codegen/ecore/genmodel/GenBase.java, emf.codegen.ecore, org.eclipse.111, 20031120_1149WL
 * @version 1.19 11/20/03
 */
package org.eclipse.emf.codegen.ecore.genmodel;


import org.eclipse.core.runtime.IProgressMonitor;

import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;


/**
 * <!-- begin-user-doc -->
 * A representation of the model object '<em><b>Gen Base</b></em>'.
 * <!-- end-user-doc -->
 *
 * <p>
 * </p>
 *
 * @see org.eclipse.emf.codegen.ecore.genmodel.GenModelPackage#getGenBase()
 * @model abstract="true"
 * @generated
 */
public interface GenBase extends EObject {
  GenModel getGenModel();

  String capName(String name);
  String uncapName(String name);
  String uncapPrefixedName(String in);
  String safeName(String name);
  String format(String name, char separator, String prefix, boolean includePrefix);

  boolean canGenerate();
  void generate(IProgressMonitor progressMonitor);

  GenModelPackage ePackageGenModel();

  //
  // EMFEdit generation
  //
  boolean canGenerateEdit();
  void generateEdit(IProgressMonitor progressMonitor);

  boolean canGenerateEditor();
  void generateEditor(IProgressMonitor progressMonitor);

  boolean reconcile();
}
