/**
 * <copyright> 
 *
 * Copyright (c) 2002 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 * 
 * Contributors: 
 *   IBM - Initial API and implementation
 *
 * </copyright>
 *
 * plugins/org.eclipse.emf.edit.ui/src/org/eclipse/emf/edit/ui/action/CreateSiblingAction.java, emf.edit.ui, org.eclipse.111, 20031120_1149WL
 * @version 1.2 11/20/03
 */
package org.eclipse.emf.edit.ui.action;


import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.command.UnexecutableCommand;

import org.eclipse.emf.edit.command.CreateChildCommand;

import org.eclipse.emf.edit.domain.EditingDomain;

import java.util.Collection;

import org.eclipse.jface.viewers.ISelection;

import org.eclipse.ui.IEditorPart;


/**
 * A sibling creation action is implemented by creating a {@link
 * CreateChildCommand}.
 */
public class CreateSiblingAction extends StaticSelectionCommandAction
{
  /**
   * This describes the sibling to be created.
   */
  protected Object descriptor;

  /**
   * This constructs an instance of an action that creates a sibling
   * specified by <code>descriptor</code>.
   */
  public CreateSiblingAction(IEditorPart editorPart, ISelection selection, 
                             Object descriptor)
  {
    super(editorPart);
    this.descriptor = descriptor;
    configureAction(selection);
  }

  /**
   * This creates the command for {@link
   * StaticSelectionCommandAction#createActionCommand}.
   */
  protected Command createActionCommand(EditingDomain editingDomain,
                                        Collection collection)
  {
    if (collection.size() == 1)
    {
      return CreateChildCommand.create(editingDomain, null,
                                       descriptor, collection);
    }
    return UnexecutableCommand.INSTANCE;
  }
}
