/**
 * <copyright> 
 *
 * Copyright (c) 2002 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 * 
 * Contributors: 
 *   IBM - Initial API and implementation
 *
 * </copyright>
 *
 * plugins/org.eclipse.emf.edit.ui/src/org/eclipse/emf/edit/ui/action/DeleteAction.java, emf.edit.ui, org.eclipse.111, 20031120_1149WL
 * @version 1.3 11/20/03
 */
package org.eclipse.emf.edit.ui.action;


import org.eclipse.emf.common.command.Command;

import org.eclipse.emf.edit.command.RemoveCommand;

import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.edit.domain.IEditingDomainProvider;

import org.eclipse.emf.edit.ui.EMFEditUIPlugin;

import java.util.Collection;

import org.eclipse.ui.IEditorPart;


/**
 * A delete action is implemented by creating a {@link RemoveCommand}.
 */
public class DeleteAction extends CommandActionHandler
{
  public DeleteAction(EditingDomain domain)
  {
    super(domain, EMFEditUIPlugin.INSTANCE.getString("_UI_Delete_menu_item"));
  }

  public DeleteAction()
  {
    super(null, EMFEditUIPlugin.INSTANCE.getString("_UI_Delete_menu_item"));
  }

  public Command createCommand(Collection selection)
  {
    return RemoveCommand.create(domain, selection);
  }

  public void setActiveEditor(IEditorPart editorPart)
  {
    if (editorPart instanceof IEditingDomainProvider)
    {
      domain = ((IEditingDomainProvider)editorPart).getEditingDomain();
    }
  }
}
