/**
 * <copyright>
 *
 * Copyright (c) 2002 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 * 
 * Contributors: 
 *   IBM - Initial API and implementation
 *
 * </copyright>
 *
 * plugins/org.eclipse.emf.ecore.xmi/src/org/eclipse/emf/ecore/xmi/UnresolvedReferenceException.java, emf.ecore.xmi, org.eclipse.111, 20031120_1149WL
 * @version 1.5 11/20/03
 */
package org.eclipse.emf.ecore.xmi;

public class UnresolvedReferenceException extends XMIException {
    protected String reference;

	/**
	 * Constructor for UnresolvedReferenceException.
	 * @param reference
	 * @param location
	 * @param line
	 * @param column
	 */
	public UnresolvedReferenceException(
		String reference,
		String location,
		int line,
		int column) {
		super("Unresolved reference '" + reference + "'.", location, line, column);
		this.reference = reference;
	}
	
	public String getReference() {
		return reference;
	}	
}
