/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.common.ui.celleditor;

import org.eclipse.swt.custom.TableTree;
import org.eclipse.swt.custom.TableTreeEditor;
import org.eclipse.swt.custom.TableTreeItem;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;

public abstract class ExtendedTableTreeEditor
extends TableTreeEditor
implements KeyListener,
MouseListener,
SelectionListener {
    protected Table table;
    protected TableItem selectedTableItem;
    protected TableTree tableTree;
    protected TableTreeItem editTableTreeItem;
    protected int editTableTreeItemColumn;
    boolean isActivating;
    boolean isDeactivating;
    boolean isActive;

    public ExtendedTableTreeEditor(TableTree tableTree) {
        super(tableTree);
        this.tableTree = tableTree;
        this.table = tableTree.getTable();
        this.table.addKeyListener((KeyListener)this);
        this.table.addMouseListener((MouseListener)this);
        this.table.addSelectionListener((SelectionListener)this);
    }

    public void mouseDoubleClick(MouseEvent event) {
        this.editTableTreeItem = null;
    }

    public void mouseDown(MouseEvent event) {
        this.editTableTreeItem = null;
        this.editTableTreeItemColumn = -1;
        if (event.button == 1) {
            boolean wasActive = this.getEditor() != null && !this.getEditor().isDisposed();
            Point point = new Point(event.x, event.y);
            TableItem[] tableItems = this.tableTree.getTable().getItems();
            int columnCount = this.tableTree.getTable().getColumnCount();
            int i = this.tableTree.getTable().getTopIndex();
            block0: while (i < tableItems.length) {
                int j = 0;
                while (j < columnCount) {
                    Rectangle bounds = tableItems[i].getBounds(j);
                    if (bounds.y > event.y) break block0;
                    if (bounds.contains(event.x, event.y)) {
                        if (j == 0 && tableItems[i].getImageBounds(0).contains(event.x, event.y)) break block0;
                        TableItem tableItem = tableItems[i];
                        if (tableItem == this.selectedTableItem || wasActive) {
                            if (tableItem != this.selectedTableItem) {
                                this.table.setSelection(i);
                                Event selectionEvent = new Event();
                                selectionEvent.widget = this.table;
                                selectionEvent.item = tableItem;
                                this.table.notifyListeners(13, selectionEvent);
                                this.selectedTableItem = tableItem;
                            }
                            this.editTableTreeItem = (TableTreeItem)tableItems[i].getData();
                            this.editTableTreeItemColumn = j;
                            break block0;
                        }
                        TableItem mouseBasedTableItem = this.table.getItem(point);
                        if (mouseBasedTableItem != null) break block0;
                        this.table.setSelection(i);
                        Event selectionEvent = new Event();
                        selectionEvent.widget = this.table;
                        selectionEvent.item = tableItem;
                        this.table.notifyListeners(13, selectionEvent);
                        this.selectedTableItem = tableItem;
                        break block0;
                    }
                    ++j;
                }
                ++i;
            }
            if (this.editTableTreeItem == null && wasActive) {
                this.dismiss();
            }
        }
    }

    public void dismiss() {
        this.setEditor(null, null, -1);
    }

    public void mouseUp(MouseEvent event) {
        if (event.button == 1) {
            Point point = new Point(event.x, event.y);
            TableItem[] tableItems = this.tableTree.getTable().getItems();
            int columnCount = this.tableTree.getTable().getColumnCount();
            int i = this.tableTree.getTable().getTopIndex();
            block0: while (i < tableItems.length) {
                int j = 0;
                while (j < columnCount) {
                    Rectangle bounds = tableItems[i].getBounds(j);
                    if (bounds.y > event.y) break block0;
                    if (bounds.contains(event.x, event.y)) {
                        if (j == 0 && tableItems[i].getImageBounds(0).contains(event.x, event.y)) break block0;
                        TableItem tableItem = tableItems[i];
                        TableTreeItem tableTreeItem = (TableTreeItem)tableItems[i].getData();
                        if (tableTreeItem != this.editTableTreeItem) break block0;
                        this.selectedTableItem = null;
                        this.table.showSelection();
                        this.editItem(tableItem, this.editTableTreeItem, this.editTableTreeItemColumn);
                        break block0;
                    }
                    ++j;
                }
                ++i;
            }
        }
    }

    public void widgetDefaultSelected(SelectionEvent event) {
        this.widgetSelected(event);
    }

    public void widgetSelected(SelectionEvent event) {
        TableItem[] selection = this.table.getSelection();
        this.selectedTableItem = selection.length == 1 ? selection[0] : null;
    }

    public void keyPressed(KeyEvent event) {
    }

    public void keyReleased(KeyEvent event) {
        TableItem[] selection = this.table.getSelection();
        TableItem tableItem = this.selectedTableItem = selection.length == 1 ? selection[0] : null;
        if (event.character == ' ' && this.selectedTableItem != null) {
            this.editItem(this.selectedTableItem, (TableTreeItem)this.selectedTableItem.getData(), 0);
            this.selectedTableItem = null;
        }
    }

    protected abstract void editItem(TableItem var1, TableTreeItem var2, int var3);

    public void setEditor(Control canvas, TableTreeItem tableTreeItem, int column) {
        super.setEditor(canvas, tableTreeItem, column);
    }
}

