/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.edit.command;

import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EFactory;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.edit.EMFEditPlugin;
import org.eclipse.emf.edit.command.AbstractOverrideableCommand;
import org.eclipse.emf.edit.command.ChildrenToCopyProvider;
import org.eclipse.emf.edit.command.CommandParameter;
import org.eclipse.emf.edit.command.CopyCommand;
import org.eclipse.emf.edit.domain.EditingDomain;

public class CreateCopyCommand
extends AbstractOverrideableCommand
implements ChildrenToCopyProvider {
    protected static final String LABEL = EMFEditPlugin.INSTANCE.getString("_UI_CreateCopyCommand_label");
    protected static final String DESCRIPTION = EMFEditPlugin.INSTANCE.getString("_UI_CreateCopyCommand_description");
    protected EObject owner;
    protected EObject copy;
    protected CopyCommand.Helper copyHelper;
    static /* synthetic */ Class class$org$eclipse$emf$edit$command$CreateCopyCommand;

    public static Command create(EditingDomain domain, Object owner, CopyCommand.Helper copyHelper) {
        return domain.createCommand(class$org$eclipse$emf$edit$command$CreateCopyCommand == null ? (class$org$eclipse$emf$edit$command$CreateCopyCommand = CreateCopyCommand.class$("org.eclipse.emf.edit.command.CreateCopyCommand")) : class$org$eclipse$emf$edit$command$CreateCopyCommand, new CommandParameter(owner, null, copyHelper));
    }

    public CreateCopyCommand(EditingDomain domain, EObject owner, CopyCommand.Helper copyHelper) {
        super(domain, LABEL, DESCRIPTION);
        this.owner = owner;
        this.copyHelper = copyHelper;
    }

    public EObject getOwner() {
        return this.owner;
    }

    public CopyCommand.Helper getCopyHelper() {
        return this.copyHelper;
    }

    protected boolean prepare() {
        return true;
    }

    public void doExecute() {
        EClass metaObject = this.owner.eClass();
        EPackage ePackage = metaObject.getEPackage();
        EFactory eFactory = ePackage.getEFactoryInstance();
        this.copy = eFactory.create(metaObject);
        this.copyHelper.put(this.owner, this.copy);
    }

    public void doUndo() {
        this.copyHelper.remove(this.owner);
    }

    public void doRedo() {
        this.copyHelper.put(this.owner, this.copy);
    }

    public Collection doGetResult() {
        return Collections.singleton(this.copy);
    }

    public Collection doGetChildrenToCopy() {
        HashSet result = new HashSet();
        Iterator i = this.owner.eContents().iterator();
        while (i.hasNext()) {
            result.add(i.next());
        }
        return result;
    }

    public String toString() {
        StringBuffer result = new StringBuffer(super.toString());
        result.append(" (owner: " + this.owner + ")");
        result.append(" (copyHelper: " + this.copyHelper + ")");
        return result.toString();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

