/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.edit.command;

import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EEnumLiteral;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.edit.EMFEditPlugin;
import org.eclipse.emf.edit.command.AbstractOverrideableCommand;
import org.eclipse.emf.edit.command.CommandParameter;
import org.eclipse.emf.edit.command.CopyCommand;
import org.eclipse.emf.edit.domain.EditingDomain;

public class InitializeCopyCommand
extends AbstractOverrideableCommand {
    protected static final String LABEL = EMFEditPlugin.INSTANCE.getString("_UI_InitializeCopyCommand_label");
    protected static final String DESCRIPTION = EMFEditPlugin.INSTANCE.getString("_UI_InitializeCopyCommand_description");
    protected EObject owner;
    protected EObject copy;
    protected CopyCommand.Helper copyHelper;
    static /* synthetic */ Class class$org$eclipse$emf$edit$command$InitializeCopyCommand;

    public static Command create(EditingDomain domain, Object owner, CopyCommand.Helper copyHelper) {
        return domain.createCommand(class$org$eclipse$emf$edit$command$InitializeCopyCommand == null ? (class$org$eclipse$emf$edit$command$InitializeCopyCommand = InitializeCopyCommand.class$("org.eclipse.emf.edit.command.InitializeCopyCommand")) : class$org$eclipse$emf$edit$command$InitializeCopyCommand, new CommandParameter(owner, null, copyHelper));
    }

    public InitializeCopyCommand(EditingDomain domain, EObject owner, CopyCommand.Helper copyHelper) {
        super(domain, LABEL, DESCRIPTION);
        this.owner = owner;
        this.copy = copyHelper.getCopy(owner);
        this.copyHelper = copyHelper;
    }

    public EObject getOwner() {
        return this.owner;
    }

    public EObject getCopy() {
        return this.copy;
    }

    public CopyCommand.Helper getCopyHelper() {
        return this.copyHelper;
    }

    protected boolean prepare() {
        return this.owner.eClass().isInstance((Object)this.copy);
    }

    public void doExecute() {
        this.copyAttributes();
        this.copyReferences();
    }

    protected Collection getAttributesToCopy() {
        return this.owner.eClass().getEAllAttributes();
    }

    protected void copyAttributes() {
        Iterator attributes = this.getAttributesToCopy().iterator();
        while (attributes.hasNext()) {
            EAttribute attribute = (EAttribute)attributes.next();
            if (!attribute.isChangeable() || !attribute.isMany() && !this.owner.eIsSet((EStructuralFeature)attribute)) continue;
            Object value = this.owner.eGet((EStructuralFeature)attribute);
            if (value == null) {
                this.copy.eSet((EStructuralFeature)attribute, value);
                continue;
            }
            if (!attribute.isMany()) {
                this.copy.eSet((EStructuralFeature)attribute, !(value instanceof EObject) || value instanceof EEnumLiteral ? value : this.copyHelper.getCopy((EObject)value));
                continue;
            }
            if (attribute.getEType() == null) {
                this.copy.eSet((EStructuralFeature)attribute, value);
                continue;
            }
            List list = (List)this.copy.eGet((EStructuralFeature)attribute);
            Iterator values = ((List)value).iterator();
            while (values.hasNext()) {
                list.add(this.copyHelper.getCopy((EObject)values.next()));
            }
        }
    }

    protected Collection getReferencesToCopy() {
        return this.owner.eClass().getEAllReferences();
    }

    protected void copyReferences() {
        Iterator references = this.getReferencesToCopy().iterator();
        block0: while (references.hasNext()) {
            boolean copiedTargetRequired;
            EReference reference = (EReference)references.next();
            if (!reference.isChangeable()) continue;
            EReference reverseReference = reference.getEOpposite();
            Object value = this.owner.eGet((EStructuralFeature)reference);
            if (value == null) continue;
            boolean bl = copiedTargetRequired = reverseReference != null || reference.isContainment();
            if (reference.isMany()) {
                List valueList = (List)value;
                if (valueList.isEmpty()) continue;
                List copyList = (List)this.copy.eGet((EStructuralFeature)reference);
                Iterator valueIter = valueList.iterator();
                while (valueIter.hasNext()) {
                    EObject target = this.copyHelper.getCopyTarget((EObject)valueIter.next(), copiedTargetRequired);
                    if (target == null) continue block0;
                    copyList.add(target);
                }
                continue;
            }
            EObject target = this.copyHelper.getCopyTarget((EObject)value, copiedTargetRequired);
            if (target == null) continue;
            this.copy.eSet((EStructuralFeature)reference, (Object)target);
        }
    }

    public void doUndo() {
    }

    public void doRedo() {
    }

    public Collection doGetResult() {
        return Collections.singleton(this.copy);
    }

    public Collection doGetAffectedObjects() {
        return Collections.singleton(this.copy);
    }

    public String toString() {
        StringBuffer result = new StringBuffer(super.toString() + ")");
        result.append(" (domain: " + this.domain + ")");
        result.append(" (owner: " + this.owner + ")");
        result.append(" (copy: " + this.copy + ")");
        result.append(" (copyHelper: " + this.copyHelper + ")");
        return result.toString();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

