/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.codegen.jmerge;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.apache.xerces.impl.xpath.regex.RegularExpression;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xml.sax.InputSource;

public class JControlModel {
    protected List dictionaryPatterns;
    protected List pullRules;
    protected List sweepRules;
    protected List sortRules;
    protected String indent;
    protected String redirect;
    protected boolean standardBraceStyle;

    public JControlModel(String uri) {
        this.initialize(uri);
    }

    public JControlModel(Element element) {
        this.initialize(element);
    }

    public boolean convertToStandardBraceStyle() {
        return this.standardBraceStyle;
    }

    public void setConvertToStandardBraceStyle(boolean standardBraceStyle) {
        this.standardBraceStyle = standardBraceStyle;
    }

    public String getLeadingTabReplacement() {
        return this.indent;
    }

    public void setLeadingTabReplacement(String indent) {
        this.indent = indent;
    }

    public String getRedirect() {
        return this.redirect;
    }

    public List getDictionaryPatterns() {
        if (this.dictionaryPatterns == null) {
            this.dictionaryPatterns = new ArrayList();
        }
        return this.dictionaryPatterns;
    }

    public List getPullRules() {
        if (this.pullRules == null) {
            this.pullRules = new ArrayList();
        }
        return this.pullRules;
    }

    public List getSweepRules() {
        if (this.sweepRules == null) {
            this.sweepRules = new ArrayList();
        }
        return this.sweepRules;
    }

    public List getSortRules() {
        if (this.sortRules == null) {
            this.sortRules = new ArrayList();
        }
        return this.sortRules;
    }

    protected void initialize(String uri) {
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        documentBuilderFactory.setNamespaceAware(true);
        documentBuilderFactory.setValidating(false);
        try {
            DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
            Document document = documentBuilder.parse(new InputSource(uri));
            this.initialize(document.getDocumentElement());
        }
        catch (Exception exception) {
            exception.printStackTrace(System.err);
        }
    }

    protected void initialize(Element element) {
        if (element.getLocalName().equals("options")) {
            if ("standard".equals(element.getAttributeNS(null, "braceStyle"))) {
                this.standardBraceStyle = true;
            }
            if (element.hasAttributeNS(null, "indent")) {
                this.indent = element.getAttributeNS(null, "indent");
            }
            if (element.hasAttributeNS(null, "redirect")) {
                this.redirect = element.getAttributeNS(null, "redirect");
            }
            Node child = element.getFirstChild();
            while (child != null) {
                if (child.getNodeType() == 1) {
                    Element elementChild = (Element)child;
                    if (elementChild.getLocalName().equals("dictionaryPattern")) {
                        this.getDictionaryPatterns().add(new DictionaryPattern(elementChild));
                    } else if (elementChild.getLocalName().equals("pull")) {
                        this.getPullRules().add(new PullRule(elementChild));
                    } else if (elementChild.getLocalName().equals("sweep")) {
                        this.getSweepRules().add(new SweepRule(elementChild));
                    } else if (elementChild.getLocalName().equals("sort")) {
                        this.getSortRules().add(new SortRule(elementChild));
                    }
                }
                child = child.getNextSibling();
            }
        }
    }

    public static Class classForClassName(String className) {
        className = "org.eclipse.jdt.core.jdom.IDOM" + className;
        try {
            Class<?> result = Class.forName(className);
            return result;
        }
        catch (ClassNotFoundException classNotFoundException) {
            return null;
        }
    }

    public static class SortRule {
        protected String name;
        protected Class selector;
        protected RegularExpression markup;

        public SortRule() {
        }

        public SortRule(Element element) {
            this.initialize(element);
        }

        public void initialize(Element element) {
            if (element.hasAttribute("select")) {
                this.selector = JControlModel.classForClassName(element.getAttribute("select"));
            }
            if (element.hasAttribute("markup")) {
                this.markup = new RegularExpression(element.getAttribute("markup"), "ms");
            }
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public Class getSelector() {
            return this.selector;
        }

        public void setSelector(Class selector) {
            this.selector = selector;
        }

        public RegularExpression getMarkup() {
            return this.markup;
        }

        public void setMarkup(RegularExpression markup) {
            this.markup = markup;
        }
    }

    public static class SweepRule {
        protected String name;
        protected Class selector;
        protected RegularExpression markup;

        public SweepRule() {
        }

        public SweepRule(Element element) {
            this.initialize(element);
        }

        public void initialize(Element element) {
            if (element.hasAttribute("select")) {
                this.selector = JControlModel.classForClassName(element.getAttribute("select"));
            }
            if (element.hasAttribute("markup")) {
                this.markup = new RegularExpression(element.getAttribute("markup"), "ms");
            }
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public Class getSelector() {
            return this.selector;
        }

        public void setSelector(Class selector) {
            this.selector = selector;
        }

        public RegularExpression getMarkup() {
            return this.markup;
        }

        public void setMarkup(RegularExpression markup) {
            this.markup = markup;
        }
    }

    public static class PullRule {
        protected static Class[] noParameterTypes = new Class[0];
        protected String name;
        protected RegularExpression sourceMarkup;
        protected Feature sourceGetFeature;
        protected RegularExpression sourceTransfer;
        protected RegularExpression targetMarkup;
        protected Feature targetPutFeature;
        protected RegularExpression targetTransfer;

        public PullRule() {
        }

        public PullRule(Element element) {
            this.initialize(element);
        }

        public void initialize(Element element) {
            this.sourceGetFeature = new Feature(element.getAttribute("sourceGet"), noParameterTypes);
            if (this.sourceGetFeature != null) {
                Class<?> sourceReturnType = this.sourceGetFeature.getFeatureMethod().getReturnType();
                this.targetPutFeature = new Feature(element.getAttribute("targetPut"), new Class[]{sourceReturnType});
                if (this.targetPutFeature.getFeatureMethod() == null && sourceReturnType.isArray()) {
                    this.targetPutFeature = new Feature(element.getAttribute("targetPut"), new Class[]{sourceReturnType.getComponentType()});
                }
            }
            if (element.hasAttribute("sourceMarkup")) {
                this.sourceMarkup = new RegularExpression(element.getAttribute("sourceMarkup"), "ms");
            }
            if (element.hasAttribute("targetMarkup")) {
                this.targetMarkup = new RegularExpression(element.getAttribute("targetMarkup"), "ms");
            }
            if (element.hasAttribute("sourceTransfer")) {
                this.sourceTransfer = new RegularExpression(element.getAttribute("sourceTransfer"), "ms");
            }
            if (element.hasAttribute("targetTransfer")) {
                this.targetTransfer = new RegularExpression(element.getAttribute("targetTransfer"), "ms");
            }
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public Feature getSourceGetFeature() {
            return this.sourceGetFeature;
        }

        public void setSourceGetFeature(Feature sourceGetFeature) {
            this.sourceGetFeature = sourceGetFeature;
        }

        public Feature getTargetPutFeature() {
            return this.targetPutFeature;
        }

        public void setTargetPutFeature(Feature targetPutFeature) {
            this.targetPutFeature = targetPutFeature;
        }

        public RegularExpression getSourceTransfer() {
            return this.sourceTransfer;
        }

        public void setSourceTransfer(RegularExpression sourceTransfer) {
            this.sourceTransfer = sourceTransfer;
        }

        public RegularExpression getTargetTransfer() {
            return this.targetTransfer;
        }

        public void setTargetTransfer(RegularExpression targetTransfer) {
            this.targetTransfer = targetTransfer;
        }

        public RegularExpression getSourceMarkup() {
            return this.sourceMarkup;
        }

        public void setSourceMarkup(RegularExpression sourceMarkup) {
            this.sourceMarkup = sourceMarkup;
        }

        public RegularExpression getTargetMarkup() {
            return this.targetMarkup;
        }

        public void setTargetMarkup(RegularExpression targetMarkup) {
            this.targetMarkup = targetMarkup;
        }
    }

    public static class DictionaryPattern {
        protected static Class[] noParameterTypes = new Class[0];
        protected static Class[] stringParameterType = new Class[]{class$java$lang$String == null ? (class$java$lang$String = DictionaryPattern.class$("java.lang.String")) : class$java$lang$String};
        protected String name;
        protected Feature selectorFeature;
        protected RegularExpression regularExpression;
        static /* synthetic */ Class class$java$lang$String;

        public DictionaryPattern() {
        }

        public DictionaryPattern(Element element) {
            this.initialize(element);
        }

        public void initialize(Element element) {
            this.name = element.getAttribute("name");
            this.selectorFeature = new Feature(element.getAttribute("select"), noParameterTypes);
            this.regularExpression = new RegularExpression(element.getAttribute("match"), "ms");
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public Feature getSelectorFeature() {
            return this.selectorFeature;
        }

        public void setSelectorFeature(Feature selectorFeature) {
            this.selectorFeature = selectorFeature;
        }

        public RegularExpression getRegularExpression() {
            return this.regularExpression;
        }

        public void setRegularExpression(RegularExpression regularExpression) {
            this.regularExpression = regularExpression;
        }

        static /* synthetic */ Class class$(String x0) {
            try {
                return Class.forName(x0);
            }
            catch (ClassNotFoundException x1) {
                throw new NoClassDefFoundError(x1.getMessage());
            }
        }
    }

    public static class Feature {
        protected Class featureClass;
        protected Method featureMethod;

        public Feature(String path, Class[] parameterTypes) {
            int index = path.indexOf(47);
            String className = "org.eclipse.jdt.core.jdom.IDOM" + path.substring(0, index);
            String methodName = path.substring(index + 1);
            try {
                this.featureClass = Class.forName(className);
                this.featureMethod = this.featureClass.getMethod(methodName, parameterTypes);
            }
            catch (NoSuchMethodException exception) {
            }
            catch (ClassNotFoundException exception) {
                // empty catch block
            }
        }

        public Class getFeatureClass() {
            return this.featureClass;
        }

        public Method getFeatureMethod() {
            return this.featureMethod;
        }
    }
}

