/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.common.notify.impl;

import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.NotificationChain;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.notify.NotifyingList;
import org.eclipse.emf.common.notify.impl.NotificationChainImpl;
import org.eclipse.emf.common.notify.impl.NotificationImpl;
import org.eclipse.emf.common.util.BasicEList;

public class NotifyingListImpl
extends BasicEList
implements NotifyingList {
    public NotifyingListImpl() {
    }

    public NotifyingListImpl(int initialCapacity) {
        super(initialCapacity);
    }

    public NotifyingListImpl(Collection collection) {
        super(collection);
    }

    public Object getNotifier() {
        return null;
    }

    public Object getFeature() {
        return null;
    }

    public int getFeatureID() {
        return -1;
    }

    protected int getFeatureID(Class expectedClass) {
        return this.getFeatureID();
    }

    protected boolean hasInverse() {
        return false;
    }

    protected boolean canContainNull() {
        return !this.hasInverse();
    }

    protected boolean isNotificationRequired() {
        return false;
    }

    protected NotificationChain inverseAdd(Object object, NotificationChain notifications) {
        return notifications;
    }

    protected NotificationChain inverseRemove(Object object, NotificationChain notifications) {
        return notifications;
    }

    protected Notification createNotification(int eventType, Object oldObject, Object newObject, int index) {
        return new NotificationImpl(eventType, oldObject, newObject, index){

            public Object getNotifier() {
                return NotifyingListImpl.this.getNotifier();
            }

            public Object getFeature() {
                return NotifyingListImpl.this.getFeature();
            }

            public int getFeatureID(Class expectedClass) {
                return NotifyingListImpl.this.getFeatureID(expectedClass);
            }
        };
    }

    protected NotificationChain createNotificationChain(int initialCapacity) {
        return new NotificationChainImpl(initialCapacity);
    }

    protected void dispatchNotification(Notification notification) {
        ((Notifier)this.getNotifier()).eNotify(notification);
    }

    public void addUnique(Object object) {
        if (this.isNotificationRequired()) {
            int index = this.size;
            super.addUnique(index, object);
            Notification notification = this.createNotification(3, null, object, index);
            if (this.hasInverse()) {
                NotificationChain notifications = this.createNotificationChain(3);
                notifications = this.inverseAdd(object, notifications);
                notifications.add(notification);
                notifications.dispatch();
            } else {
                this.dispatchNotification(notification);
            }
        } else {
            super.addUnique(object);
            if (this.hasInverse()) {
                NotificationChain notifications = null;
                if ((notifications = this.inverseAdd(object, notifications)) != null) {
                    notifications.dispatch();
                }
            }
        }
    }

    public void addUnique(int index, Object object) {
        if (this.isNotificationRequired()) {
            super.addUnique(index, object);
            Notification notification = this.createNotification(3, null, object, index);
            if (this.hasInverse()) {
                NotificationChain notifications = this.createNotificationChain(3);
                notifications = this.inverseAdd(object, notifications);
                notifications.add(notification);
                notifications.dispatch();
            } else {
                this.dispatchNotification(notification);
            }
        } else {
            super.addUnique(index, object);
            if (this.hasInverse()) {
                NotificationChain notifications = null;
                if ((notifications = this.inverseAdd(object, notifications)) != null) {
                    notifications.dispatch();
                }
            }
        }
    }

    public boolean addAllUnique(Collection collection) {
        return this.addAllUnique(this.size, collection);
    }

    public boolean addAllUnique(int index, Collection collection) {
        int collectionSize = collection.size();
        if (collectionSize == 0) {
            return false;
        }
        if (this.isNotificationRequired()) {
            Notification notification;
            super.addAllUnique(index, collection);
            Notification notification2 = notification = collectionSize == 1 ? this.createNotification(3, null, collection.iterator().next(), index) : this.createNotification(5, null, collection, index);
            if (this.hasInverse()) {
                NotificationChain notifications = this.createNotificationChain(collectionSize);
                int lastIndex = index + collectionSize;
                int i = index;
                while (i < lastIndex) {
                    notifications = this.inverseAdd(this.data[i], notifications);
                    ++i;
                }
                notifications.add(notification);
                notifications.dispatch();
            } else {
                this.dispatchNotification(notification);
            }
        } else {
            super.addAllUnique(index, collection);
            if (this.hasInverse()) {
                NotificationChain notifications = null;
                int lastIndex = index + collectionSize;
                int i = index;
                while (i < lastIndex) {
                    notifications = this.inverseAdd(this.data[i], notifications);
                    ++i;
                }
                if (notifications != null) {
                    notifications.dispatch();
                }
            }
        }
        return true;
    }

    public NotificationChain basicAdd(Object object, NotificationChain notifications) {
        if (this.isNotificationRequired()) {
            if (notifications == null) {
                notifications = this.createNotificationChain(4);
            }
            int index = this.size;
            super.addUnique(index, object);
            notifications.add(this.createNotification(3, null, object, index));
        } else {
            super.addUnique(this.size, object);
        }
        return notifications;
    }

    public Object remove(int index) {
        if (this.isNotificationRequired()) {
            Notification notification = this.createNotification(4, super.remove(index), null, index);
            Object oldObject = notification.getOldValue();
            if (this.hasInverse() && oldObject != null) {
                NotificationChain notifications = this.createNotificationChain(2);
                notifications = this.inverseRemove(oldObject, notifications);
                notifications.add(notification);
                notifications.dispatch();
            } else {
                this.dispatchNotification(notification);
            }
            return oldObject;
        }
        Object oldObject = super.remove(index);
        if (this.hasInverse() && oldObject != null) {
            NotificationChain notifications = null;
            if ((notifications = this.inverseRemove(oldObject, notifications)) != null) {
                notifications.dispatch();
            }
        }
        return oldObject;
    }

    public boolean removeAll(Collection collection) {
        int[] positions;
        boolean result;
        block17: {
            block16: {
                result = false;
                positions = null;
                if (!this.isNotificationRequired()) break block16;
                int listSize = collection.size();
                if (listSize <= 0) break block17;
                BasicEList list = new BasicEList(collection);
                Object[] objects = list.data();
                positions = new int[listSize];
                int count = 0;
                int i = 0;
                while (i < this.size) {
                    Object object = this.data[i];
                    int j = listSize;
                    while (--j >= 0) {
                        if (!this.equalObjects(object, objects[j])) continue;
                        if (count != j) {
                            Object x = objects[count];
                            objects[count] = objects[j];
                            objects[j] = x;
                        }
                        positions[count++] = i;
                        break;
                    }
                    ++i;
                }
                if (count <= 0) break block17;
                result = true;
                int i2 = count;
                while (--i2 >= 0) {
                    super.remove(positions[i2]);
                }
                if (count != listSize) {
                    int i3 = listSize;
                    while (--i3 >= count) {
                        list.remove(i3);
                    }
                    int[] oldPositions = positions;
                    positions = new int[count];
                    System.arraycopy(oldPositions, 0, positions, 0, count);
                }
                collection = list;
                break block17;
            }
            collection = this.getDuplicates(collection);
            int i = this.size;
            while (--i >= 0) {
                if (!collection.contains(this.data[i])) continue;
                super.remove(i);
                result = true;
            }
        }
        if (result) {
            if (this.isNotificationRequired()) {
                Notification notification;
                int collectionSize = collection.size();
                Notification notification2 = notification = collectionSize == 1 ? this.createNotification(4, collection.iterator().next(), null, positions[0]) : this.createNotification(6, collection, positions, positions[0]);
                if (this.hasInverse()) {
                    NotificationChain notifications = this.createNotificationChain(collectionSize + 1);
                    Iterator i = collection.iterator();
                    while (i.hasNext()) {
                        notifications = this.inverseRemove(i.next(), notifications);
                    }
                    notifications.add(notification);
                    notifications.dispatch();
                } else {
                    this.dispatchNotification(notification);
                }
            } else if (this.hasInverse()) {
                NotificationChain notifications = null;
                Iterator i = collection.iterator();
                while (i.hasNext()) {
                    notifications = this.inverseRemove(i.next(), notifications);
                }
                if (notifications != null) {
                    notifications.dispatch();
                }
            }
            return true;
        }
        return false;
    }

    public NotificationChain basicRemove(Object object, NotificationChain notifications) {
        int index = this.indexOf(object);
        if (index != -1) {
            Object oldObject = super.remove(index);
            if (this.isNotificationRequired()) {
                if (notifications == null) {
                    notifications = this.createNotificationChain(4);
                }
                notifications.add(this.createNotification(4, oldObject, null, index));
            }
        }
        return notifications;
    }

    public void clear() {
        if (this.isNotificationRequired()) {
            if (this.size > 0) {
                Notification notification;
                BasicEList.UnmodifiableEList collection = new BasicEList.UnmodifiableEList(this.size, this.data);
                int collectionSize = this.size;
                super.clear();
                Notification notification2 = notification = collectionSize == 1 ? this.createNotification(4, collection.get(0), null, -1) : this.createNotification(6, collection, null, -1);
                if (this.hasInverse()) {
                    NotificationChain notifications = this.createNotificationChain(collectionSize + 1);
                    Iterator i = collection.iterator();
                    while (i.hasNext()) {
                        notifications = this.inverseRemove(i.next(), notifications);
                    }
                    notifications.add(notification);
                    notifications.dispatch();
                } else {
                    this.dispatchNotification(notification);
                }
            } else {
                super.clear();
                this.dispatchNotification(this.createNotification(6, Collections.EMPTY_LIST, null, -1));
            }
        } else if (this.hasInverse()) {
            if (this.size > 0) {
                Object[] oldData = this.data;
                int oldSize = this.size;
                super.clear();
                NotificationChain notifications = null;
                int i = 0;
                while (i < oldSize) {
                    notifications = this.inverseRemove(oldData[i], notifications);
                    ++i;
                }
                if (notifications != null) {
                    notifications.dispatch();
                }
            } else {
                super.clear();
            }
        } else {
            super.clear();
        }
    }

    public Object setUnique(int index, Object object) {
        if (this.isNotificationRequired()) {
            Notification notification = this.createNotification(1, super.setUnique(index, object), object, index);
            Object oldObject = notification.getOldValue();
            if (this.hasInverse() && !this.equalObjects(oldObject, object)) {
                NotificationChain notifications = this.createNotificationChain(4);
                if (oldObject != null) {
                    notifications = this.inverseRemove(oldObject, notifications);
                }
                notifications = this.inverseAdd(object, notifications);
                notifications.add(notification);
                notifications.dispatch();
            } else {
                this.dispatchNotification(notification);
            }
            return oldObject;
        }
        Object oldObject = super.setUnique(index, object);
        if (this.hasInverse() && !this.equalObjects(oldObject, object)) {
            NotificationChain notifications = null;
            if (oldObject != null) {
                notifications = this.inverseRemove(oldObject, notifications);
            }
            if ((notifications = this.inverseAdd(object, notifications)) != null) {
                notifications.dispatch();
            }
        }
        return oldObject;
    }

    public NotificationChain basicSet(int index, Object object, NotificationChain notifications) {
        if (this.isNotificationRequired()) {
            if (notifications == null) {
                notifications = this.createNotificationChain(4);
            }
            notifications.add(this.createNotification(1, super.setUnique(index, object), object, index));
        } else {
            super.setUnique(index, object);
        }
        return notifications;
    }

    public Object move(int targetIndex, int sourceIndex) {
        Object object = super.move(targetIndex, sourceIndex);
        if (this.isNotificationRequired()) {
            this.dispatchNotification(this.createNotification(7, new Integer(sourceIndex), object, targetIndex));
        }
        return object;
    }
}

