/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.codegen.ecore.genmodel.presentation;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EventObject;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IResourceDeltaVisitor;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.emf.codegen.ecore.genmodel.GenModel;
import org.eclipse.emf.codegen.ecore.genmodel.presentation.GenModelEditor;
import org.eclipse.emf.codegen.ecore.genmodel.provider.GenModelEditPlugin;
import org.eclipse.emf.codegen.ecore.genmodel.provider.GenModelItemProviderAdapterFactory;
import org.eclipse.emf.common.command.BasicCommandStack;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.command.CommandStack;
import org.eclipse.emf.common.command.CommandStackListener;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.provider.EcoreItemProviderAdapterFactory;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.edit.domain.AdapterFactoryEditingDomain;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.edit.domain.IEditingDomainProvider;
import org.eclipse.emf.edit.provider.AdapterFactoryItemDelegator;
import org.eclipse.emf.edit.provider.ComposedAdapterFactory;
import org.eclipse.emf.edit.provider.resource.ResourceItemProviderAdapterFactory;
import org.eclipse.emf.edit.ui.action.EditingDomainActionBarContributor;
import org.eclipse.emf.edit.ui.celleditor.AdapterFactoryTreeEditor;
import org.eclipse.emf.edit.ui.dnd.EditingDomainViewerDropAdapter;
import org.eclipse.emf.edit.ui.dnd.LocalTransfer;
import org.eclipse.emf.edit.ui.dnd.ViewerDragAdapter;
import org.eclipse.emf.edit.ui.provider.AdapterFactoryContentProvider;
import org.eclipse.emf.edit.ui.provider.AdapterFactoryLabelProvider;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IStatusLineManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.dnd.DragSourceListener;
import org.eclipse.swt.dnd.DropTargetListener;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.events.ControlAdapter;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.IPartListener;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.actions.WorkspaceModifyOperation;
import org.eclipse.ui.dialogs.SaveAsDialog;
import org.eclipse.ui.part.FileEditorInput;
import org.eclipse.ui.part.MultiPageEditorPart;
import org.eclipse.ui.views.properties.IPropertySheetPage;
import org.eclipse.ui.views.properties.IPropertySourceProvider;
import org.eclipse.ui.views.properties.PropertySheet;
import org.eclipse.ui.views.properties.PropertySheetPage;

public class GenModelEditor
extends MultiPageEditorPart
implements IEditingDomainProvider,
ISelectionProvider,
IMenuListener {
    protected AdapterFactoryEditingDomain editingDomain;
    protected ComposedAdapterFactory adapterFactory;
    protected PropertySheetPage propertySheetPage;
    protected Viewer currentViewer;
    protected ISelectionChangedListener selectionChangedListener;
    protected Collection selectionChangedListeners = new ArrayList();
    protected ISelection editorSelection;
    protected IPartListener partListener = new IPartListener(){

        public void partActivated(IWorkbenchPart p) {
            if (p instanceof PropertySheet) {
                if (((PropertySheet)p).getCurrentPage() == GenModelEditor.this.propertySheetPage) {
                    GenModelEditor.this.getActionBarContributor().setActiveEditor((IEditorPart)GenModelEditor.this);
                    GenModelEditor.this.handleActivate();
                }
            } else if (p == GenModelEditor.this) {
                GenModelEditor.this.handleActivate();
            }
        }

        public void partBroughtToTop(IWorkbenchPart p) {
        }

        public void partClosed(IWorkbenchPart p) {
        }

        public void partDeactivated(IWorkbenchPart p) {
        }

        public void partOpened(IWorkbenchPart p) {
        }
    };
    Collection removedResources = new ArrayList();
    Collection changedResources = new ArrayList();
    Collection savedResources = new ArrayList();
    protected IResourceChangeListener resourceChangeListener = new IResourceChangeListener(){

        public void resourceChanged(IResourceChangeEvent event) {
            ResourceSet resourceSet = GenModelEditor.this.editingDomain.getResourceSet();
            IResourceDelta delta = event.getDelta();
            try {
                class ResourceDeltaVisitor
                implements IResourceDeltaVisitor {
                    protected ResourceSet resourceSet;
                    protected Collection changedResources;
                    protected Collection removedResources;
                    private final /* synthetic */ 2 this$1;

                    ResourceDeltaVisitor(2 this$1) {
                        this.this$1 = this$1;
                        this.resourceSet = 2.access$000(this.this$1).editingDomain.getResourceSet();
                        this.changedResources = new ArrayList<E>();
                        this.removedResources = new ArrayList<E>();
                    }

                    public boolean visit(IResourceDelta delta) {
                        Resource resource;
                        if (delta.getResource().getType() == 1 && (delta.getKind() & 6) != 0 && (resource = this.resourceSet.getResource(URI.createURI((String)delta.getFullPath().toString()), false)) != null) {
                            if ((delta.getKind() & 2) != 0) {
                                this.removedResources.add(resource);
                            } else {
                                this.changedResources.add(resource);
                            }
                        }
                        return true;
                    }

                    public Collection getChangedResources() {
                        return this.changedResources;
                    }

                    public Collection getRemovedResources() {
                        return this.removedResources;
                    }
                }
                ResourceDeltaVisitor visitor = new ResourceDeltaVisitor(this);
                delta.accept((IResourceDeltaVisitor)visitor);
                GenModelEditor.this.removedResources.addAll(visitor.getRemovedResources());
                if (!visitor.getRemovedResources().isEmpty() && !GenModelEditor.this.isDirty()) {
                    GenModelEditor.this.getSite().getShell().getDisplay().asyncExec(new Runnable(this){
                        private final /* synthetic */ 2 this$1;
                        {
                            this.this$1 = this$1;
                        }

                        public void run() {
                            2.access$000(this.this$1).getSite().getPage().closeEditor((IEditorPart)2.access$000(this.this$1), false);
                            2.access$000(this.this$1).dispose();
                        }
                    });
                }
                GenModelEditor.this.changedResources.addAll(visitor.getChangedResources());
            }
            catch (CoreException exception) {
                GenModelEditPlugin.INSTANCE.log((Object)exception);
            }
        }

        static /* synthetic */ GenModelEditor access$000(2 x0) {
            return x0.GenModelEditor.this;
        }
    };
    static /* synthetic */ Class class$org$eclipse$ui$views$properties$IPropertySheetPage;

    public void handleActivate() {
        if (!this.removedResources.isEmpty()) {
            if (this.handleDirtyConflict()) {
                this.getSite().getPage().closeEditor((IEditorPart)this, false);
                this.dispose();
            } else {
                this.removedResources.clear();
                this.changedResources.clear();
                this.savedResources.clear();
            }
        } else if (!this.changedResources.isEmpty()) {
            this.changedResources.removeAll(this.savedResources);
            this.handleChangedResources();
            this.changedResources.clear();
            this.savedResources.clear();
        }
    }

    protected void handleChangedResources() {
        if (!this.isDirty() || this.handleDirtyConflict()) {
            Resource mainResource = (Resource)this.editingDomain.getResourceSet().getResources().get(0);
            boolean reload = false;
            Iterator i = this.changedResources.iterator();
            while (i.hasNext()) {
                Resource resource = (Resource)i.next();
                if (resource == mainResource) {
                    reload = true;
                }
                if (!resource.isLoaded()) continue;
                resource.unload();
                try {
                    resource.load(Collections.EMPTY_MAP);
                }
                catch (IOException exception) {
                    GenModelEditPlugin.INSTANCE.log(exception);
                }
            }
            if (reload) {
                GenModel genModel = (GenModel)mainResource.getContents().get(0);
                this.initialize(genModel);
                this.currentViewer.setInput((Object)mainResource);
            }
        }
    }

    protected void initialize(GenModel genModel) {
        genModel.reconcile();
        genModel.setCanGenerate(true);
        this.validate();
        Hashtable options = JavaCore.getOptions();
        String tabSize = (String)options.get("org.eclipse.jdt.core.formatter.tabulation.size");
        String braceStyle = (String)options.get("org.eclipse.jdt.core.formatter.newline.openingBrace");
        String tabCharacter = (String)options.get("org.eclipse.jdt.core.formatter.tabulation.char");
        if ("tab".equals(tabCharacter)) {
            genModel.getJControlModel().setLeadingTabReplacement("\t");
        } else {
            String spaces = "";
            int i = Integer.parseInt(tabSize);
            while (i > 0) {
                spaces = spaces + " ";
                --i;
            }
            genModel.getJControlModel().setLeadingTabReplacement(spaces);
        }
        genModel.getJControlModel().setConvertToStandardBraceStyle("do not insert".equals(braceStyle));
    }

    protected boolean handleDirtyConflict() {
        return MessageDialog.openQuestion((Shell)this.getSite().getShell(), (String)GenModelEditor.getString("_UI_FileConflict_label"), (String)GenModelEditor.getString("_WARN_FileConflict"));
    }

    public GenModelEditor() {
        ArrayList<GenModelItemProviderAdapterFactory> factories = new ArrayList<GenModelItemProviderAdapterFactory>();
        factories.add(new GenModelItemProviderAdapterFactory());
        factories.add((GenModelItemProviderAdapterFactory)new ResourceItemProviderAdapterFactory());
        factories.add((GenModelItemProviderAdapterFactory)new EcoreItemProviderAdapterFactory());
        this.adapterFactory = new ComposedAdapterFactory(factories);
        BasicCommandStack commandStack = new BasicCommandStack();
        commandStack.addCommandStackListener(new CommandStackListener(){

            public void commandStackChanged(EventObject event) {
                GenModelEditor.super.getContainer().getDisplay().asyncExec(new Runnable(this, event){
                    private final /* synthetic */ EventObject val$event;
                    private final /* synthetic */ 4 this$1;
                    {
                        this.this$1 = this$1;
                        this.val$event = val$event;
                    }

                    public void run() {
                        4.access$100(this.this$1).firePropertyChange(257);
                        Command mostRecentCommand = ((CommandStack)this.val$event.getSource()).getMostRecentCommand();
                        if (mostRecentCommand != null) {
                            4.access$100(this.this$1).setSelectionToViewer(mostRecentCommand.getAffectedObjects());
                        }
                    }
                });
            }

            static /* synthetic */ GenModelEditor access$100(4 x0) {
                return x0.GenModelEditor.this;
            }
        });
        this.editingDomain = new AdapterFactoryEditingDomain((AdapterFactory)this.adapterFactory, (CommandStack)commandStack);
    }

    protected void firePropertyChange(int action) {
        super.firePropertyChange(action);
    }

    public void setSelectionToViewer(Collection collection) {
        final Collection theSelection = collection;
        if (theSelection != null && !theSelection.isEmpty()) {
            Runnable runnable = new Runnable(){

                public void run() {
                    if (GenModelEditor.this.currentViewer != null) {
                        GenModelEditor.this.currentViewer.setSelection((ISelection)new StructuredSelection(theSelection.toArray()), true);
                    }
                }
            };
            runnable.run();
        }
    }

    public EditingDomain getEditingDomain() {
        return this.editingDomain;
    }

    public void setCurrentViewer(Viewer viewer) {
        if (this.currentViewer != viewer) {
            if (this.selectionChangedListener == null) {
                this.selectionChangedListener = new ISelectionChangedListener(){

                    public void selectionChanged(SelectionChangedEvent selectionChangedEvent) {
                        GenModelEditor.this.setSelection(selectionChangedEvent.getSelection());
                    }
                };
            }
            if (this.currentViewer != null) {
                this.currentViewer.removeSelectionChangedListener(this.selectionChangedListener);
            }
            if (viewer != null) {
                viewer.addSelectionChangedListener(this.selectionChangedListener);
            }
            this.currentViewer = viewer;
            this.setSelection((ISelection)(this.currentViewer == null ? StructuredSelection.EMPTY : this.currentViewer.getSelection()));
        }
    }

    protected void createContextMenuFor(StructuredViewer viewer) {
        MenuManager contextMenu = new MenuManager("#PopUp");
        contextMenu.add((IContributionItem)new Separator("additions"));
        contextMenu.setRemoveAllWhenShown(true);
        contextMenu.addMenuListener((IMenuListener)this);
        Menu menu = contextMenu.createContextMenu(viewer.getControl());
        viewer.getControl().setMenu(menu);
        this.getSite().registerContextMenu(contextMenu, (ISelectionProvider)viewer);
        int dndOperations = 7;
        Transfer[] transfers = new Transfer[]{LocalTransfer.getInstance()};
        viewer.addDragSupport(dndOperations, transfers, (DragSourceListener)new ViewerDragAdapter((Viewer)viewer));
        viewer.addDropSupport(dndOperations, transfers, (DropTargetListener)new EditingDomainViewerDropAdapter((EditingDomain)this.editingDomain, (Viewer)viewer));
    }

    public void createPages() {
        IFileEditorInput modelFile = (IFileEditorInput)this.getEditorInput();
        try {
            Resource resource = this.editingDomain.loadResource(URI.createPlatformResourceURI((String)modelFile.getFile().getFullPath().toString()).toString());
            GenModel genModel = (GenModel)resource.getContents().get(0);
            this.initialize(genModel);
        }
        catch (Exception exception) {
            GenModelEditPlugin.INSTANCE.log(exception);
        }
        Tree tree = new Tree(this.getContainer(), 2);
        TreeViewer treeViewer = new TreeViewer(tree);
        this.setCurrentViewer((Viewer)treeViewer);
        treeViewer.setContentProvider((IContentProvider)new AdapterFactoryContentProvider((AdapterFactory)this.adapterFactory));
        treeViewer.setLabelProvider((IBaseLabelProvider)new AdapterFactoryLabelProvider((AdapterFactory)this.adapterFactory));
        treeViewer.setInput(this.editingDomain.getResourceSet().getResources().get(0));
        new AdapterFactoryTreeEditor(treeViewer.getTree(), (AdapterFactory)this.adapterFactory);
        this.createContextMenuFor((StructuredViewer)treeViewer);
        int pageIndex = this.addPage((Control)tree);
        this.setActivePage(0);
        this.getContainer().addControlListener((ControlListener)new ControlAdapter(){
            boolean guard = false;

            public void controlResized(ControlEvent event) {
                if (!this.guard) {
                    this.guard = true;
                    GenModelEditor.this.hideTabs();
                    this.guard = false;
                }
            }
        });
    }

    protected void hideTabs() {
        if (this.getPageCount() <= 1) {
            this.setPageText(0, "");
            ((CTabFolder)this.getContainer()).setTabHeight(1);
            Point point = this.getContainer().getSize();
            this.getContainer().setSize(point.x, point.y + 2);
        }
    }

    protected void pageChange(int pageIndex) {
        super.pageChange(pageIndex);
        Control control = this.getControl(pageIndex);
        if (control != null) {
            control.setVisible(true);
            control.setFocus();
        }
    }

    public Object getAdapter(Class key) {
        if (key.equals(class$org$eclipse$ui$views$properties$IPropertySheetPage == null ? (class$org$eclipse$ui$views$properties$IPropertySheetPage = GenModelEditor.class$("org.eclipse.ui.views.properties.IPropertySheetPage")) : class$org$eclipse$ui$views$properties$IPropertySheetPage)) {
            return this.getPropertySheetPage();
        }
        return super.getAdapter(key);
    }

    public IPropertySheetPage getPropertySheetPage() {
        if (this.propertySheetPage == null) {
            this.propertySheetPage = new PropertySheetPage(){

                public void makeContributions(IMenuManager menuManager, IToolBarManager toolBarManager, IStatusLineManager statusLineManager) {
                    super.makeContributions(menuManager, toolBarManager, statusLineManager);
                }
            };
            this.propertySheetPage.setPropertySourceProvider((IPropertySourceProvider)new AdapterFactoryContentProvider((AdapterFactory)this.adapterFactory){

                public void notifyChanged(Object object, int eventType, Object feature, Object oldValue, Object newValue, int index) {
                    GenModelEditor.super.getContainer().getDisplay().asyncExec(new Runnable(this){
                        private final /* synthetic */ 10 this$1;
                        {
                            this.this$1 = this$1;
                        }

                        public void run() {
                            10.access$300(this.this$1).propertySheetPage.refresh();
                        }
                    });
                }

                static /* synthetic */ GenModelEditor access$300(10 x0) {
                    return x0.GenModelEditor.this;
                }
            });
        }
        return this.propertySheetPage;
    }

    public boolean isDirty() {
        return ((BasicCommandStack)this.editingDomain.getCommandStack()).isSaveNeeded();
    }

    public void doSave(IProgressMonitor progressMonitor) {
        WorkspaceModifyOperation operation = new WorkspaceModifyOperation(){

            protected void execute(IProgressMonitor monitor) throws CoreException {
                try {
                    Resource savedResource = (Resource)GenModelEditor.this.editingDomain.getResourceSet().getResources().get(0);
                    GenModelEditor.this.savedResources.add(savedResource);
                    savedResource.save(Collections.EMPTY_MAP);
                }
                catch (Exception exception) {
                    GenModelEditPlugin.INSTANCE.log(exception);
                }
            }
        };
        try {
            new ProgressMonitorDialog(this.getSite().getShell()).run(false, false, (IRunnableWithProgress)operation);
            ((BasicCommandStack)this.editingDomain.getCommandStack()).saveIsDone();
            this.firePropertyChange(257);
        }
        catch (Exception exception) {
            GenModelEditPlugin.INSTANCE.log(exception);
        }
    }

    public boolean isSaveAsAllowed() {
        return true;
    }

    public void doSaveAs() {
        IFile file;
        SaveAsDialog saveAsDialog = new SaveAsDialog(this.getSite().getShell());
        saveAsDialog.open();
        IPath path = saveAsDialog.getResult();
        if (path != null && (file = ResourcesPlugin.getWorkspace().getRoot().getFile(path)) != null && (!file.exists() || MessageDialog.openQuestion((Shell)this.getSite().getShell(), (String)GenModelEditor.getString("_UI_FileExists_label"), (String)GenModelEditor.getString("_WARN_FileExists", file.getName())))) {
            ((Resource)this.editingDomain.getResourceSet().getResources().get(0)).setURI(URI.createPlatformResourceURI((String)file.getFullPath().toString()));
            FileEditorInput modelFile = new FileEditorInput(file);
            this.setInput((IEditorInput)modelFile);
            this.setTitle(file.getName());
            this.doSave(this.getActionBars().getStatusLineManager().getProgressMonitor());
        }
    }

    public void gotoMarker(IMarker marker) {
    }

    public void init(IEditorSite site, IEditorInput editorInput) throws PartInitException, PartInitException, PartInitException, PartInitException, PartInitException, PartInitException, PartInitException, PartInitException, PartInitException, PartInitException {
        if (!(editorInput instanceof IFileEditorInput)) {
            throw new PartInitException("Invalid Input: Must be IFileEditorInput.");
        }
        this.setSite((IWorkbenchPartSite)site);
        this.setInput(editorInput);
        this.setTitle(((IFileEditorInput)editorInput).getFile().getName());
        site.setSelectionProvider((ISelectionProvider)this);
        site.getPage().addPartListener(this.partListener);
        ResourcesPlugin.getWorkspace().addResourceChangeListener(this.resourceChangeListener, 1);
    }

    public void setFocus() {
        this.getControl(this.getActivePage()).setFocus();
    }

    public void addSelectionChangedListener(ISelectionChangedListener listener) {
        this.selectionChangedListeners.add(listener);
    }

    public void removeSelectionChangedListener(ISelectionChangedListener listener) {
        this.selectionChangedListeners.remove(listener);
    }

    public ISelection getSelection() {
        return this.editorSelection;
    }

    public void setSelection(ISelection selection) {
        this.editorSelection = selection;
        Iterator listeners = this.selectionChangedListeners.iterator();
        while (listeners.hasNext()) {
            ISelectionChangedListener listener = (ISelectionChangedListener)listeners.next();
            listener.selectionChanged(new SelectionChangedEvent((ISelectionProvider)this, selection));
        }
        this.setStatusLineManager(selection);
    }

    public void setStatusLineManager(ISelection selection) {
        IStatusLineManager statusLineManager = this.getActionBars().getStatusLineManager();
        if (selection instanceof IStructuredSelection) {
            List collection = ((IStructuredSelection)selection).toList();
            switch (collection.size()) {
                case 0: {
                    statusLineManager.setMessage(GenModelEditor.getString("_UI_NoObjectSelected"));
                    break;
                }
                case 1: {
                    String text = new AdapterFactoryItemDelegator((AdapterFactory)this.adapterFactory).getText(collection.iterator().next());
                    statusLineManager.setMessage(GenModelEditor.getString("_UI_SingleObjectSelected", text));
                    break;
                }
                default: {
                    statusLineManager.setMessage(GenModelEditor.getString("_UI_MultiObjectSelected", Integer.toString(collection.size())));
                    break;
                }
            }
        } else {
            statusLineManager.setMessage("");
        }
    }

    private static String getString(String key) {
        return GenModelEditPlugin.INSTANCE.getString(key);
    }

    private static String getString(String key, Object s1) {
        return GenModelEditPlugin.INSTANCE.getString(key, new Object[]{s1});
    }

    public void menuAboutToShow(IMenuManager menuManager) {
        ((IMenuListener)this.getEditorSite().getActionBarContributor()).menuAboutToShow(menuManager);
    }

    public EditingDomainActionBarContributor getActionBarContributor() {
        return (EditingDomainActionBarContributor)this.getEditorSite().getActionBarContributor();
    }

    public IActionBars getActionBars() {
        return this.getActionBarContributor().getActionBars();
    }

    public AdapterFactory getAdapterFactory() {
        return this.adapterFactory;
    }

    public void dispose() {
        ResourcesPlugin.getWorkspace().removeResourceChangeListener(this.resourceChangeListener);
        this.getSite().getPage().removePartListener(this.partListener);
        this.adapterFactory.dispose();
        this.getActionBarContributor().setActiveEditor(null);
        if (this.propertySheetPage != null) {
            this.propertySheetPage.dispose();
        }
        super.dispose();
    }

    public void validate() {
        Resource mainResource = (Resource)this.editingDomain.getResourceSet().getResources().get(0);
        GenModel genModel = (GenModel)mainResource.getContents().get(0);
        IStatus status = genModel.validate();
        if (!status.isOK()) {
            ErrorDialog.openError((Shell)this.getSite().getShell(), (String)GenModelEditPlugin.INSTANCE.getString("_UI_ModelProblems_title"), (String)"", (IStatus)status);
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    public class ReverseAdapterFactoryContentProvider
    extends AdapterFactoryContentProvider {
        public ReverseAdapterFactoryContentProvider(AdapterFactory adapterFactory) {
            super(adapterFactory);
        }

        public Object[] getElements(Object object) {
            Object parent = super.getParent(object);
            return (parent == null ? Collections.EMPTY_SET : Collections.singleton(parent)).toArray();
        }

        public Object[] getChildren(Object object) {
            Object parent = super.getParent(object);
            return (parent == null ? Collections.EMPTY_SET : Collections.singleton(parent)).toArray();
        }

        public boolean hasChildren(Object object) {
            Object parent = super.getParent(object);
            return parent != null;
        }

        public Object getParent(Object object) {
            return null;
        }
    }
}

