/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.ecore.action;

import org.eclipse.core.resources.IFile;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IActionDelegate;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.ActionDelegate;

public class OpenEditorAction
extends ActionDelegate
implements IActionDelegate {
    protected IFile file;

    public void run(IAction action) {
        IWorkbenchWindow workbenchWindow = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        IWorkbenchPage page = workbenchWindow.getActivePage();
        try {
            page.openEditor(this.file, action.getId().indexOf("XML") == -1 ? "org.eclipse.emf.ecore.presentation.ReflectiveEditorID" : "org.eclipse.emf.ecore.presentation.XMLReflectiveEditorID");
        }
        catch (PartInitException exception) {
            MessageDialog.openError((Shell)workbenchWindow.getShell(), (String)"Open Editor", (String)exception.getMessage());
        }
    }

    public void selectionChanged(IAction action, ISelection selection) {
        Object object;
        if (selection instanceof IStructuredSelection && (object = ((IStructuredSelection)selection).getFirstElement()) instanceof IFile) {
            this.file = (IFile)object;
            action.setEnabled(action.getId().indexOf("XML") != -1 || Resource.Factory.Registry.INSTANCE.getExtensionToFactoryMap().containsKey(this.file.getFullPath().getFileExtension()));
            return;
        }
        this.file = null;
        action.setEnabled(false);
    }
}

