/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.codegen.ecore.rose2ecore;

import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.codegen.ecore.CodeGenEcorePlugin;
import org.eclipse.emf.codegen.ecore.Generator;
import org.eclipse.emf.codegen.ecore.Rose2GenModel;
import org.eclipse.emf.codegen.ecore.rose2ecore.RoseUtil;
import org.eclipse.emf.codegen.ecore.rose2ecore.RoseVisitor;
import org.eclipse.emf.codegen.ecore.rose2ecore.TableObject;
import org.eclipse.emf.codegen.ecore.rose2ecore.parser.RoseNode;
import org.eclipse.emf.codegen.ecore.rose2ecore.parser.Util;
import org.eclipse.emf.common.util.BasicEList;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EDataType;
import org.eclipse.emf.ecore.EEnum;
import org.eclipse.emf.ecore.EEnumLiteral;
import org.eclipse.emf.ecore.EModelElement;
import org.eclipse.emf.ecore.ENamedElement;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EOperation;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EParameter;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.ETypedElement;
import org.eclipse.emf.ecore.EcoreFactory;
import org.eclipse.emf.ecore.EcorePackage;
import org.eclipse.emf.ecore.util.EcoreSwitch;

public class EcoreBuilder
implements RoseVisitor {
    protected RoseUtil roseUtil;
    protected EcorePackage ecorePackage;
    protected EcoreFactory ecoreFactory;
    protected Set bounded = new HashSet();
    protected List eStructuralFeatures = new BasicEList(){

        protected boolean useEquals() {
            return false;
        }
    };
    protected Map eEnums = new HashMap();
    protected Map idToParentMap = new HashMap();
    protected EReference ref1 = null;
    protected EReference ref2 = null;
    protected RoseNode role1 = null;
    protected RoseNode role2 = null;
    protected static Comparator eClassComparator = new Comparator(){

        public int compare(Object o1, Object o2) {
            int count2;
            EClass c1 = (EClass)o1;
            EClass c2 = (EClass)o2;
            int count1 = c1.getEAllAttributes().size() + c1.getEAllReferences().size();
            if (count1 < (count2 = c2.getEAllAttributes().size() + c2.getEAllReferences().size())) {
                return 1;
            }
            if (count1 > count2) {
                return -1;
            }
            return c1.getName().compareTo(c2.getName());
        }
    };
    protected Comparator eReferenceComparator = new Comparator(){

        public int compare(Object o1, Object o2) {
            return EcoreBuilder.this.eStructuralFeatures.indexOf(o1) - EcoreBuilder.this.eStructuralFeatures.indexOf(o2);
        }
    };

    public EcoreBuilder(RoseUtil roseUtil) {
        this.roseUtil = roseUtil;
        this.ecorePackage = EcorePackage.eINSTANCE;
        this.ecoreFactory = EcoreFactory.eINSTANCE;
    }

    public void visitList(RoseNode roseNode) {
    }

    public void visitObject(RoseNode roseNode) {
        String roseNodeValue = roseNode.getValue();
        String objectKey = roseNode.getKey();
        String objectType = Util.getType(roseNodeValue);
        String objectName = Util.getName(roseNodeValue);
        RoseNode currentNode = roseNode;
        Object parent = currentNode.getNode();
        while (parent == null) {
            currentNode = currentNode.getParent();
            parent = currentNode.getNode();
        }
        if (objectKey.equals("") && objectType.equals("Class_Category")) {
            if (roseNode.isLoaded()) {
                String id = roseNode.getRoseId();
                if (this.idToParentMap.containsKey(id)) {
                    parent = this.idToParentMap.get(id);
                }
                EPackage ePackage = this.ecoreFactory.createEPackage();
                if (parent instanceof EPackage) {
                    ((EPackage)parent).getESubpackages().add(ePackage);
                } else if (parent instanceof EList) {
                    ((EList)parent).add(ePackage);
                }
                this.setEPackageProperties(roseNode, ePackage, objectName.toLowerCase());
            } else {
                this.idToParentMap.put(roseNode.getRoseId(), parent);
            }
        } else if (objectType.equals("Class")) {
            RoseNode stereoTypeNode;
            if (objectName == null || objectName.length() == 0) {
                String quid = roseNode.getRoseId();
                if (quid != null) {
                    quid = quid.substring(1, quid.length() - 1);
                }
                objectName = "Unnamed" + quid;
                this.error(CodeGenEcorePlugin.INSTANCE.getString("_UI_UnnamedClass_message", new Object[]{objectName}));
            }
            if ((stereoTypeNode = roseNode.findNodeWithKey("stereotype")) != null) {
                String stereoTypeValue = stereoTypeNode.getValue();
                if ((stereoTypeValue = stereoTypeValue.substring(1, stereoTypeValue.length() - 1)).equals("Interface")) {
                    EClass eClass = this.ecoreFactory.createEClass();
                    String classifierName = roseNode.getClassifierName();
                    if (classifierName == null || classifierName.length() == 0) {
                        classifierName = this.validName(this.upperCaseName(objectName));
                    }
                    eClass.setName(classifierName);
                    roseNode.setNode(eClass);
                    this.setEClassProperties(roseNode, eClass);
                    eClass.setInterface(true);
                    eClass.setAbstract(true);
                    this.build(roseNode, parent, (ENamedElement)eClass);
                } else if (stereoTypeValue.equalsIgnoreCase("enumeration")) {
                    EEnum eEnum = this.ecoreFactory.createEEnum();
                    String classifierName = roseNode.getClassifierName();
                    if (classifierName == null || classifierName.length() == 0) {
                        classifierName = this.validName(this.upperCaseName(objectName));
                    }
                    eEnum.setName(classifierName);
                    roseNode.setNode(eEnum);
                    this.setEEnumProperties(roseNode, eEnum);
                    this.build(roseNode, parent, (ENamedElement)eEnum);
                } else if (stereoTypeValue.equalsIgnoreCase("datatype") || stereoTypeValue.equalsIgnoreCase("primitive")) {
                    EDataType eDataType = this.ecoreFactory.createEDataType();
                    String classifierName = roseNode.getClassifierName();
                    if (classifierName == null || classifierName.length() == 0) {
                        classifierName = this.validName(this.upperCaseName(objectName));
                    }
                    eDataType.setName(classifierName);
                    roseNode.setNode(eDataType);
                    this.setEDataTypeProperties(roseNode, eDataType);
                    this.build(roseNode, parent, (ENamedElement)eDataType);
                    String uml2MOFCorbaType = roseNode.getUML2MOFCorbaType();
                    if (uml2MOFCorbaType != null) {
                        int end;
                        int start = (uml2MOFCorbaType = uml2MOFCorbaType.trim()).indexOf("typedef ");
                        if (start != -1 && (end = (uml2MOFCorbaType = uml2MOFCorbaType.substring(8)).lastIndexOf(" ")) != -1) {
                            uml2MOFCorbaType = uml2MOFCorbaType.substring(0, end);
                        }
                        if (uml2MOFCorbaType != null && uml2MOFCorbaType.length() != 0) {
                            this.roseUtil.typeTable.put(eDataType, uml2MOFCorbaType);
                        }
                    }
                } else if (stereoTypeValue.equalsIgnoreCase("javatype")) {
                    int index;
                    EDataType eDataType = this.ecoreFactory.createEDataType();
                    String classifierName = roseNode.getClassifierName();
                    if (classifierName == null || classifierName.length() == 0) {
                        index = objectName.lastIndexOf(".");
                        classifierName = this.validName(this.upperCaseName(index == -1 ? objectName : objectName.substring(index + 1)));
                    }
                    eDataType.setName(this.validName(this.upperCaseName((index = objectName.lastIndexOf(".")) == -1 ? objectName : objectName.substring(index + 1))));
                    eDataType.setInstanceClassName(objectName);
                    roseNode.setNode(eDataType);
                    this.setEDataTypeProperties(roseNode, eDataType);
                    this.build(roseNode, parent, (ENamedElement)eDataType);
                } else if (stereoTypeValue.equalsIgnoreCase("abstract")) {
                    EClass eClass = this.ecoreFactory.createEClass();
                    String classifierName = roseNode.getClassifierName();
                    if (classifierName == null || classifierName.length() == 0) {
                        classifierName = this.validName(this.upperCaseName(objectName));
                    }
                    eClass.setName(classifierName);
                    roseNode.setNode(eClass);
                    this.setEClassProperties(roseNode, eClass);
                    this.build(roseNode, parent, (ENamedElement)eClass);
                } else if (stereoTypeValue.equalsIgnoreCase("MapEntry")) {
                    EClass eClass = this.ecoreFactory.createEClass();
                    String classifierName = roseNode.getClassifierName();
                    if (classifierName == null || classifierName.length() == 0) {
                        classifierName = this.validName(this.upperCaseName(objectName));
                    }
                    eClass.setName(classifierName);
                    roseNode.setNode(eClass);
                    this.setEClassProperties(roseNode, eClass);
                    eClass.setInstanceClassName("java.util.Map$Entry");
                    this.build(roseNode, parent, (ENamedElement)eClass);
                } else {
                    this.warning(CodeGenEcorePlugin.INSTANCE.getString("_UI_UnrecognizedStereotype_message", new Object[]{stereoTypeValue, objectName}));
                    EClass eClass = this.ecoreFactory.createEClass();
                    String classifierName = roseNode.getClassifierName();
                    if (classifierName == null || classifierName.length() == 0) {
                        classifierName = this.validName(this.upperCaseName(objectName));
                    }
                    eClass.setName(classifierName);
                    roseNode.setNode(eClass);
                    this.setEClassProperties(roseNode, eClass);
                    this.build(roseNode, parent, (ENamedElement)eClass);
                }
            } else {
                EClass eClass = this.ecoreFactory.createEClass();
                String classifierName = roseNode.getClassifierName();
                if (classifierName == null || classifierName.length() == 0) {
                    classifierName = this.validName(this.upperCaseName(objectName));
                }
                eClass.setName(classifierName);
                roseNode.setNode(eClass);
                this.setEClassProperties(roseNode, eClass);
                this.build(roseNode, parent, (ENamedElement)eClass);
            }
        } else if (objectType.equals("Operation")) {
            EOperation eOperation = this.ecoreFactory.createEOperation();
            String operationName = roseNode.getOperationName();
            if (operationName == null || operationName.length() == 0) {
                operationName = this.validName(objectName);
            }
            eOperation.setName(operationName);
            roseNode.setNode(eOperation);
            this.setResultType(roseNode, eOperation);
            this.setEOperationProperties(roseNode, eOperation);
            if (parent instanceof EClass) {
                ((EClass)parent).getEOperations().add(eOperation);
            }
        } else if (objectType.equals("Parameter")) {
            EParameter eParameter = this.ecoreFactory.createEParameter();
            eParameter.setName(this.validName(objectName));
            roseNode.setNode(eParameter);
            if (parent instanceof EOperation) {
                ((EOperation)parent).getEParameters().add(eParameter);
            }
            this.setEParameterProperties(roseNode, eParameter);
        } else if (objectType.equals("Inheritance_Relationship")) {
            ArrayList<String> superList;
            String quidu = roseNode.getRoseRefId();
            if (quidu != null && !quidu.equals("")) {
                quidu = quidu.substring(1, quidu.length() - 1);
            }
            if ((superList = (ArrayList<String>)this.roseUtil.superTable.get(parent)) == null) {
                superList = new ArrayList<String>();
                this.roseUtil.superTable.put(parent, superList);
            }
            superList.add(quidu);
            superList.add(roseNode.getStereotype());
        } else if (objectType.equals("ClassAttribute") && !roseNode.isDerived()) {
            if (parent instanceof EEnum) {
                EEnumLiteral eEnumLiteral = ((EEnum)parent).getEEnumLiteral(objectName);
                if (eEnumLiteral == null) {
                    eEnumLiteral = this.ecoreFactory.createEEnumLiteral();
                    String literalName = roseNode.getAttributeName();
                    if (literalName == null || literalName.length() == 0) {
                        literalName = this.validName(objectName);
                    }
                    eEnumLiteral.setName(literalName);
                    roseNode.setNode(eEnumLiteral);
                    if (!this.setEEnumLiteralProperties(roseNode, eEnumLiteral)) {
                        if (((EEnum)parent).getELiterals() == null) {
                            eEnumLiteral.setValue(0);
                        } else {
                            eEnumLiteral.setValue(((EEnum)parent).getELiterals().size());
                        }
                    }
                    ((EEnum)parent).getELiterals().add(eEnumLiteral);
                }
            } else if (parent instanceof EClassifier) {
                String stereoTypeValue = null;
                RoseNode stereoTypeNode = roseNode.findNodeWithKey("stereotype");
                if (stereoTypeNode != null) {
                    stereoTypeValue = stereoTypeNode.getValue();
                    stereoTypeValue = stereoTypeValue.substring(1, stereoTypeValue.length() - 1);
                }
                if ((parent instanceof EDataType || parent instanceof EClass && ((EClass)parent).isInterface()) && "javaclass".equalsIgnoreCase(stereoTypeValue)) {
                    this.roseUtil.typeTable.remove(parent);
                    ((EClassifier)parent).setInstanceClassName(objectName);
                } else if (parent instanceof EClass) {
                    EAttribute eAttribute = this.ecoreFactory.createEAttribute();
                    String attributeName = roseNode.getAttributeName();
                    if (attributeName == null || attributeName.length() == 0) {
                        attributeName = this.validName(objectName);
                    }
                    eAttribute.setName(attributeName);
                    roseNode.setNode(eAttribute);
                    this.setEAttributeProperties(roseNode, eAttribute);
                    ((EClass)parent).getEAttributes().add(eAttribute);
                    if (eAttribute.getUpperBound() == 0) {
                        eAttribute.setUpperBound(1);
                    }
                }
            }
        } else if (objectType.equals("Association")) {
            this.ref1 = null;
            this.ref2 = null;
            this.role1 = null;
            this.role2 = null;
        } else if (objectType.equals("Role") && !objectName.startsWith("/")) {
            EReference ref = this.ecoreFactory.createEReference();
            ref.setUpperBound(0);
            String referenceName = roseNode.getReferenceName();
            if (referenceName == null || referenceName.length() == 0) {
                referenceName = this.validName(objectName);
            }
            ref.setName(referenceName);
            roseNode.setNode(ref);
            this.setEReferenceProperties(roseNode, ref);
            if (this.ref1 == null) {
                this.ref1 = ref;
            } else if (this.ref2 == null) {
                this.ref2 = ref;
            }
            if (this.role1 == null) {
                this.role1 = roseNode;
            } else if (this.role2 == null) {
                this.role2 = roseNode;
            }
            if (this.ref1 != null && this.ref2 != null && this.role1 != null && this.role2 != null) {
                TableObject obj;
                String ref2Quidu;
                String ref1Quidu = this.role1.getRoseRefId();
                if (ref1Quidu != null && !ref1Quidu.equals("")) {
                    ref1Quidu = ref1Quidu.substring(1, ref1Quidu.length() - 1);
                }
                if ((ref2Quidu = this.role2.getRoseRefId()) != null && !ref2Quidu.equals("")) {
                    ref2Quidu = ref2Quidu.substring(1, ref2Quidu.length() - 1);
                }
                boolean ref1Navigable = this.role1.isNavigable();
                boolean ref2Navigable = this.role2.isNavigable();
                if (ref1Navigable) {
                    this.ref2.setEOpposite(this.ref1);
                    this.setEReferenceIsContainment(this.ref1, this.role1, this.role2);
                    this.roseUtil.refTable.put(this.ref1, ref2Quidu);
                    obj = (TableObject)this.roseUtil.quidTable.get(ref1Quidu);
                    if (obj != null) {
                        this.roseUtil.typeTable.put(this.ref1, obj.getName());
                    } else {
                        this.warning(CodeGenEcorePlugin.INSTANCE.getString("_UI_UnresolvedTypeNameFor_message", new Object[]{this.role1.getRoseSupplier(), this.ref1.getName()}));
                        this.roseUtil.typeTable.put(this.ref1, "EObject");
                    }
                }
                if (ref2Navigable) {
                    this.ref1.setEOpposite(this.ref2);
                    this.setEReferenceIsContainment(this.ref2, this.role2, this.role1);
                    this.roseUtil.refTable.put(this.ref2, ref1Quidu);
                    obj = (TableObject)this.roseUtil.quidTable.get(ref2Quidu);
                    if (obj != null) {
                        this.roseUtil.typeTable.put(this.ref2, obj.getName());
                    } else {
                        this.warning(CodeGenEcorePlugin.INSTANCE.getString("_UI_UnresolvedTypeNameFor_message", new Object[]{this.role2.getRoseSupplier(), this.ref2.getName()}));
                        this.roseUtil.typeTable.put(this.ref2, "EObject");
                    }
                }
            }
            if (ref.getUpperBound() == 0) {
                this.setEReferenceDefaultMultiplicity(ref);
            }
        }
    }

    protected EList getExtentFromTableObject(RoseNode roseNode) {
        TableObject obj;
        String quid = roseNode.getRoseId();
        if (quid != null) {
            quid = quid.substring(1, quid.length() - 1);
        }
        return (obj = (TableObject)this.roseUtil.quidTable.get(quid)) == null ? null : obj.getContainer().getExtent();
    }

    protected void setEReferenceIsContainment(EReference ref, RoseNode role1, RoseNode role2) {
        boolean isAggregate = role2.isAggregate();
        String containmentV = role1.getContainment();
        if (isAggregate && containmentV != null && containmentV.equalsIgnoreCase("by value")) {
            EReference opposite = ref.getEOpposite();
            if (opposite != null && opposite.getUpperBound() != 1) {
                if (this.bounded.contains(opposite)) {
                    this.error(CodeGenEcorePlugin.INSTANCE.getString("_UI_ContainerRelationUpperBound_message", new Object[]{ref.getName(), ref.getEOpposite().getName()}));
                }
                opposite.setUpperBound(1);
            }
            ref.setContainment(true);
        }
    }

    protected void setResultType(RoseNode roseNode, EOperation eOperation) {
        String quid = roseNode.getRoseRefId();
        if (quid != null && !quid.equals("")) {
            TableObject tableObj = (TableObject)this.roseUtil.quidTable.get(quid = quid.substring(1, quid.length() - 1));
            if (tableObj != null) {
                this.roseUtil.typeTable.put(eOperation, tableObj.getName());
            } else {
                this.warning(CodeGenEcorePlugin.INSTANCE.getString("_UI_UnresolvedTypeIDFor_message", new Object[]{quid, eOperation.getName()}));
                this.roseUtil.typeTable.put(eOperation, "EString");
            }
        } else {
            String resultValue = this.getQualifiedTypeName((ETypedElement)eOperation, roseNode.getResult());
            if (resultValue != null && !resultValue.equalsIgnoreCase("void")) {
                if (!resultValue.equals("")) {
                    this.roseUtil.typeTable.put(eOperation, resultValue);
                } else {
                    this.warning(CodeGenEcorePlugin.INSTANCE.getString("_UI_UnresolvedTypeNameFor_message", new Object[]{roseNode.getRoseSupplier(), eOperation.getName()}));
                    this.roseUtil.typeTable.put(eOperation, "EString");
                }
            }
        }
    }

    protected void setEPackageProperties(RoseNode roseNode, EPackage ePackage, String tentativeName) {
        String nsURI;
        String nsPrefix;
        roseNode.setNode(ePackage);
        String packageName = roseNode.getPackageName();
        if (packageName == null || packageName.length() == 0) {
            packageName = this.validName(tentativeName);
        }
        ePackage.setName(packageName);
        String basePackage = roseNode.getBasePackage();
        String prefix = roseNode.getPrefix();
        String string = nsPrefix = roseNode.getNsPrefix() == null || roseNode.getNsPrefix().length() == 0 ? (String)this.roseUtil.packageNameToNSNameMap.get(packageName) : roseNode.getNsPrefix();
        if (nsPrefix == null || nsPrefix.length() == 0) {
            nsPrefix = packageName;
            EPackage eSuperPackage = ePackage.getESuperPackage();
            if (eSuperPackage != null) {
                nsPrefix = eSuperPackage.getNsPrefix() + "." + nsPrefix;
            } else if (basePackage != null && basePackage.length() != 0) {
                nsPrefix = basePackage + "." + nsPrefix;
            }
        }
        ePackage.setNsPrefix(nsPrefix);
        String string2 = nsURI = roseNode.getNsURI() == null || roseNode.getNsURI().length() == 0 ? (String)this.roseUtil.packageNameToNSURIMap.get(packageName) : roseNode.getNsURI();
        if (nsURI == null || nsURI.length() == 0) {
            nsURI = Rose2GenModel.noQualify ? nsPrefix + ".ecore" : "http:///" + nsPrefix.replace('.', '/') + ".ecore";
        }
        ePackage.setNsURI(nsURI);
        if (prefix != null && prefix.length() == 0) {
            prefix = null;
        }
        if (basePackage != null && basePackage.length() == 0) {
            basePackage = null;
        }
        if (prefix != null || basePackage != null) {
            ArrayList<String> information = new ArrayList<String>();
            information.add(basePackage);
            information.add(prefix);
            this.roseUtil.getEPackageToInformationMap().put(ePackage, information);
        }
    }

    protected void setEClassProperties(RoseNode roseNode, EClass eClass) {
        eClass.setAbstract(roseNode.isAbstract());
    }

    protected void setEDataTypeProperties(RoseNode roseNode, EDataType eDataType) {
        eDataType.setSerializable(!roseNode.isAbstract());
    }

    protected void setEEnumProperties(RoseNode roseNode, EEnum eEnum) {
        String value = roseNode.getDocumentation();
        if (value != null && !value.equals("")) {
            this.eEnums.put(eEnum, value);
        }
    }

    protected void populateEEnumFromDocumentation(EEnum eEnum, String documentation) {
        EList eLiterals = eEnum.getELiterals();
        StringTokenizer stringTokenizer = new StringTokenizer(documentation, ", ");
        while (stringTokenizer.hasMoreTokens()) {
            String literalV;
            String name = literalV = stringTokenizer.nextToken();
            String number = "";
            int ind = literalV.indexOf("=");
            if (ind != -1) {
                name = literalV.substring(0, ind);
                number = literalV.substring(ind + 1, literalV.length());
            }
            int numberValue = 0;
            if (!number.equals("")) {
                numberValue = new Integer(number);
            } else if (!eLiterals.isEmpty()) {
                numberValue = ((EEnumLiteral)eLiterals.get(eLiterals.size() - 1)).getValue() + 1;
            }
            if (name.equals("")) continue;
            EEnumLiteral lit = eEnum.getEEnumLiteral(name);
            if (lit == null) {
                lit = this.ecoreFactory.createEEnumLiteral();
                lit.setName(this.validName(name));
                lit.setValue(numberValue);
                eLiterals.add(lit);
                continue;
            }
            lit.setValue(numberValue);
        }
    }

    protected void setEOperationProperties(RoseNode roseNode, EOperation eOperation) {
    }

    protected void setEAttributeProperties(RoseNode roseNode, EAttribute eAttribute) {
        this.eStructuralFeatures.add(eAttribute);
        String quid = roseNode.getRoseRefId();
        if (quid != null && !quid.equals("")) {
            TableObject tableObj = (TableObject)this.roseUtil.quidTable.get(quid = quid.substring(1, quid.length() - 1));
            if (tableObj != null) {
                this.roseUtil.typeTable.put(eAttribute, tableObj.getName());
            } else {
                this.warning(CodeGenEcorePlugin.INSTANCE.getString("_UI_UnresolvedTypeIDFor_message", new Object[]{quid, eAttribute.getName()}));
                this.roseUtil.typeTable.put(eAttribute, "String");
            }
        } else {
            String type = this.getQualifiedTypeName((ETypedElement)eAttribute, roseNode.getType());
            if (type != null && !type.equals("")) {
                this.roseUtil.typeTable.put(eAttribute, type);
            } else {
                this.roseUtil.typeTable.put(eAttribute, "String");
                this.warning(CodeGenEcorePlugin.INSTANCE.getString("_UI_AttributeDoesNotDefineItsType_message", new Object[]{eAttribute.getName()}));
            }
        }
        String initv = roseNode.getInitV();
        if (initv != null && initv.length() >= 2) {
            if (initv.charAt(0) == '\'' && initv.charAt(initv.length() - 1) == '\'') {
                try {
                    char i = EcoreBuilder.parseChar(initv.substring(1, initv.length() - 1));
                    initv = Integer.toString(i);
                }
                catch (IllegalArgumentException e) {
                    this.error(CodeGenEcorePlugin.INSTANCE.getString("_UI_InvalidDefaultValueForAttribute_message", new Object[]{eAttribute.getName()}));
                    initv = null;
                }
            } else if (initv.charAt(0) == '\"' && initv.charAt(initv.length() - 1) == '\"') {
                try {
                    initv = EcoreBuilder.parseString(initv.substring(1, initv.length() - 1));
                }
                catch (IllegalArgumentException e) {
                    this.error(CodeGenEcorePlugin.INSTANCE.getString("_UI_InvalidDefaultValueForAttribute_message", new Object[]{eAttribute.getName()}));
                    initv = null;
                }
            }
        }
        if (initv != null && !initv.equals("")) {
            eAttribute.setDefaultValueLiteral(initv);
        }
        this.setEStructuralFeatureProperties(roseNode, (EStructuralFeature)eAttribute);
        eAttribute.setTransient(roseNode.isTransient());
        eAttribute.setVolatile(roseNode.isVolatile());
        eAttribute.setChangeable(roseNode.isChangeable());
        eAttribute.setUnique(roseNode.isUnique());
        eAttribute.setUnsettable(roseNode.isUnsettable());
        eAttribute.setID(roseNode.isID());
    }

    protected void setEReferenceProperties(RoseNode roseNode, EReference eReference) {
        this.eStructuralFeatures.add(eReference);
        this.setEStructuralFeatureProperties(roseNode, (EStructuralFeature)eReference);
        eReference.setTransient(roseNode.isTransient());
        eReference.setVolatile(roseNode.isVolatile());
        eReference.setChangeable(roseNode.isChangeable());
        eReference.setResolveProxies(roseNode.isResolveProxies());
        eReference.setUnsettable(roseNode.isUnsettable());
    }

    protected void setEStructuralFeatureProperties(RoseNode roseNode, EStructuralFeature eStructuralFeature) {
        String multiplicity;
        String string = multiplicity = eStructuralFeature instanceof EAttribute ? roseNode.getStereotype() : roseNode.getRoleMultiplicity();
        if (multiplicity != null) {
            this.bounded.add(eStructuralFeature);
            if (multiplicity.length() > 0 && Character.isLetter(multiplicity.charAt(0)) && !"n".equalsIgnoreCase(multiplicity)) {
                return;
            }
            StringTokenizer stringTokenizer = new StringTokenizer(multiplicity, ". ");
            switch (stringTokenizer.countTokens()) {
                case 1: {
                    String bound = stringTokenizer.nextToken();
                    if (bound.equals("*") || bound.equalsIgnoreCase("n")) {
                        eStructuralFeature.setUpperBound(-1);
                        break;
                    }
                    try {
                        int boundValue = Integer.parseInt(bound);
                        if (boundValue > 0) {
                            eStructuralFeature.setLowerBound(boundValue);
                            eStructuralFeature.setUpperBound(boundValue);
                            break;
                        }
                        this.warning(CodeGenEcorePlugin.INSTANCE.getString("_UI_BadMultiplicityFor_message", new Object[]{multiplicity, eStructuralFeature.getName()}));
                    }
                    catch (NumberFormatException exception) {
                        this.warning(CodeGenEcorePlugin.INSTANCE.getString("_UI_BadMultiplicityFor_message", new Object[]{multiplicity, eStructuralFeature.getName()}));
                    }
                    break;
                }
                case 2: {
                    String lowerBound = stringTokenizer.nextToken();
                    try {
                        int lowerBoundValue = Integer.parseInt(lowerBound);
                        if (lowerBoundValue >= 0) {
                            String upperBound = stringTokenizer.nextToken();
                            if (upperBound.equals("*") || upperBound.equalsIgnoreCase("n")) {
                                eStructuralFeature.setLowerBound(lowerBoundValue);
                                eStructuralFeature.setUpperBound(-1);
                                break;
                            }
                            int upperBoundValue = Integer.parseInt(upperBound);
                            if (upperBoundValue <= 0 || lowerBoundValue > upperBoundValue) {
                                this.warning(CodeGenEcorePlugin.INSTANCE.getString("_UI_BadMultiplicityFor_message", new Object[]{multiplicity, eStructuralFeature.getName()}));
                                break;
                            }
                            eStructuralFeature.setLowerBound(lowerBoundValue);
                            eStructuralFeature.setUpperBound(upperBoundValue);
                            break;
                        }
                        this.warning(CodeGenEcorePlugin.INSTANCE.getString("_UI_BadMultiplicityFor_message", new Object[]{multiplicity, eStructuralFeature.getName()}));
                    }
                    catch (NumberFormatException exception) {
                        this.warning(CodeGenEcorePlugin.INSTANCE.getString("_UI_BadMultiplicityFor_message", new Object[]{multiplicity, eStructuralFeature.getName()}));
                    }
                    break;
                }
                default: {
                    this.warning(CodeGenEcorePlugin.INSTANCE.getString("_UI_BadMultiplicityFor_message", new Object[]{multiplicity, eStructuralFeature.getName()}));
                }
            }
        }
    }

    protected boolean setEEnumLiteralProperties(RoseNode roseNode, EEnumLiteral eEnumLiteral) {
        String value = roseNode.getInitV();
        if (value != null && !value.equals("")) {
            eEnumLiteral.setValue(Integer.parseInt(value));
            return true;
        }
        return false;
    }

    protected void setEParameterProperties(RoseNode roseNode, EParameter eParameter) {
        String quid = roseNode.getRoseRefId();
        if (quid != null && !quid.equals("")) {
            TableObject tableObj = (TableObject)this.roseUtil.quidTable.get(quid = quid.substring(1, quid.length() - 1));
            if (tableObj != null) {
                this.roseUtil.typeTable.put(eParameter, tableObj.getName());
            } else {
                this.warning(CodeGenEcorePlugin.INSTANCE.getString("_UI_UnresolvedTypeIDFor_message", new Object[]{quid, eParameter.getEOperation().getName()}));
                this.roseUtil.typeTable.put(eParameter, "EObject");
            }
        } else {
            String type = this.getQualifiedTypeName((ETypedElement)eParameter, roseNode.getType());
            if (type != null && !type.equals("")) {
                this.roseUtil.typeTable.put(eParameter, type);
            } else {
                this.warning(CodeGenEcorePlugin.INSTANCE.getString("_UI_UnresolvedTypeNameFor_message", new Object[]{roseNode.getRoseSupplier(), eParameter.getEOperation().getName()}));
                this.roseUtil.typeTable.put(eParameter, "EObject");
            }
        }
    }

    protected void setEReferenceDefaultMultiplicity(EReference eReference) {
        if (eReference.getEOpposite() == null || !eReference.getEOpposite().isContainment()) {
            eReference.setLowerBound(0);
            eReference.setUpperBound(-1);
        }
    }

    public void setEEnums() {
        Iterator i = this.eEnums.entrySet().iterator();
        while (i.hasNext()) {
            Map.Entry entry = i.next();
            EEnum eEnum = (EEnum)entry.getKey();
            if (!eEnum.getELiterals().isEmpty()) continue;
            this.populateEEnumFromDocumentation(eEnum, (String)entry.getValue());
        }
    }

    public void setSuper() {
        HashMap<EClass, List[]> superMap = new HashMap<EClass, List[]>();
        Iterator i = this.roseUtil.superTable.keySet().iterator();
        while (i.hasNext()) {
            Object subObject = i.next();
            if (subObject instanceof EClass) {
                EClass eClass = (EClass)subObject;
                ArrayList<Object> extend = new ArrayList<Object>();
                ArrayList<Object> unspecified = new ArrayList<Object>();
                ArrayList<Object> mixin = new ArrayList<Object>();
                ArrayList<Object> nonClass = new ArrayList<Object>();
                Iterator j = ((List)this.roseUtil.superTable.get(eClass)).iterator();
                while (j.hasNext()) {
                    String quid = (String)j.next();
                    String stereotype = (String)j.next();
                    TableObject tableObject = (TableObject)this.roseUtil.quidTable.get(quid);
                    if (tableObject == null) continue;
                    Object superObject = tableObject.getObject();
                    if (superObject instanceof EClass) {
                        EClass superClass = (EClass)superObject;
                        if (!superClass.isInterface()) {
                            if ("extend".equals(stereotype)) {
                                extend.add(superObject);
                                continue;
                            }
                            if ("mixin".equals(stereotype)) {
                                mixin.add(superObject);
                                continue;
                            }
                            unspecified.add(superObject);
                            continue;
                        }
                        nonClass.add(superObject);
                        continue;
                    }
                    this.warning(CodeGenEcorePlugin.INSTANCE.getString("_UI_CannotAddSuperLinkBetween_message", new Object[]{eClass.getName(), ((ENamedElement)superObject).getName()}));
                }
                if (extend.size() > 1) {
                    this.warning(CodeGenEcorePlugin.INSTANCE.getString("_UI_CannotSpecifyMoreThanOneExtendFor_message", new Object[]{eClass.getName()}));
                }
                superMap.put(eClass, new List[]{extend, unspecified, mixin});
                eClass.getESuperTypes().addAll(extend);
                eClass.getESuperTypes().addAll(unspecified);
                eClass.getESuperTypes().addAll(mixin);
                eClass.getESuperTypes().addAll(nonClass);
                continue;
            }
            this.warning(CodeGenEcorePlugin.INSTANCE.getString("_UI_CannotAddSuperLinkInvolving_message", new Object[]{((ENamedElement)subObject).getName()}));
        }
        Iterator entries = superMap.entrySet().iterator();
        while (entries.hasNext()) {
            Map.Entry entry = entries.next();
            EClass eClass = (EClass)entry.getKey();
            List[] collections = (List[])entry.getValue();
            Collections.sort(collections[0], eClassComparator);
            Collections.sort(collections[1], eClassComparator);
            Collections.sort(collections[2], eClassComparator);
            ArrayList combined = new ArrayList(collections[0]);
            combined.addAll(collections[1]);
            combined.addAll(collections[2]);
            EList eSuper = eClass.getESuperTypes();
            ListIterator ordered = combined.listIterator();
            while (ordered.hasNext()) {
                Object eSuperItem = ordered.next();
                eSuper.move(ordered.previousIndex(), eSuperItem);
            }
        }
    }

    public void setIDs(EObject parent, EObject child) {
        new EcoreSwitch(){

            public Object caseEPackage(EPackage ePackage) {
                return null;
            }

            public Object caseEClassifier(EClassifier eClassifier) {
                return null;
            }

            public Object caseEOperation(EOperation eOperation) {
                return null;
            }

            public Object caseEParameter(EParameter eParameter) {
                return null;
            }

            public Object caseEStructuralFeature(EStructuralFeature eStructuralFeature) {
                return null;
            }

            public Object caseEEnumLiteral(EEnumLiteral eEnumLiteral) {
                return null;
            }

            public Object defaultCase(EObject eObject) {
                Iterator i = eObject.eContents().iterator();
                while (i.hasNext()) {
                    EcoreBuilder.this.setIDs(eObject, (EObject)i.next());
                }
                return this;
            }
        }.doSwitch(child);
    }

    public void validate(EObject object) {
        new EcoreSwitch(){

            public Object caseEDataType(EDataType eDataType) {
                if (!(eDataType instanceof EEnum) && eDataType.getInstanceClassName() == null) {
                    EcoreBuilder.this.error(CodeGenEcorePlugin.INSTANCE.getString("_UI_DatatypeNotSetFor_message", new Object[]{eDataType.getName()}));
                    eDataType.setInstanceClassName("java.lang.String");
                }
                return null;
            }

            public Object caseEEnum(EEnum eEnum) {
                Iterator literals = eEnum.getELiterals().iterator();
                block0: while (literals.hasNext()) {
                    EEnumLiteral eEnumLiteral = (EEnumLiteral)literals.next();
                    Iterator allLiterals = eEnum.getELiterals().iterator();
                    while (allLiterals.hasNext()) {
                        EEnumLiteral otherLiteral = (EEnumLiteral)allLiterals.next();
                        if (eEnumLiteral == otherLiteral) continue block0;
                        if (!eEnumLiteral.getName().equalsIgnoreCase(otherLiteral.getName())) continue;
                        EcoreBuilder.this.error(CodeGenEcorePlugin.INSTANCE.getString("_UI_DuplicateLiteral_message", new Object[]{eEnumLiteral.getName(), eEnum.getName()}));
                        literals.remove();
                        continue block0;
                    }
                }
                return this;
            }

            public Object caseEClass(EClass eClass) {
                EReference opposite;
                Iterator attributes = eClass.getEAttributes().iterator();
                block2: while (attributes.hasNext()) {
                    EAttribute eAttribute = (EAttribute)attributes.next();
                    if (Rose2GenModel.unsettablePrimitive) {
                        try {
                            EDataType eDataType = eAttribute.getEAttributeType();
                            if (eDataType instanceof EEnum || eDataType.getInstanceClass().isPrimitive()) {
                                eAttribute.setUnsettable(true);
                            }
                        }
                        catch (Exception e) {
                            // empty catch block
                        }
                    }
                    Iterator allFeatures = eClass.getEAllStructuralFeatures().iterator();
                    while (allFeatures.hasNext()) {
                        EStructuralFeature otherFeature = (EStructuralFeature)allFeatures.next();
                        if (eAttribute == otherFeature) continue block2;
                        if (eAttribute.getName().equalsIgnoreCase(otherFeature.getName())) {
                            EcoreBuilder.this.error(CodeGenEcorePlugin.INSTANCE.getString("_UI_DuplicateAttribute_message", new Object[]{eAttribute.getName(), eClass.getName()}));
                            attributes.remove();
                            continue block2;
                        }
                        if (eAttribute.getEAttributeType().isSerializable() || eAttribute.isTransient()) continue;
                        EcoreBuilder.this.error(CodeGenEcorePlugin.INSTANCE.getString("_UI_TheAttributeShouldBeTransient_message", new Object[]{eAttribute.getName(), eAttribute.getEType().getName()}));
                        continue block2;
                    }
                }
                ArrayList<EReference> oppositesToRemove = new ArrayList<EReference>();
                Iterator references = eClass.getEReferences().iterator();
                while (references.hasNext()) {
                    EReference eReference = (EReference)references.next();
                    opposite = eReference.getEOpposite();
                    if (opposite != null) {
                        if (opposite.eContainer() == null) {
                            EcoreBuilder.this.error(CodeGenEcorePlugin.INSTANCE.getString("_UI_AnAssociationHasADanglingEnd_message", new Object[]{opposite.getName(), eReference.getName()}));
                            opposite = null;
                            eReference.setEOpposite(null);
                        } else if (opposite.isContainment()) {
                            eReference.setTransient(true);
                            if (eReference.getUpperBound() != 1) {
                                if (EcoreBuilder.this.bounded.contains(eReference)) {
                                    EcoreBuilder.this.error(CodeGenEcorePlugin.INSTANCE.getString("_UI_ContainerRelationUpperBound_message", new Object[]{opposite.getName(), eReference.getName()}));
                                }
                                eReference.setUpperBound(1);
                            }
                        }
                    }
                    if (eReference.isTransient() && !eReference.isVolatile() && opposite != null && !opposite.isTransient() && opposite.isResolveProxies() && !opposite.isContainment()) {
                        EcoreBuilder.this.error(CodeGenEcorePlugin.INSTANCE.getString("_UI_CrossDocumentBidirectionalTransient_message", new Object[]{opposite.getName(), eReference.getName()}));
                    }
                    Iterator allFeatures = eClass.getEAllStructuralFeatures().iterator();
                    while (allFeatures.hasNext()) {
                        EStructuralFeature otherFeature = (EStructuralFeature)allFeatures.next();
                        if (eReference == otherFeature) break;
                        if (!eReference.getName().equalsIgnoreCase(otherFeature.getName())) continue;
                        EcoreBuilder.this.error(CodeGenEcorePlugin.INSTANCE.getString("_UI_DuplicateReference_message", new Object[]{eReference.getName(), eClass.getName()}));
                        if (opposite != null) {
                            oppositesToRemove.add(opposite);
                        }
                        references.remove();
                        break;
                    }
                    if (eReference.isContainer() || !"java.util.Map$Entry".equals(eReference.getEType().getInstanceClassName()) || eReference.isContainment() && eReference.isMany()) continue;
                    EcoreBuilder.this.error(CodeGenEcorePlugin.INSTANCE.getString("_UI_MultiplicityManyContainmentIsAssumedFor_message", new Object[]{eReference.getName(), eClass.getName()}));
                    eReference.setContainment(true);
                    eReference.setUpperBound(-1);
                }
                Iterator opposites = oppositesToRemove.iterator();
                while (opposites.hasNext()) {
                    opposite = (EReference)opposites.next();
                    EClass oppositeEClass = opposite.getEContainingClass();
                    if (oppositeEClass == null) continue;
                    oppositeEClass.getEReferences().remove(opposite);
                }
                if (eClass.getESuperTypes().size() > 1) {
                    Iterator superTypes = eClass.getESuperTypes().iterator();
                    superTypes.next();
                    block7: while (superTypes.hasNext()) {
                        EClass superType = (EClass)superTypes.next();
                        Iterator superFeatures = superType.getEAllStructuralFeatures().iterator();
                        block8: while (superFeatures.hasNext()) {
                            EStructuralFeature superFeature = (EStructuralFeature)superFeatures.next();
                            Iterator allFeatures = eClass.getEAllStructuralFeatures().iterator();
                            while (allFeatures.hasNext()) {
                                EStructuralFeature otherFeature = (EStructuralFeature)allFeatures.next();
                                if (superFeature == otherFeature) continue block8;
                                if (!superFeature.getName().equalsIgnoreCase(otherFeature.getName())) continue;
                                EcoreBuilder.this.error(CodeGenEcorePlugin.INSTANCE.getString("_UI_DuplicateFeatureInheritance_message", new Object[]{superFeature.getName(), eClass.getName(), superType.getName()}));
                                superTypes.remove();
                                continue block7;
                            }
                        }
                    }
                }
                if ("java.util.Map$Entry".equals(eClass.getInstanceClassName())) {
                    EStructuralFeature keyFeature = eClass.getEStructuralFeature("key");
                    EStructuralFeature valueFeature = eClass.getEStructuralFeature("value");
                    if (keyFeature == null) {
                        EcoreBuilder.this.error(CodeGenEcorePlugin.INSTANCE.getString("_UI_ExpectingFeatureNamedKey_message", new Object[]{eClass.getName()}));
                        eClass.setInstanceClassName(null);
                    }
                    if (valueFeature == null) {
                        EcoreBuilder.this.error(CodeGenEcorePlugin.INSTANCE.getString("_UI_ExpectingFeatureNamedValue_message", new Object[]{eClass.getName()}));
                        eClass.setInstanceClassName(null);
                    }
                }
                return this;
            }

            public Object defaultCase(EObject eObject) {
                Iterator i = eObject.eContents().iterator();
                while (i.hasNext()) {
                    EcoreBuilder.this.validate((EObject)i.next());
                }
                return this;
            }
        }.doSwitch(object);
    }

    public void setEReferences() {
        Iterator i = this.roseUtil.refTable.keySet().iterator();
        while (i.hasNext()) {
            EReference eReference = (EReference)i.next();
            String quid = (String)this.roseUtil.refTable.get(eReference);
            TableObject tableObject = (TableObject)this.roseUtil.quidTable.get(quid);
            if (tableObject == null) continue;
            Object struct = tableObject.getObject();
            if (struct instanceof EClass) {
                ((EClass)struct).getEReferences().add(-1 - Collections.binarySearch(((EClass)struct).getEReferences(), eReference, this.eReferenceComparator), eReference);
                continue;
            }
            this.warning(CodeGenEcorePlugin.INSTANCE.getString("_UI_CannotAddReference_message", new Object[]{eReference.getName(), tableObject.getName()}));
        }
    }

    public void setETypeClassifier() {
        Iterator it = this.roseUtil.typeTable.keySet().iterator();
        while (it.hasNext()) {
            EDataType eClassifier;
            EModelElement element = (EModelElement)it.next();
            String type = (String)this.roseUtil.typeTable.get(element);
            TableObject tableObj = null;
            if (type.indexOf(".") == -1) {
                String qualifier = "";
                EObject parent = element.eContainer();
                while (parent != null) {
                    if (parent instanceof EPackage) {
                        qualifier = ((EPackage)parent).getName() + "." + qualifier;
                    }
                    parent = parent.eContainer();
                }
                tableObj = (TableObject)this.roseUtil.nameTable.get(qualifier + type);
            }
            if (tableObj == null) {
                tableObj = (TableObject)this.roseUtil.nameTable.get(type);
            }
            if (tableObj != null && tableObj.getObject() != null && element instanceof ETypedElement) {
                EReference eReference;
                EClassifier eType = (EClassifier)tableObj.getObject();
                if (eType instanceof EClass && element instanceof EAttribute) {
                    EAttribute eAttribute = (EAttribute)element;
                    EReference eReference2 = this.ecoreFactory.createEReference();
                    eReference2.setName(eAttribute.getName());
                    eReference2.setTransient(eAttribute.isTransient());
                    eReference2.setVolatile(eAttribute.isVolatile());
                    eReference2.setChangeable(eAttribute.isChangeable());
                    eReference2.setLowerBound(eAttribute.getLowerBound());
                    eReference2.setUpperBound(eAttribute.getUpperBound());
                    eReference2.setContainment(true);
                    this.eStructuralFeatures.set(this.eStructuralFeatures.indexOf(eAttribute), eReference2);
                    EClass containingClass = eAttribute.getEContainingClass();
                    containingClass.getEAttributes().remove(eAttribute);
                    containingClass.getEReferences().add(-1 - Collections.binarySearch(containingClass.getEReferences(), eReference2, this.eReferenceComparator), eReference2);
                    element = eReference2;
                }
                ((ETypedElement)element).setEType(eType);
                if (!(element instanceof EReference) || !"".equals((eReference = (EReference)element).getName())) continue;
                eReference.setName(eType.getName());
                continue;
            }
            if (type.equals("boolean") || type.equalsIgnoreCase("eboolean")) {
                eClassifier = this.getBasicType("EBoolean");
            } else if (type.equalsIgnoreCase("boolean") || type.equalsIgnoreCase("ebooleanobject")) {
                eClassifier = this.getBasicType("EBooleanObject");
            } else if (type.equalsIgnoreCase("string") || type.equalsIgnoreCase("estring")) {
                eClassifier = this.ecorePackage.getEString();
            } else if (type.equalsIgnoreCase("char") || type.equalsIgnoreCase("echar")) {
                eClassifier = this.getBasicType("EChar");
            } else if (type.equalsIgnoreCase("character") || type.equalsIgnoreCase("echaracterobject")) {
                eClassifier = this.getBasicType("ECharacterObject");
            } else if (type.equals("double") || type.equalsIgnoreCase("edouble") || type.equalsIgnoreCase("currency")) {
                eClassifier = this.getBasicType("EDouble");
            } else if (type.equalsIgnoreCase("double") || type.equalsIgnoreCase("edoubleobject")) {
                eClassifier = this.getBasicType("EDoubleObject");
            } else if (type.equalsIgnoreCase("int") || type.equalsIgnoreCase("eint")) {
                eClassifier = this.getBasicType("EInt");
            } else if (type.equalsIgnoreCase("integer") || type.equalsIgnoreCase("eintegerobject")) {
                eClassifier = this.getBasicType("EIntegerObject");
            } else if (type.equals("long long") || type.equals("long") || type.equalsIgnoreCase("elong")) {
                eClassifier = this.getBasicType("ELong");
            } else if (type.equalsIgnoreCase("long") || type.equalsIgnoreCase("elongobject")) {
                eClassifier = this.getBasicType("ELongObject");
            } else if (type.equals("float") || type.equalsIgnoreCase("efloat") || type.equalsIgnoreCase("single")) {
                eClassifier = this.getBasicType("EFloat");
            } else if (type.equalsIgnoreCase("float") || type.equalsIgnoreCase("efloatobject")) {
                eClassifier = this.getBasicType("EFloatObject");
            } else if (type.equals("short") || type.equalsIgnoreCase("eshort")) {
                eClassifier = this.getBasicType("EShort");
            } else if (type.equalsIgnoreCase("short") || type.equalsIgnoreCase("eshortobject")) {
                eClassifier = this.getBasicType("EShortObject");
            } else if (type.equals("byte") || type.equalsIgnoreCase("ebyte")) {
                eClassifier = this.getBasicType("EByte");
            } else if (type.equalsIgnoreCase("byte") || type.equalsIgnoreCase("ebyteObject")) {
                eClassifier = this.getBasicType("EByteObject");
            } else if (type.equalsIgnoreCase("eobject")) {
                eClassifier = this.ecorePackage.getEObject();
            } else {
                this.warning(CodeGenEcorePlugin.INSTANCE.getString("_UI_UnresolvedTypeNameFor_message", new Object[]{type, ((ENamedElement)element).getName()}));
                eClassifier = this.getBasicType("EString");
            }
            if (element instanceof EDataType) {
                ((EDataType)element).setInstanceClassName(eClassifier.getInstanceClassName());
                continue;
            }
            ((ETypedElement)element).setEType((EClassifier)eClassifier);
        }
    }

    protected EDataType getBasicType(String value) {
        return (EDataType)this.ecorePackage.getEClassifier(value);
    }

    public void createEPackageForRootClasses(EList extent, RoseNode roseNode, String packageName) {
        boolean hasSubpackages = false;
        ArrayList list = new ArrayList();
        Iterator i = extent.iterator();
        while (i.hasNext()) {
            Object object = i.next();
            if (object instanceof EPackage) continue;
            list.add(object);
        }
        if (!list.isEmpty()) {
            EPackage ePackage = this.ecoreFactory.createEPackage();
            this.setEPackageProperties(roseNode, ePackage, packageName.toLowerCase());
            extent.add(ePackage);
            Iterator i2 = ((AbstractList)list).iterator();
            while (i2.hasNext()) {
                EClassifier eClassifier = (EClassifier)i2.next();
                ePackage.getEClassifiers().add(eClassifier);
                extent.remove(eClassifier);
            }
        }
    }

    protected void build(RoseNode roseNode, Object parent, ENamedElement eNamedElement) {
        TableObject tableObj;
        String quid = roseNode.getRoseId();
        if (quid != null && !quid.equals("")) {
            quid = quid.substring(1, quid.length() - 1);
        }
        if ((tableObj = (TableObject)this.roseUtil.quidTable.get(quid)) != null) {
            tableObj.setObject(eNamedElement);
        }
        if (parent instanceof EPackage) {
            ((EPackage)parent).getEClassifiers().add(eNamedElement);
        } else if (parent instanceof EList) {
            ((EList)parent).add(eNamedElement);
        }
    }

    protected String upperCaseName(String name) {
        return name != null && name.length() > 0 && Character.isLowerCase(name.charAt(0)) ? Character.toUpperCase(name.charAt(0)) + name.substring(1) : name;
    }

    protected String validName(String name) {
        return Generator.validName(name);
    }

    protected void warning(String message) {
        System.err.println("-->Warning: " + message);
        this.roseUtil.getStatus().add((IStatus)new Status(2, CodeGenEcorePlugin.getPlugin().getDescriptor().getUniqueIdentifier(), 0, message, null));
    }

    protected void error(String message) {
        System.err.println("-->Error: " + message);
        this.roseUtil.getStatus().add((IStatus)new Status(4, CodeGenEcorePlugin.getPlugin().getDescriptor().getUniqueIdentifier(), 0, message, null));
    }

    protected static char parseChar(String c) {
        int i;
        if (c == null) {
            throw new IllegalArgumentException("null");
        }
        if ("\\b".equals(c)) {
            return '\b';
        }
        if ("\\t".equals(c)) {
            return '\t';
        }
        if ("\\n".equals(c)) {
            return '\n';
        }
        if ("\\f".equals(c)) {
            return '\f';
        }
        if ("\\r".equals(c)) {
            return '\r';
        }
        if ("\\\"".equals(c)) {
            return '\"';
        }
        if ("\\'".equals(c)) {
            return '\'';
        }
        if ("\\\\".equals(c)) {
            return '\\';
        }
        if (c.startsWith("\\u") && c.length() == 6) {
            int i2 = Integer.parseInt(c.substring(2), 16);
            if (i2 >= 0 && i2 <= 65535) {
                return (char)i2;
            }
        } else if (c.length() >= 2 && c.length() <= 4 && c.charAt(0) == '\\' && (i = Integer.parseInt(c.substring(1), 8)) >= 0 && i <= 65535) {
            return (char)i;
        }
        if (c.length() != 1) {
            throw new IllegalArgumentException(c);
        }
        return c.charAt(0);
    }

    protected static String parseString(String s) {
        if (s == null) {
            return null;
        }
        int len = s.length();
        StringBuffer result = new StringBuffer(len);
        int i = 0;
        while (i < len) {
            char c = s.charAt(i);
            if (c == '\\' && len > i + 1) {
                if ("btnfr\"'\\".indexOf(s.charAt(i + 1)) != -1) {
                    c = EcoreBuilder.parseChar(s.substring(i, i + 2));
                    ++i;
                } else if (s.charAt(i + 1) == 'u' && len > i + 5) {
                    c = EcoreBuilder.parseChar(s.substring(i, i + 6));
                    i += 5;
                } else {
                    int j = i + 1;
                    while (j < len && j - i < 4) {
                        char digit = s.charAt(j);
                        if (digit < '0' || digit > '7') break;
                        ++j;
                    }
                    c = EcoreBuilder.parseChar(s.substring(i, j));
                    i = j - 1;
                }
            }
            result.append(c);
            ++i;
        }
        return result.toString();
    }

    protected String getQualifiedTypeName(ETypedElement typedElement, String type) {
        if (null == type || type.length() == 0 || "void".equals(type)) {
            return type;
        }
        String qualifiedType = type;
        if (qualifiedType.indexOf("::") != -1) {
            StringTokenizer st = new StringTokenizer(qualifiedType, "::");
            if (st.hasMoreTokens()) {
                st.nextToken();
            }
            StringBuffer stringBuffer = new StringBuffer();
            while (st.hasMoreTokens()) {
                stringBuffer.append(st.nextToken().replace('\"', ' ').replace('[', ' ').replace(']', ' ').trim());
                if (!st.hasMoreTokens()) continue;
                stringBuffer.append(".");
            }
            qualifiedType = stringBuffer.toString();
        }
        if (qualifiedType.indexOf(46) == -1) {
            String qualifier = "";
            EObject parent = typedElement.eContainer();
            while (null != parent) {
                if (parent instanceof EPackage) {
                    qualifier = ((EPackage)parent).getName() + "." + qualifier;
                }
                parent = parent.eContainer();
            }
            qualifiedType = qualifier + qualifiedType;
        }
        if (!qualifiedType.equals(type) && !this.roseUtil.nameTable.containsKey(qualifiedType)) {
            qualifiedType = type;
        }
        return qualifiedType;
    }
}

