/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.codegen.ecore.rose2ecore.parser;

import java.util.List;
import java.util.Stack;
import org.eclipse.emf.codegen.ecore.rose2ecore.parser.RoseLexer;
import org.eclipse.emf.codegen.ecore.rose2ecore.parser.RoseLoader;
import org.eclipse.emf.codegen.ecore.rose2ecore.parser.RoseNode;
import org.eclipse.emf.codegen.ecore.rose2ecore.parser.RoseToken;

public class RoseParser {
    protected RoseLexer lexer;
    protected RoseNode versionTree;
    protected RoseNode modelTree;
    protected String baseId = "";
    protected Stack idStack = new Stack();
    protected boolean isTreeOnly = false;
    protected boolean isAllowed = true;
    protected boolean isRoot = true;
    protected boolean isListMapping = true;
    protected boolean noLogicalPresentation = false;
    protected boolean mapProperties = true;

    public RoseParser(RoseLexer lexer) {
        this(lexer, false, false);
    }

    public RoseParser(RoseLexer lexer, boolean isTreeOnly) {
        this(lexer, isTreeOnly, false);
    }

    public RoseParser(RoseLexer lexer, boolean isTreeOnly, boolean noPresentation) {
        this.lexer = lexer;
        this.isTreeOnly = isTreeOnly;
        this.noLogicalPresentation = noPresentation;
    }

    public RoseNode getVersionTree() {
        return this.versionTree;
    }

    public RoseNode getModelTree() {
        return this.modelTree;
    }

    public void parse() {
        this.baseId = null;
        this.idStack.push(new Integer(0));
        this.versionTree = this.parseExpr("");
        this.idStack.push(new Integer(0));
        this.baseId = null;
        this.modelTree = this.parseExpr("");
        RoseLoader roseLoader = this.lexer.roseLoader;
    }

    public void traverseTree(List path) {
        RoseNode node = this.modelTree;
        if (node == null) {
            return;
        }
        int i = 0;
        while (i < path.size()) {
            if (node.getRoseNodeType() == 0) {
                return;
            }
            List nodes = node.getNodes();
            Integer integ = (Integer)path.get(i);
            int j = integ;
            if (j < 1 || j > nodes.size()) break;
            node = (RoseNode)nodes.get(j - 1);
            ++i;
        }
        String id = node.getId();
        String atId = node.getAtId();
        if (id == null) {
            id = "";
        }
        if (atId == null) {
            atId = "";
        }
        String t1 = "";
        if (node.getRoseNodeType() == 0) {
            t1 = "(STRING)";
        } else if (node.getRoseNodeType() == 3) {
            t1 = "(LIST)";
        } else if (node.getRoseNodeType() == 2) {
            t1 = "(OBJECT)";
        } else if (node.getRoseNodeType() == 1) {
            t1 = "(STRING_SEQ)";
        } else if (node.getRoseNodeType() == 4) {
            t1 = "(VALUE)";
        }
        System.out.println(t1 + "\t" + node.getKey() + " --- " + node.getValue() + " - " + id + " - " + atId);
        List nodes = node.getNodes();
        int count = 1;
        int i2 = 0;
        while (i2 < nodes.size()) {
            RoseNode n = (RoseNode)nodes.get(i2);
            String t = "";
            if (n.getRoseNodeType() == 0) {
                t = "(STRING)";
            } else if (n.getRoseNodeType() == 3) {
                t = "(LIST)";
            } else if (n.getRoseNodeType() == 2) {
                t = "(OBJECT)";
            } else if (n.getRoseNodeType() == 1) {
                t = "(STRING_SEQ)";
            } else if (n.getRoseNodeType() == 4) {
                t = "(VALUE)";
            }
            System.out.println(count + " " + t + "\t" + n.getKey() + " --- " + n.getValue());
            ++count;
            ++i2;
        }
    }

    private RoseNode parseObject(String key) {
        Integer topInt = (Integer)this.idStack.pop();
        int top = topInt;
        this.idStack.push(new Integer(++top));
        this.idStack.push(new Integer(0));
        if (this.baseId == null) {
            this.baseId = "id";
        } else {
            this.baseId = this.baseId + ".";
            this.baseId = this.baseId + topInt.toString();
        }
        RoseToken tok = this.lexer.getNext();
        if (tok.getType() != 0) {
            System.out.println("  Parsing error in parseObject - expecting object token");
            return null;
        }
        tok = this.lexer.getNext();
        if (tok.getType() != 6) {
            System.out.println("  Parsing error in parseObject - expecting string");
            return null;
        }
        String label = tok.getValue();
        RoseNode root = null;
        if (this.isTreeOnly) {
            if (key.equals("root_usecase_package") || key.equals("root_subsystem") || !this.mapProperties && key.equals("properties") && label.equals("Properties")) {
                this.isListMapping = false;
            } else if (key.equals("root_category") || key.equals("process_structure") && label.equals("Processes")) {
                this.isListMapping = true;
            }
        }
        root = new RoseNode(key, label, 2);
        root.setId(this.baseId);
        while ((tok = this.lexer.peekNext()).getType() != 3) {
            tok = this.lexer.getNext();
            if (tok.getType() != 5) {
                System.out.println("  Parsing error in parseObject - expecting key " + tok.lineNum);
                return null;
            }
            String pairKey = tok.getValue();
            RoseNode node = this.parseExpr(pairKey);
            if (this.isTreeOnly) {
                if (root == null || node == null) continue;
                root.addNode(node);
                continue;
            }
            if (node == null) {
                return null;
            }
            root.addNode(node);
        }
        this.idStack.pop();
        if (this.baseId.lastIndexOf(46) > 0) {
            this.baseId = this.baseId.substring(0, this.baseId.lastIndexOf(46));
        }
        return root;
    }

    private RoseNode parseValue(String key) {
        Integer topInt = (Integer)this.idStack.pop();
        int top = topInt;
        this.idStack.push(new Integer(++top));
        this.idStack.push(new Integer(0));
        if (this.baseId == null) {
            this.baseId = "id";
        } else {
            this.baseId = this.baseId + ".";
            this.baseId = this.baseId + topInt.toString();
        }
        RoseToken tok = this.lexer.getNext();
        if (tok.getType() != 7) {
            System.out.println("  Parsing error in parseValue - expecting value token");
            return null;
        }
        tok = this.lexer.getNext();
        if (tok.getType() != 6) {
            System.out.println("  Parsing error in parseValue - expecting string");
            return null;
        }
        String label = tok.getValue();
        RoseNode root = null;
        root = new RoseNode(key, label, 4);
        root.setId(this.baseId);
        RoseNode node = this.parseS_prime("");
        if (this.isTreeOnly) {
            if (root != null && node != null) {
                root.addNode(node);
            }
        } else {
            if (node == null) {
                return null;
            }
            root.addNode(node);
        }
        this.idStack.pop();
        if (this.baseId.lastIndexOf(46) > 0) {
            this.baseId = this.baseId.substring(0, this.baseId.lastIndexOf(46));
        }
        return root;
    }

    private RoseNode parseExpr(String key) {
        RoseToken tok = this.lexer.peekNext();
        if (tok.getType() == 2) {
            RoseNode root;
            tok = this.lexer.getNext();
            tok = this.lexer.peekNext();
            if (tok.getType() == 0) {
                root = this.parseObject(key);
                if (!this.isTreeOnly && root == null) {
                    return null;
                }
            } else if (tok.getType() == 7) {
                root = this.parseValue(key);
                if (!this.isTreeOnly && root == null) {
                    return null;
                }
            } else if (tok.getType() == 1) {
                root = this.parseList(key);
                if (!this.isTreeOnly && root == null) {
                    return null;
                }
            } else {
                System.out.println("  Parsing error in parseExpr - expecting object or list");
                return null;
            }
            if ((tok = this.lexer.getNext()).getType() != 3) {
                System.out.println("  Parsing error in parseExpr - expecting right parenthesis");
                return null;
            }
            return root;
        }
        return this.parseS_prime(key);
    }

    private RoseNode parseS_prime(String key) {
        RoseToken tok = this.lexer.peekNext();
        if (tok.getType() == 6) {
            tok = this.lexer.getNext();
            RoseNode root = null;
            root = new RoseNode(key, tok.getValue(), 0);
            return root;
        }
        if (tok.getType() == 4) {
            RoseNode root = null;
            root = new RoseNode(key, "", 1);
            while ((tok = this.lexer.peekNext()).getType() == 4) {
                tok = this.lexer.getNext();
                tok = this.lexer.getNext();
                if (tok.getType() != 6) {
                    System.out.println("  Parsing error in parseS_prime - expecting string");
                    return null;
                }
                RoseNode node = null;
                node = new RoseNode("", tok.getValue(), 0);
                if (root == null) continue;
                root.addNode(node);
            }
            return root;
        }
        this.lexer.printNeighbors();
        System.out.println("  Parsing error in parseS_prime - expecting string or | " + tok.lineNum);
        return null;
    }

    private RoseNode parseList(String key) {
        boolean wasAllowed = this.isAllowed;
        this.isAllowed = this.noLogicalPresentation ? !key.equals("logical_presentations") : true;
        if (!this.isListMapping) {
            this.isAllowed = false;
        }
        RoseNode root = null;
        RoseToken tok = this.lexer.getNext();
        if (tok.getType() != 1) {
            System.out.println("  Parsing error in parseList - expecting list token");
            return null;
        }
        tok = this.lexer.getNext();
        if (tok.getType() != 6) {
            System.out.println("  Parsing error in parseList - expecting string");
            return null;
        }
        String label = tok.getValue();
        tok = this.lexer.peekNext();
        if (tok.getType() == 2) {
            root = null;
            if (!this.isTreeOnly || this.isAllowed) {
                root = new RoseNode(key, label, 3);
            }
            do {
                if ((tok = this.lexer.getNext()).getType() != 2) {
                    System.out.println("  Parsing error in parseList - expecting left parenthesis");
                    return null;
                }
                RoseNode node = this.parseObject("");
                if (this.isTreeOnly) {
                    if (root != null && node != null) {
                        root.addNode(node);
                    }
                } else {
                    if (node == null) {
                        return null;
                    }
                    root.addNode(node);
                }
                if ((tok = this.lexer.getNext()).getType() == 3) continue;
                System.out.println("  Parsing error in parseList - expecting right parenthesis");
                return null;
            } while ((tok = this.lexer.peekNext()).getType() != 3);
        } else if (tok.getType() == 3) {
            root = null;
            if (!this.isTreeOnly || this.isAllowed) {
                root = new RoseNode(key, label, 3);
            }
        } else if (tok.getType() == 6) {
            root = null;
            if (!this.isTreeOnly || this.isAllowed) {
                root = new RoseNode(key, label, 3);
            }
            do {
                if ((tok = this.lexer.getNext()).getType() != 6) {
                    System.out.println("  Parsing error in parseList - expecting string");
                    return null;
                }
                RoseNode node = null;
                node = new RoseNode("", tok.getValue(), 0);
                if (root == null) continue;
                root.addNode(node);
            } while ((tok = this.lexer.peekNext()).getType() != 3);
        } else {
            this.lexer.getNext();
            System.out.println("  Parsing error in parseList - expecting left/right parenthesis or string " + tok.lineNum);
            root = null;
        }
        this.isAllowed = wasAllowed;
        return root;
    }
}

