/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.ecore.xmi;

import java.io.PrintStream;
import java.io.PrintWriter;
import org.eclipse.emf.ecore.resource.Resource;

public class XMIException
extends Exception
implements Resource.Diagnostic {
    protected String location;
    protected int line;
    protected int column;
    protected Exception exception;

    public XMIException(String message) {
        super(message);
    }

    public XMIException(Exception exception) {
        super(exception.getMessage());
        this.exception = exception;
    }

    public XMIException(String message, Exception exception) {
        super(message);
        this.exception = exception;
    }

    public XMIException(String message, String location, int line, int column) {
        super(message);
        this.exception = this.exception;
        this.location = location;
        this.line = line;
        this.column = column;
    }

    public XMIException(String message, Exception exception, String location, int line, int column) {
        super(message);
        this.exception = exception;
        this.location = location;
        this.line = line;
        this.column = column;
    }

    public XMIException(Exception exception, String location, int line, int column) {
        super(exception.getMessage());
        this.exception = exception;
        this.location = location;
        this.line = line;
        this.column = column;
    }

    public String getMessage() {
        String result = super.getMessage();
        if (this.line != 0) {
            result = result + " (" + this.location + ", " + this.line + ", " + this.column + ")";
        }
        return result;
    }

    public String getLocation() {
        return this.location;
    }

    public int getLine() {
        return this.line;
    }

    public int getColumn() {
        return this.column;
    }

    public Exception getWrappedException() {
        return this.exception;
    }

    public void printStackTrace() {
        if (this.exception != null) {
            this.exception.printStackTrace();
        } else {
            super.printStackTrace();
        }
    }

    public void printStackTrace(PrintStream printStream) {
        if (this.exception != null) {
            this.exception.printStackTrace(printStream);
        } else {
            super.printStackTrace(printStream);
        }
    }

    public void printStackTrace(PrintWriter printWriter) {
        if (this.exception != null) {
            this.exception.printStackTrace(printWriter);
        } else {
            super.printStackTrace(printWriter);
        }
    }
}

