/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.ecore.xmi.impl;

import java.util.Map;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EFactory;
import org.eclipse.emf.ecore.ENamedElement;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.xmi.XMLHelper;
import org.eclipse.emf.ecore.xmi.XMLResource;
import org.eclipse.emf.ecore.xmi.impl.XMLHandler;
import org.xml.sax.Attributes;
import org.xml.sax.Locator;

public class SAXXMLHandler
extends XMLHandler {
    protected Locator locator;
    protected Attributes attribs;

    public SAXXMLHandler(XMLResource xmiResource, XMLHelper helper, Map options) {
        super(xmiResource, helper, options);
    }

    protected EFactory getFactoryForPrefix(String prefix) {
        EFactory factory = super.getFactoryForPrefix(prefix);
        if (factory == null && prefix.equals("") && this.helper.getNoNamespacePackage() != null) {
            factory = this.helper.getNoNamespacePackage().getEFactoryInstance();
        }
        return factory;
    }

    protected Object setAttributes(Object attributes) {
        Attributes oldAttribs = this.attribs;
        this.attribs = (Attributes)attributes;
        return oldAttribs;
    }

    public void setLocator(Object locator) {
        this.locator = (Locator)locator;
    }

    protected int getLineNumber() {
        if (this.locator != null) {
            return this.locator.getLineNumber();
        }
        return super.getLineNumber();
    }

    protected int getColumnNumber() {
        if (this.locator != null) {
            return this.locator.getColumnNumber();
        }
        return super.getColumnNumber();
    }

    protected boolean isNull() {
        return this.attribs.getValue("xsi:nil") != null;
    }

    protected void handleNamespaceAttribs() {
        int i = 0;
        int size = this.attribs.getLength();
        while (i < size) {
            String attrib = this.attribs.getQName(i);
            if (attrib.startsWith("xmlns")) {
                this.handleXMLNSAttribute(attrib, this.attribs.getValue(i));
            } else if ("xsi:schemaLocation".equals(attrib)) {
                this.handleXSISchemaLocation(this.attribs.getValue(i));
            }
            ++i;
        }
    }

    protected String getXSIType() {
        return this.attribs.getValue("xsi:type");
    }

    protected void handleObjectAttribs(EObject obj) {
        if (this.attribs != null) {
            InternalEObject internalEObject = (InternalEObject)obj;
            int i = 0;
            int size = this.attribs.getLength();
            while (i < size) {
                String name = this.attribs.getQName(i);
                if (name.equals(this.idAttribute)) {
                    this.xmlResource.setID((EObject)internalEObject, this.attribs.getValue(i));
                } else if (name.equals("href")) {
                    this.handleProxy(internalEObject, this.attribs.getValue(i));
                } else if (!name.startsWith("xmlns") && !this.notFeatures.contains(name)) {
                    this.setAttribValue(obj, name, this.attribs.getValue(i));
                }
                ++i;
            }
        }
    }

    protected void processObject(EObject object) {
        EStructuralFeature valueFeature;
        if (object != null && (valueFeature = this.getContentFeature(object)) != null) {
            this.text = new StringBuffer();
            this.objects.push(object);
            this.types.push(valueFeature);
            return;
        }
        super.processObject(object);
    }

    protected EStructuralFeature getContentFeature(EObject object) {
        EAttribute eAttribute;
        XMLResource.XMLInfo info;
        EList eAttributes;
        if (this.xmlMap != null && (eAttributes = object.eClass().getEAllAttributes()).size() > 1 && (info = this.xmlMap.getInfo((ENamedElement)(eAttribute = (EAttribute)eAttributes.get(0)))) != null && info.getXMLRepresentation() == 2) {
            return eAttribute;
        }
        return null;
    }
}

