/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.ecore.xmi.impl;

import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EFactory;
import org.eclipse.emf.ecore.ENamedElement;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.util.InternalEList;
import org.eclipse.emf.ecore.xmi.ClassNotFoundException;
import org.eclipse.emf.ecore.xmi.FeatureNotFoundException;
import org.eclipse.emf.ecore.xmi.IllegalValueException;
import org.eclipse.emf.ecore.xmi.PackageNotFoundException;
import org.eclipse.emf.ecore.xmi.UnresolvedReferenceException;
import org.eclipse.emf.ecore.xmi.XMIException;
import org.eclipse.emf.ecore.xmi.XMLHelper;
import org.eclipse.emf.ecore.xmi.XMLResource;

public abstract class XMLHandler {
    protected static final String ERROR_TYPE = "error";
    protected static final String OBJECT_TYPE = "object";
    protected static final String TYPE_ATTRIB = "xsi:type";
    protected static final String NIL_ATTRIB = "xsi:nil";
    protected static final String SCHEMA_LOCATION_ATTRIB = "xsi:schemaLocation";
    protected XMLResource xmlResource;
    protected XMLHelper helper;
    protected MyStack elements;
    protected MyStack objects;
    protected MyStack types;
    protected Map prefixesToFactories;
    protected Map urisToLocations;
    protected InternalEList extent;
    protected ResourceSet resourceSet;
    protected URI resourceURI;
    protected boolean resolve;
    protected boolean oldStyleProxyURIs;
    protected boolean disableNotify;
    protected StringBuffer text;
    protected List forwardSingleReferences;
    protected List forwardManyReferences;
    protected Object[] identifiers;
    protected int[] positions;
    protected static final int ARRAY_SIZE = 64;
    protected static final int REFERENCE_THRESHOLD = 5;
    protected int capacity;
    protected Set notFeatures;
    protected String idAttribute;
    protected XMLResource.XMLMap xmlMap;
    Map eClassFeatureNamePairToEStructuralFeatureMap = new HashMap();
    EClassFeatureNamePair eClassFeatureNamePair = new EClassFeatureNamePair();

    public XMLHandler(XMLResource xmlResource, XMLHelper helper, Map options) {
        this.xmlResource = xmlResource;
        this.helper = helper;
        this.elements = new MyStack();
        this.objects = new MyStack();
        this.types = new MyStack();
        this.prefixesToFactories = new HashMap();
        this.forwardSingleReferences = new LinkedList();
        this.forwardManyReferences = new LinkedList();
        this.identifiers = new Object[64];
        this.positions = new int[64];
        this.capacity = 64;
        this.resourceSet = xmlResource.getResourceSet();
        this.resourceURI = xmlResource.getURI();
        this.extent = (InternalEList)xmlResource.getContents();
        boolean bl = this.resolve = this.resourceURI.isHierarchical() && !this.resourceURI.isRelative();
        if (Boolean.TRUE.equals(options.get("DISABLE_NOTIFY"))) {
            this.disableNotify = true;
        }
        this.notFeatures = new HashSet();
        this.notFeatures.add(TYPE_ATTRIB);
        this.notFeatures.add(SCHEMA_LOCATION_ATTRIB);
        this.xmlMap = (XMLResource.XMLMap)options.get("XML_MAP");
        helper.setXMLMap(this.xmlMap);
        if (this.xmlMap != null) {
            EPackage pkg = this.xmlMap.getNoNamespacePackage();
            if (pkg != null) {
                helper.setNoNamespacePackage(pkg);
            }
            this.idAttribute = this.xmlMap.getIDAttributeName();
        }
    }

    protected abstract void handleObjectAttribs(EObject var1);

    protected abstract void handleNamespaceAttribs();

    protected abstract boolean isNull();

    protected abstract Object setAttributes(Object var1);

    protected abstract void setLocator(Object var1);

    protected abstract String getXSIType();

    public void startDocument() {
    }

    public void startElement(String uri, String localName, String name) {
        this.elements.push(name);
        this.handleNamespaceAttribs();
        int index = name.indexOf(":");
        String prefix = "";
        localName = name;
        if (index != -1) {
            prefix = name.substring(0, index);
            localName = name.substring(index + 1);
        }
        this.processElement(name, prefix, localName);
    }

    protected void processElement(String name, String prefix, String localName) {
        if (this.isError()) {
            this.types.push(ERROR_TYPE);
        } else if (this.objects.isEmpty()) {
            this.createTopObject(prefix, localName);
        } else {
            this.handleFeature(prefix, localName);
        }
    }

    public void endDocument() {
        Iterator i = this.forwardSingleReferences.iterator();
        while (i.hasNext()) {
            SingleReference ref = (SingleReference)i.next();
            EObject obj = this.xmlResource.getEObject((String)ref.getValue());
            if (obj != null) {
                EStructuralFeature feature = ref.getFeature();
                this.setFeatureValue(ref.getObject(), feature, obj, ref.getPosition());
                continue;
            }
            this.error(new UnresolvedReferenceException((String)ref.getValue(), this.xmlResource.getURI().toString(), ref.getLineNumber(), ref.getColumnNumber()));
        }
        Iterator i2 = this.forwardManyReferences.iterator();
        while (i2.hasNext()) {
            ManyReference ref = (ManyReference)i2.next();
            Object[] values = ref.getValues();
            int j = 0;
            int l = values.length;
            while (j < l) {
                String id = (String)values[j];
                EObject obj = this.xmlResource.getEObject(id);
                values[j] = obj;
                if (obj == null) {
                    this.error(new UnresolvedReferenceException(id, this.xmlResource.getURI().toString(), ref.getLineNumber(), ref.getColumnNumber()));
                }
                ++j;
            }
            this.setFeatureValues(ref);
        }
        if (this.disableNotify) {
            TreeIterator i3 = this.xmlResource.getAllContents();
            while (i3.hasNext()) {
                EObject eObject = (EObject)i3.next();
                eObject.eSetDeliver(true);
            }
        }
    }

    protected void createTopObject(String prefix, String name) {
        EFactory eFactory = this.getFactoryForPrefix(prefix);
        EObject newObject = this.createObjectFromFactory(eFactory, name);
        this.processTopObject(newObject);
    }

    protected void processTopObject(EObject object) {
        if (object != null) {
            this.extent.addUnique((Object)object);
        }
        this.processObject(object);
    }

    public void endElement(String uri, String localName, String name) {
        this.elements.pop();
        Object type = this.types.pop();
        if (type == OBJECT_TYPE) {
            if (this.text != null) {
                this.handleProxy((InternalEObject)this.objects.pop(), this.text.toString().trim());
                this.text = null;
            } else {
                this.objects.pop();
            }
        } else if (this.isTextFeatureValue(type)) {
            EObject eObject = (EObject)this.objects.peek();
            this.setFeatureValue(eObject, (EStructuralFeature)type, this.text == null ? null : this.text.toString());
            this.text = null;
        }
    }

    protected boolean isTextFeatureValue(Object type) {
        return type != ERROR_TYPE;
    }

    public void startPrefixMapping(String prefix, String uri) {
        this.helper.addPrefix(prefix, uri);
    }

    public void endPrefixMapping(String prefix) {
    }

    public void characters(char[] ch, int start, int length) {
        if (this.text != null) {
            this.text.append(ch, start, length);
        }
    }

    protected void handleXMLNSAttribute(String attrib, String value) {
        int index = attrib.indexOf(":");
        String prefix = index == -1 ? "" : attrib.substring(index + 1);
        this.helper.addPrefix(prefix, value);
    }

    protected void handleXSISchemaLocation(String schemaLocations) {
        if (this.urisToLocations == null) {
            this.urisToLocations = new HashMap();
            if (this.xmlResource != null) {
                this.xmlResource.getDefaultSaveOptions().put("SCHEMA_LOCATION", Boolean.TRUE);
            }
        }
        StringTokenizer stringTokenizer = new StringTokenizer(schemaLocations, " ");
        while (stringTokenizer.hasMoreTokens()) {
            String key = stringTokenizer.nextToken();
            if (!stringTokenizer.hasMoreTokens()) continue;
            String value = stringTokenizer.nextToken();
            URI uri = URI.createDeviceURI((String)value);
            if (this.resolve && uri.isRelative() && uri.hasRelativePath()) {
                uri = this.helper.resolve(uri, this.resourceURI);
            }
            this.urisToLocations.put(key, uri);
        }
    }

    protected void handleFeature(String prefix, String name) {
        EObject peekObject = (EObject)this.objects.peek();
        EStructuralFeature feature = this.getFeature(peekObject, prefix, name);
        if (feature != null) {
            int kind = this.helper.getFeatureKind(feature);
            if (kind == 1 || kind == 2) {
                this.types.push(feature);
                if (!this.isNull()) {
                    this.text = new StringBuffer();
                }
            } else {
                this.createObject(peekObject, feature);
            }
        } else {
            this.error(new FeatureNotFoundException(name, peekObject, this.getLocation(), this.getLineNumber(), this.getColumnNumber()));
        }
    }

    protected int getLineNumber() {
        return -1;
    }

    protected int getColumnNumber() {
        return -1;
    }

    protected String getLocation() {
        return this.xmlResource.getURI().toString();
    }

    public void error(XMIException e) {
        this.xmlResource.getErrors().add(e);
    }

    public void warning(XMIException e) {
        this.xmlResource.getWarnings().add(e);
    }

    public void fatalError(XMIException e) {
        this.xmlResource.getErrors().add(e);
    }

    protected void createObject(EObject peekObject, EStructuralFeature feature) {
        if (this.isNull()) {
            this.setFeatureValue(peekObject, feature, null);
            this.objects.push(null);
            this.types.push(OBJECT_TYPE);
        } else {
            String xsiType = this.getXSIType();
            if (xsiType != null) {
                this.createObjectFromTypeName(peekObject, xsiType, feature);
            } else {
                XMLResource.XMLInfo info;
                EObject object = this.createObjectFromFeatureType(peekObject, feature);
                if (this.xmlMap != null && (info = this.xmlMap.getInfo((ENamedElement)feature)) != null && info.getXMLRepresentation() == 0) {
                    this.text = new StringBuffer();
                }
            }
        }
    }

    protected EObject createObjectFromTypeName(EObject peekObject, String typeQName, EStructuralFeature feature) {
        String typeName = null;
        String prefix = "";
        int index = typeQName.indexOf(":");
        if (index > 0) {
            prefix = typeQName.substring(0, index);
            typeName = typeQName.substring(index + 1);
        } else {
            typeName = typeQName;
        }
        EFactory eFactory = this.getFactoryForPrefix(prefix);
        EObject obj = this.createObjectFromFactory(eFactory, typeName);
        if (obj != null) {
            this.setFeatureValue(peekObject, feature, obj);
        }
        this.processObject(obj);
        return obj;
    }

    protected EObject createObjectFromFeatureType(EObject peekObject, EStructuralFeature feature) {
        EObject obj;
        String typeName = null;
        EFactory factory = null;
        EClassifier eType = null;
        if (feature != null && (eType = feature.getEType()) != null) {
            EClass eClass = (EClass)eType;
            typeName = this.helper.getName((ENamedElement)eClass);
            factory = eClass.getEPackage().getEFactoryInstance();
        }
        if ((obj = this.createObjectFromFactory(factory, typeName)) != null) {
            this.setFeatureValue(peekObject, feature, obj);
        }
        this.processObject(obj);
        return obj;
    }

    protected EObject createObjectFromFactory(EFactory factory, String typeName) {
        EObject newObject = null;
        if (factory != null) {
            newObject = this.helper.createObject(factory, typeName);
            if (newObject != null) {
                if (this.disableNotify) {
                    newObject.eSetDeliver(false);
                }
                this.handleObjectAttribs(newObject);
            } else {
                this.error(new ClassNotFoundException(typeName, factory, this.getLocation(), this.getLineNumber(), this.getColumnNumber()));
            }
        }
        return newObject;
    }

    protected void processObject(EObject object) {
        if (object != null) {
            this.objects.push(object);
            this.types.push(OBJECT_TYPE);
        } else {
            this.types.push(ERROR_TYPE);
        }
    }

    protected EFactory getFactoryForPrefix(String prefix) {
        EPackage ePackage;
        EFactory factory = (EFactory)this.prefixesToFactories.get(prefix);
        if (factory == null && (ePackage = this.getPackageForURI(this.helper.getURI(prefix))) != null) {
            factory = ePackage.getEFactoryInstance();
            this.prefixesToFactories.put(prefix, factory);
        }
        return factory;
    }

    protected EPackage getPackageForURI(String uriString) {
        if (uriString == null) {
            return null;
        }
        EPackage ePackage = EPackage.Registry.INSTANCE.getEPackage(uriString);
        if (ePackage == null) {
            URI locationURI;
            URI uri = URI.createDeviceURI((String)uriString);
            if (uri.scheme() == null) {
                Iterator entries = EPackage.Registry.INSTANCE.entrySet().iterator();
                while (entries.hasNext()) {
                    Map.Entry entry = entries.next();
                    String nsURI = (String)entry.getKey();
                    if (!nsURI.endsWith(uriString) || nsURI.charAt(nsURI.length() - uriString.length() - 1) != '/') continue;
                    this.oldStyleProxyURIs = true;
                    return (EPackage)entry.getValue();
                }
            }
            if (this.urisToLocations != null && (locationURI = (URI)this.urisToLocations.get(uriString)) != null) {
                uri = locationURI;
            }
            String fragment = uri.fragment();
            Resource resource = null;
            if (this.resourceSet != null) {
                resource = this.resourceSet.getResource(uri.trimFragment(), true);
            }
            if (resource != null) {
                Object content = null;
                if (fragment != null) {
                    content = resource.getEObject(fragment);
                } else {
                    EList contents = resource.getContents();
                    if (!contents.isEmpty()) {
                        content = contents.get(0);
                    }
                }
                if (content instanceof EPackage) {
                    ePackage = (EPackage)content;
                }
            }
        }
        if (ePackage == null) {
            this.error(new PackageNotFoundException(uriString, this.getLocation(), this.getLineNumber(), this.getColumnNumber()));
        }
        return ePackage;
    }

    protected void setFeatureValue(EObject object, EStructuralFeature feature, Object value) {
        this.setFeatureValue(object, feature, value, -1);
    }

    protected void setFeatureValue(EObject object, EStructuralFeature feature, Object value, int position) {
        try {
            this.helper.setValue(object, feature, value, position);
        }
        catch (RuntimeException e) {
            this.error(new IllegalValueException(object, feature, value, e, this.getLocation(), this.getLineNumber(), this.getColumnNumber()));
        }
    }

    protected void setFeatureValues(ManyReference reference) {
        List xmiExceptions = this.helper.setManyReference(reference, this.getLocation());
        if (xmiExceptions != null) {
            Iterator i = xmiExceptions.iterator();
            while (i.hasNext()) {
                XMIException exception = (XMIException)i.next();
                this.error(exception);
            }
        }
    }

    protected void setAttribValue(EObject object, String name, String value) {
        EStructuralFeature feature;
        int index = name.indexOf(":");
        String prefix = "";
        String localName = name;
        if (index != -1) {
            prefix = name.substring(0, index);
            localName = name.substring(index + 1);
        }
        if ((feature = this.getFeature(object, prefix, name)) == null) {
            this.error(new FeatureNotFoundException(name, object, this.getLocation(), this.getLineNumber(), this.getColumnNumber()));
        } else {
            int kind = this.helper.getFeatureKind(feature);
            if (kind == 1 || kind == 2) {
                this.setFeatureValue(object, feature, value, -2);
            } else {
                this.setValueFromId(object, (EReference)feature, value);
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    protected void setValueFromId(EObject object, EReference eReference, String ids) {
        StringTokenizer st = new StringTokenizer(ids);
        boolean isFirstID = true;
        boolean mustAdd = false;
        boolean mustAddOrNotOppositeIsMany = false;
        int size = 0;
        String qName = null;
        int position = 0;
        while (st.hasMoreTokens()) {
            EObject resolvedEObject;
            String id;
            block12: {
                id = st.nextToken();
                int index = id.indexOf("#");
                if (index != -1) {
                    if (index == 0) {
                        id = id.substring(1);
                        break block12;
                    } else {
                        Object oldAttributes = this.setAttributes(null);
                        InternalEObject proxy = (InternalEObject)(qName == null ? this.createObjectFromFeatureType(object, (EStructuralFeature)eReference) : this.createObjectFromTypeName(object, qName, (EStructuralFeature)eReference));
                        this.setAttributes(oldAttributes);
                        this.handleProxy(proxy, id);
                        this.objects.pop();
                        qName = null;
                        ++position;
                        continue;
                    }
                }
                if (id.indexOf(":") != -1) {
                    qName = id;
                    continue;
                }
            }
            if (isFirstID) {
                EReference eOpposite = eReference.getEOpposite();
                mustAdd = eOpposite == null || eOpposite.isTransient() || eReference.isMany();
                mustAddOrNotOppositeIsMany = mustAdd || !eOpposite.isMany();
                isFirstID = false;
            }
            if (mustAddOrNotOppositeIsMany && (resolvedEObject = this.xmlResource.getEObject(id)) != null) {
                this.setFeatureValue(object, (EStructuralFeature)eReference, resolvedEObject);
                qName = null;
                ++position;
                continue;
            }
            if (mustAdd) {
                if (size == this.capacity) {
                    this.growArrays();
                }
                this.identifiers[size] = id;
                this.positions[size] = position;
                ++size;
            }
            qName = null;
            ++position;
        }
        if (position == 0) {
            this.setFeatureValue(object, (EStructuralFeature)eReference, null, -2);
            return;
        }
        if (size > 5) {
            Object[] values = new Object[size];
            int[] currentPositions = new int[size];
            System.arraycopy(this.identifiers, 0, values, 0, size);
            System.arraycopy(this.positions, 0, currentPositions, 0, size);
            ManyReference ref = new ManyReference(object, (EStructuralFeature)eReference, values, currentPositions, this.getLineNumber(), this.getColumnNumber());
            this.forwardManyReferences.add(ref);
            return;
        }
        int i = 0;
        while (i < size) {
            SingleReference ref = new SingleReference(object, (EStructuralFeature)eReference, this.identifiers[i], this.positions[i], this.getLineNumber(), this.getColumnNumber());
            this.forwardSingleReferences.add(ref);
            ++i;
        }
    }

    protected void handleProxy(InternalEObject proxy, String uriLiteral) {
        if (this.oldStyleProxyURIs) {
            proxy.eSetProxyURI(URI.createURI((String)(uriLiteral.startsWith("/") ? uriLiteral : "/" + uriLiteral)));
        } else {
            URI uri = URI.createDeviceURI((String)uriLiteral);
            if (this.resolve && uri.isRelative() && uri.hasRelativePath() && !EPackage.Registry.INSTANCE.containsKey(uri.trimFragment().toString())) {
                uri = this.helper.resolve(uri, this.resourceURI);
            }
            proxy.eSetProxyURI(uri);
        }
    }

    protected void growArrays() {
        int oldCapacity = this.capacity;
        this.capacity *= 2;
        Object[] newIdentifiers = new Object[this.capacity];
        int[] newPositions = new int[this.capacity];
        System.arraycopy(this.identifiers, 0, newIdentifiers, 0, oldCapacity);
        System.arraycopy(this.positions, 0, newPositions, 0, oldCapacity);
        this.identifiers = newIdentifiers;
        this.positions = newPositions;
    }

    protected boolean isError() {
        return this.types.peek() == ERROR_TYPE;
    }

    protected EStructuralFeature getFeature(EObject object, String prefix, String name) {
        EClass eClass;
        this.eClassFeatureNamePair.eClass = eClass = object.eClass();
        this.eClassFeatureNamePair.featureName = name;
        EStructuralFeature result = (EStructuralFeature)this.eClassFeatureNamePairToEStructuralFeatureMap.get(this.eClassFeatureNamePair);
        if (result == null) {
            result = this.helper.getFeature(eClass, this.helper.getURI(prefix), name);
            EClassFeatureNamePair entry = new EClassFeatureNamePair();
            entry.eClass = eClass;
            entry.featureName = name;
            this.eClassFeatureNamePairToEStructuralFeatureMap.put(entry, result);
        }
        return result;
    }

    public static String getXMLEncoding(byte[] bytes) {
        int lastQuoteIndex;
        String javaEncoding = null;
        if (bytes.length >= 4) {
            if (bytes[0] == -2 && bytes[1] == -1 || bytes[0] == 0 && bytes[1] == 60) {
                javaEncoding = "UnicodeBig";
            } else if (bytes[0] == -1 && bytes[1] == -2 || bytes[0] == 60 && bytes[1] == 0) {
                javaEncoding = "UnicodeLittle";
            } else if (bytes[0] == -17 && bytes[1] == -69 && bytes[2] == -65) {
                javaEncoding = "UTF8";
            }
        }
        String header = null;
        try {
            header = javaEncoding != null ? new String(bytes, 0, bytes.length, javaEncoding) : new String(bytes, 0, bytes.length);
        }
        catch (UnsupportedEncodingException e) {
            return null;
        }
        if (!header.startsWith("<?xml")) {
            return "UTF-8";
        }
        int endOfXMLPI = header.indexOf("?>");
        int encodingIndex = header.indexOf("encoding", 6);
        if (encodingIndex == -1 || encodingIndex > endOfXMLPI) {
            return "UTF-8";
        }
        int firstQuoteIndex = header.indexOf("\"", encodingIndex);
        if (firstQuoteIndex == -1 || firstQuoteIndex > endOfXMLPI) {
            firstQuoteIndex = header.indexOf("'", encodingIndex);
            lastQuoteIndex = header.indexOf("'", firstQuoteIndex + 1);
        } else {
            lastQuoteIndex = header.indexOf("\"", firstQuoteIndex + 1);
        }
        return header.substring(firstQuoteIndex + 1, lastQuoteIndex);
    }

    static class EClassFeatureNamePair {
        public EClass eClass;
        public String featureName;

        EClassFeatureNamePair() {
        }

        public boolean equals(Object that) {
            EClassFeatureNamePair typedThat = (EClassFeatureNamePair)that;
            return typedThat.eClass == this.eClass && typedThat.featureName == this.featureName;
        }

        public int hashCode() {
            return this.eClass.hashCode() ^ this.featureName.hashCode();
        }
    }

    protected static class ManyReference
    implements XMLHelper.ManyReference {
        private EObject object;
        private EStructuralFeature feature;
        private Object[] values;
        private int[] positions;
        private int lineNumber;
        private int columnNumber;

        ManyReference(EObject object, EStructuralFeature feature, Object[] values, int[] positions, int lineNumber, int columnNumber) {
            this.object = object;
            this.feature = feature;
            this.values = values;
            this.positions = positions;
            this.lineNumber = lineNumber;
            this.columnNumber = columnNumber;
        }

        public EObject getObject() {
            return this.object;
        }

        public EStructuralFeature getFeature() {
            return this.feature;
        }

        public Object[] getValues() {
            return this.values;
        }

        public int[] getPositions() {
            return this.positions;
        }

        public int getLineNumber() {
            return this.lineNumber;
        }

        public int getColumnNumber() {
            return this.columnNumber;
        }
    }

    protected static class SingleReference {
        private EObject object;
        private EStructuralFeature feature;
        private Object value;
        private int position;
        private int lineNumber;
        private int columnNumber;

        public SingleReference(EObject object, EStructuralFeature feature, Object value, int position, int lineNumber, int columnNumber) {
            this.object = object;
            this.feature = feature;
            this.value = value;
            this.position = position;
            this.lineNumber = lineNumber;
            this.columnNumber = columnNumber;
        }

        public EObject getObject() {
            return this.object;
        }

        public EStructuralFeature getFeature() {
            return this.feature;
        }

        public Object getValue() {
            return this.value;
        }

        public int getPosition() {
            return this.position;
        }

        public int getLineNumber() {
            return this.lineNumber;
        }

        public int getColumnNumber() {
            return this.columnNumber;
        }
    }

    protected static class MyStack
    extends ArrayList {
        public Object peek() {
            int size = this.size();
            return size == 0 ? null : this.get(size - 1);
        }

        public void push(Object o) {
            this.add(o);
        }

        public Object pop() {
            int size = this.size();
            return size == 0 ? null : this.remove(size - 1);
        }
    }
}

