/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.ecore.xmi.impl;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Map;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.xmi.XMIException;
import org.eclipse.emf.ecore.xmi.XMLHelper;
import org.eclipse.emf.ecore.xmi.XMLLoad;
import org.eclipse.emf.ecore.xmi.XMLResource;
import org.eclipse.emf.ecore.xmi.impl.SAXWrapper;
import org.eclipse.emf.ecore.xmi.impl.SAXXMLHandler;
import org.eclipse.emf.ecore.xmi.impl.XMLHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class XMLLoadImpl
implements XMLLoad {
    protected static final int BUFFER_SIZE = 200;
    protected XMLResource resource;
    protected InputStream is;
    protected XMLHelper helper;
    protected Map options;

    public XMLLoadImpl(XMLHelper helper) {
        this.helper = helper;
    }

    public void load(XMLResource resource, InputStream inputStream, Map options) throws IOException {
        this.resource = resource;
        this.is = inputStream;
        this.options = options;
        try {
            SAXParser parser = this.makeParser();
            String encoding = this.getEncoding();
            resource.setEncoding(encoding);
            InputSource inputSource = new InputSource(this.is);
            String resourceURI = resource.getURI().toString();
            inputSource.setPublicId(resourceURI);
            inputSource.setSystemId(resourceURI);
            parser.parse(inputSource, this.makeDefaultHandler());
            this.helper = null;
            if (!resource.getErrors().isEmpty()) {
                XMIException exception;
                Exception error = (Exception)resource.getErrors().get(0);
                if (error instanceof XMIException && (exception = (XMIException)error).getWrappedException() != null) {
                    throw new Resource.IOWrappedException(exception.getWrappedException());
                }
                throw new Resource.IOWrappedException(error);
            }
        }
        catch (SAXException exception) {
            if (exception.getException() != null) {
                throw new Resource.IOWrappedException(exception.getException());
            }
            throw new Resource.IOWrappedException((Exception)exception);
        }
        catch (ParserConfigurationException exception) {
            throw new Resource.IOWrappedException((Exception)exception);
        }
    }

    protected SAXParser makeParser() throws ParserConfigurationException, SAXException {
        SAXParserFactory f = SAXParserFactory.newInstance();
        f.setValidating(false);
        return f.newSAXParser();
    }

    protected DefaultHandler makeDefaultHandler() {
        return new SAXWrapper(new SAXXMLHandler(this.resource, this.helper, this.options));
    }

    protected String getEncoding() throws IOException {
        if (!this.is.markSupported()) {
            this.is = new BufferedInputStream(this.is);
        }
        byte[] buffer = this.readBuffer();
        return XMLHandler.getXMLEncoding(buffer);
    }

    protected byte[] readBuffer() throws IOException {
        int bytesRead;
        byte[] buffer = new byte[200];
        this.is.mark(200);
        int totalBytesRead = bytesRead = this.is.read(buffer, 0, 200);
        while (bytesRead != -1 && totalBytesRead < 200) {
            bytesRead = this.is.read(buffer, totalBytesRead, 200 - totalBytesRead);
            if (bytesRead == -1) continue;
            totalBytesRead += bytesRead;
        }
        if (totalBytesRead < 200) {
            byte[] smallerBuffer = new byte[totalBytesRead];
            System.arraycopy(buffer, 0, smallerBuffer, 0, totalBytesRead);
            smallerBuffer = buffer;
        }
        this.is.reset();
        return buffer;
    }
}

