/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.ecore.xmi.impl;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.emf.common.util.EMap;
import org.eclipse.emf.ecore.EAnnotation;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.ENamedElement;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.xmi.XMLResource;
import org.eclipse.emf.ecore.xmi.impl.XMLInfoImpl;

public class XMLMapImpl
implements XMLResource.XMLMap {
    protected static final String XSD2ECORE = "http:///org/eclipse/emf/mapping/xsd2ecore/XSD2Ecore";
    protected Map ecoreToXMLInfo = new HashMap();
    protected EPackage noNamespacePkg;
    protected String idAttributeName;
    protected Map urisToNamesToClassifiers;

    public void add(ENamedElement element, XMLResource.XMLInfo info) {
        this.ecoreToXMLInfo.put(element, info);
    }

    public XMLResource.XMLInfo getInfo(ENamedElement element) {
        XMLResource.XMLInfo result = (XMLResource.XMLInfo)this.ecoreToXMLInfo.get(element);
        if (result == null) {
            Iterator i = element.getEAnnotations().iterator();
            while (i.hasNext()) {
                EAnnotation eAnnotation = (EAnnotation)i.next();
                if (!XSD2ECORE.equals(eAnnotation.getSource())) continue;
                result = new XMLInfoImpl();
                EMap details = eAnnotation.getDetails();
                result.setName((String)details.get((Object)"name"));
                result.setTargetNamespace((String)details.get((Object)"targetNamespace"));
                String representation = (String)details.get((Object)"representation");
                if ("element".equals(representation)) {
                    result.setXMLRepresentation(0);
                    continue;
                }
                if ("attribute".equals(representation)) {
                    result.setXMLRepresentation(1);
                    continue;
                }
                if (!"simple-content".equals(representation)) continue;
                result.setXMLRepresentation(2);
            }
            if (result != null) {
                this.ecoreToXMLInfo.put(element, result);
            }
        }
        return result;
    }

    public void setNoNamespacePackage(EPackage pkg) {
        this.noNamespacePkg = pkg;
    }

    public EPackage getNoNamespacePackage() {
        return this.noNamespacePkg;
    }

    public void setIDAttributeName(String name) {
        this.idAttributeName = name;
    }

    public String getIDAttributeName() {
        return this.idAttributeName;
    }

    public EClassifier getClassifier(String namespaceURI, String name) {
        Map namesToClassifiers;
        if (this.urisToNamesToClassifiers == null) {
            this.urisToNamesToClassifiers = new HashMap();
            this.getInfoForClassifiers(namespaceURI);
            Iterator i = this.ecoreToXMLInfo.entrySet().iterator();
            while (i.hasNext()) {
                Map.Entry entry = i.next();
                Object key = entry.getKey();
                XMLResource.XMLInfo info = (XMLResource.XMLInfo)entry.getValue();
                String uri = info.getTargetNamespace();
                if (!(key instanceof EClassifier) || info.getName() == null || uri == null) continue;
                HashMap namesToClassifiers2 = (HashMap)this.urisToNamesToClassifiers.get(uri);
                if (namesToClassifiers2 == null) {
                    namesToClassifiers2 = new HashMap();
                    this.urisToNamesToClassifiers.put(uri, namesToClassifiers2);
                }
                namesToClassifiers2.put(info.getName(), key);
            }
        }
        if ((namesToClassifiers = (Map)this.urisToNamesToClassifiers.get(namespaceURI)) != null) {
            return (EClassifier)namesToClassifiers.get(name);
        }
        return null;
    }

    private void getInfoForClassifiers(String namespaceURI) {
        EPackage pkg = EPackage.Registry.INSTANCE.getEPackage(namespaceURI);
        if (pkg != null) {
            Iterator i = pkg.getEClassifiers().iterator();
            while (i.hasNext()) {
                this.getInfo((ENamedElement)i.next());
            }
        }
    }

    public EStructuralFeature getFeature(EClass eClass, String namespaceURI, String name) {
        Iterator i = eClass.getEAllStructuralFeatures().iterator();
        while (i.hasNext()) {
            EStructuralFeature feature = (EStructuralFeature)i.next();
            XMLResource.XMLInfo info = this.getInfo((ENamedElement)feature);
            if (info == null) continue;
            String infoURI = info.getTargetNamespace();
            String infoName = info.getName();
            if (!(namespaceURI == null ? infoURI == null && name.equals(infoName) : namespaceURI.equals(infoURI) && name.equals(infoName))) continue;
            return feature;
        }
        return null;
    }
}

