/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.ecore.xmi.impl;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeMap;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.impl.ResourceImpl;
import org.eclipse.emf.ecore.xmi.XMLHelper;
import org.eclipse.emf.ecore.xmi.XMLLoad;
import org.eclipse.emf.ecore.xmi.XMLResource;
import org.eclipse.emf.ecore.xmi.XMLSave;
import org.eclipse.emf.ecore.xmi.impl.XMLHelperImpl;
import org.eclipse.emf.ecore.xmi.impl.XMLLoadImpl;
import org.eclipse.emf.ecore.xmi.impl.XMLSaveImpl;

public class XMLResourceImpl
extends ResourceImpl
implements XMLResource {
    protected Map idToEObjectMap;
    protected Map eObjectToIDMap;
    protected String encoding;
    protected boolean useZip;
    protected XMLLoad xmlLoad;
    protected XMLSaveImpl xmlSave;

    public XMLResourceImpl() {
        this.init();
    }

    public XMLResourceImpl(URI uri) {
        super(uri);
        this.init();
    }

    protected void init() {
        this.encoding = "ASCII";
    }

    protected boolean useIDs() {
        return true;
    }

    public Map getDefaultSaveOptions() {
        if (this.defaultSaveOptions == null) {
            this.defaultSaveOptions = new HashMap();
        }
        return this.defaultSaveOptions;
    }

    public Map getDefaultLoadOptions() {
        if (this.defaultLoadOptions == null) {
            this.defaultLoadOptions = new HashMap();
        }
        return this.defaultLoadOptions;
    }

    protected XMLHelper createXMLHelper() {
        return new XMLHelperImpl(this);
    }

    protected XMLLoad createXMLLoad() {
        return new XMLLoadImpl(this.createXMLHelper());
    }

    protected XMLSave createXMLSave() {
        return new XMLSaveImpl(this.createXMLHelper());
    }

    public void doLoad(InputStream inputStream, Map options) throws IOException {
        XMLLoad xmlLoad = this.createXMLLoad();
        if (options == null) {
            options = Collections.EMPTY_MAP;
        }
        xmlLoad.load(this, inputStream, options);
    }

    public void doSave(OutputStream outputStream, Map options) throws IOException {
        XMLSave xmlSave = this.createXMLSave();
        if (options == null) {
            options = Collections.EMPTY_MAP;
        }
        xmlSave.save(this, outputStream, options);
    }

    public boolean useZip() {
        return this.useZip;
    }

    public void setUseZip(boolean useZip) {
        this.useZip = useZip;
    }

    public String getEncoding() {
        return this.encoding;
    }

    public void setEncoding(String encoding) {
        this.encoding = encoding;
    }

    public Map getIDToEObjectMap() {
        if (this.idToEObjectMap == null) {
            this.idToEObjectMap = new HashMap();
        }
        return this.idToEObjectMap;
    }

    public Map getEObjectToIDMap() {
        if (this.eObjectToIDMap == null) {
            this.eObjectToIDMap = new HashMap();
        }
        return this.eObjectToIDMap;
    }

    public String getID(EObject eObject) {
        if (this.eObjectToIDMap == null) {
            return null;
        }
        return (String)this.eObjectToIDMap.get(eObject);
    }

    public void setID(EObject eObject, String id) {
        this.getEObjectToIDMap().put(eObject, id);
        this.getIDToEObjectMap().put(id, eObject);
    }

    public String getURIFragment(EObject eObject) {
        String id = this.getID(eObject);
        if (id != null) {
            return id;
        }
        return super.getURIFragment(eObject);
    }

    protected EObject getEObjectByID(String id) {
        EObject eObject;
        if (this.idToEObjectMap != null && (eObject = (EObject)this.idToEObjectMap.get(id)) != null) {
            return eObject;
        }
        return super.getEObjectByID(id);
    }

    protected boolean isPath(String uriFragment) {
        return uriFragment.startsWith("/");
    }

    public void attached(EObject eObject) {
        if (this.useIDs()) {
            String id;
            if (this.modificationTrackingAdapter != null) {
                eObject.eAdapters().add(this.modificationTrackingAdapter);
            }
            if ((id = this.getID(eObject)) != null) {
                this.getIDToEObjectMap().put(id, eObject);
            }
            TreeIterator tree = eObject.eAllContents();
            while (tree.hasNext()) {
                EObject child = (EObject)tree.next();
                String childID = this.getID(child);
                if (childID != null) {
                    this.getIDToEObjectMap().put(childID, child);
                }
                if (this.modificationTrackingAdapter == null) continue;
                child.eAdapters().add(this.modificationTrackingAdapter);
            }
        } else {
            super.attached(eObject);
        }
    }

    public void detached(EObject eObject) {
        if (this.useIDs()) {
            eObject.eAdapters().remove(this.modificationTrackingAdapter);
            if (this.idToEObjectMap != null && this.eObjectToIDMap != null) {
                this.idToEObjectMap.remove(this.eObjectToIDMap.remove(eObject));
            }
            TreeIterator tree = eObject.eAllContents();
            while (tree.hasNext()) {
                EObject child = (EObject)tree.next();
                if (this.idToEObjectMap != null && this.eObjectToIDMap != null) {
                    this.idToEObjectMap.remove(this.eObjectToIDMap.remove(child));
                }
                child.eAdapters().remove(this.modificationTrackingAdapter);
            }
        } else {
            super.detached(eObject);
        }
    }

    protected void doUnload() {
        super.doUnload();
        if (this.idToEObjectMap != null) {
            this.idToEObjectMap.clear();
        }
        if (this.eObjectToIDMap != null) {
            this.eObjectToIDMap.clear();
        }
    }

    public void changed(EObject eObject, String oldID) {
        this.idToEObjectMap.remove(oldID);
        this.idToEObjectMap.put(this.getID(eObject), eObject);
    }

    public String toKeyString() {
        StringBuffer result = new StringBuffer("Key type: ");
        result.append(this.getClass().toString());
        if (this.idToEObjectMap != null) {
            TreeMap tree = new TreeMap();
            Iterator i = this.idToEObjectMap.keySet().iterator();
            while (i.hasNext()) {
                Object key = i.next();
                if (key == null) continue;
                tree.put(key.toString(), key);
            }
            Iterator i2 = tree.values().iterator();
            while (i2.hasNext()) {
                Object key = i2.next();
                Object value = this.idToEObjectMap.get(key);
                result.append("\r\n\t[Key=" + key + ", Value=" + value + "]");
            }
        }
        return result.toString();
    }
}

