/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.ecore.impl;

import java.util.Collection;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.NotificationChain;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EDataType;
import org.eclipse.emf.ecore.EFactory;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.EcorePackage;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.impl.ENamedElementImpl;
import org.eclipse.emf.ecore.impl.ENotificationImpl;
import org.eclipse.emf.ecore.impl.ETypedElementImpl;
import org.eclipse.emf.ecore.util.EcoreDynamicEList;
import org.eclipse.emf.ecore.util.InternalEList;

public abstract class EStructuralFeatureImpl
extends ETypedElementImpl
implements EStructuralFeature {
    protected int featureID = -1;
    protected Class containerClass;
    protected Object defaultValue = null;
    protected EFactory defaultValueFactory = null;
    protected static final boolean CHANGEABLE_EDEFAULT = true;
    protected boolean changeable = true;
    protected static final boolean VOLATILE_EDEFAULT = false;
    protected boolean volatile_ = false;
    protected static final boolean TRANSIENT_EDEFAULT = false;
    protected boolean transient_ = false;
    protected static final boolean UNIQUE_EDEFAULT = true;
    protected boolean unique = true;
    protected static final String DEFAULT_VALUE_LITERAL_EDEFAULT = null;
    protected String defaultValueLiteral = DEFAULT_VALUE_LITERAL_EDEFAULT;
    protected static final int LOWER_BOUND_EDEFAULT = 0;
    protected int lowerBound = 0;
    protected static final int UPPER_BOUND_EDEFAULT = 1;
    protected int upperBound = 1;
    protected static final boolean UNSETTABLE_EDEFAULT = false;
    protected boolean unsettable = false;

    protected EStructuralFeatureImpl() {
    }

    protected EClass eStaticClass() {
        return EcorePackage.eINSTANCE.getEStructuralFeature();
    }

    public Object getDefaultValue() {
        EClassifier eType = this.getEType();
        String literal = this.getDefaultValueLiteral();
        if (literal == null && eType != null) {
            return eType.getDefaultValue();
        }
        if (eType instanceof EDataType) {
            EFactory factory = eType.getEPackage().getEFactoryInstance();
            if (factory != this.defaultValueFactory) {
                this.defaultValueFactory = factory;
                this.defaultValue = factory.createFromString((EDataType)eType, literal);
            }
            return this.defaultValue;
        }
        return null;
    }

    public void setDefaultValue(Object newDefaultValue) {
        EClassifier eType = this.getEType();
        if (eType instanceof EDataType) {
            EFactory factory = eType.getEPackage().getEFactoryInstance();
            String literal = factory.convertToString((EDataType)eType, newDefaultValue);
            this.defaultValueFactory = null;
            this.setDefaultValueLiteralGen(literal);
            return;
        }
        throw new IllegalStateException("Cannot serialize value to object without an EDataType eType");
    }

    public void setDefaultValueLiteral(String newDefaultValueLiteral) {
        this.defaultValueFactory = null;
        this.setDefaultValueLiteralGen(newDefaultValueLiteral);
    }

    public void setDefaultValueLiteralGen(String newDefaultValueLiteral) {
        String oldDefaultValueLiteral = this.defaultValueLiteral;
        this.defaultValueLiteral = newDefaultValueLiteral;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 7, (Object)oldDefaultValueLiteral, (Object)this.defaultValueLiteral));
        }
    }

    public boolean isMany() {
        int upper = this.getUpperBound();
        return upper > 1 || upper == -1;
    }

    public boolean isRequired() {
        int lower = this.getLowerBound();
        return lower >= 1;
    }

    public boolean isUnsettable() {
        return this.unsettable;
    }

    public void setUnsettable(boolean newUnsettable) {
        boolean oldUnsettable = this.unsettable;
        this.unsettable = newUnsettable;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 13, oldUnsettable, this.unsettable));
        }
    }

    public Object eGet(EStructuralFeature eFeature, boolean resolve) {
        switch (this.eDerivedStructuralFeatureID(eFeature.getFeatureID(), eFeature.getContainerClass())) {
            case 0: {
                return this.getEAnnotations();
            }
            case 1: {
                return this.getName();
            }
            case 2: {
                if (resolve) {
                    return this.getEType();
                }
                return this.basicGetEType();
            }
            case 3: {
                return this.isChangeable() ? Boolean.TRUE : Boolean.FALSE;
            }
            case 4: {
                return this.isVolatile() ? Boolean.TRUE : Boolean.FALSE;
            }
            case 5: {
                return this.isTransient() ? Boolean.TRUE : Boolean.FALSE;
            }
            case 6: {
                return this.isUnique() ? Boolean.TRUE : Boolean.FALSE;
            }
            case 7: {
                return this.getDefaultValueLiteral();
            }
            case 8: {
                return this.getDefaultValue();
            }
            case 9: {
                return new Integer(this.getLowerBound());
            }
            case 10: {
                return new Integer(this.getUpperBound());
            }
            case 11: {
                return this.isMany() ? Boolean.TRUE : Boolean.FALSE;
            }
            case 12: {
                return this.isRequired() ? Boolean.TRUE : Boolean.FALSE;
            }
            case 13: {
                return this.isUnsettable() ? Boolean.TRUE : Boolean.FALSE;
            }
            case 14: {
                return this.getEContainingClass();
            }
        }
        return this.eDynamicGet(eFeature, resolve);
    }

    public boolean eIsSet(EStructuralFeature eFeature) {
        switch (this.eDerivedStructuralFeatureID(eFeature.getFeatureID(), eFeature.getContainerClass())) {
            case 0: {
                return this.eAnnotations != null && !this.eAnnotations.isEmpty();
            }
            case 1: {
                return ENamedElementImpl.NAME_EDEFAULT == null ? this.name != null : !ENamedElementImpl.NAME_EDEFAULT.equals(this.name);
            }
            case 2: {
                return this.eType != null;
            }
            case 3: {
                return !this.changeable;
            }
            case 4: {
                return this.volatile_;
            }
            case 5: {
                return this.transient_;
            }
            case 6: {
                return !this.unique;
            }
            case 7: {
                return DEFAULT_VALUE_LITERAL_EDEFAULT == null ? this.defaultValueLiteral != null : !DEFAULT_VALUE_LITERAL_EDEFAULT.equals(this.defaultValueLiteral);
            }
            case 8: {
                return this.getDefaultValue() != null;
            }
            case 9: {
                return this.lowerBound != 0;
            }
            case 10: {
                return this.upperBound != 1;
            }
            case 11: {
                return this.isMany();
            }
            case 12: {
                return this.isRequired();
            }
            case 13: {
                return this.unsettable;
            }
            case 14: {
                return this.getEContainingClass() != null;
            }
        }
        return this.eDynamicIsSet(eFeature);
    }

    public void eSet(EStructuralFeature eFeature, Object newValue) {
        switch (this.eDerivedStructuralFeatureID(eFeature.getFeatureID(), eFeature.getContainerClass())) {
            case 0: {
                this.getEAnnotations().clear();
                this.getEAnnotations().addAll((Collection)newValue);
                return;
            }
            case 1: {
                this.setName((String)newValue);
                return;
            }
            case 2: {
                this.setEType((EClassifier)newValue);
                return;
            }
            case 3: {
                this.setChangeable((Boolean)newValue);
                return;
            }
            case 4: {
                this.setVolatile((Boolean)newValue);
                return;
            }
            case 5: {
                this.setTransient((Boolean)newValue);
                return;
            }
            case 6: {
                this.setUnique((Boolean)newValue);
                return;
            }
            case 7: {
                this.setDefaultValueLiteral((String)newValue);
                return;
            }
            case 9: {
                this.setLowerBound((Integer)newValue);
                return;
            }
            case 10: {
                this.setUpperBound((Integer)newValue);
                return;
            }
            case 13: {
                this.setUnsettable((Boolean)newValue);
                return;
            }
        }
        this.eDynamicSet(eFeature, newValue);
    }

    public void eUnset(EStructuralFeature eFeature) {
        switch (this.eDerivedStructuralFeatureID(eFeature.getFeatureID(), eFeature.getContainerClass())) {
            case 0: {
                this.getEAnnotations().clear();
                return;
            }
            case 1: {
                this.setName(ENamedElementImpl.NAME_EDEFAULT);
                return;
            }
            case 2: {
                this.setEType(null);
                return;
            }
            case 3: {
                this.setChangeable(true);
                return;
            }
            case 4: {
                this.setVolatile(false);
                return;
            }
            case 5: {
                this.setTransient(false);
                return;
            }
            case 6: {
                this.setUnique(true);
                return;
            }
            case 7: {
                this.setDefaultValueLiteral(DEFAULT_VALUE_LITERAL_EDEFAULT);
                return;
            }
            case 9: {
                this.setLowerBound(0);
                return;
            }
            case 10: {
                this.setUpperBound(1);
                return;
            }
            case 13: {
                this.setUnsettable(false);
                return;
            }
        }
        this.eDynamicUnset(eFeature);
    }

    public boolean isTransient() {
        return this.transient_;
    }

    public void setTransient(boolean newTransient) {
        boolean oldTransient = this.transient_;
        this.transient_ = newTransient;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 5, oldTransient, this.transient_));
        }
    }

    public boolean isVolatile() {
        return this.volatile_;
    }

    public void setVolatile(boolean newVolatile) {
        boolean oldVolatile = this.volatile_;
        this.volatile_ = newVolatile;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 4, oldVolatile, this.volatile_));
        }
    }

    public boolean isChangeable() {
        return this.changeable;
    }

    public void setChangeable(boolean newChangeable) {
        boolean oldChangeable = this.changeable;
        this.changeable = newChangeable;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 3, oldChangeable, this.changeable));
        }
    }

    public boolean isUnique() {
        return this.unique;
    }

    public void setUnique(boolean newUnique) {
        boolean oldUnique = this.unique;
        this.unique = newUnique;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 6, oldUnique, this.unique));
        }
    }

    public String getDefaultValueLiteral() {
        return this.defaultValueLiteral;
    }

    public int getLowerBound() {
        return this.lowerBound;
    }

    public void setLowerBound(int newLowerBound) {
        int oldLowerBound = this.lowerBound;
        this.lowerBound = newLowerBound;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 9, oldLowerBound, this.lowerBound));
        }
    }

    public int getUpperBound() {
        return this.upperBound;
    }

    public void setUpperBound(int newUpperBound) {
        int oldUpperBound = this.upperBound;
        this.upperBound = newUpperBound;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 10, oldUpperBound, this.upperBound));
        }
    }

    public String toString() {
        if (this.eIsProxy()) {
            return super.toString();
        }
        StringBuffer result = new StringBuffer(super.toString());
        result.append(" (changeable: ");
        result.append(this.changeable);
        result.append(", volatile: ");
        result.append(this.volatile_);
        result.append(", transient: ");
        result.append(this.transient_);
        result.append(", unique: ");
        result.append(this.unique);
        result.append(", defaultValueLiteral: ");
        result.append(this.defaultValueLiteral);
        result.append(", lowerBound: ");
        result.append(this.lowerBound);
        result.append(", upperBound: ");
        result.append(this.upperBound);
        result.append(", unsettable: ");
        result.append(this.unsettable);
        result.append(')');
        return result.toString();
    }

    public int getFeatureID() {
        return this.featureID;
    }

    public void setFeatureID(int featureID) {
        this.featureID = featureID;
    }

    public Class getContainerClass() {
        return this.containerClass;
    }

    public NotificationChain eInverseAdd(InternalEObject otherEnd, int featureID, Class baseClass, NotificationChain msgs) {
        if (featureID >= 0) {
            switch (this.eDerivedStructuralFeatureID(featureID, baseClass)) {
                case 0: {
                    return ((InternalEList)this.getEAnnotations()).basicAdd(otherEnd, msgs);
                }
            }
            return this.eDynamicInverseAdd(otherEnd, featureID, baseClass, msgs);
        }
        if (this.eContainer != null) {
            msgs = this.eBasicRemoveFromContainer(msgs);
        }
        return this.eBasicSetContainer(otherEnd, featureID, msgs);
    }

    public NotificationChain eInverseRemove(InternalEObject otherEnd, int featureID, Class baseClass, NotificationChain msgs) {
        if (featureID >= 0) {
            switch (baseClass == null ? featureID : this.eDerivedStructuralFeatureID(featureID, baseClass)) {
                case 0: {
                    return ((InternalEList)this.getEAnnotations()).basicRemove(otherEnd, msgs);
                }
            }
            return this.eDynamicInverseRemove(otherEnd, featureID, baseClass, msgs);
        }
        return this.eBasicSetContainer(null, featureID, msgs);
    }

    public void setContainerClass(Class containerClass) {
        this.containerClass = containerClass;
    }

    public EClass getEContainingClass() {
        return null;
    }

    public EStructuralFeature.Setting createDynamicSetting(InternalEObject internalEObject) {
        return new EcoreDynamicEList(this, internalEObject);
    }
}

