/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.ecore.plugin;

import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPluginDescriptor;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.common.util.WrappedException;
import org.eclipse.emf.ecore.plugin.ExtensionParserRegistryReader;
import org.eclipse.emf.ecore.plugin.GeneratedPackageRegistryReader;
import org.eclipse.emf.ecore.plugin.ProtocolParserRegistryReader;
import org.eclipse.emf.ecore.plugin.URIMappingRegistryReader;

public class EcorePlugin {
    private static Map platformResourceMap;
    private static Implementation plugin;
    private static IWorkspaceRoot workspaceRoot;
    static final String GENERATED_PACKAGE_PPID = "generated_package";
    static final String EXTENSION_PARSER_PPID = "extension_parser";
    static final String PROTOCOL_PARSER_PPID = "protocol_parser";
    static final String SCHEME_PARSER_PPID = "scheme_parser";
    static final String URI_MAPPING_PPID = "uri_mapping";

    public static Map getPlatformResourceMap() {
        if (platformResourceMap == null) {
            platformResourceMap = new HashMap();
        }
        return platformResourceMap;
    }

    public static URI resolvePlatformResourcePath(String platformResourcePath) {
        int index = platformResourcePath.indexOf("/", 1);
        String rootContainerName = platformResourcePath.substring(1, index);
        String relativeName = platformResourcePath.substring(index + 1);
        URI rootContainerLocation = (URI)platformResourceMap.get(rootContainerName);
        return rootContainerLocation != null ? URI.createURI((String)relativeName).resolve(rootContainerLocation) : null;
    }

    public static String[] handlePlatformResourceOptions(String[] arguments) {
        EcorePlugin.getPlatformResourceMap();
        int i = 0;
        while (i < arguments.length) {
            if (arguments[i].equalsIgnoreCase("-platformResource")) {
                int start = i;
                while (++i < arguments.length && !arguments[i].startsWith("-")) {
                    URI uri;
                    String rootContainerName = arguments[i];
                    if (++i >= arguments.length) continue;
                    String rootContainerLocation = arguments[i];
                    File file = new File(rootContainerLocation);
                    if (file.isDirectory() || !file.exists() && file.getParent() != null && file.getParentFile().isDirectory()) {
                        try {
                            file = file.getCanonicalFile();
                        }
                        catch (IOException exception) {
                            throw new WrappedException((Exception)exception);
                        }
                        uri = URI.createFileURI((String)(file.toString() + "/"));
                    } else {
                        uri = URI.createDeviceURI((String)rootContainerLocation);
                    }
                    platformResourceMap.put(rootContainerName, uri);
                }
                String[] remainingArguments = new String[arguments.length - (i - start)];
                System.arraycopy(arguments, 0, remainingArguments, 0, start);
                System.arraycopy(arguments, i, remainingArguments, start, arguments.length - i);
                return remainingArguments;
            }
            ++i;
        }
        return arguments;
    }

    public static Implementation getPlugin() {
        return plugin;
    }

    public static IWorkspaceRoot getWorkspaceRoot() {
        return workspaceRoot;
    }

    public static class Implementation
    extends Plugin {
        public Implementation(IPluginDescriptor descriptor) {
            super(descriptor);
            plugin = this;
        }

        public void startup() throws CoreException {
            super.startup();
            workspaceRoot = ResourcesPlugin.getWorkspace().getRoot();
            new GeneratedPackageRegistryReader().readRegistry();
            new ExtensionParserRegistryReader().readRegistry();
            new ProtocolParserRegistryReader().readRegistry();
            new URIMappingRegistryReader().readRegistry();
        }
    }
}

