/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.ecore.util;

import java.lang.reflect.Array;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.NotificationChain;
import org.eclipse.emf.common.notify.impl.NotifyingListImpl;
import org.eclipse.emf.common.util.BasicEList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.impl.ENotificationImpl;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.ecore.util.InternalEList;

public class EcoreEList
extends NotifyingListImpl
implements InternalEList,
EStructuralFeature.Setting.Internal {
    protected Class dataClass;
    protected InternalEObject owner;

    public EcoreEList(Class dataClass, InternalEObject owner) {
        this.dataClass = dataClass;
        this.owner = owner;
    }

    protected Object[] newData(int capacity) {
        return (Object[])Array.newInstance(this.dataClass, capacity);
    }

    public Object getNotifier() {
        return this.owner;
    }

    public Object getFeature() {
        return this.getEStructuralFeature();
    }

    public int getFeatureID() {
        return this.getEStructuralFeature().getFeatureID();
    }

    public EStructuralFeature getEStructuralFeature() {
        return this.owner.eClass().getEStructuralFeature(this.getFeatureID());
    }

    public EStructuralFeature getInverseEStructuralFeature() {
        return ((EReference)this.getEStructuralFeature()).getEOpposite();
    }

    public int getInverseFeatureID() {
        return this.getInverseEStructuralFeature().getFeatureID();
    }

    public Class getInverseFeatureClass() {
        return ((EClass)this.getInverseEStructuralFeature().getEType()).getInstanceClass();
    }

    protected boolean hasManyInverse() {
        return false;
    }

    protected boolean hasNavigableInverse() {
        return false;
    }

    protected boolean isEObject() {
        return true;
    }

    protected boolean isContainment() {
        return false;
    }

    protected boolean hasProxies() {
        return false;
    }

    protected Object resolve(int index, Object object) {
        EObject resolved;
        if (this.isEObject() && this.hasProxies() && (resolved = this.resolveProxy((EObject)object)) != object) {
            Object oldObject = ((BasicEList)this).data[index];
            this.assign(index, this.validate(index, resolved));
            this.didSet(index, object, oldObject);
            if (this.isNotificationRequired()) {
                this.owner.eNotify((Notification)new ENotificationImpl(this.owner, 9, this.getFeatureID(), object, (Object)resolved, index));
            }
            return resolved;
        }
        return object;
    }

    protected EObject resolveProxy(EObject eObject) {
        return EcoreUtil.resolve(eObject, this.owner);
    }

    public Object[] toArray() {
        if (this.hasProxies()) {
            int i = ((BasicEList)this).size - 1;
            while (i >= 0) {
                this.get(i);
                --i;
            }
        }
        return super.toArray();
    }

    public Object[] toArray(Object[] array) {
        if (this.hasProxies()) {
            int i = ((BasicEList)this).size - 1;
            while (i >= 0) {
                this.get(i);
                --i;
            }
        }
        return super.toArray(array);
    }

    protected Notification createNotification(int eventType, Object oldObject, Object newObject, int index) {
        return new ENotificationImpl(this.owner, eventType, this.getFeatureID(), oldObject, newObject, index);
    }

    protected Notification createNotification(int eventType, boolean oldValue, boolean newValue) {
        return new ENotificationImpl(this.owner, eventType, this.getFeatureID(), oldValue, newValue);
    }

    protected void dispatchNotification(Notification notification) {
        this.owner.eNotify(notification);
    }

    public List basicList() {
        return super.basicList();
    }

    protected boolean isNotificationRequired() {
        return this.owner.eNotificationRequired();
    }

    public NotificationChain inverseAdd(Object object, NotificationChain notifications) {
        InternalEObject internalEObject = (InternalEObject)object;
        if (this.hasNavigableInverse()) {
            return internalEObject.eInverseAdd(this.owner, this.getInverseFeatureID(), this.getInverseFeatureClass(), notifications);
        }
        return internalEObject.eInverseAdd(this.owner, -1 - this.getFeatureID(), null, notifications);
    }

    public NotificationChain inverseRemove(Object object, NotificationChain notifications) {
        InternalEObject internalEObject = (InternalEObject)object;
        if (this.hasNavigableInverse()) {
            return internalEObject.eInverseRemove(this.owner, this.getInverseFeatureID(), this.getInverseFeatureClass(), notifications);
        }
        return internalEObject.eInverseRemove(this.owner, -1 - this.getFeatureID(), null, notifications);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean contains(Object object) {
        if (!this.isEObject()) return super.contains(object);
        if (((BasicEList)this).size > 4) {
            if (this.isContainment()) {
                if (!(object instanceof EObject)) {
                    return false;
                }
                InternalEObject eObject = (InternalEObject)object;
                if (eObject.eContainer() != this.owner) return false;
                if (this.hasNavigableInverse()) {
                    if (eObject.eContainerFeatureID() != this.getInverseFeatureID()) return false;
                    return true;
                }
                if (-1 - eObject.eContainerFeatureID() != this.getFeatureID()) return false;
                return true;
            }
            if (this.hasInverse() && !this.hasManyInverse()) {
                if (!(object instanceof EObject)) return false;
                if (((EObject)object).eGet(this.getInverseEStructuralFeature()) != this.owner) return false;
                return true;
            }
        }
        boolean result = super.contains(object);
        if (!this.hasProxies()) return result;
        if (result) return result;
        int i = 0;
        while (i < ((BasicEList)this).size) {
            EObject eObject = this.resolveProxy((EObject)((BasicEList)this).data[i]);
            if (eObject == object) {
                return true;
            }
            ++i;
        }
        return result;
    }

    public int indexOf(Object object) {
        int index = super.indexOf(object);
        if (index >= 0) {
            return index;
        }
        if (this.isEObject()) {
            int i = 0;
            while (i < ((BasicEList)this).size) {
                EObject eObject = this.resolveProxy((EObject)((BasicEList)this).data[i]);
                if (eObject == object) {
                    return i;
                }
                ++i;
            }
        }
        return -1;
    }

    public int lastIndexOf(Object object) {
        int result = super.lastIndexOf(object);
        if (this.isEObject() && result == -1) {
            int i = ((BasicEList)this).size - 1;
            while (i >= 0) {
                EObject eObject = EcoreUtil.resolve((EObject)((BasicEList)this).data[i], this.owner);
                if (eObject == object) {
                    return i;
                }
                --i;
            }
        }
        return result;
    }

    public Iterator basicIterator() {
        return super.basicIterator();
    }

    public ListIterator basicListIterator() {
        return super.basicListIterator();
    }

    public ListIterator basicListIterator(int index) {
        return super.basicListIterator(index);
    }

    public EObject getEObject() {
        return this.owner;
    }

    public Object get(boolean resolve) {
        return this;
    }

    public void set(Object newValue) {
        this.clear();
        this.addAll((List)newValue);
    }

    public boolean isSet() {
        return !this.isEmpty();
    }

    public void unset() {
        this.clear();
    }

    public static class UnmodifiableEList
    extends BasicEList.UnmodifiableEList
    implements InternalEList,
    EStructuralFeature.Setting.Internal {
        protected InternalEObject owner;
        protected EStructuralFeature eStructuralFeature;

        public UnmodifiableEList(InternalEObject owner, EStructuralFeature eStructuralFeature, int size, Object[] data) {
            super(size, data);
            this.owner = owner;
            this.eStructuralFeature = eStructuralFeature;
        }

        public List basicList() {
            return super.basicList();
        }

        public Iterator basicIterator() {
            return super.basicIterator();
        }

        public ListIterator basicListIterator() {
            return super.basicListIterator();
        }

        public ListIterator basicListIterator(int index) {
            return super.basicListIterator(index);
        }

        public EObject getEObject() {
            return this.owner;
        }

        public EStructuralFeature getEStructuralFeature() {
            return this.eStructuralFeature;
        }

        public Object get(boolean resolve) {
            return this;
        }

        public void set(Object newValue) {
            throw new UnsupportedOperationException();
        }

        public boolean isSet() {
            return !this.isEmpty();
        }

        public void unset() {
            throw new UnsupportedOperationException();
        }

        public NotificationChain basicRemove(Object object, NotificationChain notifications) {
            throw new UnsupportedOperationException();
        }

        public NotificationChain basicAdd(Object object, NotificationChain notifications) {
            throw new UnsupportedOperationException();
        }
    }
}

