/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.ecore.util;

import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.util.AbstractTreeIterator;
import org.eclipse.emf.common.util.ECollections;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EDataType;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.util.EContentsEList;
import org.eclipse.emf.ecore.util.InternalEList;

public class EcoreUtil {
    public static Adapter getExistingAdapter(Notifier notifier, Object type) {
        return EcoreUtil.getAdapter((List)notifier.eAdapters(), type);
    }

    public static Adapter getRegisteredAdapter(EObject eObject, Object type) {
        AdapterFactory factory;
        ResourceSet resourceSet;
        Resource resource;
        Adapter result = EcoreUtil.getExistingAdapter(eObject, type);
        if (result == null && (resource = eObject.eResource()) != null && (resourceSet = resource.getResourceSet()) != null && (factory = EcoreUtil.getAdapterFactory((List)resourceSet.getAdapterFactories(), type)) != null) {
            result = factory.adaptNew((Notifier)eObject, type);
        }
        return result;
    }

    public static Adapter getAdapter(List adapters, Object type) {
        Iterator iter = adapters.iterator();
        while (iter.hasNext()) {
            Adapter adapter = (Adapter)iter.next();
            if (!adapter.isAdapterForType(type)) continue;
            return adapter;
        }
        return null;
    }

    public static AdapterFactory getAdapterFactory(List adapterFactories, Object type) {
        Iterator iter = adapterFactories.iterator();
        while (iter.hasNext()) {
            AdapterFactory factory = (AdapterFactory)iter.next();
            if (!factory.isFactoryForType(type)) continue;
            return factory;
        }
        return null;
    }

    public static EObject resolve(EObject proxy, ResourceSet resourceSet) {
        URI proxyURI = ((InternalEObject)proxy).eProxyURI();
        if (proxyURI != null) {
            try {
                EObject resolvedObject = resourceSet.getEObject(proxyURI, true);
                if (resolvedObject != null && resolvedObject != proxy) {
                    return EcoreUtil.resolve(resolvedObject, resourceSet);
                }
            }
            catch (RuntimeException runtimeException) {
                // empty catch block
            }
        }
        return proxy;
    }

    public static EObject resolve(EObject proxy, Resource resourceContext) {
        ResourceSet resourceSet;
        URI proxyURI = ((InternalEObject)proxy).eProxyURI();
        if (proxyURI != null && (resourceSet = resourceContext.getResourceSet()) != null) {
            try {
                EObject resolvedObject = resourceSet.getEObject(proxyURI, true);
                if (resolvedObject != null && resolvedObject != proxy) {
                    return EcoreUtil.resolve(resolvedObject, resourceSet);
                }
            }
            catch (RuntimeException exception) {
                // empty catch block
            }
        }
        return proxy;
    }

    public static EObject resolve(EObject proxy, EObject objectContext) {
        ResourceSet resourceSet;
        Resource resource;
        URI proxyURI = ((InternalEObject)proxy).eProxyURI();
        if (proxyURI != null && (resource = objectContext.eResource()) != null && (resourceSet = resource.getResourceSet()) != null) {
            try {
                EObject resolvedObject = resourceSet.getEObject(proxyURI, true);
                if (resolvedObject != null && resolvedObject != proxy) {
                    return EcoreUtil.resolve(resolvedObject, resourceSet);
                }
            }
            catch (RuntimeException exception) {
                // empty catch block
            }
        }
        return proxy;
    }

    public static Object getObjectByType(Collection objects, EClassifier type) {
        Iterator i = objects.iterator();
        while (i.hasNext()) {
            Object object = i.next();
            if (!type.isInstance(object)) continue;
            return object;
        }
        return null;
    }

    public static Collection getObjectsByType(Collection objects, EClassifier type) {
        ArrayList result = new ArrayList();
        Iterator i = objects.iterator();
        while (i.hasNext()) {
            Object object = i.next();
            if (!type.isInstance(object)) continue;
            result.add(object);
        }
        return result;
    }

    public static EObject copy(EObject eObject) {
        Copier copier = new Copier();
        EObject result = copier.copy(eObject);
        copier.copyReferences();
        return result;
    }

    public static Collection copyAll(Collection eObjects) {
        Copier copier = new Copier();
        Collection result = copier.copyAll(eObjects);
        copier.copyReferences();
        return result;
    }

    public static EObject getRootContainer(EObject eObject) {
        EObject result = eObject;
        EObject parent = eObject;
        while (parent != null) {
            result = parent;
            parent = parent.eContainer();
        }
        return result;
    }

    public static boolean isAncestor(EObject ancestorEObject, EObject eObject) {
        while (eObject != null) {
            if (eObject == ancestorEObject) {
                return true;
            }
            eObject = eObject.eContainer();
        }
        return false;
    }

    public static boolean isAncestor(Resource ancestorResource, EObject eObject) {
        return eObject.eResource() == ancestorResource;
    }

    public static boolean isAncestor(ResourceSet ancestorResourceSet, EObject eObject) {
        Resource resource = eObject.eResource();
        return resource != null && resource.getResourceSet() == ancestorResourceSet;
    }

    public static boolean isAncestor(Collection ancestorEMFObjects, EObject eObject) {
        if (ancestorEMFObjects.contains(eObject)) {
            return true;
        }
        EObject container = eObject.eContainer();
        while (container != null) {
            if (ancestorEMFObjects.contains(container)) {
                return true;
            }
            eObject = container;
            container = container.eContainer();
        }
        Resource resource = eObject.eResource();
        if (resource != null) {
            if (ancestorEMFObjects.contains(resource)) {
                return true;
            }
            ResourceSet resourceSet = resource.getResourceSet();
            if (resourceSet != null && ancestorEMFObjects.contains(resourceSet)) {
                return true;
            }
        }
        return false;
    }

    public static TreeIterator getAllContents(Collection emfObjects) {
        return new ContentTreeIterator(emfObjects);
    }

    public static String getIdentification(EObject eObject) {
        StringBuffer result = new StringBuffer(eObject.getClass().getName());
        EClass eClass = eObject.eClass();
        if (eClass.getInstanceClassName() == null) {
            result.append('/');
            result.append(eClass.getEPackage().getNsURI());
            result.append('#');
            result.append(eClass.getName());
        }
        result.append('@');
        result.append(Integer.toHexString(eObject.hashCode()));
        result.append('{');
        result.append(EcoreUtil.getURI(eObject));
        result.append('}');
        return result.toString();
    }

    public static URI getURI(EObject eObject) {
        URI proxyURI = ((InternalEObject)eObject).eProxyURI();
        if (proxyURI != null) {
            return proxyURI;
        }
        EObject eRootContainer = EcoreUtil.getRootContainer(eObject);
        Resource resource = eRootContainer.eResource();
        if (resource != null) {
            return resource.getURI().appendFragment(resource.getURIFragment(eObject));
        }
        StringBuffer result = new StringBuffer("#//");
        ArrayList<String> uriFragmentPath = new ArrayList<String>();
        EObject container = eObject.eContainer();
        while (container != null) {
            uriFragmentPath.add(((InternalEObject)container).eURIFragmentSegment(eObject.eContainmentFeature(), eObject));
            eObject = container;
            container = eObject.eContainer();
        }
        int size = uriFragmentPath.size();
        if (size > 0) {
            int i = size - 1;
            while (true) {
                result.append((String)uriFragmentPath.get(i));
                if (i == 0) break;
                result.append('/');
                --i;
            }
        }
        return URI.createDeviceURI((String)result.toString());
    }

    public static void setEList(EList eList, Collection prototypeList) {
        int index = 0;
        Iterator objects = prototypeList.iterator();
        while (objects.hasNext()) {
            Object prototypeObject = objects.next();
            if (eList.size() <= index) {
                eList.add(prototypeObject);
            } else {
                Object targetObject = eList.get(index);
                if (!targetObject.equals(prototypeObject)) {
                    if (eList.contains(prototypeObject)) {
                        eList.move(index, prototypeObject);
                    } else {
                        eList.add(index, prototypeObject);
                    }
                }
            }
            ++index;
        }
    }

    public static void remove(EStructuralFeature.Setting setting, Object value) {
        if (setting.getEStructuralFeature().isMany()) {
            ((List)setting.get(false)).remove(value);
        } else {
            setting.set(null);
        }
    }

    public static void replace(EStructuralFeature.Setting setting, Object oldValue, Object newValue) {
        if (setting.getEStructuralFeature().isMany()) {
            List list = (List)setting.get(false);
            list.set(list.indexOf(oldValue), newValue);
        } else {
            setting.set(newValue);
        }
    }

    public static void remove(EObject eObject, EStructuralFeature eStructuralFeature, Object value) {
        if (eStructuralFeature.isMany()) {
            ((List)eObject.eGet(eStructuralFeature)).remove(value);
        } else {
            eObject.eSet(eStructuralFeature, null);
        }
    }

    public static void replace(EObject eObject, EStructuralFeature eStructuralFeature, Object oldValue, Object newValue) {
        if (eStructuralFeature.isMany()) {
            List list = (List)eObject.eGet(eStructuralFeature);
            list.set(list.indexOf(oldValue), newValue);
        } else {
            eObject.eSet(eStructuralFeature, newValue);
        }
    }

    public static void remove(EObject eObject) {
        EObject container = eObject.eContainer();
        if (container != null) {
            EStructuralFeature feature = eObject.eContainmentFeature();
            if (feature.isMany()) {
                ((EList)container.eGet(feature)).remove(eObject);
            } else {
                container.eUnset(feature);
            }
        } else {
            Resource resource = eObject.eResource();
            if (resource != null) {
                resource.getContents().remove(eObject);
            }
        }
    }

    public static void replace(EObject eObject, EObject replacementEObject) {
        EObject container = eObject.eContainer();
        if (container != null) {
            EStructuralFeature feature = eObject.eContainmentFeature();
            if (feature.isMany()) {
                List list = (List)container.eGet(feature);
                list.set(list.indexOf(eObject), replacementEObject);
            } else {
                container.eSet(feature, replacementEObject);
            }
        } else {
            Resource resource = eObject.eResource();
            if (resource != null) {
                EList list = resource.getContents();
                list.set(list.indexOf(eObject), replacementEObject);
            }
        }
    }

    public static EObject create(EClass eClass) {
        return eClass.getEPackage().getEFactoryInstance().create(eClass);
    }

    public static Object createFromString(EDataType eDataType, String literal) {
        return eDataType.getEPackage().getEFactoryInstance().createFromString(eDataType, literal);
    }

    public static String convertToString(EDataType eDataType, Object value) {
        return eDataType.getEPackage().getEFactoryInstance().convertToString(eDataType, value);
    }

    public static String getID(EObject eObject) {
        EClass eClass = eObject.eClass();
        EAttribute eIDAttribute = eClass.getEIDAttribute();
        return eIDAttribute == null || !eObject.eIsSet(eIDAttribute) ? null : EcoreUtil.convertToString(eIDAttribute.getEAttributeType(), eObject.eGet(eIDAttribute));
    }

    public static void setID(EObject eObject, String id) {
        EClass eClass = eObject.eClass();
        EAttribute eIDAttribute = eClass.getEIDAttribute();
        if (eIDAttribute == null) {
            throw new IllegalArgumentException("The object doesn't have an ID feature.");
        }
        if (id == null) {
            eObject.eUnset(eIDAttribute);
        } else {
            eObject.eSet(eIDAttribute, EcoreUtil.createFromString(eIDAttribute.getEAttributeType(), id));
        }
    }

    public static class UnresolvedProxyCrossReferencer
    extends CrossReferencer {
        protected UnresolvedProxyCrossReferencer(EObject eObject) {
            super(eObject);
        }

        protected UnresolvedProxyCrossReferencer(Resource resource) {
            super(Collections.singleton(resource));
        }

        protected UnresolvedProxyCrossReferencer(ResourceSet resourceSet) {
            super(Collections.singleton(resourceSet));
        }

        protected UnresolvedProxyCrossReferencer(Collection emfObjects) {
            super(emfObjects);
        }

        protected boolean crossReference(EObject eObject, EReference eReference, EObject crossReferencedEObject) {
            return crossReferencedEObject.eIsProxy();
        }

        protected Map findUnresolvedProxyCrossReferences() {
            this.crossReference();
            this.done();
            return this;
        }

        public static Map find(EObject eObject) {
            return new UnresolvedProxyCrossReferencer(eObject).findUnresolvedProxyCrossReferences();
        }

        public static Map find(Resource resource) {
            return new UnresolvedProxyCrossReferencer(resource).findUnresolvedProxyCrossReferences();
        }

        public static Map find(ResourceSet resourceSet) {
            return new UnresolvedProxyCrossReferencer(resourceSet).findUnresolvedProxyCrossReferences();
        }

        public static Map find(Collection emfObjects) {
            return new UnresolvedProxyCrossReferencer(emfObjects).findUnresolvedProxyCrossReferences();
        }
    }

    public static class ProxyCrossReferencer
    extends CrossReferencer {
        protected ProxyCrossReferencer(EObject eObject) {
            super(eObject);
        }

        protected ProxyCrossReferencer(Resource resource) {
            super(Collections.singleton(resource));
        }

        protected ProxyCrossReferencer(ResourceSet resourceSet) {
            super(Collections.singleton(resourceSet));
        }

        protected ProxyCrossReferencer(Collection emfObjects) {
            super(emfObjects);
        }

        protected boolean resolve() {
            return false;
        }

        protected boolean crossReference(EObject eObject, EReference eReference, EObject crossReferencedEObject) {
            return crossReferencedEObject.eIsProxy();
        }

        protected Map findProxyCrossReferences() {
            this.crossReference();
            this.done();
            return this;
        }

        public static Map find(EObject eObject) {
            return new ProxyCrossReferencer(eObject).findProxyCrossReferences();
        }

        public static Map find(Resource resource) {
            return new ProxyCrossReferencer(resource).findProxyCrossReferences();
        }

        public static Map find(ResourceSet resourceSet) {
            return new ProxyCrossReferencer(resourceSet).findProxyCrossReferences();
        }

        public static Map find(Collection emfObjects) {
            return new ProxyCrossReferencer(emfObjects).findProxyCrossReferences();
        }
    }

    public static class UsageCrossReferencer
    extends CrossReferencer {
        protected Collection eObjectsOfInterest;

        protected UsageCrossReferencer(EObject eObject) {
            super(eObject);
        }

        protected UsageCrossReferencer(Resource resource) {
            super(resource);
        }

        protected UsageCrossReferencer(ResourceSet resourceSet) {
            super(resourceSet);
        }

        protected UsageCrossReferencer(Collection emfObjects) {
            super(emfObjects);
        }

        protected boolean crossReference(EObject eObject, EReference eReference, EObject crossReferencedEObject) {
            return this.eObjectsOfInterest.contains(crossReferencedEObject);
        }

        protected Collection findUsage(EObject eObject) {
            this.eObjectsOfInterest = Collections.singleton(eObject);
            this.crossReference();
            this.eObjectsOfInterest = null;
            this.done();
            return this.getCollection(eObject);
        }

        protected Map findAllUsage(Collection eObjectsOfInterest) {
            this.eObjectsOfInterest = eObjectsOfInterest;
            this.crossReference();
            this.eObjectsOfInterest = null;
            this.done();
            return this;
        }

        public static Collection find(EObject eObjectOfInterest, EObject eObject) {
            return new UsageCrossReferencer(eObject).findUsage(eObjectOfInterest);
        }

        public static Collection find(EObject eObjectOfInterest, Resource resource) {
            return new UsageCrossReferencer(resource).findUsage(eObjectOfInterest);
        }

        public static Collection find(EObject eObjectOfInterest, ResourceSet resourceSet) {
            return new UsageCrossReferencer(resourceSet).findUsage(eObjectOfInterest);
        }

        public static Collection find(EObject eObjectOfInterest, Collection emfObjectsToSearch) {
            return new UsageCrossReferencer(emfObjectsToSearch).findUsage(eObjectOfInterest);
        }

        public static Map findAll(Collection eObjectsOfInterest, EObject eObject) {
            return new UsageCrossReferencer(eObject).findAllUsage(eObjectsOfInterest);
        }

        public static Map findAll(Collection eObjectsOfInterest, Resource resource) {
            return new UsageCrossReferencer(resource).findAllUsage(eObjectsOfInterest);
        }

        public static Map findAll(Collection eObjectsOfInterest, ResourceSet resourceSet) {
            return new UsageCrossReferencer(resourceSet).findAllUsage(eObjectsOfInterest);
        }

        public static Map findAll(Collection eObjectsOfInterest, Collection emfObjectsToSearch) {
            return new UsageCrossReferencer(emfObjectsToSearch).findAllUsage(eObjectsOfInterest);
        }
    }

    public static class ExternalCrossReferencer
    extends CrossReferencer {
        protected ExternalCrossReferencer(Collection emfObjects) {
            super(emfObjects);
        }

        protected ExternalCrossReferencer(EObject eObject) {
            super(eObject);
        }

        protected ExternalCrossReferencer(Resource resource) {
            super(Collections.singleton(resource));
        }

        protected ExternalCrossReferencer(ResourceSet resourceSet) {
            super(Collections.singleton(resourceSet));
        }

        protected boolean crossReference(EObject eObject, EReference eReference, EObject crossReferencedEObject) {
            return !EcoreUtil.isAncestor(this.emfObjects, crossReferencedEObject);
        }

        protected Map findExternalCrossReferences() {
            this.crossReference();
            this.done();
            return this;
        }

        public static Map find(EObject eObject) {
            return new ExternalCrossReferencer(eObject).findExternalCrossReferences();
        }

        public static Map find(Resource resource) {
            return new ExternalCrossReferencer(resource).findExternalCrossReferences();
        }

        public static Map find(ResourceSet resourceSet) {
            return new ExternalCrossReferencer(resourceSet).findExternalCrossReferences();
        }

        public static Map find(Collection emfObjectsToSearch) {
            return new ExternalCrossReferencer(emfObjectsToSearch).findExternalCrossReferences();
        }
    }

    public static class CrossReferencer
    extends HashMap {
        protected Collection emfObjects;

        protected CrossReferencer(EObject eObject) {
            this.emfObjects = Collections.singleton(eObject);
        }

        protected CrossReferencer(Resource resource) {
            this.emfObjects = Collections.singleton(resource);
        }

        protected CrossReferencer(ResourceSet resourceSet) {
            this.emfObjects = Collections.singleton(resourceSet);
        }

        protected CrossReferencer(Collection emfObjects) {
            this.emfObjects = emfObjects;
        }

        protected boolean containment(EObject eObject) {
            return true;
        }

        protected boolean crossReference(EObject eObject, EReference eReference, EObject crossReferencedEObject) {
            return true;
        }

        protected boolean resolve() {
            return true;
        }

        protected Collection newCollection() {
            return new ArrayList();
        }

        protected Collection getCollection(Object key) {
            Collection result = (Collection)this.get(key);
            if (result == null) {
                result = this.newCollection();
                this.put(key, result);
            }
            return result;
        }

        protected TreeIterator newContentsIterator() {
            return new ContentTreeIterator(this.emfObjects);
        }

        protected void crossReference() {
            TreeIterator contents = this.newContentsIterator();
            while (contents.hasNext()) {
                Object content = contents.next();
                if (!(content instanceof EObject)) continue;
                EObject eObject = (EObject)content;
                if (this.containment(eObject)) {
                    this.handleCrossReference(eObject);
                    continue;
                }
                contents.prune();
            }
        }

        protected void handleCrossReference(EObject eObject) {
            InternalEObject internalEObject = (InternalEObject)eObject;
            EContentsEList.FeatureIterator crossReferences = (EContentsEList.FeatureIterator)(this.resolve() ? internalEObject.eCrossReferences().iterator() : ((InternalEList)internalEObject.eCrossReferences()).basicIterator());
            while (crossReferences.hasNext()) {
                EObject crossReferencedEObject = (EObject)crossReferences.next();
                EReference eReference = (EReference)crossReferences.feature();
                if (!this.crossReference(internalEObject, eReference, crossReferencedEObject)) continue;
                this.getCollection(crossReferencedEObject).add(internalEObject.eSetting(eReference));
            }
        }

        protected void done() {
            this.emfObjects = null;
        }

        public static Map find(Collection emfObjects) {
            CrossReferencer result = new CrossReferencer(emfObjects);
            result.crossReference();
            result.done();
            return result;
        }

        public String toString() {
            StringBuffer result = new StringBuffer("{");
            Iterator i = this.entrySet().iterator();
            while (i.hasNext()) {
                Map.Entry entry = i.next();
                EObject eObject = (EObject)entry.getKey();
                result.append(EcoreUtil.getIdentification(eObject));
                result.append("=[");
                Collection collection = (Collection)entry.getValue();
                Iterator j = collection.iterator();
                while (j.hasNext()) {
                    EStructuralFeature.Setting setting = (EStructuralFeature.Setting)j.next();
                    EStructuralFeature eStructuralFeature = setting.getEStructuralFeature();
                    result.append(eStructuralFeature.getName());
                    result.append("<-");
                    result.append(EcoreUtil.getIdentification(setting.getEObject()));
                    if (!j.hasNext()) continue;
                    result.append(", ");
                }
                result.append(']');
            }
            result.append('}');
            return result.toString();
        }

        public static void print(PrintStream out, Map crossReferenceMap) {
            out.println('{');
            Iterator i = crossReferenceMap.entrySet().iterator();
            while (i.hasNext()) {
                Map.Entry entry = i.next();
                EObject eObject = (EObject)entry.getKey();
                out.print(" ");
                out.print(EcoreUtil.getIdentification(eObject));
                Collection collection = (Collection)entry.getValue();
                if (collection.isEmpty()) {
                    out.println(" =[]");
                    continue;
                }
                out.println(" =[");
                Iterator j = collection.iterator();
                while (j.hasNext()) {
                    EStructuralFeature.Setting setting = (EStructuralFeature.Setting)j.next();
                    EStructuralFeature eStructuralFeature = setting.getEStructuralFeature();
                    out.print("   ");
                    out.print(eStructuralFeature.getName());
                    out.print("<-");
                    out.print(EcoreUtil.getIdentification(setting.getEObject()));
                    if (!j.hasNext()) continue;
                    out.println(",");
                }
                out.println(']');
            }
            out.println('}');
        }

        public static void print(PrintStream out, Collection settings) {
            if (settings.isEmpty()) {
                out.println("[]");
            } else {
                out.println("[");
                Iterator j = settings.iterator();
                while (j.hasNext()) {
                    EStructuralFeature.Setting setting = (EStructuralFeature.Setting)j.next();
                    EStructuralFeature eStructuralFeature = setting.getEStructuralFeature();
                    out.print(" ");
                    out.print(eStructuralFeature.getName());
                    out.print("<-");
                    out.print(EcoreUtil.getIdentification(setting.getEObject()));
                    if (!j.hasNext()) continue;
                    out.println(",");
                }
                out.println(']');
            }
        }
    }

    public static class ContentTreeIterator
    extends AbstractTreeIterator {
        protected Collection emfObjects;

        protected ContentTreeIterator(Collection emfObjects) {
            super((Object)emfObjects, false);
            this.emfObjects = emfObjects;
        }

        public Iterator getChildren(Object object) {
            if (object instanceof EObject) {
                return this.getEObjectChildren((EObject)object);
            }
            if (object instanceof Resource) {
                return this.getResourceChildren((Resource)object);
            }
            if (object instanceof ResourceSet) {
                return this.getResourceSetChildren((ResourceSet)object);
            }
            if (object == this.emfObjects) {
                return this.emfObjects.iterator();
            }
            return this.getObjectChildren(object);
        }

        protected Iterator getEObjectChildren(EObject eObject) {
            return eObject.eContents().iterator();
        }

        protected Iterator getResourceChildren(Resource resource) {
            return resource.getContents().iterator();
        }

        protected Iterator getResourceSetChildren(ResourceSet resourceSet) {
            EList resources = resourceSet.getResources();
            return new Iterator(this, (List)resources){
                int index;
                private final /* synthetic */ List val$resources;
                private final /* synthetic */ ContentTreeIterator this$0;
                {
                    this.this$0 = this$0;
                    this.val$resources = val$resources;
                    this.index = 0;
                }

                public boolean hasNext() {
                    return this.index < this.val$resources.size();
                }

                public Object next() {
                    return this.val$resources.get(this.index++);
                }

                public void remove() {
                    throw new UnsupportedOperationException();
                }
            };
        }

        protected Iterator getObjectChildren(Object object) {
            return ECollections.EMPTY_ELIST.iterator();
        }
    }

    public static class Copier
    extends HashMap {
        public Collection copyAll(Collection eObjects) {
            ArrayList<EObject> result = new ArrayList<EObject>(eObjects.size());
            Iterator i = eObjects.iterator();
            while (i.hasNext()) {
                result.add(this.copy((EObject)i.next()));
            }
            return result;
        }

        public EObject copy(EObject eObject) {
            EClass eClass = eObject.eClass();
            EObject copiedEObject = eClass.getEPackage().getEFactoryInstance().create(eClass);
            this.put(eObject, copiedEObject);
            Iterator i = eClass.getEAllStructuralFeatures().iterator();
            while (i.hasNext()) {
                EStructuralFeature eStructuralFeature = (EStructuralFeature)i.next();
                if (!eStructuralFeature.isChangeable()) continue;
                if (eStructuralFeature instanceof EAttribute) {
                    this.copyAttribute((EAttribute)eStructuralFeature, eObject, copiedEObject);
                    continue;
                }
                EReference eReference = (EReference)eStructuralFeature;
                if (!eReference.isContainment()) continue;
                this.copyContainment(eReference, eObject, copiedEObject);
            }
            return copiedEObject;
        }

        protected void copyContainment(EReference eReference, EObject eObject, EObject copiedEObject) {
            if (eObject.eIsSet(eReference)) {
                if (eReference.isMany()) {
                    ((List)copiedEObject.eGet(eReference)).addAll(this.copyAll((List)eObject.eGet(eReference)));
                } else {
                    EObject childEObject = (EObject)eObject.eGet(eReference);
                    copiedEObject.eSet(eReference, childEObject == null ? null : this.copy(childEObject));
                }
            }
        }

        protected void copyAttribute(EAttribute eAttribute, EObject eObject, EObject copiedEObject) {
            if (eObject.eIsSet(eAttribute)) {
                if (eAttribute.isMany()) {
                    ((List)copiedEObject.eGet(eAttribute)).addAll((List)eObject.eGet(eAttribute));
                } else {
                    copiedEObject.eSet(eAttribute, eObject.eGet(eAttribute));
                }
            }
        }

        public void copyReferences() {
            Iterator i = this.entrySet().iterator();
            while (i.hasNext()) {
                Map.Entry entry = i.next();
                EObject eObject = (EObject)entry.getKey();
                EObject copiedEObject = (EObject)entry.getValue();
                EClass eClass = eObject.eClass();
                Iterator j = eClass.getEAllReferences().iterator();
                while (j.hasNext()) {
                    EReference eReference = (EReference)j.next();
                    if (!eReference.isChangeable() || eReference.isContainment()) continue;
                    this.copyReference(eReference, eObject, copiedEObject);
                }
            }
        }

        protected void copyReference(EReference eReference, EObject eObject, EObject copiedEObject) {
            boolean isBidirectional;
            boolean bl = isBidirectional = eReference.getEOpposite() != null;
            if (eReference.isMany()) {
                List value = (List)copiedEObject.eGet(eReference);
                Iterator k = ((List)eObject.eGet(eReference)).iterator();
                while (k.hasNext()) {
                    Object referencedEObject = k.next();
                    Object copiedReferencedEObject = this.get(referencedEObject);
                    if (copiedReferencedEObject == null) {
                        if (isBidirectional) continue;
                        value.add(referencedEObject);
                        continue;
                    }
                    value.add(copiedReferencedEObject);
                }
            } else {
                Object referencedEObject = eObject.eGet(eReference);
                if (referencedEObject != null) {
                    Object copiedReferencedEObject = this.get(referencedEObject);
                    if (copiedReferencedEObject == null) {
                        if (!isBidirectional) {
                            copiedEObject.eSet(eReference, referencedEObject);
                        }
                    } else {
                        copiedEObject.eSet(eReference, copiedReferencedEObject);
                    }
                }
            }
        }
    }
}

