/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.mapping.command;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import org.eclipse.emf.common.command.AbstractCommand;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.command.CompoundCommand;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.edit.command.AddCommand;
import org.eclipse.emf.edit.command.CommandParameter;
import org.eclipse.emf.edit.command.RemoveCommand;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.mapping.Mapping;
import org.eclipse.emf.mapping.MappingPackage;
import org.eclipse.emf.mapping.MappingPlugin;
import org.eclipse.emf.mapping.domain.MappingDomain;

public class AddMappingCommand
extends AbstractCommand {
    protected static final String LABEL = MappingPlugin.getPlugin().getString("_UI_AddMappingCommand_label");
    protected static final String DESCRIPTION = MappingPlugin.getPlugin().getString("_UI_AddMappingCommand_description");
    protected MappingDomain domain;
    protected Collection collection;
    Command subcommand;
    static /* synthetic */ Class class$org$eclipse$emf$mapping$command$AddMappingCommand;

    public static Command create(MappingDomain domain, Collection collection) {
        return domain.createCommand(class$org$eclipse$emf$mapping$command$AddMappingCommand == null ? (class$org$eclipse$emf$mapping$command$AddMappingCommand = AddMappingCommand.class$("org.eclipse.emf.mapping.command.AddMappingCommand")) : class$org$eclipse$emf$mapping$command$AddMappingCommand, new CommandParameter((Object)domain.getMappingRoot(), null, collection));
    }

    public static Command create(MappingDomain domain, Mapping mapping) {
        return AddMappingCommand.create(domain, Collections.singleton(mapping));
    }

    public AddMappingCommand(MappingDomain domain, Collection collection) {
        super(LABEL, DESCRIPTION);
        this.domain = domain;
        this.collection = collection;
    }

    protected boolean prepare() {
        boolean result = this.domain != null;
        Iterator objects = this.collection.iterator();
        while (objects.hasNext()) {
            Object object = objects.next();
            if (object instanceof Mapping) continue;
            result = false;
            break;
        }
        return result;
    }

    public void execute() {
        CompoundCommand subcommands = new CompoundCommand();
        Iterator mappings = this.collection.iterator();
        while (mappings.hasNext()) {
            Mapping mapping = (Mapping)mappings.next();
            Mapping parentMapping = this.domain.getMappingRoot().getParentMapping(mapping.getMappedObjects());
            this.domain.getMappingRoot().register(mapping);
            if (!subcommands.appendAndExecute((Command)new AddCommand((EditingDomain)this.domain, (EObject)parentMapping, (EStructuralFeature)MappingPackage.eINSTANCE.getMapping_Nested(), (Object)mapping))) continue;
            ArrayList<Mapping> siblingsToReparent = new ArrayList<Mapping>();
            Iterator i = parentMapping.getNested().iterator();
            while (i.hasNext()) {
                Mapping siblingMapping = (Mapping)i.next();
                if (siblingMapping == mapping || this.domain.getMappingRoot().getParentMapping(siblingMapping.getMappedObjects()) != mapping) continue;
                siblingsToReparent.add(siblingMapping);
            }
            if (siblingsToReparent.isEmpty()) continue;
            subcommands.appendAndExecute((Command)new RemoveCommand((EditingDomain)this.domain, (EObject)parentMapping, (EStructuralFeature)MappingPackage.eINSTANCE.getMapping_Nested(), siblingsToReparent));
            subcommands.appendAndExecute((Command)new AddCommand((EditingDomain)this.domain, (EObject)mapping, (EStructuralFeature)MappingPackage.eINSTANCE.getMapping_Nested(), siblingsToReparent));
        }
        this.subcommand = subcommands.unwrap();
    }

    public void undo() {
        Iterator objects = this.collection.iterator();
        while (objects.hasNext()) {
            Mapping mapping = (Mapping)objects.next();
            this.domain.getMappingRoot().deregister(mapping);
        }
        this.subcommand.undo();
    }

    public void redo() {
        Iterator objects = this.collection.iterator();
        while (objects.hasNext()) {
            Mapping mapping = (Mapping)objects.next();
            this.domain.getMappingRoot().register(mapping);
        }
        this.subcommand.redo();
    }

    public Collection getResult() {
        return this.collection;
    }

    public Collection getAffectedObjects() {
        return this.collection;
    }

    public void dispose() {
        if (this.subcommand != null) {
            this.subcommand.dispose();
        }
        super.dispose();
    }

    public String toString() {
        StringBuffer result = new StringBuffer(super.toString());
        result.append(" (domain: " + this.domain + ")");
        result.append(" (collection: " + this.collection + ")");
        result.append(" (subcommand: " + this.subcommand + ")");
        return result.toString();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

